from sqlalchemy import VARCHAR, Column, Integer, Index, FLOAT, BOOLEAN, TIMESTAMP, JSON
from sqlalchemy.ext.declarative import declarative_base

Base = declarative_base()


class TrendsMasterTable(Base):
    __tablename__ = "trends_master_tbl_"

    id = Column(Integer, primary_key=True, autoincrement=True)
    mapping_id = Column(VARCHAR, nullable=True)
    department = Column(VARCHAR, nullable=True)
    function = Column(VARCHAR, nullable=True)
    form = Column(VARCHAR, nullable=True)
    filter = Column(JSON, nullable=True)
    parameter = Column(VARCHAR, nullable=True)
    trend_captured = Column(BOOLEAN, nullable=True)
    lower_limit = Column(FLOAT, nullable=True)
    upper_value = Column(FLOAT, nullable=True)

    # index_name = Index("trends_master_tbl_", mapping_id, department,
    #                    function, form, filter, parameter)


class TrendsFormTable(Base):
    __tablename__ = "trends_form_tbl_"

    id = Column(Integer, primary_key=True, autoincrement=True)
    mapping_id = Column(VARCHAR, nullable=True)
    time_stamp = Column(TIMESTAMP)
    value = Column(VARCHAR, nullable=True)

    # index_name = Index("trends_form_tbl_", mapping_id, time_stamp)
