from scripts.constants import Constants
from scripts.configurations import postgres_details
from sqlalchemy import select, and_, cast, Text


def get_unique_departments(table):
    return select(
        table.department.label(Constants.DATA)
    ).distinct()


def get_filter_query(
        current_level, department=None, function=None,
        form=None, filter_value=None,
        table=None
):
    query = None

    if current_level and current_level == 0:
        query = f"""
        SELECT 
            DISTINCT FUNCTION
        FROM
            {table}
        WHERE  
            DEPARTMENT='{department}'
        ORDER BY
            FUNCTION
        """

    elif current_level and current_level == 1:
        query = f"""
        SELECT 
            DISTINCT FORM
        FROM
            {table}
        WHERE  
            DEPARTMENT='{department}' 
            AND FUNCTION='{function}'
        ORDER BY
            FORM
        """

    elif current_level and current_level >= 2:
        current_level -= 1

        where_clause = ""
        if current_level >= 2:
            where_clause = f"""
            AND FILTER ->> 'l{current_level - 1}-value' = '{filter_value}'
            """

        query = f"""
        SELECT 
            DISTINCT (FILTER - >> 'l{current_level}-name') AS L{current_level}_NAME,
            (FILTER - >> 'l{current_level}-value') AS L{current_level}_VALUE
        FROM
            {table}
        WHERE  
            DEPARTMENT='{department}' 
            AND FUNCTION='{function}'
            AND FORM='{form}'
            {where_clause}
        ORDER BY
            L{current_level}_NAME
        """

    return query


def get_unique_function(table, department):
    return select(
        table.function.label(Constants.DATA)
    ).distinct().where(
        table.department == department
    )


def get_unique_form(table, department, function):
    return select(
        table.form.label(Constants.DATA)
    ).distinct().where(
        and_(
            table.department == department,
            table.function == function
        ))


def get_unique_filters(table, department, function, form):
    return select(
        cast(table.filter, Text).label(Constants.DATA)
    ).distinct().where(
        and_(
            table.department == department,
            table.function == function,
            table.form == form
        )
    )
