"""
constants.py - Application Constants

This module defines various constants used in the application.

"""


class APIConstants:
    """
    Constants related to API endpoints
    """

    SHUTDOWN = "shutdown"
    HEALTH_CHECK = "/healthcheck"
    DASHBOARD_METADATA_ENDPOINT = "/get_filter"
    DASHBOARD_DATA_ENDPOINT = "/get_data"


class MainConstants:
    """
    Constants related to the main application
    """

    META_TAG_JSON = {
        "name": "PepsiCO: Trends Dashboard",
        "description": "Service for pushing data into the Postgres table",
    }
    DESCRIPTION_KEY = "Trends Dashboard"
    TOKEN_KEY = "token"


class Constants:
    """
    Constants related to the application
    """
    EXCEPTION_RAISER = "Exception ->{}"
    TRENDS_HANDLING_ENDPOINT = "Trends Handler Endpoints"
    DATA = "data"
    LINE = "line"
    DEPARTMENT = "department"
    FORM = "form"
    FUNCTION = "function"
    VALUES = "values"
    FILTER_NAME = "filter_name"

    MAPPING_JSON = {
        0: "function",
        1: "form",
        2: "l1",
        3: "l2",
        4: "l3",
        5: "l4",
        6: "l5",
        7: "l6",
        8: "l7",
        9: "l8",
        10: "l9",
        11: "l10",

    }


class LoggerConstants:
    LOGGER_1 = ""
