from sqlalchemy import VARCHAR, Column, Integer, Index, FLOAT, BOOLEAN, TIMESTAMP, JSON
from sqlalchemy.ext.declarative import declarative_base

Base = declarative_base()


class TrendsMasterTable(Base):
    __tablename__ = "trends_master_tbl"

    id = Column(Integer, primary_key=True, autoincrement=True)
    mapping_id = Column(VARCHAR, nullable=True)
    department = Column(VARCHAR, nullable=True)
    function = Column(VARCHAR, nullable=True)
    form = Column(VARCHAR, nullable=True)
    filter = Column(JSON, nullable=True)
    parameter = Column(VARCHAR, nullable=True)
    parameter_type = Column(VARCHAR, nullable=True)
    trend_captured = Column(BOOLEAN, nullable=True)
    lower_limit = Column(FLOAT, nullable=True)
    upper_value = Column(FLOAT, nullable=True)


class TrendsFormTable(Base):
    __tablename__ = "trends_form_tbl"

    id = Column(Integer, primary_key=True, autoincrement=True)
    mapping_id = Column(VARCHAR, nullable=True)
    time_stamp = Column(TIMESTAMP)
    value = Column(FLOAT, nullable=True)
