from __future__ import annotations
from typing import Optional
from pydantic import BaseModel


class DashboardFilterInput(BaseModel):
    department: Optional[str] = None
    function: Optional[str] = None
    form: Optional[str] = None
    current_level: Optional[int] = None
    filter: Optional[dict] = None


class DashboardFilterOutput(BaseModel):
    filter_name: str
    values: list
    current_level: int


class DashboardFormInput(BaseModel):
    start_date: Optional[str]
    end_date: Optional[str]
    mapping_id: Optional[str]


class DashboardFormOutput(BaseModel):
    header_content: list
    body_content: list
    upper_limit: float
    lower_limit: float
    mean: float
