"""
event_service.py

This script initializes and configures the FastAPI
 application for the Vision App: On Demand Service.

The application includes routes, middleware, and server config.

Usage:
    from scripts.core.services.event_service import router

"""
from fastapi import APIRouter
from fastapi.responses import JSONResponse
from scripts.constants import Constants, APIConstants
from scripts.core.logging.application_logging import logger
from scripts.core.schemas.api import (
    trends_async_request, trends_async_response
)
from scripts.core.handler.trends_handler import TrendsDashboardHandler

downday_router = APIRouter(tags=[Constants.TRENDS_HANDLING_ENDPOINT])


@downday_router.on_event(APIConstants.SHUTDOWN)
async def shutdown_event():
    """
    This function prints the `Exiting!` string to the console.
    """
    print("Exiting!")


@downday_router.get(APIConstants.HEALTH_CHECK)
async def ping():
    """
    This function returns the `200 status message`.
    """
    return dict(status=200)


@downday_router.post(APIConstants.TRENDS_ASYNC_SERVICE,
                     response_model=trends_async_response)
async def save_trends_data(
        request_data: trends_async_request
):
    """
    Initiate postgres db and create tables

    Args:
        content (TrendsAsyncInput): Request body containing the
        necessary form parameters.

    Returns:
        :param request_data:
    """
    try:
        downday_obj = TrendsDashboardHandler()
        status, data = downday_obj.test()
        if status:
            return dict(status=True, message=data)
        else:
            return dict(status=False, message=data)
    except Exception as err:
        logger.exception(
            Constants.EXCEPTION_RAISER.format(str(err)),
            exc_info=True,
        )
        return JSONResponse(status_code=500, content=str(err))
