from sqlalchemy import VARCHAR, Column, Integer, Index, FLOAT

from sqlalchemy.ext.declarative import declarative_base

Base = declarative_base()


class TrendsAsyncTable(Base):
    __tablename__ = "trends_dashboard_tbl"

    id = Column(Integer, primary_key=True)
    department = Column(VARCHAR, nullable=True)
    sub_menu = Column(VARCHAR, nullable=True)
    form = Column(VARCHAR, nullable=True)
    filter = Column(VARCHAR, nullable=True)
    sub_filter = Column(VARCHAR, nullable=True)
    parameter_name = Column(VARCHAR, nullable=True)
    lower_limit = Column(FLOAT, nullable=True)
    upper_limit = Column(FLOAT, nullable=True)
    actual_value = Column(FLOAT, nullable=True)
    recheck_value = Column(FLOAT, nullable=True)

    index_name = Index('trends_async_index', id, department,
                       sub_menu, form, filter, sub_filter,
                       parameter_name)
