import copy
from datetime import datetime
from scripts.constants import Constants
from scripts.core.db.postgres import database_init
from scripts.core.schemas.postgres import TableObject
from scripts.core.logging.application_logging import logger
from scripts.core.exception.app_exceptions import GeneralException
from scripts.core.schemas.postgres.postgres_tables import \
    TrendsAsyncTable


class TrendsDashboardHandler:
    """
        Class responsible for creating tables and performing calculations for
        PepsiCo metrics.
    """
    def test(self):
        print("hello World")

    def get_max_score_data(self, db_init):
        """
        Method to get max scores for every year
        :param db_init:
        :return:
        """
        max_score_json = {}

        max_score_obj = TableObject(
            db=db_init, table_name=TrendsAsyncTable
        )
        # max_score_query = fetch_max_score_downday_query(
        #     table=max_score_obj.table,
        # )
        max_score_query = ""

        response = max_score_obj.execute_query(query=max_score_query)
        if response:
            for item in response:
                max_score_json[item['year']] = {'max': str(item['max'])}

        return max_score_json

    def bulk_upsert(self, session, table, data_list, primary_key):
        """
        Method to perform bulk upsert operation.

        Args:
            session (Session): Database session.
            table (Table): SQLAlchemy Table object.
            data_list (list): List of data to be upsert.
            primary_key (str): Primary key of the table.

        Returns:
            bool: True if upsert operation is successful, False otherwise.
        """
        try:
            existing_ids = session.query(table.date).filter(
                table.date.in_(
                    [item[primary_key] for item in data_list])).all()
            existing_ids = [id_[0] for id_ in existing_ids]

            # # Filter out existing IDs before inserting
            # unique_items = [item for item in data_list if
            #                 item[primary_key] not in existing_ids]

            # Filter out existing IDs before inserting
            # Updating the unique_items list to replace empty strings with None
            new_unique_items = []
            for item in data_list:
                new_item = {}
                for key, value in item.items():
                    if value == '':
                        new_item[key] = None
                    else:
                        new_item[key] = value
                if item[primary_key] not in existing_ids:
                    new_unique_items.append(new_item)

            session.bulk_insert_mappings(table, new_unique_items)

            instances = [table(**item) for item in new_unique_items]
            session.add_all(instances)
            session.commit()
            session.close()

            return True
        except Exception as e:
            session.rollback()
            raise RuntimeError(f"Error during upsert operation: {e}")
