from sqlalchemy import create_engine
from sqlalchemy.orm import sessionmaker
from sqlalchemy.pool import NullPool
from scripts.configurations import postgres_details
from scripts.core.logging.application_logging import logger
from sqlalchemy_utils import create_database, database_exists
from scripts.core.schemas.postgres.postgres_tables import TrendsAsyncTable
from scripts.core.exception.app_exceptions import ErrorMessages, GeneralException


def database_init():
    """
    :Objective: To create default postgres tables
    """
    database_obj = None
    try:
        # Creating engine for postgres
        engine = create_engine(url=postgres_details.uri, poolclass=NullPool)
        session_local = sessionmaker(autocommit=False, autoflush=False, bind=engine)

        # Creating a database is not exist
        if not database_exists(engine.url):
            create_database(engine.url)

        TrendsAsyncTable.__table__.create(bind=engine, checkfirst=True)
        logger.info("Tables initiation successful")

        TrendsAsyncTable.index_name.create(bind=engine, checkfirst=True)

        # Creating database object for CRUD operation
        database_obj = session_local()

    except Exception as err:
        logger.error(ErrorMessages.ERROR002.format(err), exc_info=True)
        raise GeneralException(ErrorMessages.ERROR002.format(err))
    return database_obj
