from scripts.constants import PostgresConstant
from scripts.core.db.postgres.custom_report_query import ACPQuery


class ACPReportTemplate:
    WORKSHEET_HEADER_FORMAT = {
        "bold": True,
        "align": "center",
        "valign": "center",
        "fg_color": "#e6e7eb",
        "font_color": "#1b314f",
        "border": 1,
        'font_size': '20',
    }
    COLUMN_HEADER_FORMAT = {
        "bold": True,
        "align": "center",
        "valign": "center",
        "fg_color": "#e6e7eb",
        "font_color": "#021b5e",
        "border": 1,
    }
    BLANK_COLUMN_HEADER_FORMAT = {
        "bold": True,
        "align": "center",
        "valign": "center",
    }
    REPORT_TEMPLATE = [
        {
            "BLANK": {
                "columns": [None],
                "data": [],
                "query": {},
                "data_column": [None]
            },
        },
        {
            "PARTICULARS": {
                "columns": [
                    "PARTICULARS", "UNITS", "ON DATE", "MTD"
                ],
                "query": {
                    "Production": [
                        ACPQuery.Particulars.QUERY_1,
                        ACPQuery.Particulars.QUERY_2,
                    ],
                    "FO": [
                        ACPQuery.FO.QUERY_1,
                        ACPQuery.FO.QUERY_2,
                    ],
                    "PNG/LPG": [

                    ],
                    "Rejection": [
                        ACPQuery.Rejection.QUERY_1,
                        ACPQuery.Rejection.QUERY_2,
                    ],
                    "Power": [

                    ]
                },
                "data": [],
                "data_column": [
                    "particulars", "units", "on_date", "mtd"
                ],
            },
            "BLANK": {
                "columns": [None],
                "data": [],
                "query": {},
                "data_column": [None]
            },
            "PERSONS ON DUTY": {
                "columns": [
                    "PERSONS ON DUTY", "A", "B", "C"
                ],
                "query": {
                    "PersonsOnDuty": [
                        ACPQuery.PersonsOnDuty.QUERY_1,
                    ]
                },
                "data": [],
                "data_column": [
                    "persons_on_duty", "a", "b", "c"
                ],
            },
            "BLANK1": {
                "columns": [None],
                "data": [],
                "query": {},
                "data_column": [None]
            },
            "ANODE LUG THICKNESS": {
                "columns": [
                    "ANODE LUG THICKNESS (22-32 mm)", "ANODE BODY THICKNESS (31-41 mm)"
                ],
                "query": {
                    "AnodeLugThickness": [
                        ACPQuery.AnodeLugThickness.QUERY_1,
                    ]
                },
                "data": [],
                "data_column": [
                    "anode_lug_thickness", "anode_body_thickness"
                ],
            },
        },
        {
            "A-SHIFT COMMUNICATION": {
                "columns": [
                    "S.No", "A-SHIFT COMMUNICATION"
                ],
                "query": {
                    "AShiftCommunication": [
                        ACPQuery.AShiftCommunication.QUERY_1,
                    ],
                },
                "data": [],
                "data_column": [
                    "s_no", "a_shift_comm"
                ],
            },
            "SHIFTWISE DATA": {
                "columns": [
                    "MOULD", "SET VALUE", "FIELD WT"
                ],
                "query": {
                    "ShiftwiseData": [
                        ACPQuery.PersonsOnDuty.QUERY_1,
                    ]
                },
                "data": [],
                "data_column": [
                    "mould", "set_value", "field_wt"
                ],
                "addition": {
                    "merge_header": "SHIFTWISE DATA"
                }
            }
        }
    ]
