import uuid
from datetime import datetime, timedelta

from scripts.configurations import security_conf_details
from scripts.core.db.redis_connections import login_db
from scripts.core.security.jwt_util import JWT

jwt = JWT()


def create_token(
    user_id,
    ip,
    token,
    age=security_conf_details.lock_out_time_mins,
    login_token=None,
    project_id=None,
):
    """
    This method is to create a cookie
    """
    uid = login_token
    if not uid:
        uid = str(uuid.uuid4()).replace("-", "")

    payload = {"ip": ip, "user_id": user_id, "token": token, "uid": uid, "age": age}
    if project_id:
        payload["project_id"] = project_id
    exp = datetime.utcnow() + timedelta(minutes=age)
    _extras = {"iss": security_conf_details.issuer, "exp": exp}
    _payload = {**payload, **_extras}

    new_token = jwt.encode(_payload)

    # Add session to redis
    login_db.set(uid, new_token)
    login_db.expire(uid, timedelta(minutes=age))

    return uid
