"""
"""


class MainConstants:
    """
    Constants related to the main application
    """

    META_TAG_JSON = {
        "name": "Vision App 2.0: Cement Bag Event Processor",
        "description": "On Demand Service for capturing the events",
    }
    DESCRIPTION_KEY = "Cement Bag Event Processor"
    TOKEN_KEY = "token"


class APIConstants:
    """
    Constants related to API endpoints
    """

    STARTUP = "startup"
    SHUTDOWN = "shutdown"
    HEALTH_CHECK = "/healthcheck"

    CUSTOM_REPORT_ENDPOINT = "/custom_report"


class CommonConstants:
    """
    Common constants used in the application
    """

    GET = "GET"
    POST = "POST"
    CUSTOM_REPORT_TAG = "Event Handler Endpoints"
    EXCEPTION_RAISER = "Exception ->{}"
    DEV_KEY = "dev"
    DATE_TIME_FORMAT = "%Y-%m-%d"
    QUERY = "query"
    DAY_START_DATE = "day_start_date"
    DAY_END_DATE = "day_end_date"
    MONTH_START_DATE = "month_start_date"
    MONTH_END_DATE = "month_end_date"
    YEAR_START_DATE = "year_start_date"
    YEAR_END_DATE = "year_end_date"
    DATA_COLUMN = "data_column"
    DATA = "data"


class ReportType:
    """
    Constants related to ReportType
    """

    REFINERY_REPORT = "refinery_report"


figlet = """
  ____    _                   _   _   _          
 / ___|  | |_    ___   _ __  | | (_) | |_    ___ 
 \___ \  | __|  / _ \ | '__| | | | | | __|  / _ /
  ___) | | |_  |  __/ | |    | | | | | |_  |  __/
 |____/   \__|  \___| |_|    |_| |_|  \__|  \___|

  ____                                  _   
 |  _ \    ___   _ __     ___    _ __  | |_ 
 | |_) |  / _ \ | '_ \   / _ \  | '__| | __|
 |  _ <  |  __/ | |_) | | (_) | | |    | |_ 
 |_| \_\  \___| | .__/   \___/  |_|     \__|
                |_|                         
"""
