from scripts.core.db.postgres.custom_report_query import SterliteRefineryQuery


class SterliteRefineryTemplate:
    WORKSHEET_HEADER_FORMAT = {
        "bold": True,
        "align": "center",
        "valign": "center",
        "fg_color": "#e6e7eb",
        "font_color": "#1b314f",
        "border": 1,
        'font_size': '20',
    }
    COLUMN_HEADER_FORMAT = {
        "bold": True,
        "align": "center",
        "valign": "center",
        "fg_color": "#e6e7eb",
        "font_color": "#021b5e",
        "border": 1,
    }
    REPORT_TEMPLATE = [
        {
            "CATHODE PRODUCTION REVISED": {
                "columns": [
                    "CATHODE PRODUCTION REVISED",
                    "UOM"
                ],
                "query": {
                    "Cathode Production Revised": [
                        SterliteRefineryQuery.CathodeProductionRevised.QUERY_1,
                    ]
                },
                "data": [],
                "data_column": [
                    "cathode_production_revised", "uom"
                ],
            },
            "DEPOSIT REVISED": {
                "columns": [
                    "DEPOSIT REVISED"
                ],
                "query": {
                    "Deposit Revised": [
                        SterliteRefineryQuery.DepositRevised.QUERY_1,
                    ]
                },
                "data": [],
                "data_column": [
                    "deposit_revised"
                ],
            },
        },
        {
            "ANODE AVAILABILITY": {
                "columns": [
                    "ANODE AVAILABILITY",
                    "UOM",
                    "NORMS (Month)",
                    "ON DATE(Day)",
                    "MTD",
                    "YTD",
                ],
                "query": {
                    "ANODE_AVAILABILITY": [
                        SterliteRefineryQuery.AnodeAvailability.QUERY_1,
                        SterliteRefineryQuery.AnodeAvailability.QUERY_2,
                        SterliteRefineryQuery.AnodeAvailability.QUERY_3,
                    ],
                    "DO CELLS IN OPERATION": [
                        SterliteRefineryQuery.DOCellsInOperation.QUERY_1
                    ],
                    "Total Cells In Operation": [
                        SterliteRefineryQuery.TotalCellsInOperation.QUERY_1,
                        SterliteRefineryQuery.TotalCellsInOperation.QUERY_2,
                        SterliteRefineryQuery.TotalCellsInOperation.QUERY_3,
                    ],
                },
                "data": [],
                "data_column": [
                    "anode_availability", "uom", "norms",
                    "on_date", "mtd", "ytd"],
            },
            "SAFETY REPORT": {
                "columns": ["SAFETY REPORT", "UOM", "NORMS", "ON DATE", "MTD", "YTD"],
                "query": {
                    "No. of Near Miss": [
                        SterliteRefineryQuery.NoOfNearMiss.QUERY_1,
                        SterliteRefineryQuery.NoOfNearMiss.QUERY_2,
                        SterliteRefineryQuery.NoOfNearMiss.QUERY_3,
                    ],
                    "No. of First Aid": [
                        SterliteRefineryQuery.NoOfFirstAid.QUERY_1,
                        SterliteRefineryQuery.NoOfFirstAid.QUERY_2,
                        SterliteRefineryQuery.NoOfFirstAid.QUERY_3,
                    ]
                },
                "data": [],
                "data_column": ["safety_report", "uom", "norms",
                                "on_date", "mtd", "ytd"],
            },
        },
        {
            "POWER AVAILABILITY": {
                "columns": [
                    "POWER AVAILABILITY",
                    "UOM",
                    "NORMS",
                    "ON DATE",
                    "MTD",
                    "YTD",
                ],
                "query": {
                    "Grid Power Availability": [
                        SterliteRefineryQuery.GridPowerAvailability.QUERY_1,
                        SterliteRefineryQuery.GridPowerAvailability.QUERY_2,
                        SterliteRefineryQuery.GridPowerAvailability.QUERY_3,
                    ],
                    "Cir 1 Avg. Rectifier Running Hrs.": [
                        SterliteRefineryQuery.Circulation1.QUERY_1,
                        SterliteRefineryQuery.Circulation1.QUERY_2,
                        SterliteRefineryQuery.Circulation1.QUERY_3,
                    ],
                    "Cir 2 Avg. Rectifier Running Hrs.": [
                        SterliteRefineryQuery.Circulation2.QUERY_1,
                        SterliteRefineryQuery.Circulation2.QUERY_2,
                        SterliteRefineryQuery.Circulation2.QUERY_3,
                    ],
                    "Power Availability to Cir-1": [
                        SterliteRefineryQuery.PowerAvailabilityCir1.QUERY_1,
                        SterliteRefineryQuery.PowerAvailabilityCir1.QUERY_2,
                        SterliteRefineryQuery.PowerAvailabilityCir1.QUERY_3,
                    ],
                    "Power Availability to Cir-2": [
                        SterliteRefineryQuery.PowerAvailabilityCir2.QUERY_1,
                        SterliteRefineryQuery.PowerAvailabilityCir2.QUERY_2,
                        SterliteRefineryQuery.PowerAvailabilityCir2.QUERY_3,
                    ],
                    "Power Availability to Cell House": [
                        SterliteRefineryQuery.PowerAvailabilityCellHouse.QUERY_1,
                        SterliteRefineryQuery.PowerAvailabilityCellHouse.QUERY_2,
                        SterliteRefineryQuery.PowerAvailabilityCellHouse.QUERY_3,
                    ],
                    "Cir-1 40 KA Rectifier Avg. Current": [
                        SterliteRefineryQuery.Cir140KARectifierAvgCurrent.QUERY_1,
                        SterliteRefineryQuery.Cir140KARectifierAvgCurrent.QUERY_2,
                        SterliteRefineryQuery.Cir140KARectifierAvgCurrent.QUERY_3,
                    ],
                    "Cir-2 35 KA Rectifier Avg. Current": [
                        SterliteRefineryQuery.Cir235KARectifierAvgCurrent.QUERY_1,
                        SterliteRefineryQuery.Cir235KARectifierAvgCurrent.QUERY_2,
                        SterliteRefineryQuery.Cir235KARectifierAvgCurrent.QUERY_3,
                    ],
                    "Total Avg. Current": [
                        SterliteRefineryQuery.TotalAvgCurrent.QUERY_1,
                        SterliteRefineryQuery.TotalAvgCurrent.QUERY_2,
                        SterliteRefineryQuery.TotalAvgCurrent.QUERY_3,
                    ],
                    "Current Density": [
                        SterliteRefineryQuery.CurrentDensity.QUERY_1,
                        SterliteRefineryQuery.CurrentDensity.QUERY_2,
                        SterliteRefineryQuery.CurrentDensity.QUERY_3,
                    ]
                },
                "data": [],
                "data_column": ["power_availability", "uom",
                                "norms", "on_date", "mtd",
                                "ytd"],
            },
            "RM ANODE RECEIPT DETAILS": {
                "columns": [
                    "RM ANODE RECEIPT DETAILS",
                    "ON DATE",
                    "MTD",
                    "YTD",
                    "Material",
                    "OPENING STOCK",
                ],
                "query": {
                    "AcpCcpcCcp": [
                        SterliteRefineryQuery.AcpCcpcCcp.QUERY_1,
                    ]
                },
                "data": [],
                "data_column": ["rm_anode_receipt_details", "on_date",
                                "mtd", "ytd", "material", "opening_stock"],
            },
        },
        {
            "EFFICIENCIES": {
                "columns": ["EFFICIENCIES", "UOM", "NORMS", "ON DATE", "MTD", "YTD"],
                "query": {
                    "CurrentEfficiency": [
                        SterliteRefineryQuery.CurrentEfficiency.QUERY_1,
                        SterliteRefineryQuery.CurrentEfficiency.QUERY_2,
                        SterliteRefineryQuery.CurrentEfficiency.QUERY_3,
                    ],
                    "TimeEfficiency": [
                        SterliteRefineryQuery.TimeEfficiency.QUERY_1,
                        SterliteRefineryQuery.TimeEfficiency.QUERY_2,
                        SterliteRefineryQuery.TimeEfficiency.QUERY_3,
                    ],
                    "E40KARectifierEfficiency": [
                        SterliteRefineryQuery.E40KARectifierEfficiency.QUERY_1,
                        SterliteRefineryQuery.E40KARectifierEfficiency.QUERY_2,
                        SterliteRefineryQuery.E40KARectifierEfficiency.QUERY_3,
                    ],
                    "E35KARectifierEfficiency": [
                        SterliteRefineryQuery.E35KARectifierEfficiency.QUERY_1,
                        SterliteRefineryQuery.E35KARectifierEfficiency.QUERY_2,
                        SterliteRefineryQuery.E35KARectifierEfficiency.QUERY_3,
                    ],
                    "SpentAnodeGenerationRate": [
                        SterliteRefineryQuery.SpentAnodeGenerationRate.QUERY_1,
                        SterliteRefineryQuery.SpentAnodeGenerationRate.QUERY_2,
                        SterliteRefineryQuery.SpentAnodeGenerationRate.QUERY_3,
                    ]
                },
                "data": [],
                "data_column": ["efficiencies", "uom", "norms",
                                "on_date", "mtd", "ytd"],
            },
            "BANK / CROP": {
                "columns": [
                    "BANK / CROP",
                    "CE (%)",
                    "THEOR. WEIGHT",
                    "ACTUAL WEIGHT",
                    "STRIPPING TIME",
                ],
                "query": {
                    "BANK / CROP": [
                        SterliteRefineryQuery.BankCropStripping.QUERY_1,
                    ]
                },
                "data": [],
                "data_column": ["bank_crop", "ce", "theor_weight",
                                "actual_weight", "stripping_time"],
            },
        },
        {
            "PRODUCTION": {
                "columns": ["PRODUCTION", "UOM", "NORMS", "ON DATE", "MTD", "YTD"],
                "query": {
                    "CathodeDeposit": [
                        SterliteRefineryQuery.CathodeDeposit.QUERY_1,
                        SterliteRefineryQuery.CathodeDeposit.QUERY_2,
                        SterliteRefineryQuery.CathodeDeposit.QUERY_3,
                    ],
                    "CathodeProductionSAP": [
                        SterliteRefineryQuery.CathodeProductionSAP.QUERY_1,
                        SterliteRefineryQuery.CathodeProductionSAP.QUERY_2,
                        SterliteRefineryQuery.CathodeProductionSAP.QUERY_3,
                    ],
                    "DepositCellDay": [
                        SterliteRefineryQuery.DepositCellDay.QUERY_1,
                        SterliteRefineryQuery.DepositCellDay.QUERY_2,
                        SterliteRefineryQuery.DepositCellDay.QUERY_3,
                    ]
                },
                "data": [],
                "data_column": ["production", "uom", "norms",
                                "on_date", "mtd", "ytd"],
            },
            "CIRCULATION": {
                "columns": ["CIRCULATION", "CE%", "THEOR. WEIGHT", "ACTUAL WEIGHT"],
                "query": {
                    "Cir1Cir2": [
                        SterliteRefineryQuery.Cir1Cir2.QUERY_1,
                    ],
                    "TotalCirculation": [
                        SterliteRefineryQuery.TotalCirculation.QUERY_1,
                    ]
                },
                "data": [],
                "data_column": ["circulation", "ce", "theor_weight", "actual_weight"],
            },
        },
        {
            "FG INVENTORY": {
                "columns": ["FG INVENTORY", "ON DATE", "MTD", "YTD"],
                "query": {
                    "Cathode": [
                        SterliteRefineryQuery.Cathode.QUERY_1,
                        SterliteRefineryQuery.Cathode.QUERY_2,
                        SterliteRefineryQuery.Cathode.QUERY_3,
                    ],
                    "NiSO4": [
                        SterliteRefineryQuery.NiSO4.QUERY_1,
                        SterliteRefineryQuery.NiSO4.QUERY_2,
                        SterliteRefineryQuery.NiSO4.QUERY_3,
                    ],
                    "RawSlime": [
                        SterliteRefineryQuery.RawSlime.QUERY_1,
                        SterliteRefineryQuery.RawSlime.QUERY_2,
                        SterliteRefineryQuery.RawSlime.QUERY_3,
                    ],
                    "CuSo4": [
                        SterliteRefineryQuery.CuSo4.QUERY_1,
                        SterliteRefineryQuery.CuSo4.QUERY_2,
                        SterliteRefineryQuery.CuSo4.QUERY_3,
                    ],
                },
                "data": [],
                "data_column": ["fg_inventory", "on_date", "mtd", "ytd"],
            },
            "PRODUCTION": {
                "columns": ["PRODUCTION", "ON DATE", "MTD", "YTD"],
                "query": {
                    "FGProdCathode": [
                        SterliteRefineryQuery.FGProdCathode.QUERY_1,
                        SterliteRefineryQuery.FGProdCathode.QUERY_2,
                        SterliteRefineryQuery.FGProdCathode.QUERY_3,
                    ],
                    "FGProdNiSO4": [
                        SterliteRefineryQuery.FGProdNiSO4.QUERY_1,
                        SterliteRefineryQuery.FGProdNiSO4.QUERY_2,
                        SterliteRefineryQuery.FGProdNiSO4.QUERY_3,
                    ],
                    "FGProdRawSlime": [
                        SterliteRefineryQuery.FGProdRawSlime.QUERY_1,
                        SterliteRefineryQuery.FGProdRawSlime.QUERY_2,
                        SterliteRefineryQuery.FGProdRawSlime.QUERY_3,
                    ],
                    "FGProdCuSo4": [
                        SterliteRefineryQuery.FGProdCuSo4.QUERY_1,
                        SterliteRefineryQuery.FGProdCuSo4.QUERY_2,
                        SterliteRefineryQuery.FGProdCuSo4.QUERY_3,
                    ],
                },
                "data": [],
                "data_column": ["production", "on_date", "mtd", "ytd"],
            },
        },
        {
            "CROP": {
                "columns": [
                    "CROP",
                    "BANKS",
                    "TOTAL CELLS",
                    "CELL VOLTAGE (V)",
                    "T. SHORTS / CELL / CHECK",
                ],
                "query": {
                    "CROP": [
                        SterliteRefineryQuery.CropCir.QUERY_1,
                    ]
                },
                "data": [],
                "data_column": ["crop", "banks", "total_cells",
                                "cell_voltage", "t_shorts"],
            },
            "DEPOSIT LOSS (-) / GAIN (+) DETAILS": {
                "columns": [
                    "CATEGORY",
                    "ON DATE",
                    "TILL DATE"
                ],
                "query": {},
                "data": [],
                "data_column": [
                    "category",
                    "on_date",
                    "till_date"
                ],
            }
        },
        {
            "STRIPPING TIME": {
                "columns": [
                    "STRIPPING TIME",
                    "UOM",
                    "1st CROP - Stripping time",
                    "2nd CROP - Change over time",
                    "3rd CROP"
                ],
                "query": {
                    "StrippingTime": [
                        SterliteRefineryQuery.StrippingTime.QUERY_1
                    ]
                },
                "data": [],
                "data_column": [
                    "stripping_time", "uom", "1st_crop",
                    "2nd_crop", "3rd_crop"
                ],
            },
            "CSM PLATE REJECTION": {
                "columns": [
                    "CSM Plate Rejection",
                    "UOM",
                    "ON DATE"
                ],
                "query": {
                    "StrippingTime": [
                        SterliteRefineryQuery.CsmPlateRejection.QUERY_1
                    ]
                },
                "data": [],
                "data_column": [
                    "csm_plate_rejection", "uom", "on_date"
                ],
            }
        },
        {
            "FILTER AVAILABILITY": {
                "columns": [
                    "FILTER AVAILABILITY",
                    "UOM",
                    "NORMS",
                    "ON DATE",
                    "MTD",
                    "YTD"
                ],
                "query": {
                    "FilterAvailability": [
                        SterliteRefineryQuery.FilterAvailability.QUERY_1,
                        SterliteRefineryQuery.FilterAvailability.QUERY_2,
                        SterliteRefineryQuery.FilterAvailability.QUERY_3,
                    ]
                },
                "data": [],
                "data_column": [
                    "filter_availability", "uom", "norms", "on_date", "mtd", "ytd"
                ],
            },
            "FILTERED VOLUME": {
                "columns": [
                    "FILTERED VOLUME"
                ],
                "query": {
                    "FilterAvailability": [
                        SterliteRefineryQuery.FilteredVolume.QUERY_1
                    ]
                },
                "data": [],
                "data_column": [
                    "filter_availability"
                ],
            },
            "TOTAL VOLUME REFINERY": {
                "columns": [
                    "TOTAL VOLUME REFINERY"
                ],
                "query": {
                    "TotalVolumeRefinery": [
                        SterliteRefineryQuery.TotalVolumeRefinery.QUERY_1
                    ]
                },
                "data": [],
                "data_column": [
                    "total_volume_refinery"
                ],
            },
        },
        {
            "SPECIFIC ENERGY CONSUMPTION": {
                "columns": [
                    "UTILITIES CONSUMPTIONS",
                    "UOM",
                    "NORMS",
                    "ON DATE",
                    "MTD",
                    "YTD",
                ],
                "query": {
                    "SteamConsumptionForMachines": [
                        SterliteRefineryQuery.SteamConsumptionForMachines.QUERY_1,
                        SterliteRefineryQuery.SteamConsumptionForMachines.QUERY_2,
                        SterliteRefineryQuery.SteamConsumptionForMachines.QUERY_3,
                    ],
                    "SteamConsumptionForCellHouse": [
                        SterliteRefineryQuery.SteamConsumptionForCellHouse.QUERY_1,
                        SterliteRefineryQuery.SteamConsumptionForCellHouse.QUERY_2,
                        SterliteRefineryQuery.SteamConsumptionForCellHouse.QUERY_3,
                    ],
                    "SteamConsumptionTotal": [
                        SterliteRefineryQuery.SteamConsumptionTotal.QUERY_1,
                        SterliteRefineryQuery.SteamConsumptionTotal.QUERY_2,
                        SterliteRefineryQuery.SteamConsumptionTotal.QUERY_3,
                    ],
                    "SteamCSPlant": [
                        SterliteRefineryQuery.SteamCSPlant.QUERY_1,
                        SterliteRefineryQuery.SteamCSPlant.QUERY_2,
                        SterliteRefineryQuery.SteamCSPlant.QUERY_3,
                    ],
                    "SteamNSPlant": [
                        SterliteRefineryQuery.SteamNSPlant.QUERY_1,
                        SterliteRefineryQuery.SteamNSPlant.QUERY_2,
                        SterliteRefineryQuery.SteamNSPlant.QUERY_3,
                    ],
                    "SteamMEEPlant": [
                        SterliteRefineryQuery.SteamMEEPlant.QUERY_1,
                        SterliteRefineryQuery.SteamMEEPlant.QUERY_2,
                        SterliteRefineryQuery.SteamMEEPlant.QUERY_3,
                    ],
                    "AncillaryPowerConsumption": [
                        SterliteRefineryQuery.AncillaryPowerConsumption.QUERY_1,
                        SterliteRefineryQuery.AncillaryPowerConsumption.QUERY_2,
                        SterliteRefineryQuery.AncillaryPowerConsumption.QUERY_3,
                    ],
                    "PurificationPowerConsumption": [
                        SterliteRefineryQuery.PurificationPowerConsumption.QUERY_1,
                        SterliteRefineryQuery.PurificationPowerConsumption.QUERY_2,
                        SterliteRefineryQuery.PurificationPowerConsumption.QUERY_3,
                    ],
                    "RectifierPowerConsumption": [
                        SterliteRefineryQuery.RectifierPowerConsumption.QUERY_1,
                        SterliteRefineryQuery.RectifierPowerConsumption.QUERY_2,
                        SterliteRefineryQuery.RectifierPowerConsumption.QUERY_3,
                    ],
                    "PowerConsumptionMEE": [
                        SterliteRefineryQuery.PowerConsumptionMEE.QUERY_1,
                        SterliteRefineryQuery.PowerConsumptionMEE.QUERY_2,
                        SterliteRefineryQuery.PowerConsumptionMEE.QUERY_3,
                    ],
                    "PowerConsumptionCSNS": [
                        SterliteRefineryQuery.PowerConsumptionCSNS.QUERY_1,
                        SterliteRefineryQuery.PowerConsumptionCSNS.QUERY_2,
                        SterliteRefineryQuery.PowerConsumptionCSNS.QUERY_3,
                    ]
                },
                "data": [],
                "data_column": [
                    "utilities_consumptions",
                    "uom",
                    "norms",
                    "on_date",
                    "mtd",
                    "ytd",
                ],
            },
            "SPECIFIC CONSUMPTION": {
                "columns": ["CONSUMABLES", "UOM", "NORMS", "ON DATE", "MTD", "YTD"],
                "query": {
                    "EdgeStripConsumption": [
                        SterliteRefineryQuery.EdgeStripConsumption.QUERY_1,
                        SterliteRefineryQuery.EdgeStripConsumption.QUERY_2,
                        SterliteRefineryQuery.EdgeStripConsumption.QUERY_3,
                    ],
                    "PlateRepairing": [
                        SterliteRefineryQuery.PlateRepairing.QUERY_1,
                        SterliteRefineryQuery.PlateRepairing.QUERY_2,
                        SterliteRefineryQuery.PlateRepairing.QUERY_3,
                    ],
                    "WaxConsumption": [
                        SterliteRefineryQuery.WaxConsumption.QUERY_1,
                        SterliteRefineryQuery.WaxConsumption.QUERY_2,
                        SterliteRefineryQuery.WaxConsumption.QUERY_3,
                    ],
                    "GlueConsumption": [
                        SterliteRefineryQuery.GlueConsumption.QUERY_1,
                        SterliteRefineryQuery.GlueConsumption.QUERY_2,
                        SterliteRefineryQuery.GlueConsumption.QUERY_3,
                    ],
                    "ThioureaConsumption": [
                        SterliteRefineryQuery.ThioureaConsumption.QUERY_1,
                        SterliteRefineryQuery.ThioureaConsumption.QUERY_2,
                        SterliteRefineryQuery.ThioureaConsumption.QUERY_3,
                    ],
                    "HClAddition": [
                        SterliteRefineryQuery.HClAddition.QUERY_1,
                        SterliteRefineryQuery.HClAddition.QUERY_2,
                        SterliteRefineryQuery.HClAddition.QUERY_3,
                    ],
                    "H2SO4Addition": [
                        SterliteRefineryQuery.H2SO4Addition.QUERY_1,
                        SterliteRefineryQuery.H2SO4Addition.QUERY_2,
                        SterliteRefineryQuery.H2SO4Addition.QUERY_3,
                    ]
                },
                "data": [],
                "data_column": ["consumables", "uom", "norms", "on_date", "mtd",
                                "ytd"],
            },
        },
        {
            "ELECTROLYTE COMPOSITION": {
                "columns": [
                    "ELECTROLYTE COMPOSITION",
                    "UOM",
                    "NORMS",
                    "DATE",
                    "CIR-1",
                    "CIR-2",
                ],
                "query": {
                    "ElectrolyteComposition": [
                        SterliteRefineryQuery.ElectrolyteComposition.QUERY_1
                    ]
                },
                "data": [],
                "data_column": [
                    "electrolyte_composition",
                    "uom",
                    "norms",
                    "date",
                    "cir_1",
                    "cir_2",
                ],
            },
            "SUSPENDED SOLIDS 1": {
                "columns": [
                    "Cir-1: I/L",
                    "Cir-1: VALUES",
                ],
                "query": {
                    "SuspendedSolidsCir1": [
                        SterliteRefineryQuery.SuspendedSolidsCir1.QUERY_1,
                    ]
                },
                "data": [],
                "data_column": ["cir_1", "cir_1_values"],
            },
            "SUSPENDED SOLIDS 2": {
                "columns": [
                    "Cir-2: I/L",
                    "Cir-2: Values",
                ],
                "query": {
                    "SuspendedSolidsCir2": [
                        SterliteRefineryQuery.SuspendedSolidsCir2.QUERY_1,
                    ]
                },
                "data": [],
                "data_column": ["cir_2", "cir_2_values"],
            },
        },
        {
            "BLEEDING SECTION": {
                "columns": ["BLEEDING SECTION", "UOM", "ON DATE", "MTD", "YTD"],
                "query": [],
                "data": [],
                "data_column": ["bleeding_section", "uom", "on_date", "mtd", "ytd"],
            },
            "BANK / CROP": {
                "columns": ["BANK / CROP", "TIME", "WEIGHT (MT)", "CELLS", "READING"],
                "query": [],
                "data": [],
                "data_column": ["bank_crop", "time", "weight", "cells", "reading"],
            },
        },
        {
            "DEPARTMENT(M4)": {
                "columns": [
                    "DEPARTMENT(M4)", "EQUIPMENT DETAILS",
                    "EQUIPMENT LOCATION", "DURATION",
                    "(MT) PRODUCTION", "CAUSE OF THE BREAK DOWN",
                ],
                "query": [],
                "data": [],
                "data_column": [
                    "department(m4)", "equipment_details",
                    "equipment_location", "duration",
                    "production", "cause"],
            },
            "PM COMPLIANCE": {
                "columns": [
                    "PM COMPLIANCE",
                    "FTD",
                    "MTD",
                ],
                "query": [],
                "data": [],
                "data_column": [
                    "pm_compliance",
                    "ftd",
                    "mtd"
                ],
            }
        },
    ]
