from __future__ import annotations
from typing import Optional
from pydantic import BaseModel


class ReportInput(BaseModel):
    job_id: Optional[str]
    user_id: Optional[str]
    report: Optional[dict]
    property: Optional[dict]
    job_type: Optional[str]
    tz: Optional[str]
    file_name: Optional[str]


class ReportOutput(BaseModel):
    job_id: str
    file_path: str = ""
    file_name: Optional[str] = None
    is_schedule: Optional[bool] = False
    project_id: str
