"""
"""


class MainConstants:
    """
    Constants related to the main application
    """

    META_TAG_JSON = {
        "name": "Vision App 2.0: Cement Bag Event Processor",
        "description": "On Demand Service for capturing the events",
    }
    DESCRIPTION_KEY = "Cement Bag Event Processor"
    TOKEN_KEY = "token"


class APIConstants:
    """
    Constants related to API endpoints
    """

    STARTUP = "startup"
    SHUTDOWN = "shutdown"
    HEALTH_CHECK = "/healthcheck"

    CUSTOM_REPORT_ENDPOINT = "/custom_report"


class CommonConstants:
    """
    Common constants used in the application
    """

    GET = "GET"
    POST = "POST"
    CUSTOM_REPORT_TAG = "Event Handler Endpoints"
    EXCEPTION_RAISER = "Exception ->{}"
    DEV_KEY = "dev"
    DATE_TIME_FORMAT = "%Y-%m-%d"
    QUERY = "query"
    DAY_START_DATE = "day_start_date"
    DAY_END_DATE = "day_end_date"
    MONTH_START_DATE = "month_start_date"
    MONTH_END_DATE = "month_end_date"
    YEAR_START_DATE = "year_start_date"
    YEAR_END_DATE = "year_end_date"
    DATA_COLUMN = "data_column"
    DATA = "data"
    PROPERTY = "property"
    START_DATE = "start_date"
    END_DATE = "end_date"
    FREQUENCY = 'D'
    START_COLUMN = 0
    START_ROW = 2
    REFINERY_COLUMN_WIDTH = 27
    ACP_COLUMN_WIDTH = 24


class ReportType:
    """
    Constants related to ReportType
    """

    REFINERY_REPORT = "refinery_report"
    ACP_REPORT = "acp_report"
    CCPP_REPORT = "ccpp_report"
    REFINERY_WORKSHEET_NAME = "REFINERY DAILY PERFORMANCE REPORT"
    ACP_WORKSHEET_NAME_1 = "VEDANTA LIMITED"
    ACP_WORKSHEET_NAME_2 = "ANODE CASTING PLANT (ACP) - SHIFT INCHARGE LOG SHEET"
    DATE = "DATE"
    LOGO_IMAGE_PATH = "images/vedanta_sterlite_copper.png"


class PostgresConstant:
    """ Constant used in Postgre SQL """
    STRELITE_DATALAKE_DEV = "strelite-datalakedev"
    PROJECT_101__ILENS_AI = "project_101__ilens_ai"


figlet = """
  ____    _                   _   _   _          
 / ___|  | |_    ___   _ __  | | (_) | |_    ___ 
 \___ \  | __|  / _ \ | '__| | | | | | __|  / _ /
  ___) | | |_  |  __/ | |    | | | | | |_  |  __/
 |____/   \__|  \___| |_|    |_| |_|  \__|  \___|

  ____                                  _   
 |  _ \    ___   _ __     ___    _ __  | |_ 
 | |_) |  / _ \ | '_ \   / _ \  | '__| | __|
 |  _ <  |  __/ | |_) | | (_) | | |    | |_ 
 |_| \_\  \___| | .__/   \___/  |_|     \__|
                |_|                         
"""
