"""
This __init__ file contains the configuration settings for the application
"""
import os
import shutil

from pydantic import BaseSettings
from dotenv import load_dotenv

""" Loading dot env file"""
load_dotenv("dev-variables.env")


class SecurityDetails(BaseSettings):
    """
    Configuration class for security token details
    """
    secure_cookie: bool
    lock_out_time_mins: int
    leeway_in_mins: int
    token: str
    issuer: str
    alg: str
    public_key_path: str
    private_key_path: str


class ServiceDetails(BaseSettings):
    """
    Configuration class for application service details
    """
    host_name: str
    port_name: str
    env: str
    exception_trace: bool


class LoggingDetails(BaseSettings):
    """
    Configuration class for logging database details
    """
    log_base_path: str
    log_level: str
    max_bytes: int
    handler_type: str
    log_file_name: str
    backup_count: int


class PostgresDetails(BaseSettings):
    """
    Configuration class for PostgreSQL database details.

    Config:
        env_prefix (str): The environment variable prefix for PostgreSQL settings.
    """
    uri: str
    host: str
    port: str
    username: str
    password: str
    database: str

    class Config:
        env_prefix = "POSTGRES_"


class RedisDetails(BaseSettings):
    """
    Configuration class for Redis database details

    Config:
        env_prefix (str): The environment variable prefix for Redis settings.
    """

    uri: str
    login_db: int
    dashboard_db: int
    live_tag_db: int
    live_previous_tag_db: int
    partition_db: int
    project_tags_db: int

    class Config:
        env_prefix = "REDIS_"


security_conf_details = SecurityDetails()
service_details = ServiceDetails()
logging_details = LoggingDetails()
postgres_details = PostgresDetails()
redis_details = RedisDetails()
