class SterliteRefineryQuery:
    """
    Refinery report queries
    """

    class AnodeAvailability:
        QUERY_1 = """
        SELECT 
        'Cell House Anode Availability' AS ANODE_AVAILABILITY,
        '%' AS UOM,
        AVG(ANODE.AA_PLANNED) AS NORMS,
        (SUM(ANODE.NUMERATOR) / NULLIF(SUM(DENOMINATOR), 0)) * 100 AS ON_DATE
        
        FROM
            (SELECT ACTUAL.AA_NUMO AS NUMERATOR,
                    ACTUAL.AA_DENO AS DENOMINATOR,
                    PLAN.AA_PLANNED,
                    COALESCE(ACTUAL.DATE,
        
                        PLAN.DATE) AS date
                FROM SEMANTIC_PROD.REFINERY_ANODE_AVAILABILITY_ACTUAL_VIEW ACTUAL
                FULL JOIN
                    (SELECT DD_1.DATE_DT AS date,
                            M_PLAN.AA_PLANNED
                        FROM
                            (SELECT DATE(date) AS POSTING_DATE,
                                    ANODE_AVAILABILITY_VALUE::numeric AS AA_PLANNED
                                FROM SEMANTIC_DEV.ANODE_AVAILABILITY
                                WHERE 
                             LOWER(TRIM(ANODE_AVAILABILITY_SELECT)) = 
                             'anode availability'
                                    AND DATE_PART('day',date) = 1
                                GROUP BY 1,
                                    2)M_PLAN
                        LEFT JOIN
                            (SELECT DIM_DATE.DATE_DT,
                                    DIM_DATE.MONTH_OF_YR_NUM AS MNTH,
                                    DIM_DATE.YR_NAME AS YR
                                FROM SEMANTIC_PROD.DIM_DATE) DD_1 ON 
                     DD_1.MNTH = DATE_PART('month', M_PLAN.POSTING_DATE)
                        AND DD_1.YR = DATE_PART('year', M_PLAN.POSTING_DATE))PLAN 
             ON ACTUAL.DATE = PLAN.DATE)ANODE
        
        WHERE 
        DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
        
        GROUP BY
        1,2;
        """
        QUERY_2 = """
                SELECT 
                'Cell House Anode Availability' AS ANODE_AVAILABILITY,
                '%' AS UOM,
                (SUM(ANODE.NUMERATOR) / NULLIF(SUM(DENOMINATOR), 0)) * 100 AS MTD

                FROM
                (SELECT ACTUAL.AA_NUMO AS NUMERATOR,
                        ACTUAL.AA_DENO AS DENOMINATOR,
                        PLAN.AA_PLANNED,
                        COALESCE(ACTUAL.DATE,

                            PLAN.DATE) AS date
                    FROM SEMANTIC_PROD.REFINERY_ANODE_AVAILABILITY_ACTUAL_VIEW ACTUAL
                    FULL JOIN
                        (SELECT DD_1.DATE_DT AS date,
                                M_PLAN.AA_PLANNED
                            FROM
                                (SELECT DATE(date) AS POSTING_DATE,
                                        ANODE_AVAILABILITY_VALUE::numeric AS AA_PLANNED
                                    FROM SEMANTIC_DEV.ANODE_AVAILABILITY
                                    WHERE 
                                 LOWER(TRIM(ANODE_AVAILABILITY_SELECT)) = 
                                 'anode availability'
                                        AND DATE_PART('day',date) = 1
                                    GROUP BY 1,
                                        2)M_PLAN
                            LEFT JOIN
                                (SELECT DIM_DATE.DATE_DT,
                                        DIM_DATE.MONTH_OF_YR_NUM AS MNTH,
                                        DIM_DATE.YR_NAME AS YR
                                    FROM SEMANTIC_PROD.DIM_DATE) DD_1 ON 
                         DD_1.MNTH = DATE_PART('month', M_PLAN.POSTING_DATE)
                            AND DD_1.YR = DATE_PART('year', M_PLAN.POSTING_DATE))PLAN 
                     ON ACTUAL.DATE = PLAN.DATE)ANODE

                WHERE 
                DATE BETWEEN '{month_start_date}' AND '{month_end_date}'

                GROUP BY
                1,2;
                """
        QUERY_3 = """
                SELECT 
                'Cell House Anode Availability' AS ANODE_AVAILABILITY,
                '%' AS UOM,
                (SUM(ANODE.NUMERATOR) / NULLIF(SUM(DENOMINATOR), 0)) * 100 AS YTD

                FROM
                (SELECT ACTUAL.AA_NUMO AS NUMERATOR,
                        ACTUAL.AA_DENO AS DENOMINATOR,
                        PLAN.AA_PLANNED,
                        COALESCE(ACTUAL.DATE,

                            PLAN.DATE) AS date
                    FROM SEMANTIC_PROD.REFINERY_ANODE_AVAILABILITY_ACTUAL_VIEW ACTUAL
                    FULL JOIN
                        (SELECT DD_1.DATE_DT AS date,
                                M_PLAN.AA_PLANNED
                            FROM
                                (SELECT DATE(date) AS POSTING_DATE,
                                        ANODE_AVAILABILITY_VALUE::numeric AS AA_PLANNED
                                    FROM SEMANTIC_DEV.ANODE_AVAILABILITY
                                    WHERE 
                                 LOWER(TRIM(ANODE_AVAILABILITY_SELECT)) = 
                                 'anode availability'
                                        AND DATE_PART('day',date) = 1
                                    GROUP BY 1,
                                        2)M_PLAN
                            LEFT JOIN
                                (SELECT DIM_DATE.DATE_DT,
                                        DIM_DATE.MONTH_OF_YR_NUM AS MNTH,
                                        DIM_DATE.YR_NAME AS YR
                                    FROM SEMANTIC_PROD.DIM_DATE) DD_1 ON 
                         DD_1.MNTH = DATE_PART('month', M_PLAN.POSTING_DATE)
                            AND DD_1.YR = DATE_PART('year', M_PLAN.POSTING_DATE))PLAN 
                 ON ACTUAL.DATE = PLAN.DATE)ANODE

                WHERE 
                DATE BETWEEN '{year_start_date}' AND '{year_end_date}'

                GROUP BY
                1,2;
                """

    class DOCellsInOperation:
        QUERY_1 = """
        SELECT 
        'DO Cells In Operation' AS ANODE_AVAILABILITY,
        'No.' AS UOM, 
        MAX(CASE 
            WHEN LOWER(TRIM(KPI)) = 'liberator_cells_plan' THEN METRIC_VALUE END) 
            AS NORMS,
        MAX(CASE 
            WHEN LOWER(TRIM(KPI)) = 'liberator_cells_actual' THEN METRIC_VALUE END) 
            AS ON_DATE,
        MAX(CASE 
            WHEN LOWER(TRIM(KPI)) = 'liberator_cells_actual' THEN METRIC_VALUE END) 
            AS MTD,
        MAX(CASE 
            WHEN LOWER(TRIM(KPI)) = 'liberator_cells_actual' THEN METRIC_VALUE END) 
            AS YTD
        
        FROM 
        SEMANTIC_PROD.BANKS_CELLS_LIBERATORS_VIEW
        
        GROUP BY 
        1,2
        """

    class TotalCellsInOperation:
        QUERY_1 = """
        SELECT 
        'Total Cells In Operation' AS ANODE_AVAILABILITY,
        'No.' AS UOM,
        MAX(NORMS) AS NORMS,
        MAX(METRIC_VALUE) AS ON_DATE
        
        FROM
            (SELECT KPI,
                    CASE
                        WHEN LOWER(TRIM(KPI)) = 'operational_cells_plan' 
                        THEN ROUND(AVG(METRIC_VALUE))
                        ELSE NULL
                    END AS NORMS,
                    CASE
                        WHEN LOWER(TRIM(KPI)) = 'operational_cells_actual' 
                        THEN ROUND(AVG(METRIC_VALUE))
                        ELSE NULL
                    END AS METRIC_VALUE
                FROM SEMANTIC_PROD.REFINERY_OPERATIONAL_CELLS_VIEW
                WHERE LOWER(TRIM(KPI)) in 
                ('operational_cells_actual', 'operational_cells_plan')
                    AND (date BETWEEN '{day_start_date}' AND '{day_end_date}')
                GROUP BY 1)OP_CELLS
        GROUP BY 1,2
        """
        QUERY_2 = """
        SELECT 
        'Total Cells In Operation' AS ANODE_AVAILABILITY,
        'No.' AS UOM,
        MAX(METRIC_VALUE) AS MTD
        
        FROM
            (SELECT KPI,
                    CASE
                        WHEN LOWER(TRIM(KPI)) = 'operational_cells_plan' THEN ROUND(AVG(METRIC_VALUE))
                        ELSE NULL
                    END AS NORMS,
                    CASE
                        WHEN LOWER(TRIM(KPI)) = 'operational_cells_actual' THEN ROUND(AVG(METRIC_VALUE))
                        ELSE NULL
                    END AS METRIC_VALUE
                FROM SEMANTIC_PROD.REFINERY_OPERATIONAL_CELLS_VIEW
                WHERE LOWER(TRIM(KPI)) in ('operational_cells_actual', 'operational_cells_plan')
                    AND (date BETWEEN '{month_start_date}' AND '{month_end_date}')
                GROUP BY 1)OP_CELLS
        GROUP BY 1,2
        """
        QUERY_3 = """
                SELECT 
                'Total Cells In Operation' AS ANODE_AVAILABILITY,
                'No.' AS UOM,
                MAX(METRIC_VALUE) AS YTD

                FROM
                (SELECT KPI,
                        CASE
                            WHEN LOWER(TRIM(KPI)) = 'operational_cells_plan' 
                            THEN ROUND(AVG(METRIC_VALUE))
                            ELSE NULL
                        END AS NORMS,
                        CASE
                            WHEN LOWER(TRIM(KPI)) = 'operational_cells_actual' 
                            THEN ROUND(AVG(METRIC_VALUE))
                            ELSE NULL
                        END AS METRIC_VALUE
                    FROM SEMANTIC_PROD.REFINERY_OPERATIONAL_CELLS_VIEW
                    WHERE LOWER(TRIM(KPI)) in 
                    ('operational_cells_actual', 'operational_cells_plan')
                        AND (date BETWEEN '{year_start_date}' AND '{year_end_date}')
                    GROUP BY 1)OP_CELLS
                GROUP BY 1,2
                """

    class NoOfNearMiss:
        QUERY_1 = """
        SELECT 
            CASE
                WHEN LOWER(TRIM(KPI)) = 'first aid' THEN 'No. of First Aid'
                WHEN LOWER(TRIM(KPI)) = 'near miss' THEN 'No. of Near Miss'
            ELSE NULL
            END AS safety_report,
            
            'No.' AS UOM,
            0 AS NORMS,
            ROUND(SUM(METRIC_VALUE), 2) AS ON_DATE
        FROM SEMANTIC_PROD.REFINERY_HSE_VIEW
        WHERE LOWER(TRIM(KPI)) in ('near miss') 
        AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
        GROUP BY 1,2,3
        """
        QUERY_2 = """
        SELECT 
            CASE
                WHEN LOWER(TRIM(KPI)) = 'first aid' THEN 'No. of First Aid'
                WHEN LOWER(TRIM(KPI)) = 'near miss' THEN 'No. of Near Miss'
            ELSE NULL
            END AS safety_report,

            'No.' AS UOM,
            0 AS NORMS,
            ROUND(SUM(METRIC_VALUE), 2) AS MTD
        FROM SEMANTIC_PROD.REFINERY_HSE_VIEW
        WHERE LOWER(TRIM(KPI)) in ('near miss') 
        AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
        GROUP BY 1,2,3
        """
        QUERY_3 = """
        SELECT 
            CASE
                WHEN LOWER(TRIM(KPI)) = 'first aid' THEN 'No. of First Aid'
                WHEN LOWER(TRIM(KPI)) = 'near miss' THEN 'No. of Near Miss'
            ELSE NULL
            END AS safety_report,

            'No.' AS UOM,
            0 AS NORMS,
            ROUND(SUM(METRIC_VALUE), 2) AS YTD
        FROM SEMANTIC_PROD.REFINERY_HSE_VIEW
        WHERE LOWER(TRIM(KPI)) in ('near miss') 
        AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
        GROUP BY 1,2,3
        """

    class NoOfFirstAid:
        QUERY_1 = """
        SELECT 
            CASE
                WHEN LOWER(TRIM(KPI)) = 'first aid' THEN 'No. of First Aid'
                WHEN LOWER(TRIM(KPI)) = 'near miss' THEN 'No. of Near Miss'
            ELSE NULL
            END AS safety_report,

            'No.' AS UOM,
            0 AS NORMS,
            ROUND(SUM(METRIC_VALUE), 2) AS ON_DATE
        FROM SEMANTIC_PROD.REFINERY_HSE_VIEW
        WHERE LOWER(TRIM(KPI)) in ('first aid') 
        AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
        GROUP BY 1,2,3
        """
        QUERY_2 = """
        SELECT 
            CASE
                WHEN LOWER(TRIM(KPI)) = 'first aid' THEN 'No. of First Aid'
                WHEN LOWER(TRIM(KPI)) = 'near miss' THEN 'No. of Near Miss'
            ELSE NULL
            END AS safety_report,

            'No.' AS UOM,
            0 AS NORMS,
            ROUND(SUM(METRIC_VALUE), 2) AS MTD
        FROM SEMANTIC_PROD.REFINERY_HSE_VIEW
        WHERE LOWER(TRIM(KPI)) in ('first aid') 
        AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
        GROUP BY 1,2,3
        """
        QUERY_3 = """
        SELECT 
            CASE
                WHEN LOWER(TRIM(KPI)) = 'first aid' THEN 'No. of First Aid'
                WHEN LOWER(TRIM(KPI)) = 'near miss' THEN 'No. of Near Miss'
            ELSE NULL
            END AS safety_report,

            'No.' AS UOM,
            0 AS NORMS,
            ROUND(SUM(METRIC_VALUE), 2) AS YTD
        FROM SEMANTIC_PROD.REFINERY_HSE_VIEW
        WHERE LOWER(TRIM(KPI)) in ('first aid') 
        AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
        GROUP BY 1,2,3
        """

    class Cir140KARectifierAvgCurrent:
        QUERY_1 = """
                SELECT 
                'Cir-1 40 KA Rectifier Avg. Current' AS power_availability,
                'KAmp' AS uom,
                AVG(PLAN_METRIC_VALUE) AS norms,
                SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(
                CASE 
                    WHEN ACTUAL_METRIC_VALUE <> 0 THEN 1 
                    ELSE NULL END), 0), 1) AS on_date
                    
                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) = '40ka_rectifier_current'
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1,2
                """
        QUERY_2 = """
                SELECT 
                'Cir-1 40 KA Rectifier Avg. Current' AS power_availability,
                'KAmp' AS uom,
                SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(
                CASE 
                    WHEN ACTUAL_METRIC_VALUE <> 0 THEN 1 
                    ELSE NULL END), 0), 1) AS mtd

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) = '40ka_rectifier_current'
                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1,2
                """
        QUERY_3 = """
                SELECT 
                'Cir-1 40 KA Rectifier Avg. Current' AS power_availability,
                'KAmp' AS uom,
                SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(
                CASE 
                    WHEN ACTUAL_METRIC_VALUE <> 0 THEN 1 
                    ELSE NULL END), 0), 1) AS ytd

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) = '40ka_rectifier_current'
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1,2
                """

    class Cir235KARectifierAvgCurrent:
        QUERY_1 = """
                SELECT 
                'Cir-2 35 KA Rectifier Avg. Current' AS power_availability,
                'KAmp' AS uom,
                AVG(PLAN_METRIC_VALUE) AS norms,
                SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(
                    CASE
                    WHEN ACTUAL_METRIC_VALUE <> 0 
                    THEN 1 ELSE NULL END), 0), 1) 
                    AS on_date
                    
                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) = '35ka_rectifier_current'
                    AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1,2
                """
        QUERY_2 = """
                SELECT 
                'Cir-2 35 KA Rectifier Avg. Current' AS power_availability,
                'KAmp' AS uom,
                SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(
                    CASE
                    WHEN ACTUAL_METRIC_VALUE <> 0 
                    THEN 1 ELSE NULL END), 0), 1) 
                    AS mtd

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) = '35ka_rectifier_current'
                    AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1,2
                """
        QUERY_3 = """
                SELECT 
                'Cir-2 35 KA Rectifier Avg. Current' AS power_availability,
                'KAmp' AS uom,
                SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(
                    CASE
                    WHEN ACTUAL_METRIC_VALUE <> 0 
                    THEN 1 ELSE NULL END), 0), 1) 
                    AS ytd

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) = '35ka_rectifier_current'
                    AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1,2
                """

    class TotalAvgCurrent:
        QUERY_1 = """
                SELECT 
                'Total Avg. Current' AS power_availability,
                'KAmp' AS uom,
                AVG(PLAN_METRIC_VALUE) AS norms,
                SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(
                CASE WHEN ACTUAL_METRIC_VALUE <> 0 THEN 1
                ELSE NULL END), 0), 1) AS on_date
                
                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) in 
                ('40ka_rectifier_current', '35ka_rectifier_current')
                
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1,2
                """
        QUERY_2 = """
                SELECT 
                'Total Avg. Current' AS power_availability,
                'KAmp' AS uom,
                SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(
                CASE WHEN ACTUAL_METRIC_VALUE <> 0 THEN 1
                ELSE NULL END), 0), 1) AS mtd

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) in 
                ('40ka_rectifier_current', '35ka_rectifier_current')

                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1,2
                """
        QUERY_3 = """
                SELECT 
                'Total Avg. Current' AS power_availability,
                'KAmp' AS uom,
                SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(
                CASE WHEN ACTUAL_METRIC_VALUE <> 0 THEN 1
                ELSE NULL END), 0), 1) AS ytd

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) in 
                ('40ka_rectifier_current', '35ka_rectifier_current')

                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1,2
                """

    class CurrentDensity:
        QUERY_1 = """
                SELECT 
                'Current Density' AS power_availability,
                'Amp / m2' AS uom,
                AVG(NUMO_PLAN) AS norms,
                AVG(NUMO_ACTUAL) AS on_date
                
                FROM SEMANTIC_PROD.CE_CD_TE_DETAILED_VIEW CCTDV2
                WHERE 
                LOWER(TRIM(CATEGORY)) = 'cd'
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                """
        QUERY_2 = """
                SELECT 
                'Current Density' AS power_availability,
                'Amp / m2' AS uom,
                AVG(NUMO_ACTUAL) AS mtd

                FROM SEMANTIC_PROD.CE_CD_TE_DETAILED_VIEW CCTDV2
                WHERE 
                LOWER(TRIM(CATEGORY)) = 'cd'
                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                """
        QUERY_3 = """
                SELECT 
                'Current Density' AS power_availability,
                'Amp / m2' AS uom,
                AVG(NUMO_ACTUAL) AS ytd

                FROM SEMANTIC_PROD.CE_CD_TE_DETAILED_VIEW CCTDV2
                WHERE 
                LOWER(TRIM(CATEGORY)) = 'cd'
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                """
