from scripts.constants import PostgresConstant
from scripts.core.db.postgres.custom_report_query import SterliteCCPPQuery


class CCPCReportTemplate:
    CCPC_REPORT_TEMPLATE = [
        {
            "BLANK0": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            }
        },
        {
            "PARTICULARS": {
                "columns": [
                    "PARTICULARS",
                    "UNIT",
                    "ON DATE",
                    "MTD",
                ],
                "query": {},
                "data": [],
                "data_column": ["particulars", "unit", "on_date", "mtd",
                                ],
            },
            "BLANK0": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "LPG CONSUMPTION": {
                "columns": ["TOTAL BREAKDOWN DETAILS(MINS)", "DURATION(MINS)"],
                "query": {
                },
                "data": [],
                "data_column": ["kpi", "breakdown_duration_hours"],
            },
            "BLANK1": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "TOTAL BREAKDOWN DETAILS": {
                "columns": ["TEMP", "ON DATE"],
                "query": {

                },
                "data": [],
                "data_column": ["temp", "on_date"],
            },
            "BLANK2": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "MONTH WISE PRODUCTION": {
                "columns": ["POSITION", "SHIFT", "AVG-TEMP"],
                "query": {
                },
                "data": [],
                "data_column": ["position", "shift", "avg-temp"],
                "addition": {
                    "merge_header": "Furnace Shell Temp       	DCS - Data to be fetched shiftwise",
                }

            },

        },
        {
            "CHARGING DETAILS": {
                "columns": [
                    "DCS - DATA TO BE FETCHED SHIFTWISE",
                    "",
                    "6AM",
                    "7AM",
                    "8AM",
                    "1PM"
                ],
                "query": {
                },
                "data": [],
                "data_column": [
                    "dcs_data_to_be_fetched_shiftwise",
                    "",
                    "6am",
                    "7am",
                    "8am",
                    "1pm"
                ],
                "addition": {
                    "merge_header": "SHIFT-A",
                }
            },
            "BLANK0": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "INTERNAL ANODE REJECTION": {
                "columns": [
                    "DCS - DATA TO BE FETCHED SHIFTWISE",
                    "",
                    "6AM",
                    "7AM",
                    "8AM",
                    "1PM"
                ],
                "query": {
                },
                "data": [],
                "data_column": [
                    "dcs - data to be fetched shiftwise",
                    "",
                    "6am",
                    "7am",
                    "8am",
                    "1pm"
                ],
                "addition": {
                    "merge_header": "SHIFT-B",
                }
            },
            "BLANK1": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "PARTICULAR TEMP": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            }

        },
        {
            "TBC": {
                "columns": [
                    "DCS - DATA TO BE FETCHED SHIFTWISE",
                    "",
                    "6AM",
                    "7AM",
                    "8AM",
                    "1PM"
                ],
                "query": {
                },
                "data": [],
                "data_column": [
                    "dcs - data to be fetched shiftwise",
                    "",
                    "6am",
                    "7am",
                    "8am",
                    "1pm"
                ],
                "addition": {
                    "merge_header": "SHIFT-C",
                }
            }
        },
        {
            "PERSON ON DUTY": {
                "columns": ["SHIFT", "TIME", "TANK OUTLET PRESSURE", "VAP. OUTLET PRESSURE", "LINE. OUTLET PRESSURE",
                            "LINE. TEM "],
                "query": {
                },
                "data": [],
                "data_column": ["shift", "time", "tank outlet pressure", "vap. outlet pressure",
                                "line. outlet pressure", "line. tem "],
            },
        },
        {
            "PRODUCTION DETAILS": {
                "columns": ["PARAMATER", "AVG VALUE"],
                "query": {
                },
                "data": [],
                "data_column": ["parameter", "avg_value"]
            },
        },
        {
            "CONSUMPTION ITEMS": {
                "columns": ["CHARGING DETAILS", "A SHIFT", "B SHIFT", "C SHIFT", "TOTAL"],
                "query": {
                },
                "data": [],
                "data_column": ["charging_details", "shift_a", "shift_b", "shift_c", "total"],
            }

        },
        {
            "ACTIVITY TIME": {
                "columns": [
                    "PRODUCTION DETAILS-NO. OF ANODES",
                    "A SHIFT",
                    "B SHIFT",
                    "C SHIFT",
                    "TOTAL",
                    "A-SHIFT PRDN",
                    "B-SHIFT PRDN",
                    "C-SHIFT PRDN",
                    "OD PRODN (MT) ="
                ],
                "query": {

                },
                "data": [],
                "data_column": [
                    "production details-no. of anodes",
                    "a_shift",
                    "b_shift",
                    "c_shift",
                    "total",
                    "a_shift_prdn",
                    "b_shift_prdn",
                    "c_shift_prdn",
                    "od_prodn"
                ],
            }

        },
        {
            "A-SHIFT": {
                "columns": [
                    "CONSUMPTION ITEMS",
                    "UNIT",
                    "ON DATE",
                    "MTD",
                ],
                "query": {
                },
                "data": [],
                "data_column": [
                    "consumption_items",
                    "unit",
                    "on_date",
                    "mtd",
                ],
            },
            "BLANK0": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "LINEAR CASTING": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
        },
        {
            "A-SHIFT": {
                "columns": [
                    "CONSUMPTION ITEMS",
                    "UNIT",
                    "ON DATE",
                    "MTD",
                ],
                "query": {
                },
                "data": [],
                "data_column": [
                    "consumption_items",
                    "unit",
                    "on_date",
                    "mtd",
                ],
            },
            "BLANK0": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "LINEAR CASTING": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
        },
        {
            "SHIFT ACTIVITY": {
                "columns": [
                    "ACTIVITY-TIME",
                    "SHIFT",
                    "START TIME",
                    "END TIME",
                    "TOTAL TIME (MINUTES)",
                    "REASON FOR STOPAGE"
                ],
                "query": {
                },
                "data": [],
                "data_column": [
                    "activity_time",
                    "shift",
                    "start_time",
                    "end_time",
                    "total_time",
                    "reason_for_stopage"
                ],
            },
            "BLANK": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "CIRCULAR CASTING": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
        },
        {
            "B-SHIFT": {
                "columns": [
                    "CONSUMPTION ITEMS",
                    "UNIT",
                    "ON DATE",
                    "MTD",
                ],
                "query": {
                },
                "data": [],
                "data_column": [
                    "consumption_items",
                    "unit",
                    "on_date",
                    "mtd",
                ],
            },
            "BLANK0": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "LINEAR CASTING": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
        },
        {
            "SHIFT ACTIVITY": {
                "columns": [
                    "ACTIVITY-TIME",
                    "SHIFT",
                    "START TIME",
                    "END TIME",
                    "TOTAL TIME (MINUTES)",
                    "REASON FOR STOPAGE"
                ],
                "query": {
                },
                "data": [],
                "data_column": [
                    "activity_time",
                    "shift",
                    "start_time",
                    "end_time",
                    "total_time",
                    "reason_for_stopage"
                ],
            },
            "BLANK": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "CIRCULAR CASTING": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
        },
        {
            "C-SHIFT": {
                "columns": [
                    "CONSUMPTION ITEMS",
                    "UNIT",
                    "ON DATE",
                    "MTD",
                ],
                "query": {
                },
                "data": [],
                "data_column": [
                    "consumption_items",
                    "unit",
                    "on_date",
                    "mtd",
                ],
            },
            "BLANK0": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "LINEAR CASTING": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
        },
        {
            "SHIFT ACTIVITY": {
                "columns": [
                    "ACTIVITY-TIME",
                    "SHIFT",
                    "START TIME",
                    "END TIME",
                    "TOTAL TIME (MINUTES)",
                    "REASON FOR STOPAGE"
                ],
                "query": {
                },
                "data": [],
                "data_column": [
                    "activity_time",
                    "shift",
                    "start_time",
                    "end_time",
                    "total_time",
                    "reason_for_stopage"
                ],
            },
            "BLANK": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "CIRCULAR CASTING": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
        }
    ]
    WORKSHEET_HEADER_FORMAT = {
        "bold": True,
        "align": "center",
        "valign": "center",
        "fg_color": "#e6e7eb",
        "font_color": "#1b314f",
        "border": 1,
        'font_size': '20',
    }
    COLUMN_HEADER_FORMAT = {
        "bold": True,
        "align": "center",
        "valign": "center",
        "fg_color": "#e6e7eb",
        "font_color": "#021b5e",
        "border": 1,
    }
    BLANK_COLUMN_HEADER_FORMAT = {
        "bold": True,
        "align": "center",
        "valign": "center",
    }
