from scripts.core.db.postgres.custom_report_query import SterliteRefineryQuery


class SterliteRefineryTemplate:
    REPORT_TEMPLATE = [
        {
            "ANODE AVAILABILITY": {
                "columns": [
                    "ANODE AVAILABILITY",
                    "UOM",
                    "NORMS (Month)",
                    "ON DATE(Day)",
                    "MTD",
                    "YTD",
                ],
                "query": {
                    "ANODE_AVAILABILITY": [
                        SterliteRefineryQuery.AnodeAvailability.QUERY_1,
                        SterliteRefineryQuery.AnodeAvailability.QUERY_2,
                        SterliteRefineryQuery.AnodeAvailability.QUERY_3,
                    ],
                    "DO CELLS IN OPERATION": [
                        SterliteRefineryQuery.DOCellsInOperation.QUERY_1
                    ],
                    "Total Cells In Operation": [
                        SterliteRefineryQuery.TotalCellsInOperation.QUERY_1,
                        SterliteRefineryQuery.TotalCellsInOperation.QUERY_2,
                        SterliteRefineryQuery.TotalCellsInOperation.QUERY_3,
                    ],
                },
                "data": [],
                "data_column": [
                    "anode_availability", "uom", "norms",
                    "on_date", "mtd", "ytd"],
                "description": "",
                "format": "",
            },
            "SAFETY REPORT": {
                "columns": ["SAFETY REPORT", "UOM", "NORMS", "ON DATE", "MTD", "YTD"],
                "query": {
                    "No. of Near Miss": [
                        SterliteRefineryQuery.NoOfNearMiss.QUERY_1,
                        SterliteRefineryQuery.NoOfNearMiss.QUERY_2,
                        SterliteRefineryQuery.NoOfNearMiss.QUERY_3,
                    ],
                    "No. of First Aid": [
                        SterliteRefineryQuery.NoOfFirstAid.QUERY_1,
                        SterliteRefineryQuery.NoOfFirstAid.QUERY_2,
                        SterliteRefineryQuery.NoOfFirstAid.QUERY_3,
                    ]
                },
                "data": [],
                "data_column": ["safety_report", "uom", "norms",
                                "on_date", "mtd", "ytd"],
                "additions": [],
                "description": "",
                "format": "",
            },
        },
        {
            "POWER AVAILABILITY": {
                "columns": [
                    "POWER AVAILABILITY",
                    "UOM",
                    "NORMS",
                    "ON DATE",
                    "MTD",
                    "YTD",
                ],
                "query": {
                    "Grid Power Availability": [],
                    "Cir 1 Avg. Rectifier Running Hrs.": [],
                    "Cir 2 Avg. Rectifier Running Hrs.": [],
                    "Power Availability to Cir-1": [],
                    "Power Availability to Cir-2": [],
                    "Power Availability to Cell House": [],
                    "Cir-1 40 KA Rectifier Avg. Current": [
                        SterliteRefineryQuery.Cir140KARectifierAvgCurrent.QUERY_1,
                        SterliteRefineryQuery.Cir140KARectifierAvgCurrent.QUERY_2,
                        SterliteRefineryQuery.Cir140KARectifierAvgCurrent.QUERY_3,
                    ],
                    "Cir-2 35 KA Rectifier Avg. Current": [],
                    "Total Avg. Current": [],
                    "Current Density": []
                },
                "data": [],
                "data_column": ["power_availability", "uom",
                                "norms", "on_date", "mtd",
                                "ytd"],
                "additions": [],
                "description": "",
                "format": "",
            },
            "RM ANODE RECEIPT DETAILS": {
                "columns": [
                    "RM ANODE RECEIPT DETAILS",
                    "ON DATE",
                    "MTD",
                    "YTD",
                    "Material",
                    "OPENING STOCK",
                ],
                "query": [],
                "data": [],
                "data_column": ["rm_anode_receipt_details", "on_date",
                                "mtd", "ytd", "material", "opening_stock"],
                "additions": [],
                "description": "",
                "format": "",
            },
        },
        {
            "EFFICIENCIES": {
                "columns": ["EFFICIENCIES", "UOM", "NORMS", "ON DATE", "MTD", "YTD"],
                "query": [],
                "data": [],
                "data_column": ["efficiencies", "uom", "norms",
                                "on_date", "mtd", "ytd"],
                "additions": [],
                "description": "",
                "format": "",
            },
            "BANK / CROP": {
                "columns": [
                    "BANK / CROP",
                    "CE (%)",
                    "THEOR. WEIGHT",
                    "ACTUAL WEIGHT",
                    "STRIPPING TIME",
                ],
                "query": [],
                "data": [],
                "data_column": ["bank_crop", "ce(%)", "theor_weight",
                                "actual_weight", "stripping_time"],
                "additions": [],
                "description": "",
                "format": "",
            },
        },
        {
            "PRODUCTION": {
                "columns": ["PRODUCTION", "UOM", "NORMS", "ON DATE", "MTD", "YTD"],
                "query": [],
                "data": [],
                "data_column": ["production", "uom", "norms",
                                "on_date", "mtd", "ytd"],
                "additions": [],
                "description": "",
                "format": "",
            },
            "CIRCULATION": {
                "columns": ["CIRCULATION", "CE%", "THEOR. WEIGHT", "ACTUAL WEIGHT"],
                "query": [],
                "data": [],
                "data_column": ["circulation", "ce", "theor_weight", "actual_weight"],
                "additions": [],
                "description": "",
                "format": "",
            },
        },
        {
            "FG INVENTORY": {
                "columns": ["FG INVENTORY", "ON DATE", "MTD", "YTD"],
                "query": [],
                "data": [],
                "data_column": ["fg_inventory", "on_date", "mtd", "ytd"],
                "additions": [],
                "description": "",
                "format": "",
            },
            "PRODUCTION": {
                "columns": ["PRODUCTION", "ON DATE", "MTD", "YTD"],
                "query": [],
                "data": [],
                "data_column": ["production", "on_date", "mtd", "ytd"],
                "additions": [],
                "description": "",
                "format": "",
            },
        },
        {
            "CROP": {
                "columns": [
                    "CROP",
                    "BANKS",
                    "TOTAL CELLS",
                    "CELL VOLTAGE (V)",
                    "T. SHORTS / CELL / CHECK",
                ],
                "query": [],
                "data": [],
                "data_column": ["crop", "banks", "total_cells",
                                "cell_voltage", "t_shorts"],
                "additions": [],
                "description": "",
                "format": "",
            }
        },
        {
            "STRIPPING TIME": {
                "columns": [
                    "STRIPPING TIME",
                    "UOM",
                    "1st CROP - Sttripping time",
                    "2nd CROP - Change over time",
                    "3rd CROP",
                    "CSM Plate Rejection"
                ],
                "query": [],
                "data": [],
                "data_column": [
                    "stripping_time",
                    "uom",
                    "1st_crop",
                    "2nd_crop",
                    "3rd_crop",
                    "csm_plate_rejection"
                ],
                "additions": [],
                "description": "",
                "format": "",
            }
        },
        {
            "FILTER AVAILABILITY": {
                "columns": [
                    "FILTER AVAILABILITY",
                    "ON DATE",
                    "MTD",
                    "Filtered Volume",
                    "Total Volume Refinery",
                    "ON DATE",
                ],
                "query": [],
                "data": [],
                "data_column": [
                    "filter_availability", "on_date", "mtd", "filtered_volume",
                    "total_volume_refinery", "on_date"
                ],
                "additions": [],
                "description": "",
                "format": "",
            }
        },
        {
            "SPECIFIC ENERGY CONSUMPTION": {
                "columns": [
                    "UTILITIES CONSUMPTIONS",
                    "UOM",
                    "NORMS",
                    "ON DATE",
                    "MTD",
                    "YTD",
                ],
                "query": [],
                "data": [],
                "data_column": [
                    "utilities_consumptions",
                    "uom",
                    "norms",
                    "on_date",
                    "mtd",
                    "ytd",
                ],
                "additions": [],
                "description": "",
                "format": "",
            },
            "SPECIFIC CONSUMPTION": {
                "columns": ["CONSUMABLES", "UOM", "NORMS", "ON DATE", "MTD", "YTD"],
                "query": [],
                "data": [],
                "data_column": ["consumables", "uom", "norms", "on_date", "mtd",
                                "ytd"],
                "additions": [],
                "description": "",
                "format": "",
            },
        },
        {
            "ELECTROLYTE COMPOSITION": {
                "columns": [
                    "ELECTROLYTE COMPOSITION",
                    "UOM",
                    "NORMS",
                    "DATE",
                    "CIR-1",
                    "CIR-2",
                ],
                "query": [],
                "data": [],
                "data_column": [
                    "electrolyte_composition",
                    "uom",
                    "norms",
                    "date",
                    "cir_1",
                    "cir_2",
                ],
                "additions": [],
                "description": "",
                "format": "",
            },
            "SUSPENDED SOLIDS": {
                "columns": ["SUSPENDED SOLIDS"],
                "query": [],
                "data": [],
                "data_column": ["suspended_solids"],
                "additions": [],
                "description": "",
                "format": "",
            },
        },
        {
            "BLEEDING SECTION": {
                "columns": ["BLEEDING SECTION", "UOM", "ON DATE", "MTD", "YTD"],
                "query": [],
                "data": [],
                "data_column": ["bleeding_section", "uom", "on_date", "mtd", "ytd"],
                "additions": [],
                "description": "",
                "format": "",
            },
            "BANK / CROP": {
                "columns": ["BANK / CROP", "TIME", "WEIGHT (MT)", "CELLS", "READING"],
                "query": [],
                "data": [],
                "data_column": ["bank_crop", "time", "weight", "cells", "reading"],
                "additions": [],
                "description": "",
                "format": "",
            },
        },
        {
            "DEPARTMENT(M4)": {
                "columns": [
                    "DEPARTMENT(M4)",
                    "EQUIPMENT DETAILS",
                    "EQUIPMENT LOCATION",
                    "DURATION",
                    "(MT) PRODUCTION",
                    "CAUSE OF THE BREAK DOWN",
                ],
                "query": [],
                "data": [],
                "data_column": [
                    "department(m4)",
                    "equipment_details",
                    "equipment_location",
                    "duration",
                    "production",
                    "cause",
                ],
                "additions": [],
                "description": "",
                "format": "",
            }
        },
    ]
