from scripts.constants import PostgresConstant
from scripts.core.db.postgres.custom_report_query import SterliteRefineryQuery, SterliteCCPCQuery


class SterliteRefineryTemplate:
    WORKSHEET_HEADER_FORMAT = {
        "bold": True,
        "align": "center",
        "valign": "center",
        "fg_color": "#e6e7eb",
        "font_color": "#1b314f",
        "border": 1,
        'font_size': '20',
    }
    COLUMN_HEADER_FORMAT = {
        "bold": True,
        "align": "center",
        "valign": "center",
        "fg_color": "#e6e7eb",
        "font_color": "#021b5e",
        "border": 1,
    }
    BLANK_COLUMN_HEADER_FORMAT = {
        "bold": True,
        "align": "center",
        "valign": "center",
    }
    CCPC_REPORT_TEMPLATE = [
        {
            "PARTICULARS": {
                "columns": [
                    "PARTICULARS",
                    "UNIT",
                    "ONDATE",
                    "MTD",
                ],
                "query": {
                    "BLISTER": [
                        SterliteCCPCQuery.BLISTER.QUERY_1,
                        SterliteCCPCQuery.BLISTER.QUERY_2,
                    ],
                    "KCMANODE": [
                        SterliteCCPCQuery.KCMANODE.QUERY_1,
                        SterliteCCPCQuery.KCMANODE.QUERY_2,
                    ],
                    "DINGOT": [
                        SterliteCCPCQuery.DINGOT.QUERY_1,
                        SterliteCCPCQuery.DINGOT.QUERY_2,
                    ],
                    "IMPORTEDSPENTANODE": [
                        SterliteCCPCQuery.IMPORTEDSPENTANODE.QUERY_1,
                        SterliteCCPCQuery.IMPORTEDSPENTANODE.QUERY_2,
                    ],
                    "CURODRM": [
                        SterliteCCPCQuery.CURODRM.QUERY_1,
                        SterliteCCPCQuery.CURODRM.QUERY_2,
                    ],
                    "MASTERALLOY": [
                        SterliteCCPCQuery.MASTERALLOY.QUERY_1,
                        SterliteCCPCQuery.MASTERALLOY.QUERY_2,
                    ],
                    "CUSHAVINGS": [
                        SterliteCCPCQuery.CUSHAVINGS.QUERY_1,
                        SterliteCCPCQuery.CUSHAVINGS.QUERY_2,
                    ],
                    "SAPPRODUCTIONBOOKING": [
                        SterliteCCPCQuery.SAPPRODUCTIONBOOKING.QUERY_1,
                        SterliteCCPCQuery.SAPPRODUCTIONBOOKING.QUERY_2,
                    ],
                    "D.OCATHODE(RFNY)": [
                        SterliteCCPCQuery.DOCATHODE.QUERY_1,
                        SterliteCCPCQuery.DOCATHODE.QUERY_2,
                    ],
                    "REFINERYSPENTANODE": [
                        SterliteCCPCQuery.REFINERYSPENTANODE.QUERY_1,
                        SterliteCCPCQuery.REFINERYSPENTANODE.QUERY_2,
                    ],
                    "REFINERYREJECTEDANODE": [
                        SterliteCCPCQuery.REFINERYREJECTEDANODE.QUERY_1,
                        SterliteCCPCQuery.REFINERYREJECTEDANODE.QUERY_2,
                    ],
                    "REJECTEDCOILS": [
                        SterliteCCPCQuery.REJECTEDCOILS.QUERY_1,
                        SterliteCCPCQuery.REJECTEDCOILS.QUERY_2,
                    ],
                    "GGRADE": [
                        SterliteCCPCQuery.GGRADE.QUERY_1,
                        SterliteCCPCQuery.GGRADE.QUERY_2,
                    ],
                    "ACPREJANODE": [
                        SterliteCCPCQuery.ACPREJANODE.QUERY_1,
                        SterliteCCPCQuery.ACPREJANODE.QUERY_2,
                    ],
                    "BERRY": [
                        SterliteCCPCQuery.BERRY.QUERY_1,
                        SterliteCCPCQuery.BERRY.QUERY_2,
                    ],
                    "RFNYCUTCOIL": [
                        SterliteCCPCQuery.RFNYCUTCOIL.QUERY_1,
                        SterliteCCPCQuery.RFNYCUTCOIL.QUERY_2,
                    ],
                    "CCPCREJANODE": [
                        SterliteCCPCQuery.CCPCREJANODE.QUERY_1,
                        SterliteCCPCQuery.CCPCREJANODE.QUERY_2,
                    ],
                    "ANODEREJECTION": [
                        SterliteCCPCQuery.ANODEREJECTION.QUERY_1,
                        SterliteCCPCQuery.ANODEREJECTION.QUERY_2,
                    ],
                },
                "data": [],
                "data_column": ["particulars", "unit", "ondate", "mtd",
                                ],
            },
            "BLANK": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "TOTAL BREAKDOWN DETAILS": {
                "columns": ["TOTAL BREAKDOWN DETAILS(MINS)", "DURATION(MINS)"],
                "query": {
                    "TOTAL BREAKDOWN DETAILS(MINS)": [
                        SterliteCCPCQuery.TotalBreakdownDetails.QUERY_1,
                        SterliteCCPCQuery.TotalBreakdownDetails.QUERY_2
                    ]
                },
                "data": [],
                "data_column": ["total breakdown details(mins)", "duration(mins)"],
            },
            "BLANK": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "METAL TEMP": {
                "columns": ["TEMP", "ONDATE"],
                "query": {
                    "METAL TEMP": [
                        SterliteCCPCQuery.MetalTemp.QUERY_1,
                    ]
                },
                "data": [],
                "data_column": ["total breakdown details(mins)", "duration(mins)"],
            },
            "BLANK": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "FURNACE SHELL TEMP": {
                "columns": ["POSITION", "SHIFT", "AVG-TEMP"],
                "query": {
                    "METAL TEMP": [
                        SterliteCCPCQuery.MetalTemp.QUERY_1,
                    ]
                },
                "data": [],
                "data_column": ["position", "shift", "avg-temp"],
            },

        },
        {
            "SHIFT-A": {
                "columns": [
                    "DCS - DATA TO BE FETCHED SHIFTWISE",
                    "",
                    "6AM",
                    "7AM",
                    "8AM",
                    "",
                    "",
                    "",
                    "1PM"
                ],
                "query": {
                },
                "data": [],
                "data_column": [
                    "dcs - data to be fetched shiftwise",
                    "",
                    "6am",
                    "7am",
                    "8am",
                    "",
                    "",
                    "",
                    "1pm"
                ],
            }
        },
        {
            "SHIFT-B": {
                "columns": [
                    "DCS - DATA TO BE FETCHED SHIFTWISE",
                    "",
                    "6AM",
                    "7AM",
                    "8AM",
                    "",
                    "",
                    "",
                    "1PM"
                ],
                "query": {
                },
                "data": [],
                "data_column": [
                    "dcs - data to be fetched shiftwise",
                    "",
                    "6am",
                    "7am",
                    "8am",
                    "",
                    "",
                    "",
                    "1pm"
                ],
            }
        },
        {
            "SHIFT-C": {
                "columns": [
                    "DCS - DATA TO BE FETCHED SHIFTWISE",
                    "",
                    "6AM",
                    "7AM",
                    "8AM",
                    "",
                    "",
                    "",
                    "1PM"
                ],
                "query": {
                },
                "data": [],
                "data_column": [
                    "dcs - data to be fetched shiftwise",
                    "",
                    "6am",
                    "7am",
                    "8am",
                    "",
                    "",
                    "",
                    "1pm"
                ],
            }
        },
        {
            "TBC": {
                "columns": ["SHIFT", "TIME", "TANK OUTLET PRESSURE", "VAP. OUTLET PRESSURE", "LINE. OUTLET PRESSURE",
                            "LINE. TEM "],
                "query": {},
                "data": [],
                "data_column": ["shift", "time", "tank outlet pressure", "vap. outlet pressure",
                                "line. outlet pressure", "line. tem "],
            },
            "Electrical Vaporiser 1": {
                "columns": ["WATER TEMP.", "WATER LEVEL", "WATER VALVE CONDITION", "STATUS"
                            ],
                "query": {
                    "BANK / CROP": [
                        SterliteRefineryQuery.BankCropStripping.QUERY_1,
                    ]
                },
                "data": [],
                "data_column": ["water temp.", "water level", "water valve condition", "status"
                                ],
            },
            "Electrical Vaporiser 2": {
                "columns": ["WATER TEMP.", "WATER LEVEL", "WATER VALVE CONDITION", "STATUS"
                            ],
                "query": {
                    "BANK / CROP": [
                        SterliteRefineryQuery.BankCropStripping.QUERY_1,
                    ]
                },
                "data": [],
                "data_column": ["water temp.", "water level", "water valve condition", "status"
                                ],
            },
            "Electrical Vaporiser 3": {
                "columns": ["WATER TEMP.", "WATER LEVEL", "WATER VALVE CONDITION", "STATUS"
                            ],
                "query": {
                    "BANK / CROP": [
                        SterliteRefineryQuery.BankCropStripping.QUERY_1,
                    ]
                },
                "data": [],
                "data_column": ["water temp.", "water level", "water valve condition", "status"
                                ],
            },
            "Electrical Vaporiser 4": {
                "columns": ["WATER TEMP.", "WATER LEVEL", "WATER VALVE CONDITION", "STATUS"
                            ],
                "query": {
                    "BANK / CROP": [
                        SterliteRefineryQuery.BankCropStripping.QUERY_1,
                    ]
                },
                "data": [],
                "data_column": ["water temp.", "water level", "water valve condition", "status"
                                ],
            },
        },
        {
            "PROCESS PARAMETERS": {
                "columns": ["PARAMATER", "RANGE ", "AVG VALUE", "2", "3", "4"],
                "query": {
                },
                "data": [],
                "data_column": ["paramater", "range ", "avg value", "2", "3", "4"],
            },
        },
        {
            "CHARGING DETAILS": {
                "columns": ["CHARGING DETAILS", "A SHIFT", "B SHIFT", "C SHIFT", "TOTAL"],
                "query": {
                    "ChargingDetails": [
                        SterliteCCPCQuery.ChargingDetails.QUERY_1,
                        SterliteCCPCQuery.ChargingDetails.QUERY_2,
                    ]

                },

                "data": [],
                "data_column": ["charging details", "shift_a", "shift_b", "shift_c", "total"],
            },
            "BLANK": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "MONTHWISE PRODUCTION DETAILS (MT)": {
                "columns": ["NOS", "TARGET", "PRODUCTION"],
                "query": {},
                "data": [],
                "data_column": ["nos", "target", "production"],
            },
        },
        {
            "PRODUCTION DETAILS-NO. OF ANODES": {
                "columns": [
                    "PRODUCTION DETAILS-NO. OF ANODES",
                    "A SHIFT",
                    "B SHIFT",
                    "C SHIFT",
                    "TOTAL",
                    "A-SHIFT PRDN",
                    "B-SHIFT PRDN",
                    "C-SHIFT PRDN",
                    "OD PRODN (MT) ="
                ],
                "query": {
                    "CROP": [
                        SterliteRefineryQuery.CropCir.QUERY_1,
                    ]
                },
                "data": [],
                "data_column": [
                    "production details-no. of anodes",
                    "a shift",
                    "b shift",
                    "c shift",
                    "total",
                    "a-shift prdn",
                    "b-shift prdn",
                    "c-shift prdn",
                    "od prodn (mt) ="
                ],
            },
            "BLANK": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "DEPOSIT LOSS (-) / GAIN (+) DETAILS": {
                "columns": [
                    "CATEGORY",
                    "ON DATE",
                    "MTD",
                    "YTD"
                ],
                "query": {
                    "DepositLossGainDetails": [
                        SterliteRefineryQuery.DepositLossGainDetails.QUERY_1,
                        SterliteRefineryQuery.DepositLossGainDetails.QUERY_2,
                        SterliteRefineryQuery.DepositLossGainDetails.QUERY_3,
                    ]
                },
                "data": [],
                "data_column": [
                    "category",
                    "on_date",
                    "mtd",
                    "ytd"
                ],
                "addition": {
                    "merge_header": "DEPOSIT LOSS (-) / GAIN (+) DETAILS",
                    "primary": "category"
                }
            }
        },
        {
            "CONSUMPTION ITEMS": {
                "columns": [
                    "CONSUMPTION ITEMS",
                    "ON DATE",
                    "MTD",
                    "UNIT"
                ],
                "query": {
                    "BariumSulphate": [
                        SterliteCCPCQuery.BariumSulphate.QUERY_1,
                        SterliteCCPCQuery.BariumSulphate.QUERY_2,
                    ],
                    "SodiumSulphate": [
                        SterliteCCPCQuery.SodiumSulphate.QUERY_1,
                        SterliteCCPCQuery.SodiumSulphate.QUERY_2,
                    ],
                    "Power": [
                        SterliteCCPCQuery.Power.QUERY_1,
                        SterliteCCPCQuery.Power.QUERY_2,
                    ]
                },
                "data": [],
                "data_column": [
                    "consumption_items",
                    "on_date",
                    "mtd",
                    "unit"
                ],
            }
        },
        {
            "ACTIVITY\TIME": {
                "columns": [
                    "ACTIVITY\tIME",
                    "SHIFT",
                    "START TIME",
                    "END TIME",
                    "TOTAL TIME (MINUTES)",
                    "REASON FOR STOPAGE"
                ],
                "query": {
                    "CASTING": [],
                    "MELTING": []
                },
                "data": [],
                "data_column": [
                    "activity\time",
                    "shift",
                    "start time",
                    "end time",
                    "total time (minutes)",
                    "reason for stopage"
                ],
            }
        },
        {
            "PERSONS ON DUTY": {
                "columns": [
                    "PERSONS ON DUTY",
                    "A SHIFT",
                    "B SHIFT",
                    "C SHIFT"
                ],
                "query": {
                    "PersonOnDuty": [
                        SterliteCCPCQuery.PersonOnDuty.QUERY_1
                    ]

                },
                "data": [],
                "data_column": [
                    "persons_on_duty",
                    "a_shift",
                    "b_shift",
                    "c_shift"
                ]
            },
            "BLANK": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "SHIFT": {
                "columns": ["SHIFT", "LPG CONSUMPTION", "SPECIFIC PER SHIFT"],
                "query": {},
                "data": [],
                "data_column": ["shift", "lpg consumption", "specific per shift"],
                "addition": {
                    "merge_header": "SPECIFIC CONSUMPTION",
                    "primary": "consumables"
                }
            },
        },
        {
            "A SHIFT": {
                "columns": [
                    "A SHIFT"
                ],
                "query": {
                },
                "data": [],
                "data_column": ["a_shift"
                                ]
            },
            "BLANK": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "SET ANODE WEIGHT -270": {
                "columns": ["SET ANODE WEIGHT -270", "WEIGH BRIDGE"],
                "query": {
                    "SetAnideWeight": [
                        SterliteCCPCQuery.SetAnodeWeight.QUERY_1
                    ]
                },
                "data": [],
                "data_column": ["kpi", "shift","set_anode_weight","weight_bridge","metric"],
                "addition": {
                    "merge_header": "SPECIFIC CONSUMPTION",
                    "primary": "consumables"
                }
            },
        },
        {
            "SHIFT ACTIVITY TRACKER DESCRIPTION": {
                "columns": [
                    "S.NO",
                    "SHIFT ACTIVITY TRACKER DESCRIPTION"
                ],
                "query": {
                    "StrippingTime": [
                        SterliteRefineryQuery.StrippingTime.QUERY_1
                    ]
                },
                "data": [],
                "data_column": [
                    "s.no",
                    "shift_activity_tracker_description"
                ]
            }
        },
        {
            "B SHIFT": {
                "columns": [
                    "B SHIFT"
                ],
                "query": {
                },
                "data": [],
                "data_column": ["b_shift"
                                ]
            },
            "BLANK": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "SET ANODE WEIGHT -270": {
                "columns": ["SET ANODE WEIGHT -270", "WEIGH BRIDGE"],
                "query": {
                    "SetAnideWeight": [
                        SterliteCCPCQuery.SetAnodeWeight.QUERY_1
                    ]
                },
                "data": [],
                "data_column": ["kpi", "shift","set_anode_weight","weight_bridge","metric"],
                "addition": {
                    "merge_header": "SPECIFIC CONSUMPTION",
                    "primary": "consumables"
                }
            },
        },
        {
            "SHIFT ACTIVITY TRACKER DESCRIPTION": {
                "columns": [
                    "S.NO",
                    "SHIFT ACTIVITY TRACKER DESCRIPTION"
                ],
                "query": {
                    "StrippingTime": [
                        SterliteRefineryQuery.StrippingTime.QUERY_1
                    ]
                },
                "data": [],
                "data_column": [
                    "s.no",
                    "shift_activity_tracker_description"
                ]
            }
        },
        {
            "C SHIFT": {
                "columns": [
                    "C SHIFT"
                ],
                "query": {
                },
                "data": [],
                "data_column": ["c_shift"
                                ]
            },
            "BLANK": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "SET ANODE WEIGHT -270": {
                "columns": ["SET ANODE WEIGHT -270", "WEIGH BRIDGE"],
                "query": {
                    "SetAnideWeight": [
                        SterliteCCPCQuery.SetAnodeWeight.QUERY_1
                    ]
                },
                "data": [],
                "data_column": ["kpi", "shift","set_anode_weight","weight_bridge","metric"],
                "addition": {
                    "merge_header": "SPECIFIC CONSUMPTION",
                    "primary": "consumables"
                }
            },
        },
        {
            "SHIFT ACTIVITY TRACKER DESCRIPTION": {
                "columns": [
                    "S.NO",
                    "SHIFT ACTIVITY TRACKER DESCRIPTION"
                ],
                "query": {
                    "StrippingTime": [
                        SterliteRefineryQuery.StrippingTime.QUERY_1
                    ]
                },
                "data": [],
                "data_column": [
                    "s.no",
                    "shift_activity_tracker_description"
                ]
            }
        },
    ]
