from scripts.core.db.postgres.custom_report_query import ACPQuery


class ACPReportTemplate:
    """ HEADER STYLING FORMAT """
    WORKSHEET_IMAGE_HEADER_FORMAT = {
        "bold": True,
        "align": "center",
        "valign": "center",
        "border": 1,
    }
    WORKSHEET_HEADER_FORMAT = {
        "bold": True,
        "align": "center",
        "valign": "center",
        "border": 1,
        "fg_color": "#1AC5F3",
        'font_size': '18',
    }

    """ DATE HEADER """
    WORKSHEET_DATE_HEADER_FORMAT = {
        "bold": True,
        "align": "center",
        "valign": "center",
        "border": 1,
        "fg_color": "#F4AD66",
        'font_size': '12',
    }
    WORKSHEET_DATE_FORMAT = {
        "bold": True,
        "align": "center",
        "valign": "center",
        "border": 1,
        "fg_color": "#F4CE84",
        'font_size': '12',
    }

    """ COLUMN HEADER FORMAT """
    COLUMN_HEADER_FORMAT = {
        "bold": True,
        "align": "center",
        "valign": "center",
        "fg_color": "#e6e7eb",
        "font_color": "#021b5e",
        "border": 1,
    }
    BLANK_COLUMN_HEADER_FORMAT = {
        "bold": True,
        "align": "center",
        "valign": "center",
    }

    """ REPORT TEMPLATE """
    REPORT_TEMPLATE = [
        {
            "BLANK": {
                "columns": [None],
                "data": [],
                "query": {},
                "data_column": [None]
            },
        },
        {
            "PARTICULARS": {
                "columns": [
                    "PARTICULARS", "UNITS", "ON DATE", "MTD"
                ],
                "query": {
                    "Production": [
                        ACPQuery.Particulars.QUERY_1,
                        ACPQuery.Particulars.QUERY_2,
                    ],
                    "FO": [
                        ACPQuery.FO.QUERY_1,
                        ACPQuery.FO.QUERY_2,
                    ],
                    "Rejection": [
                        ACPQuery.Rejection.QUERY_1,
                        ACPQuery.Rejection.QUERY_2,
                    ],
                },
                "data": [],
                "data_column": [
                    "particulars", "units", "on_date", "mtd"
                ],
            },
            "BLANK": {
                "columns": [None],
                "data": [],
                "query": {},
                "data_column": [None]
            },
            "PERSONS ON DUTY": {
                "columns": [
                    "PERSONS ON DUTY", "A", "B", "C"
                ],
                "query": {
                    "PersonsOnDuty": [
                        ACPQuery.PersonsOnDuty.QUERY_1,
                    ]
                },
                "data": [],
                "data_column": [
                    "persons_on_duty", "a", "b", "c"
                ],
            },
            "BLANK1": {
                "columns": [None],
                "data": [],
                "query": {},
                "data_column": [None]
            },
            "ANODE LUG THICKNESS": {
                "columns": [
                    "ANODE LUG THICKNESS (22-32 mm)", "ANODE BODY THICKNESS (31-41 mm)"
                ],
                "query": {
                    "AnodeLugThickness": [
                        ACPQuery.AnodeLugThickness.QUERY_1,
                    ]
                },
                "data": [],
                "data_column": [
                    "anode_lug_thickness", "anode_body_thickness"
                ],
            },
        },
        # {
        #     "A-SHIFT COMMUNICATION": {
        #         "columns": [
        #             "S.No", "A-SHIFT COMMUNICATION"
        #         ],
        #         "query": {
        #             "AShiftCommunication": [
        #                 ACPQuery.AShiftCommunication.QUERY_1,
        #             ],
        #         },
        #         "data": [],
        #         "data_column": [
        #             "s_no", "a_shift_comm"
        #         ],
        #     },
        #     "A SHIFTWISE DATA": {
        #         "columns": [
        #             "MOULD", "SET VALUE", "FIELD WT"
        #         ],
        #         "query": {
        #             "AShiftwiseData": [
        #                 ACPQuery.AShiftwiseData.QUERY_1,
        #             ]
        #         },
        #         "data": [],
        #         "data_column": [
        #             "mould", "set_value", "field_wt"
        #         ],
        #         "addition": {
        #             "merge_header": "SHIFTWISE DATA"
        #         }
        #     }
        # },
        # {
        #     "B-SHIFT COMMUNICATION": {
        #         "columns": [
        #             "S.No", "B-SHIFT COMMUNICATION"
        #         ],
        #         "query": {
        #             "BShiftCommunication": [
        #                 ACPQuery.BShiftCommunication.QUERY_1,
        #             ],
        #         },
        #         "data": [],
        #         "data_column": [
        #             "s_no", "b_shift_comm"
        #         ],
        #     },
        #     "B SHIFTWISE DATA": {
        #         "columns": [
        #             "MOULD", "SET VALUE", "FIELD WT"
        #         ],
        #         "query": {
        #             "BShiftwiseData": [
        #                 ACPQuery.BShiftwiseData.QUERY_1,
        #             ]
        #         },
        #         "data": [],
        #         "data_column": [
        #             "mould", "set_value", "field_wt"
        #         ],
        #         "addition": {
        #             "merge_header": "SHIFTWISE DATA"
        #         }
        #     }
        # },
        # {
        #     "C-SHIFT COMMUNICATION": {
        #         "columns": [
        #             "S.No", "C-SHIFT COMMUNICATION"
        #         ],
        #         "query": {
        #             "CShiftCommunication": [
        #                 ACPQuery.CShiftCommunication.QUERY_1,
        #             ],
        #         },
        #         "data": [],
        #         "data_column": [
        #             "s_no", "a_shift_comm"
        #         ],
        #     },
        #     "C SHIFTWISE DATA": {
        #         "columns": [
        #             "MOULD", "SET VALUE", "FIELD WT"
        #         ],
        #         "query": {
        #             "CShiftwiseData": [
        #                 ACPQuery.CShiftwiseData.QUERY_1,
        #             ]
        #         },
        #         "data": [],
        #         "data_column": [
        #             "mould", "set_value", "field_wt"
        #         ],
        #         "addition": {
        #             "merge_header": "SHIFTWISE DATA"
        #         }
        #     }
        # },
        # {
        #     "PARAMETERS": {
        #         "columns": [
        #             "PARAMETERS", "RANGE", "VALUE"
        #         ],
        #         "query": {
        #             "Furnace1FoTemperature": [
        #                 ACPQuery.Furnace1FoTemperature.QUERY_1,
        #             ],
        #             "FoOilPressure": [
        #                 ACPQuery.FoOilPressure.QUERY_1,
        #             ],
        #             "Furnace1OilFlow": [
        #                 ACPQuery.Furnace1OilFlow.QUERY_1,
        #             ],
        #             "Furnace2OilFlow": [
        #                 ACPQuery.Furnace2OilFlow.QUERY_1,
        #             ],
        #             "MeltTemperature": [
        #                 ACPQuery.MeltTemperature.QUERY_1,
        #             ],
        #             "MouldTemperature": [
        #                 ACPQuery.MouldTemperature.QUERY_1,
        #             ],
        #             "LpgVapourizerTemperature": [
        #                 ACPQuery.LpgVapourizerTemperature.QUERY_1,
        #             ],
        #             "LaunderBlowerAirPressure": [
        #                 ACPQuery.LaunderBlowerAirPressure.QUERY_1,
        #             ],
        #             "Furnace1ShellTemperature": [
        #                 ACPQuery.Furnace1ShellTemperature.QUERY_1,
        #             ],
        #             "Furnace2ShellTemperature": [
        #                 ACPQuery.Furnace2ShellTemperature.QUERY_1,
        #             ],
        #             "BariumSulphateSolutionSpecificGravity": [
        #                 ACPQuery.BariumSulphateSolutionSpecificGravity.QUERY_1,
        #             ],
        #             "MouldAlignmentLevel": [
        #                 ACPQuery.MouldAlignmentLevel.QUERY_1,
        #             ],
        #             "HeatNoArsenicA": [
        #                 ACPQuery.HeatNoArsenicA.QUERY_1,
        #             ],
        #             "HeatNoArsenicB": [
        #                 ACPQuery.HeatNoArsenicB.QUERY_1,
        #             ],
        #             "HeatNoArsenicC": [
        #                 ACPQuery.HeatNoArsenicC.QUERY_1,
        #             ]
        #         },
        #         "data": [],
        #         "data_column": [
        #             "parameters", "range", "value"
        #         ],
        #     },
        # },
        # {
        #     "FURNACE SHIFT A": {
        #         "columns": [
        #             "FURNACE", "BURNER 1", "BURNER 2", "BURNER 3"
        #         ],
        #         "query": {
        #             "FurnaceShiftA": [
        #                 ACPQuery.FurnaceShiftA.QUERY_1,
        #             ],
        #         },
        #         "data": [],
        #         "data_column": [
        #             "furnace", "burner_1", "burner_2", "burner_3"
        #         ],
        #         "addition": {
        #             "merge_header": "SHIFT - A DATA"
        #         }
        #     },
        #     "FURNACE SHIFT B": {
        #         "columns": [
        #             "FURNACE", "BURNER 1", "BURNER 2", "BURNER 3"
        #         ],
        #         "query": {
        #             "FurnaceShiftB": [
        #                 ACPQuery.FurnaceShiftB.QUERY_1,
        #             ],
        #         },
        #         "data": [],
        #         "data_column": [
        #             "furnace", "burner_1", "burner_2", "burner_3"
        #         ],
        #         "addition": {
        #             "merge_header": "SHIFT - B DATA"
        #         }
        #     },
        #     "FURNACE SHIFT C": {
        #         "columns": [
        #             "FURNACE", "BURNER 1", "BURNER 2", "BURNER 3"
        #         ],
        #         "query": {
        #             "FurnaceShiftC": [
        #                 ACPQuery.FurnaceShiftC.QUERY_1,
        #             ],
        #         },
        #         "data": [],
        #         "data_column": [
        #             "furnace", "burner_1", "burner_2", "burner_3"
        #         ],
        #         "addition": {
        #             "merge_header": "SHIFT - C DATA"
        #         }
        #     }
        # }

    ]
