from scripts.constants import PostgresConstant
from scripts.core.db.postgres.custom_report_query import SterliteCCPPQuery


class CCPPReportTemplate:
    CCPP_REPORT_TEMPLATE = [
        {
            "BLANK0": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {

                },
                "data_column": [
                    None
                ]
            }
        },
        {
            "PARTICULARS": {
                "columns": [
                    "PARTICULARS",
                    "UNIT",
                    "ON DATE",
                    "MTD",
                ],
                "query": {
                    "Production": [
                        SterliteCCPPQuery.Production.QUERY_1,
                        SterliteCCPPQuery.Production.QUERY_2
                    ],
                    "Lpg": [
                        SterliteCCPPQuery.Lpg.QUERY_1,
                        SterliteCCPPQuery.Lpg.QUERY_2,
                    ],
                    "BariumSulphate": [
                        SterliteCCPPQuery.BariumSulphate.QUERY_1,
                        SterliteCCPPQuery.BariumSulphate.QUERY_2
                    ],

                    "SodiumSilicate": [
                        SterliteCCPPQuery.SodiumSilicate.QUERY_1,
                        SterliteCCPPQuery.SodiumSilicate.QUERY_2,
                    ],
                    "Power": [
                        SterliteCCPPQuery.Power.QUERY_1,
                        SterliteCCPPQuery.Power.QUERY_2,
                    ],
                    "KanshakiBlister": [
                        SterliteCCPPQuery.KanshakiBlister.QUERY_1,
                        SterliteCCPPQuery.KanshakiBlister.QUERY_2,
                    ],
                    "RejectedCoil": [
                        SterliteCCPPQuery.RejectedCoil.QUERY_1,
                        SterliteCCPPQuery.RejectedCoil.QUERY_2,
                    ],
                    "MasterAlloy": [
                        SterliteCCPPQuery.MasterAlloy.QUERY_1,
                        SterliteCCPPQuery.MasterAlloy.QUERY_2,
                    ],
                    "CssBlister": [
                        SterliteCCPPQuery.CssBlister.QUERY_1,
                        SterliteCCPPQuery.CssBlister.QUERY_2,
                    ],
                    "InternalRejectionAnode": [
                        SterliteCCPPQuery.InternalRejectionAnode.QUERY_1,
                        SterliteCCPPQuery.InternalRejectionAnode.QUERY_2,
                    ],
                    "RefinerySpentAnode": [
                        SterliteCCPPQuery.RefinerySpentAnode.QUERY_1,
                        SterliteCCPPQuery.RefinerySpentAnode.QUERY_2,
                    ],
                    "SapProduction": [
                        SterliteCCPPQuery.SapProduction.QUERY_1,
                        SterliteCCPPQuery.SapProduction.QUERY_2,
                    ],
                    "Dingot": [
                        SterliteCCPPQuery.Dingot.QUERY_1,
                        SterliteCCPPQuery.Dingot.QUERY_2,
                    ],
                    "KcmAnode": [
                        SterliteCCPPQuery.KcmAnode.QUERY_1,
                        SterliteCCPPQuery.KcmAnode.QUERY_2,
                    ],
                    "CuLumps": [
                        SterliteCCPPQuery.CuLumps.QUERY_1,
                        SterliteCCPPQuery.CuLumps.QUERY_2,
                    ],
                    "AcpRejectAnode": [
                        SterliteCCPPQuery.AcpRejectAnode.QUERY_1,
                        SterliteCCPPQuery.AcpRejectAnode.QUERY_2,
                    ],
                    "ChargingVariation": [
                        SterliteCCPPQuery.ChargingVariation.QUERY_1,
                        SterliteCCPPQuery.ChargingVariation.QUERY_2,
                    ],
                    "AnodesBookingPending": [
                        SterliteCCPPQuery.AnodesBookingPending.QUERY_1,
                        SterliteCCPPQuery.AnodesBookingPending.QUERY_2
                    ],
                    "AnodeInCCPPYard": [
                        SterliteCCPPQuery.AnodeInCCPPYard.QUERY_1,
                        SterliteCCPPQuery.AnodeInCCPPYard.QUERY_2
                    ]
                },
                "data": [],
                "data_column": ["particulars", "unit", "on_date", "mtd",
                                ],
            },
            "BLANK0": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "LPG CONSUMPTION": {
                "columns": ["TOTAL BREAKDOWN DETAILS(MINS)", "DURATION(MINS)"],
                "query": {
                },
                "data": [],
                "data_column": ["kpi", "breakdown_duration_hours"],
            },
            "BLANK1": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "TOTAL BREAKDOWN DETAILS": {
                "columns": ["TOTAL BREAKDOWN DETAILS(MINS)", "ON DATE"],
                "query": {
                    "TotalBreakdownDetails": [SterliteCCPPQuery.TotalBreakdownDetails.QUERY_1],
                    "TotalBreakdownDetails1": [SterliteCCPPQuery.TotalBreakdownDetails1.QUERY_1]
                },
                "data": [],
                "data_column": ["total_breakdown", "on_date"],
            },
            "BLANK2": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "MONTH WISE PRODUCTION": {
                "columns": ["NOS", "SHIFT", "PRODUCTION"],
                "query": {
                    "MonthwiseProductionDetails": [SterliteCCPPQuery.MonthwiseProductionDetails.QUERY_1]
                },
                "data": [],
                "data_column": ["nos", "target", "production"],
                "addition": {
                    "merge_header": "Monthwise Production details (MT)",
                }

            },

        },
        {
            "CHARGING DETAILS": {
                "columns": [
                    "CHARGING_DETAIL",
                    "A-SHIFT",
                    "B-SHIFT",
                    "C-SHIFT",
                    "TOTAL"
                ],
                "query": {
                    "ChargingDetails": [SterliteCCPPQuery.ChargingDetails.QUERY_1]
                },
                "data": [],
                "data_column": [
                    "charging_detail",
                    "a_shift",
                    "b_shift",
                    "c_shift",
                    "total"
                ]
            },
            "BLANK0": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "INTERNAL ANODE REJECTION": {
                "columns": [
                    "INTERNAL ANODE REJECTION",
                    "CCPP ANODE REJECTION"
                ],
                "query": {
                    "InternalAnodeRejection": [
                        SterliteCCPPQuery.InternalAnodeRejection.QUERY_1
                    ]
                },
                "data": [],
                "data_column": [
                    "internal_anode_rejection",
                    "ccpp_anode_rejection"
                ],
            },
            "BLANK1": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "PARTICULAR TEMP": {
                "columns": [
                    "PARTICULARS",
                    "UOM",
                    "FTD"
                ],
                "data": [],
                "query": {
                    "Paticulars": [SterliteCCPPQuery.Paticulars.QUERY_1],
                    "LugThickness": [SterliteCCPPQuery.LugThickness.QUERY_1]
                },
                "data_column": [
                    "particulars",
                    "uom",
                    "ftd"
                ]
            }

        },
        {
            "TBC": {
                "columns": [

                ],
                "query": {
                    "Tbc": [SterliteCCPPQuery.Tbc.QUERY_1,
                            SterliteCCPPQuery.Tbc.QUERY_2]
                },
                "data": [],
                "data_column": [

                ],
            }
        },
        {
            "PERSON ON DUTY": {
                "columns": ["PERSONS ON DUTY", "A SHIFT", "B SHIFT", "C SHIFT"],
                "query": {
                    "PersonOnDuty": [SterliteCCPPQuery.PersonOnDuty.QUERY_1]
                },
                "data": [],
                "data_column": ["persons_on_duty", "a_shift", "b_shift", "c_shift"],
            },
        },
        {
            "PRODUCTION DETAILS": {
                "columns": ["PRODUCTION_DETAIL", "A_SHIFT", "B_SHIFT", "C_SHIFT", "TOTAL_ANODE", "A_SHIFT_PRODUCTION",
                            "B_SHIFT_PRODUCTION", "C_SHIFT_PRODUCTION", "OD_PRODUCTION"],
                "query": {
                    "ProductionDetails1": [SterliteCCPPQuery.ProductionDetails1.QUERY_1],
                    "ProductionDetails2": [SterliteCCPPQuery.ProductionDetails2.QUERY_1]
                },
                "data": [],
                "data_column": ["production_detail", "a_shift", "b_shift", "c_shift", "total_anode",
                                "a_shift_production", "b_shift_production", "c_shift_production", "od_production"]
            },
        },
        {
            "CONSUMPTION ITEMS": {
                "columns": ["CONSUMPTION ITEM", "UNIT", "ON DATE", "MTD"],
                "query": {
                    "ConsumptionItem1": [SterliteCCPPQuery.ConsumptionItem1.QUERY_1,
                                         SterliteCCPPQuery.ConsumptionItem1.QUERY_2],
                    "ConsumptionItem2": [SterliteCCPPQuery.ConsumptionItem2.QUERY_1,
                                         SterliteCCPPQuery.ConsumptionItem2.QUERY_2],
                    "ConsumptionItem3": [SterliteCCPPQuery.ConsumptionItem3.QUERY_1,
                                         SterliteCCPPQuery.ConsumptionItem3.QUERY_2]
                },
                "data": [],
                "data_column": ["consumption_item", "unit", "on_date", "mtd"],
            }

        },
        {
            "ACTIVITY TIME": {
                "columns": [
                    "ACTIVITY TIME",
                    "SHIFT TIME",
                    "END TIME",
                    "TOTAL TIME (MINUTES)",
                    "REASON FOR STOPAGE"
                ],
                "query": {
                    # "ActivityTime":[
                    #     # SterliteCCPPQuery.ActivityTime.QUERY_1
                    # ]
                },
                "data": [],
                "data_column": [
                     "activity_time",
                    "shift_time",
                    "end_time",
                    "total_time",
                    "reason_for_stopage"
                ],
            }

        },
        # {
        #     "A-SHIFT": {
        #         "columns": ["",""
        #         ],
        #         "query": {
        #         },
        #         "data": [],
        #         "data_column": ["",""
        #
        #         ],
        #         "addition": {
        #             "merge_header": "A-SHIFT",
        #         }
        #     },
        #     "BLANK0": {
        #         "columns": [
        #             None
        #         ],
        #         "data": [],
        #         "query": {},
        #         "data_column": [
        #             None
        #         ]
        #     },
        #     "LINEAR CASTING": {
        #         "columns": [
        #             "",""
        #         ],
        #         "data": [],
        #         "query": {},
        #         "data_column": [
        #             "",""
        #         ],
        #         "addition": {
        #             "merge_header": "LINEAR CASTING",
        #         }
        #     },
        # },
        # {
        #     "A-SHIFT": {
        #         "columns": [
        #             "",""
        #         ],
        #         "query": {
        #         },
        #         "data": [],
        #         "data_column": [
        #             "",""
        #         ],
        #     },
        #     "BLANK0": {
        #         "columns": [
        #             None
        #         ],
        #         "data": [],
        #         "query": {},
        #         "data_column": [
        #             None
        #         ]
        #     },
        #     "CIRCULAR CASTING": {
        #         "columns": [
        #             "",""
        #         ],
        #         "data": [],
        #         "query": {},
        #         "data_column": [
        #             "",""
        #         ],
        #         "addition": {
        #             "merge_header": "CIRCULAR CASTING",
        #         }
        #     },
        # },
        # {
        #     "SHIFT ACTIVITY": {
        #         "columns": [
        #             "",""
        #         ],
        #         "query": {
        #         },
        #         "data": [],
        #         "data_column": [
        #             "",""
        #         ],
        #     },
        #     "BLANK": {
        #         "columns": [
        #             None
        #         ],
        #         "data": [],
        #         "query": {},
        #         "data_column": [
        #             None
        #         ]
        #     },
        #     "CIRCULAR CASTING": {
        #         "columns": [
        #             "",""
        #         ],
        #         "data": [],
        #         "query": {},
        #         "data_column": [
        #             "",""
        #         ],
        #         "addition": {
        #             "merge_header": "CIRCULAR CASTING",
        #         }
        #     },
        # },
        # {
        #     "B-SHIFT": {
        #         "columns": [
        #             "", ""
        #         ],
        #         "query": {
        #         },
        #         "data": [],
        #         "data_column": [
        #             "",""
        #         ],
        #     },
        #     "BLANK0": {
        #         "columns": [
        #             None
        #         ],
        #         "data": [],
        #         "query": {},
        #         "data_column": [
        #             None
        #         ]
        #     },
        #     "LINEAR CASTING": {
        #         "columns": [
        #             "",""
        #         ],
        #         "data": [],
        #         "query": {},
        #         "data_column": [
        #             "",""
        #         ],
        #         "addition": {
        #             "merge_header": "LINEAR CASTING",
        #         }
        #     },
        # },
        # {
        #     "SHIFT ACTIVITY": {
        #         "columns": [
        #             "ACTIVITY-TIME",
        #             "SHIFT",
        #             "START TIME",
        #             "END TIME",
        #             "TOTAL TIME (MINUTES)",
        #             "REASON FOR STOPAGE"
        #         ],
        #         "query": {
        #         },
        #         "data": [],
        #         "data_column": [
        #             "activity_time",
        #             "shift",
        #             "start_time",
        #             "end_time",
        #             "total_time",
        #             "reason_for_stopage"
        #         ],
        #     },
        #     "BLANK": {
        #         "columns": [
        #             None
        #         ],
        #         "data": [],
        #         "query": {},
        #         "data_column": [
        #             None
        #         ]
        #     },
        #     "CIRCULAR CASTING": {
        #         "columns": [
        #             "",""
        #         ],
        #         "data": [],
        #         "query": {},
        #         "data_column": [
        #             "",""
        #         ],
        #         "addition": {
        #             "merge_header": "CIRCULAR CASTING",
        #         }
        #     },
        # },
        # {
        #     "C-SHIFT": {
        #         "columns": ["",""
        #
        #         ],
        #         "query": {
        #         },
        #         "data": [],
        #         "data_column": ["",""
        #
        #         ],
        #     },
        #     "BLANK0": {
        #         "columns": [
        #             None
        #         ],
        #         "data": [],
        #         "query": {},
        #         "data_column": [
        #             None
        #         ]
        #     },
        #     "LINEAR CASTING": {
        #         "columns": [
        #             "",""
        #         ],
        #         "data": [],
        #         "query": {},
        #         "data_column": [
        #             "",""
        #         ],
        #         "addition": {
        #             "merge_header": "LINEAR CASTING",
        #         }
        #     },
        # },
        # {
        #     "SHIFT ACTIVITY": {
        #         "columns": ["",""
        #         ],
        #         "query": {
        #         },
        #         "data": [],
        #         "data_column": ["",""
        #
        #         ],
        #     },
        #     "BLANK": {
        #         "columns": [
        #             None
        #         ],
        #         "data": [],
        #         "query": {},
        #         "data_column": [
        #             None
        #         ]
        #     },
        #     "CIRCULAR CASTING": {
        #         "columns": [
        #             "",""
        #         ],
        #         "data": [],
        #         "query": {},
        #         "data_column": [
        #             "",""
        #         ],
        #         "addition": {
        #             "merge_header": "CIRCULAR CASTING",
        #         }
        #     },
        # }
    ]
    WORKSHEET_HEADER_FORMAT = {
        "bold": True,
        "align": "center",
        "valign": "center",
        "fg_color": "#e6e7eb",
        "font_color": "#1b314f",
        "border": 1,
        'font_size': '20',
    }
    COLUMN_HEADER_FORMAT = {
        "bold": True,
        "align": "center",
        "valign": "center",
        "fg_color": "#e6e7eb",
        "font_color": "#021b5e",
        "border": 1,
    }
    BLANK_COLUMN_HEADER_FORMAT = {
        "bold": True,
        "align": "center",
        "valign": "center",
    }
