class SterliteRefineryQuery:
    """
    Refinery report queries
    """

    class AnodeAvailability:
        # QUERY FOR ANODE_AVAILABILITY, UOM, NORMS, ON_DATE
        QUERY_AA = """
        SELECT 
        'Cell House Anode Availability' AS ANODE_AVAILABILITY,
        '%' AS UOM,
        AVG(ANODE.AA_PLANNED) AS NORMS,
        (SUM(ANODE.NUMERATOR) / NULLIF(SUM(DENOMINATOR), 0)) * 100 AS ON_DATE
        
        FROM
            (SELECT ACTUAL.AA_NUMO AS NUMERATOR,
                    ACTUAL.AA_DENO AS DENOMINATOR,
                    PLAN.AA_PLANNED,
                    COALESCE(ACTUAL.DATE,
        
                        PLAN.DATE) AS date
                FROM SEMANTIC_PROD.REFINERY_ANODE_AVAILABILITY_ACTUAL_VIEW ACTUAL
                FULL JOIN
                    (SELECT DD_1.DATE_DT AS date,
                            M_PLAN.AA_PLANNED
                        FROM
                            (SELECT DATE(date) AS POSTING_DATE,
                                    ANODE_AVAILABILITY_VALUE::numeric AS AA_PLANNED
                                FROM SEMANTIC_DEV.ANODE_AVAILABILITY
                                WHERE 
                             LOWER(TRIM(ANODE_AVAILABILITY_SELECT)) = 
                             'anode availability'
                                    AND DATE_PART('day',date) = 1
                                GROUP BY 1,
                                    2)M_PLAN
                        LEFT JOIN
                            (SELECT DIM_DATE.DATE_DT,
                                    DIM_DATE.MONTH_OF_YR_NUM AS MNTH,
                                    DIM_DATE.YR_NAME AS YR
                                FROM SEMANTIC_PROD.DIM_DATE) DD_1 ON 
                     DD_1.MNTH = DATE_PART('month', M_PLAN.POSTING_DATE)
                        AND DD_1.YR = DATE_PART('year', M_PLAN.POSTING_DATE))PLAN 
             ON ACTUAL.DATE = PLAN.DATE)ANODE
        
        WHERE 
        DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
        
        GROUP BY
        1,2;
        """
        QUERY_MTD = """
                SELECT 
                'Cell House Anode Availability' AS ANODE_AVAILABILITY,
                '%' AS UOM,
                (SUM(ANODE.NUMERATOR) / NULLIF(SUM(DENOMINATOR), 0)) * 100 AS MTD

                FROM
                    (SELECT ACTUAL.AA_NUMO AS NUMERATOR,
                            ACTUAL.AA_DENO AS DENOMINATOR,
                            PLAN.AA_PLANNED,
                            COALESCE(ACTUAL.DATE,

                                PLAN.DATE) AS date
                        FROM SEMANTIC_PROD.REFINERY_ANODE_AVAILABILITY_ACTUAL_VIEW ACTUAL
                        FULL JOIN
                            (SELECT DD_1.DATE_DT AS date,
                                    M_PLAN.AA_PLANNED
                                FROM
                                    (SELECT DATE(date) AS POSTING_DATE,
                                            ANODE_AVAILABILITY_VALUE::numeric AS AA_PLANNED
                                        FROM SEMANTIC_DEV.ANODE_AVAILABILITY
                                        WHERE 
                                     LOWER(TRIM(ANODE_AVAILABILITY_SELECT)) = 
                                     'anode availability'
                                            AND DATE_PART('day',date) = 1
                                        GROUP BY 1,
                                            2)M_PLAN
                                LEFT JOIN
                                    (SELECT DIM_DATE.DATE_DT,
                                            DIM_DATE.MONTH_OF_YR_NUM AS MNTH,
                                            DIM_DATE.YR_NAME AS YR
                                        FROM SEMANTIC_PROD.DIM_DATE) DD_1 ON 
                             DD_1.MNTH = DATE_PART('month', M_PLAN.POSTING_DATE)
                                AND DD_1.YR = DATE_PART('year', M_PLAN.POSTING_DATE))PLAN 
                     ON ACTUAL.DATE = PLAN.DATE)ANODE

                WHERE 
                DATE BETWEEN '{month_start_date}' AND '{month_end_date}'

                GROUP BY
                1,2;
                """
        QUERY_YTD = """
                SELECT 
                'Cell House Anode Availability' AS ANODE_AVAILABILITY,
                '%' AS UOM,
                (SUM(ANODE.NUMERATOR) / NULLIF(SUM(DENOMINATOR), 0)) * 100 AS YTD

                FROM
                    (SELECT ACTUAL.AA_NUMO AS NUMERATOR,
                            ACTUAL.AA_DENO AS DENOMINATOR,
                            PLAN.AA_PLANNED,
                            COALESCE(ACTUAL.DATE,

                                PLAN.DATE) AS date
                        FROM SEMANTIC_PROD.REFINERY_ANODE_AVAILABILITY_ACTUAL_VIEW ACTUAL
                        FULL JOIN
                            (SELECT DD_1.DATE_DT AS date,
                                    M_PLAN.AA_PLANNED
                                FROM
                                    (SELECT DATE(date) AS POSTING_DATE,
                                            ANODE_AVAILABILITY_VALUE::numeric AS AA_PLANNED
                                        FROM SEMANTIC_DEV.ANODE_AVAILABILITY
                                        WHERE 
                                     LOWER(TRIM(ANODE_AVAILABILITY_SELECT)) = 
                                     'anode availability'
                                            AND DATE_PART('day',date) = 1
                                        GROUP BY 1,
                                            2)M_PLAN
                                LEFT JOIN
                                    (SELECT DIM_DATE.DATE_DT,
                                            DIM_DATE.MONTH_OF_YR_NUM AS MNTH,
                                            DIM_DATE.YR_NAME AS YR
                                        FROM SEMANTIC_PROD.DIM_DATE) DD_1 ON 
                             DD_1.MNTH = DATE_PART('month', M_PLAN.POSTING_DATE)
                                AND DD_1.YR = DATE_PART('year', M_PLAN.POSTING_DATE))PLAN 
                     ON ACTUAL.DATE = PLAN.DATE)ANODE

                WHERE 
                DATE BETWEEN '{year_start_date}' AND '{year_end_date}'

                GROUP BY
                1,2;
                """

    class DOCellsInOperation:
        QUERY_AA = """
        SELECT 
        'DO Cells In Operation' AS ANODE_AVAILABILITY,
        'No.' AS UOM, 
        MAX(CASE 
            WHEN LOWER(TRIM(KPI)) = 'liberator_cells_plan' THEN METRIC_VALUE END) 
            AS NORMS,
        MAX(CASE 
            WHEN LOWER(TRIM(KPI)) = 'liberator_cells_actual' THEN METRIC_VALUE END) 
            AS ON_DATE,
        MAX(CASE 
            WHEN LOWER(TRIM(KPI)) = 'liberator_cells_actual' THEN METRIC_VALUE END) 
            AS MTD,
        MAX(CASE 
            WHEN LOWER(TRIM(KPI)) = 'liberator_cells_actual' THEN METRIC_VALUE END) 
            AS YTD
        
        FROM 
        SEMANTIC_PROD.BANKS_CELLS_LIBERATORS_VIEW
        
        GROUP BY 
        1,2
        """

    class TotalCellsInOperation:
        QUERY_1 = """
        SELECT 
        'Total Cells In Operation' AS ANODE_AVAILABILITY,
        'No.' AS UOM,
        MAX(NORMS) AS NORMS,
        MAX(METRIC_VALUE) AS ON_DATE
        
        FROM
            (SELECT KPI,
                    CASE
                        WHEN LOWER(TRIM(KPI)) = 'operational_cells_plan' THEN ROUND(AVG(METRIC_VALUE))
                        ELSE NULL
                    END AS NORMS,
                    CASE
                        WHEN LOWER(TRIM(KPI)) = 'operational_cells_actual' THEN ROUND(AVG(METRIC_VALUE))
                        ELSE NULL
                    END AS METRIC_VALUE
                FROM SEMANTIC_PROD.REFINERY_OPERATIONAL_CELLS_VIEW
                WHERE LOWER(TRIM(KPI)) in ('operational_cells_actual', 'operational_cells_plan')
                    AND (date BETWEEN '{day_start_date}' AND '{day_end_date}')
                GROUP BY 1)OP_CELLS
        GROUP BY 1,2
        """
        QUERY_2 = """
        SELECT 
        'Total Cells In Operation' AS ANODE_AVAILABILITY,
        'No.' AS UOM,
        MAX(METRIC_VALUE) AS MTD
        
        FROM
            (SELECT KPI,
                    CASE
                        WHEN LOWER(TRIM(KPI)) = 'operational_cells_plan' THEN ROUND(AVG(METRIC_VALUE))
                        ELSE NULL
                    END AS NORMS,
                    CASE
                        WHEN LOWER(TRIM(KPI)) = 'operational_cells_actual' THEN ROUND(AVG(METRIC_VALUE))
                        ELSE NULL
                    END AS METRIC_VALUE
                FROM SEMANTIC_PROD.REFINERY_OPERATIONAL_CELLS_VIEW
                WHERE LOWER(TRIM(KPI)) in ('operational_cells_actual', 'operational_cells_plan')
                    AND (date BETWEEN '{month_start_date}' AND '{month_end_date}')
                GROUP BY 1)OP_CELLS
        GROUP BY 1,2
        """
        QUERY_3 = """
                SELECT 
                'Total Cells In Operation' AS ANODE_AVAILABILITY,
                'No.' AS UOM,
                MAX(METRIC_VALUE) AS YTD

                FROM
                (SELECT KPI,
                        CASE
                            WHEN LOWER(TRIM(KPI)) = 'operational_cells_plan' THEN ROUND(AVG(METRIC_VALUE))
                            ELSE NULL
                        END AS NORMS,
                        CASE
                            WHEN LOWER(TRIM(KPI)) = 'operational_cells_actual' THEN ROUND(AVG(METRIC_VALUE))
                            ELSE NULL
                        END AS METRIC_VALUE
                    FROM SEMANTIC_PROD.REFINERY_OPERATIONAL_CELLS_VIEW
                    WHERE LOWER(TRIM(KPI)) in ('operational_cells_actual', 'operational_cells_plan')
                        AND (date BETWEEN '{year_start_date}' AND '{year_end_date}')
                    GROUP BY 1)OP_CELLS
                GROUP BY 1,2
                """
