from scripts.core.db.postgres.custom_report_query import SterliteRefineryQuery


class SterliteRefineryTemplate:
    REPORT_TEMPLATE = [
        {
            "ANODE AVAILABILITY": {
                "columns": [
                    "ANODE AVAILABILITY",
                    "UOM",
                    "NORMS (Month)",
                    "ON DATE(Day)",
                    "MTD",
                    "YTD"
                ],
                "query": {
                    "ANODE_AVAILABILITY": [
                        SterliteRefineryQuery.AnodeAvailability.QUERY_AA,
                        SterliteRefineryQuery.AnodeAvailability.QUERY_MTD,
                        SterliteRefineryQuery.AnodeAvailability.QUERY_YTD
                    ],
                    "DO CELLS IN OPERATION": [
                        SterliteRefineryQuery.DOCellsInOperation.QUERY_AA
                    ],
                    "Total Cells In Operation": [
                        SterliteRefineryQuery.TotalCellsInOperation.QUERY_1,
                        SterliteRefineryQuery.TotalCellsInOperation.QUERY_2,
                        SterliteRefineryQuery.TotalCellsInOperation.QUERY_3
                    ]
                },
                "data": [],
                "data_column": ["anode_availability", "uom",
                                "norms", "on_date", "mtd",
                                "ytd"],
                "description": "",
                "format": ""
            },
            "SAFETY REPORT": {
                "columns": [
                    "SAFETY REPORT",
                    "UOM",
                    "NORMS",
                    "ON DATE",
                    "MTD",
                    "YTD"
                ],
                "query": [],
                "data": [],
                "data_column": ["safety_report", "uom",
                                "norms", "on_date", "mtd",
                                "ytd"],
                "additions": [],
                "description": "",
                "format": ""
            }
        },
        {
            "POWER AVAILABILITY": {
                "columns": [
                    "POWER AVAILABILITY",
                    "UOM",
                    "NORMS",
                    "ON DATE",
                    "MTD",
                    "YTD"
                ],
                "query": [],
                "data": [],
                "additions": [],
                "description": "",
                "format": ""
            },
            "RM ANODE RECEIPT DETAILS": {
                "columns": [
                    "RM ANODE RECEIPT DETAILS",
                    "ON DATE",
                    "MTD",
                    "YTD",
                    "Material",
                    "OPENING STOCK"
                ],
                "query": [],
                "data": [],
                "additions": [],
                "description": "",
                "format": ""
            }
        },
        {
            "EFFICIENCIES": {
                "columns": [
                    "EFFICIENCIES",
                    "UOM",
                    "NORMS",
                    "ON DATE",
                    "MTD",
                    "YTD"
                ],
                "query": [],
                "data": [],
                "additions": [],
                "description": "",
                "format": ""
            },
            "BANK / CROP": {
                "columns": [
                    "BANK / CROP",
                    "CE (%)",
                    "THEOR. WEIGHT",
                    "ACTUAL WEIGHT",
                    "STRIPPING TIME"
                ],
                "query": [],
                "data": [],
                "additions": [],
                "description": "",
                "format": ""
            }
        },
        {
            "PRODUCTION": {
                "columns": [
                    "PRODUCTION",
                    "UOM",
                    "NORMS",
                    "ON DATE",
                    "MTD",
                    "YTD"
                ],
                "query": [],
                "data": [],
                "additions": [],
                "description": "",
                "format": ""
            },
            "CIRCULATION": {
                "columns": [
                    "CIRCULATION",
                    "CE%",
                    "THEOR. WEIGHT",
                    "ACTUAL WEIGHT"
                ],
                "query": [],
                "data": [],
                "additions": [],
                "description": "",
                "format": ""
            }
        },
        {
            "FG INVENTORY": {
                "columns": [
                    "FG INVENTORY",
                    "ON DATE",
                    "MTD",
                    "YTD"
                ],
                "query": [],
                "data": [],
                "additions": [],
                "description": "",
                "format": ""
            },
            "PRODUCTION": {
                "columns": [
                    "PRODUCTION",
                    "ON DATE",
                    "MTD",
                    "YTD"
                ],
                "query": [],
                "data": [],
                "additions": [],
                "description": "",
                "format": ""
            }
        },
        {
            "CROP": {
                "columns": [
                    "CROP",
                    "BANKS",
                    "TOTAL CELLS",
                    "CELL VOLTAGE (V)",
                    "T. SHORTS / CELL / CHECK"
                ],
                "query": [],
                "data": [],
                "additions": [],
                "description": "",
                "format": ""
            }
        },
        {
            "STRIPPING TIME": {
                "columns": [
                    "STRIPPING TIME",
                    "UOM",
                    "1st CROP - Sttripping time",
                    "2nd CROP - Change over time",
                    "3rd CROP",
                    "CSM Plate Rejection"
                ],
                "query": [],
                "data": [],
                "additions": [],
                "description": "",
                "format": ""
            }
        },
        {
            "FILTER AVAILABILITY": {
                "columns": [
                    "FILTER AVAILABILITY",
                    "ON DATE",
                    "MTD",
                    "Filtered Volume",
                    "Total Volume Refinery",
                    "ON DATE"
                ],
                "query": [],
                "data": [],
                "additions": [],
                "description": "",
                "format": ""
            }
        },
        {
            "SPECIFIC ENERGY CONSUMPTION": {
                "columns": [
                    "UTILITIES CONSUMPTIONS",
                    "UOM",
                    "NORMS",
                    "ON DATE",
                    "MTD",
                    "YTD"
                ],
                "query": [],
                "data": [],
                "additions": [],
                "description": "",
                "format": ""
            },
            "SPECIFIC CONSUMPTION": {
                "columns": [
                    "CONSUMABLES",
                    "UOM",
                    "NORMS",
                    "ON DATE",
                    "MTD",
                    "YTD"
                ],
                "query": [],
                "data": [],
                "additions": [],
                "description": "",
                "format": ""
            }
        },
        {
            "ELECTROLYTE COMPOSITION": {
                "columns": [
                    "ELECTROLYTE COMPOSITION",
                    "UOM",
                    "NORMS",
                    "DATE",
                    "CIR-1",
                    "CIR-2"
                ],
                "query": [],
                "data": [],
                "additions": [],
                "description": "",
                "format": ""
            },
            "SUSPENDED SOLIDS": {
                "columns": [
                    "SUSPENDED SOLIDS"
                ],
                "query": [],
                "data": [],
                "additions": [],
                "description": "",
                "format": ""
            }
        },
        {
            "BLEEDING SECTION": {
                "columns": [
                    "BLEEDING SECTION",
                    "UOM",
                    "ON DATE",
                    "MTD",
                    "YTD"
                ],
                "query": [],
                "data": [],
                "additions": [],
                "description": "",
                "format": ""
            },
            "BANK / CROP": {
                "columns": [
                    "BANK / CROP",
                    "TIME",
                    "WEIGHT (MT)",
                    "CELLS",
                    "READING"
                ],
                "query": [

                ],
                "data": [],
                "additions": [],
                "description": "",
                "format": ""
            }
        },
        {
            "DEPARTMENT(M4)": {
                "columns": [
                    "DEPARTMENT(M4)",
                    "EQUIPMENT DETAILS",
                    "EQUIPMENT LOCATION",
                    "DURATION",
                    "(MT) PRODUCTION",
                    "CAUSE OF THE BREAK DOWN"
                ],
                "query": [],
                "data": [],
                "additions": [],
                "description": "",
                "format": ""
            }
        }
    ]
