import pandas as pd
from datetime import datetime
from scripts.constants import ReportType, CommonConstants
from scripts.template.sterlite_report_template import SterliteRefineryTemplate
from scripts.core.logging.application_logging import logger
from scripts.core.exception.app_exceptions import GeneralException
from scripts.core.utilities.postgresql_db_utils import PostgresDBUtility


class CustomReportHandler:
    def __init__(self):
        self.postgres_db_obj = PostgresDBUtility()

    def create_custom_date_filter(self, input_json):
        """
        This method convert start date and end date to a date range.
        :param input_json:
        :return:
        """
        date_range_list = []
        # Start date
        start_date = datetime.strptime(
            input_json["property"]["start_date"], CommonConstants.DATE_TIME_FORMAT
        )
        # End date
        end_date = datetime.strptime(
            input_json["property"]["end_date"], CommonConstants.DATE_TIME_FORMAT
        )

        logger.info(f"Creating list of dates starting from {start_date} to {end_date}")
        date_list = pd.date_range(start_date, end_date, freq='D')

        # Iterating and creating where clause filters
        # Output - {'day_start_date': 'YYYY-MM-DD', 'day_end_date': 'YYYY-MM-DD',
        # 'month_start_date': 'YYYY-MM-DD', 'month_end_date': 'YYYY-MM-DD',
        # 'year_start_date': 'YYYY-MM-DD', 'year_end_date': 'YYYY-MM-DD'}

        for each_dates in date_list.strftime(
                CommonConstants.DATE_TIME_FORMAT).to_list():

            # To get the financial year
            financial_year = None
            date_obj = datetime.strptime(each_dates, CommonConstants.DATE_TIME_FORMAT)
            if date_obj.month >= 4:
                financial_year = str(date_obj.year)
            elif date_obj.month < 4:
                financial_year = str(date_obj.year - 1)

            date_range_list.append(
                dict(
                    day_start_date=each_dates,
                    day_end_date=each_dates,
                    month_start_date=each_dates[:-2] + "01",
                    month_end_date=each_dates,
                    year_start_date=financial_year + "-04-01",
                    year_end_date=each_dates,
                )
            )
        return date_range_list

    def get_queries_from_db(self, input_json, date_filter):
        """
        :param input_json:
        :param date_filter:
        :return:
        """
        for each_blocks in input_json:
            # Iterating each blocks for fetching query
            print(each_blocks)

            if input_json[each_blocks][CommonConstants.QUERY]:
                for each_kpi in input_json[each_blocks][CommonConstants.QUERY]:
                    temp_data_dict = dict()
                    # Iterating each query for each KPI

                    for each_query in \
                            input_json[each_blocks][CommonConstants.QUERY][each_kpi]:
                        query = each_query. \
                            format(
                            day_start_date=date_filter[CommonConstants.DAY_START_DATE],
                            day_end_date=date_filter[CommonConstants.DAY_END_DATE],
                            month_start_date=date_filter[
                                CommonConstants.MONTH_START_DATE],
                            month_end_date=date_filter[CommonConstants.MONTH_END_DATE],
                            year_start_date=date_filter[
                                CommonConstants.YEAR_START_DATE],
                            year_end_date=date_filter[CommonConstants.YEAR_END_DATE]
                            )

                        response = self.postgres_db_obj.fetch_data(query=query)
                        if response:
                            temp_data_dict.update(dict(response[0]))

                        if not temp_data_dict:
                            # Creating null values if no data
                            for each_columns in input_json[each_blocks]["data_column"]:
                                temp_data_dict.update({each_columns: None})

                    input_json[each_blocks]["data"].append(temp_data_dict)
            else:
                temp_data_dict = dict()
                for each_columns in input_json[each_blocks]["data_column"]:
                    temp_data_dict.update(
                        {each_columns: None}
                    )
                input_json[each_blocks]["data"].append(temp_data_dict)
        return input_json

    def custom_report_handler(self, input_json):
        """
        :param input_json:
        :return:
        """
        status = False
        message = "Error generating a message"
        data = "Data"
        try:
            # if str(input_json.job_type).lower() == ReportType.REFINERY_REPORT:
            if str(input_json["job_type"]).lower() == ReportType.REFINERY_REPORT:
                date_filter = self.create_custom_date_filter(input_json=input_json)

                for each_date_range in date_filter:
                    # Iterating over sterlite json file
                    for each_blocks in SterliteRefineryTemplate.REPORT_TEMPLATE:
                        # Getting the data from queries
                        each_blocks = self.get_queries_from_db(
                            input_json=each_blocks, date_filter=each_date_range
                        )
                        # print(each_blocks)
                        print("=========================================")
                    break

        except GeneralException as err:
            logger.error(f"Exception in custom_report_handler: {err}")
        return status, message, data
