"""
app.py - Sterlite Vedanta: Refinery Custom Report

    This script initializes and configures the Custom Report application
    for generating custom report.

    Usage:
        Start the FastAPI application by running this script.
"""

import uvicorn
from fastapi import FastAPI, Depends
from fastapi.middleware.cors import CORSMiddleware
from __version__ import version
from scripts.constants import MainConstants, CommonConstants
from scripts.configurations import service_details
from scripts.core.services import api_router, auth_obj

app = FastAPI(
    title="Sterlite Vedanta: Custom Report",
    version=version,
    description=MainConstants.DESCRIPTION_KEY,
    openapi_tags=[MainConstants.META_TAG_JSON]
)

if service_details.env.lower() != CommonConstants.DEV_KEY:
    app.include_router(router=api_router, dependencies=[Depends(auth_obj)])
else:
    app.include_router(router=api_router)

origins = ["*"]
app.add_middleware(
    CORSMiddleware,
    allow_origins=origins,
    allow_credentials=True,
    allow_methods=["*"],
    allow_headers=["*"],
    expose_headers=[MainConstants.TOKEN_KEY]
)

if __name__ == '__main__':
    uvicorn.run(app=app,
                host=service_details.host_name,
                port=int(service_details.port_name))
