class SterliteRefineryQuery:
    """
    Refinery report queries
    """

    class AnodeAvailability:
        """ ANODE AVAILABILITY """
        QUERY_1 = """
        SELECT 
        'Cell House Anode Availability' AS ANODE_AVAILABILITY,
        '%' AS UOM,
        AVG(ANODE.AA_PLANNED) AS NORMS,
        (SUM(ANODE.NUMERATOR) / NULLIF(SUM(DENOMINATOR), 0)) * 100 AS ON_DATE
        
        FROM
            (SELECT ACTUAL.AA_NUMO AS NUMERATOR,
                    ACTUAL.AA_DENO AS DENOMINATOR,
                    PLAN.AA_PLANNED,
                    COALESCE(ACTUAL.DATE,
        
                        PLAN.DATE) AS date
                FROM SEMANTIC_PROD.REFINERY_ANODE_AVAILABILITY_ACTUAL_VIEW ACTUAL
                FULL JOIN
                    (SELECT DD_1.DATE_DT AS date,
                            M_PLAN.AA_PLANNED
                        FROM
                            (SELECT DATE(date) AS POSTING_DATE,
                                    ANODE_AVAILABILITY_VALUE::numeric AS AA_PLANNED
                                FROM SEMANTIC_DEV.ANODE_AVAILABILITY
                                WHERE 
                             LOWER(TRIM(ANODE_AVAILABILITY_SELECT)) = 
                             'anode availability'
                                    AND DATE_PART('day',date) = 1
                                GROUP BY 1,
                                    2)M_PLAN
                        LEFT JOIN
                            (SELECT DIM_DATE.DATE_DT,
                                    DIM_DATE.MONTH_OF_YR_NUM AS MNTH,
                                    DIM_DATE.YR_NAME AS YR
                                FROM SEMANTIC_PROD.DIM_DATE) DD_1 ON 
                     DD_1.MNTH = DATE_PART('month', M_PLAN.POSTING_DATE)
                        AND DD_1.YR = DATE_PART('year', M_PLAN.POSTING_DATE))PLAN 
             ON ACTUAL.DATE = PLAN.DATE)ANODE
        
        WHERE 
        DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
        
        GROUP BY
        1,2;
        """
        QUERY_2 = """
                SELECT 
                'Cell House Anode Availability' AS ANODE_AVAILABILITY,
                '%' AS UOM,
                (SUM(ANODE.NUMERATOR) / NULLIF(SUM(DENOMINATOR), 0)) * 100 AS MTD

                FROM
                (SELECT ACTUAL.AA_NUMO AS NUMERATOR,
                        ACTUAL.AA_DENO AS DENOMINATOR,
                        PLAN.AA_PLANNED,
                        COALESCE(ACTUAL.DATE,

                            PLAN.DATE) AS date
                    FROM SEMANTIC_PROD.REFINERY_ANODE_AVAILABILITY_ACTUAL_VIEW ACTUAL
                    FULL JOIN
                        (SELECT DD_1.DATE_DT AS date,
                                M_PLAN.AA_PLANNED
                            FROM
                                (SELECT DATE(date) AS POSTING_DATE,
                                        ANODE_AVAILABILITY_VALUE::numeric AS AA_PLANNED
                                    FROM SEMANTIC_DEV.ANODE_AVAILABILITY
                                    WHERE 
                                 LOWER(TRIM(ANODE_AVAILABILITY_SELECT)) = 
                                 'anode availability'
                                        AND DATE_PART('day',date) = 1
                                    GROUP BY 1,
                                        2)M_PLAN
                            LEFT JOIN
                                (SELECT DIM_DATE.DATE_DT,
                                        DIM_DATE.MONTH_OF_YR_NUM AS MNTH,
                                        DIM_DATE.YR_NAME AS YR
                                    FROM SEMANTIC_PROD.DIM_DATE) DD_1 ON 
                         DD_1.MNTH = DATE_PART('month', M_PLAN.POSTING_DATE)
                            AND DD_1.YR = DATE_PART('year', M_PLAN.POSTING_DATE))PLAN 
                     ON ACTUAL.DATE = PLAN.DATE)ANODE

                WHERE 
                DATE BETWEEN '{month_start_date}' AND '{month_end_date}'

                GROUP BY
                1,2;
                """
        QUERY_3 = """
                SELECT 
                'Cell House Anode Availability' AS ANODE_AVAILABILITY,
                '%' AS UOM,
                (SUM(ANODE.NUMERATOR) / NULLIF(SUM(DENOMINATOR), 0)) * 100 AS YTD

                FROM
                (SELECT ACTUAL.AA_NUMO AS NUMERATOR,
                        ACTUAL.AA_DENO AS DENOMINATOR,
                        PLAN.AA_PLANNED,
                        COALESCE(ACTUAL.DATE,

                            PLAN.DATE) AS date
                    FROM SEMANTIC_PROD.REFINERY_ANODE_AVAILABILITY_ACTUAL_VIEW ACTUAL
                    FULL JOIN
                        (SELECT DD_1.DATE_DT AS date,
                                M_PLAN.AA_PLANNED
                            FROM
                                (SELECT DATE(date) AS POSTING_DATE,
                                        ANODE_AVAILABILITY_VALUE::numeric AS AA_PLANNED
                                    FROM SEMANTIC_DEV.ANODE_AVAILABILITY
                                    WHERE 
                                 LOWER(TRIM(ANODE_AVAILABILITY_SELECT)) = 
                                 'anode availability'
                                        AND DATE_PART('day',date) = 1
                                    GROUP BY 1,
                                        2)M_PLAN
                            LEFT JOIN
                                (SELECT DIM_DATE.DATE_DT,
                                        DIM_DATE.MONTH_OF_YR_NUM AS MNTH,
                                        DIM_DATE.YR_NAME AS YR
                                    FROM SEMANTIC_PROD.DIM_DATE) DD_1 ON 
                         DD_1.MNTH = DATE_PART('month', M_PLAN.POSTING_DATE)
                            AND DD_1.YR = DATE_PART('year', M_PLAN.POSTING_DATE))PLAN 
                 ON ACTUAL.DATE = PLAN.DATE)ANODE

                WHERE 
                DATE BETWEEN '{year_start_date}' AND '{year_end_date}'

                GROUP BY
                1,2;
                """

    class DOCellsInOperation:
        """ ANODE AVAILABILITY """
        QUERY_1 = """
        SELECT 
        'DO Cells In Operation' AS ANODE_AVAILABILITY,
        'No.' AS UOM, 
        MAX(CASE 
            WHEN LOWER(TRIM(KPI)) = 'liberator_cells_plan' THEN METRIC_VALUE END) 
            AS NORMS,
        MAX(CASE 
            WHEN LOWER(TRIM(KPI)) = 'liberator_cells_actual' THEN METRIC_VALUE END) 
            AS ON_DATE,
        MAX(CASE 
            WHEN LOWER(TRIM(KPI)) = 'liberator_cells_actual' THEN METRIC_VALUE END) 
            AS MTD,
        MAX(CASE 
            WHEN LOWER(TRIM(KPI)) = 'liberator_cells_actual' THEN METRIC_VALUE END) 
            AS YTD
        
        FROM 
        SEMANTIC_PROD.BANKS_CELLS_LIBERATORS_VIEW
        
        GROUP BY 
        1,2
        """

    class TotalCellsInOperation:
        """ ANODE AVAILABILITY """
        QUERY_1 = """
        SELECT 
        'Total Cells In Operation' AS ANODE_AVAILABILITY,
        'No.' AS UOM,
        MAX(NORMS) AS NORMS,
        MAX(METRIC_VALUE) AS ON_DATE
        
        FROM
            (SELECT KPI,
                    CASE
                        WHEN LOWER(TRIM(KPI)) = 'operational_cells_plan' 
                        THEN ROUND(AVG(METRIC_VALUE))
                        ELSE NULL
                    END AS NORMS,
                    CASE
                        WHEN LOWER(TRIM(KPI)) = 'operational_cells_actual' 
                        THEN ROUND(AVG(METRIC_VALUE))
                        ELSE NULL
                    END AS METRIC_VALUE
                FROM SEMANTIC_PROD.REFINERY_OPERATIONAL_CELLS_VIEW
                WHERE LOWER(TRIM(KPI)) in 
                ('operational_cells_actual', 'operational_cells_plan')
                    AND (date BETWEEN '{day_start_date}' AND '{day_end_date}')
                GROUP BY 1)OP_CELLS
        GROUP BY 1,2
        """
        QUERY_2 = """
        SELECT 
        'Total Cells In Operation' AS ANODE_AVAILABILITY,
        'No.' AS UOM,
        MAX(METRIC_VALUE) AS MTD
        
        FROM
            (SELECT KPI,
                    CASE
                        WHEN LOWER(TRIM(KPI)) = 'operational_cells_plan' THEN ROUND(AVG(METRIC_VALUE))
                        ELSE NULL
                    END AS NORMS,
                    CASE
                        WHEN LOWER(TRIM(KPI)) = 'operational_cells_actual' THEN ROUND(AVG(METRIC_VALUE))
                        ELSE NULL
                    END AS METRIC_VALUE
                FROM SEMANTIC_PROD.REFINERY_OPERATIONAL_CELLS_VIEW
                WHERE LOWER(TRIM(KPI)) in ('operational_cells_actual', 'operational_cells_plan')
                    AND (date BETWEEN '{month_start_date}' AND '{month_end_date}')
                GROUP BY 1)OP_CELLS
        GROUP BY 1,2
        """
        QUERY_3 = """
                SELECT 
                'Total Cells In Operation' AS ANODE_AVAILABILITY,
                'No.' AS UOM,
                MAX(METRIC_VALUE) AS YTD

                FROM
                (SELECT KPI,
                        CASE
                            WHEN LOWER(TRIM(KPI)) = 'operational_cells_plan' 
                            THEN ROUND(AVG(METRIC_VALUE))
                            ELSE NULL
                        END AS NORMS,
                        CASE
                            WHEN LOWER(TRIM(KPI)) = 'operational_cells_actual' 
                            THEN ROUND(AVG(METRIC_VALUE))
                            ELSE NULL
                        END AS METRIC_VALUE
                    FROM SEMANTIC_PROD.REFINERY_OPERATIONAL_CELLS_VIEW
                    WHERE LOWER(TRIM(KPI)) in 
                    ('operational_cells_actual', 'operational_cells_plan')
                        AND (date BETWEEN '{year_start_date}' AND '{year_end_date}')
                    GROUP BY 1)OP_CELLS
                GROUP BY 1,2
                """

    class NoOfNearMiss:
        """ SAFETY REPORT """
        QUERY_1 = """
        SELECT 
            CASE
                WHEN LOWER(TRIM(KPI)) = 'first aid' THEN 'No. of First Aid'
                WHEN LOWER(TRIM(KPI)) = 'near miss' THEN 'No. of Near Miss'
            ELSE NULL
            END AS safety_report,
            
            'No.' AS UOM,
            0 AS NORMS,
            ROUND(SUM(METRIC_VALUE), 2) AS ON_DATE
        FROM SEMANTIC_PROD.REFINERY_HSE_VIEW
        WHERE LOWER(TRIM(KPI)) in ('near miss') 
        AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
        GROUP BY 1,2,3
        """
        QUERY_2 = """
        SELECT 
            CASE
                WHEN LOWER(TRIM(KPI)) = 'first aid' THEN 'No. of First Aid'
                WHEN LOWER(TRIM(KPI)) = 'near miss' THEN 'No. of Near Miss'
            ELSE NULL
            END AS safety_report,

            'No.' AS UOM,
            0 AS NORMS,
            ROUND(SUM(METRIC_VALUE), 2) AS MTD
        FROM SEMANTIC_PROD.REFINERY_HSE_VIEW
        WHERE LOWER(TRIM(KPI)) in ('near miss') 
        AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
        GROUP BY 1,2,3
        """
        QUERY_3 = """
        SELECT 
            CASE
                WHEN LOWER(TRIM(KPI)) = 'first aid' THEN 'No. of First Aid'
                WHEN LOWER(TRIM(KPI)) = 'near miss' THEN 'No. of Near Miss'
            ELSE NULL
            END AS safety_report,

            'No.' AS UOM,
            0 AS NORMS,
            ROUND(SUM(METRIC_VALUE), 2) AS YTD
        FROM SEMANTIC_PROD.REFINERY_HSE_VIEW
        WHERE LOWER(TRIM(KPI)) in ('near miss') 
        AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
        GROUP BY 1,2,3
        """

    class NoOfFirstAid:
        """ SAFETY REPORT """
        QUERY_1 = """
        SELECT 
            CASE
                WHEN LOWER(TRIM(KPI)) = 'first aid' THEN 'No. of First Aid'
                WHEN LOWER(TRIM(KPI)) = 'near miss' THEN 'No. of Near Miss'
            ELSE NULL
            END AS safety_report,

            'No.' AS UOM,
            0 AS NORMS,
            ROUND(SUM(METRIC_VALUE), 2) AS ON_DATE
        FROM SEMANTIC_PROD.REFINERY_HSE_VIEW
        WHERE LOWER(TRIM(KPI)) in ('first aid') 
        AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
        GROUP BY 1,2,3
        """
        QUERY_2 = """
        SELECT 
            CASE
                WHEN LOWER(TRIM(KPI)) = 'first aid' THEN 'No. of First Aid'
                WHEN LOWER(TRIM(KPI)) = 'near miss' THEN 'No. of Near Miss'
            ELSE NULL
            END AS safety_report,

            'No.' AS UOM,
            0 AS NORMS,
            ROUND(SUM(METRIC_VALUE), 2) AS MTD
        FROM SEMANTIC_PROD.REFINERY_HSE_VIEW
        WHERE LOWER(TRIM(KPI)) in ('first aid') 
        AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
        GROUP BY 1,2,3
        """
        QUERY_3 = """
        SELECT 
            CASE
                WHEN LOWER(TRIM(KPI)) = 'first aid' THEN 'No. of First Aid'
                WHEN LOWER(TRIM(KPI)) = 'near miss' THEN 'No. of Near Miss'
            ELSE NULL
            END AS safety_report,

            'No.' AS UOM,
            0 AS NORMS,
            ROUND(SUM(METRIC_VALUE), 2) AS YTD
        FROM SEMANTIC_PROD.REFINERY_HSE_VIEW
        WHERE LOWER(TRIM(KPI)) in ('first aid') 
        AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
        GROUP BY 1,2,3
        """

    class Cir140KARectifierAvgCurrent:
        """ POWER AVAILABILITY """
        QUERY_1 = """
                SELECT 
                'Cir-1 40 KA Rectifier Avg. Current' AS power_availability,
                'KAmp' AS uom,
                AVG(PLAN_METRIC_VALUE) AS norms,
                SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(
                CASE 
                    WHEN ACTUAL_METRIC_VALUE <> 0 THEN 1 
                    ELSE NULL END), 0), 1) AS on_date
                    
                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) = '40ka_rectifier_current'
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1,2
                """
        QUERY_2 = """
                SELECT 
                'Cir-1 40 KA Rectifier Avg. Current' AS power_availability,
                'KAmp' AS uom,
                SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(
                CASE 
                    WHEN ACTUAL_METRIC_VALUE <> 0 THEN 1 
                    ELSE NULL END), 0), 1) AS mtd

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) = '40ka_rectifier_current'
                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1,2
                """
        QUERY_3 = """
                SELECT 
                'Cir-1 40 KA Rectifier Avg. Current' AS power_availability,
                'KAmp' AS uom,
                SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(
                CASE 
                    WHEN ACTUAL_METRIC_VALUE <> 0 THEN 1 
                    ELSE NULL END), 0), 1) AS ytd

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) = '40ka_rectifier_current'
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1,2
                """

    class Cir235KARectifierAvgCurrent:
        """ POWER AVAILABILITY """
        QUERY_1 = """
                SELECT 
                'Cir-2 35 KA Rectifier Avg. Current' AS power_availability,
                'KAmp' AS uom,
                AVG(PLAN_METRIC_VALUE) AS norms,
                SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(
                    CASE
                    WHEN ACTUAL_METRIC_VALUE <> 0 
                    THEN 1 ELSE NULL END), 0), 1) 
                    AS on_date
                    
                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) = '35ka_rectifier_current'
                    AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1,2
                """
        QUERY_2 = """
                SELECT 
                'Cir-2 35 KA Rectifier Avg. Current' AS power_availability,
                'KAmp' AS uom,
                SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(
                    CASE
                    WHEN ACTUAL_METRIC_VALUE <> 0 
                    THEN 1 ELSE NULL END), 0), 1) 
                    AS mtd

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) = '35ka_rectifier_current'
                    AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1,2
                """
        QUERY_3 = """
                SELECT 
                'Cir-2 35 KA Rectifier Avg. Current' AS power_availability,
                'KAmp' AS uom,
                SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(
                    CASE
                    WHEN ACTUAL_METRIC_VALUE <> 0 
                    THEN 1 ELSE NULL END), 0), 1) 
                    AS ytd

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) = '35ka_rectifier_current'
                    AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1,2
                """

    class TotalAvgCurrent:
        """ POWER AVAILABILITY """
        QUERY_1 = """
                SELECT 
                'Total Avg. Current' AS power_availability,
                'KAmp' AS uom,
                AVG(PLAN_METRIC_VALUE) AS norms,
                SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(
                CASE WHEN ACTUAL_METRIC_VALUE <> 0 THEN 1
                ELSE NULL END), 0), 1) AS on_date
                
                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) in 
                ('40ka_rectifier_current', '35ka_rectifier_current')
                
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1,2
                """
        QUERY_2 = """
                SELECT 
                'Total Avg. Current' AS power_availability,
                'KAmp' AS uom,
                SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(
                CASE WHEN ACTUAL_METRIC_VALUE <> 0 THEN 1
                ELSE NULL END), 0), 1) AS mtd

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) in 
                ('40ka_rectifier_current', '35ka_rectifier_current')

                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1,2
                """
        QUERY_3 = """
                SELECT 
                'Total Avg. Current' AS power_availability,
                'KAmp' AS uom,
                SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(
                CASE WHEN ACTUAL_METRIC_VALUE <> 0 THEN 1
                ELSE NULL END), 0), 1) AS ytd

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) in 
                ('40ka_rectifier_current', '35ka_rectifier_current')

                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1,2
                """

    class CurrentDensity:
        """ POWER AVAILABILITY """
        QUERY_1 = """
                SELECT 
                'Current Density' AS power_availability,
                'Amp / m2' AS uom,
                AVG(NUMO_PLAN) AS norms,
                AVG(NUMO_ACTUAL) AS on_date
                
                FROM SEMANTIC_PROD.CE_CD_TE_DETAILED_VIEW CCTDV2
                WHERE 
                LOWER(TRIM(CATEGORY)) = 'cd'
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                """
        QUERY_2 = """
                SELECT 
                'Current Density' AS power_availability,
                'Amp / m2' AS uom,
                AVG(NUMO_ACTUAL) AS mtd

                FROM SEMANTIC_PROD.CE_CD_TE_DETAILED_VIEW CCTDV2
                WHERE 
                LOWER(TRIM(CATEGORY)) = 'cd'
                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                """
        QUERY_3 = """
                SELECT 
                'Current Density' AS power_availability,
                'Amp / m2' AS uom,
                AVG(NUMO_ACTUAL) AS ytd

                FROM SEMANTIC_PROD.CE_CD_TE_DETAILED_VIEW CCTDV2
                WHERE 
                LOWER(TRIM(CATEGORY)) = 'cd'
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                """

    class EdgeStripConsumption:
        """ SPECIFIC CONSUMPTION """
        QUERY_1 = """
                SELECT 
                CONSUMABLES AS consumables,
                MAX(NORMS_UOM) AS uom,
                AVG(NORMS) AS norms,
                    CASE
                        WHEN CONSUMABLES in 
                        ('Glue_Consumption',
                        'Thiourea_Consumption',
                        'Wax_Consumption',
                        'H2SO4_Addition',
                        'HCl_Addition')
                        AND SUM(DEPOSIT) <> 0 THEN SUM(METRIC_QUANTITY) / SUM(DEPOSIT)
                        WHEN CONSUMABLES in 
                        ('Edge_Strip_Consumption', 'Plate_repairing') 
                        THEN SUM(METRIC_QUANTITY) ELSE 0
                    END AS on_date

                FROM SEMANTIC_PROD.CONSUMABLES_KPI_VIEW
                WHERE CONSUMABLES in 
                ('Edge_Strip_Consumption')

                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1
                """
        QUERY_2 = """
                SELECT 
                CONSUMABLES AS consumables,
                MAX(NORMS_UOM) AS uom,
                    CASE
                        WHEN CONSUMABLES in 
                        ('Glue_Consumption',
                        'Thiourea_Consumption',
                        'Wax_Consumption',
                        'H2SO4_Addition',
                        'HCl_Addition')
                        AND SUM(DEPOSIT) <> 0 THEN SUM(METRIC_QUANTITY) / SUM(DEPOSIT)
                        WHEN CONSUMABLES in 
                        ('Edge_Strip_Consumption', 'Plate_repairing') 
                        THEN SUM(METRIC_QUANTITY) ELSE 0
                    END AS mtd

                FROM SEMANTIC_PROD.CONSUMABLES_KPI_VIEW
                WHERE CONSUMABLES in 
                ('Edge_Strip_Consumption')

                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1
                """
        QUERY_3 = """
                SELECT 
                CONSUMABLES AS consumables,
                MAX(NORMS_UOM) AS uom,
                    CASE
                        WHEN CONSUMABLES in 
                        ('Glue_Consumption',
                        'Thiourea_Consumption',
                        'Wax_Consumption',
                        'H2SO4_Addition',
                        'HCl_Addition')
                        AND SUM(DEPOSIT) <> 0 THEN SUM(METRIC_QUANTITY) / SUM(DEPOSIT)
                        WHEN CONSUMABLES in 
                        ('Edge_Strip_Consumption', 'Plate_repairing') 
                        THEN SUM(METRIC_QUANTITY) ELSE 0
                    END AS ytd

                FROM SEMANTIC_PROD.CONSUMABLES_KPI_VIEW
                WHERE CONSUMABLES in 
                ('Edge_Strip_Consumption')

                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1
                """

    class PlateRepairing:
        """ SPECIFIC CONSUMPTION """
        QUERY_1 = """
                SELECT 
                CONSUMABLES AS consumables,
                MAX(NORMS_UOM) AS uom,
                AVG(NORMS) AS norms,
                    CASE
                        WHEN CONSUMABLES in 
                        ('Glue_Consumption',
                        'Thiourea_Consumption',
                        'Wax_Consumption',
                        'H2SO4_Addition',
                        'HCl_Addition')
                        AND SUM(DEPOSIT) <> 0 THEN SUM(METRIC_QUANTITY) / SUM(DEPOSIT)
                        WHEN CONSUMABLES in 
                        ('Edge_Strip_Consumption', 'Plate_repairing') 
                        THEN SUM(METRIC_QUANTITY) ELSE 0
                    END AS on_date

                FROM SEMANTIC_PROD.CONSUMABLES_KPI_VIEW
                WHERE CONSUMABLES in 
                ('Plate_repairing')

                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1
                """
        QUERY_2 = """
                SELECT 
                CONSUMABLES AS consumables,
                MAX(NORMS_UOM) AS uom,
                    CASE
                        WHEN CONSUMABLES in 
                        ('Glue_Consumption',
                        'Thiourea_Consumption',
                        'Wax_Consumption',
                        'H2SO4_Addition',
                        'HCl_Addition')
                        AND SUM(DEPOSIT) <> 0 THEN SUM(METRIC_QUANTITY) / SUM(DEPOSIT)
                        WHEN CONSUMABLES in 
                        ('Edge_Strip_Consumption', 'Plate_repairing') 
                        THEN SUM(METRIC_QUANTITY) ELSE 0
                    END AS mtd

                FROM SEMANTIC_PROD.CONSUMABLES_KPI_VIEW
                WHERE CONSUMABLES in 
                ('Plate_repairing')

                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1
                """
        QUERY_3 = """
                SELECT 
                CONSUMABLES AS consumables,
                MAX(NORMS_UOM) AS uom,
                    CASE
                        WHEN CONSUMABLES in 
                        ('Glue_Consumption',
                        'Thiourea_Consumption',
                        'Wax_Consumption',
                        'H2SO4_Addition',
                        'HCl_Addition')
                        AND SUM(DEPOSIT) <> 0 THEN SUM(METRIC_QUANTITY) / SUM(DEPOSIT)
                        WHEN CONSUMABLES in 
                        ('Edge_Strip_Consumption', 'Plate_repairing') 
                        THEN SUM(METRIC_QUANTITY) ELSE 0
                    END AS ytd

                FROM SEMANTIC_PROD.CONSUMABLES_KPI_VIEW
                WHERE CONSUMABLES in 
                ('Plate_repairing')

                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1
                """

    class WaxConsumption:
        """ SPECIFIC CONSUMPTION """
        QUERY_1 = """
                SELECT 
                CONSUMABLES AS consumables,
                MAX(NORMS_UOM) AS uom,
                AVG(NORMS) AS norms,
                    CASE
                        WHEN CONSUMABLES in 
                        ('Glue_Consumption',
                        'Thiourea_Consumption',
                        'Wax_Consumption',
                        'H2SO4_Addition',
                        'HCl_Addition')
                        AND SUM(DEPOSIT) <> 0 THEN SUM(METRIC_QUANTITY) / SUM(DEPOSIT)
                        WHEN CONSUMABLES in 
                        ('Edge_Strip_Consumption', 'Plate_repairing') 
                        THEN SUM(METRIC_QUANTITY) ELSE 0
                    END AS on_date

                FROM SEMANTIC_PROD.CONSUMABLES_KPI_VIEW
                WHERE CONSUMABLES in 
                ('Wax_Consumption')

                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1
                """
        QUERY_2 = """
                SELECT 
                CONSUMABLES AS consumables,
                MAX(NORMS_UOM) AS uom,
                    CASE
                        WHEN CONSUMABLES in 
                        ('Glue_Consumption',
                        'Thiourea_Consumption',
                        'Wax_Consumption',
                        'H2SO4_Addition',
                        'HCl_Addition')
                        AND SUM(DEPOSIT) <> 0 THEN SUM(METRIC_QUANTITY) / SUM(DEPOSIT)
                        WHEN CONSUMABLES in 
                        ('Edge_Strip_Consumption', 'Plate_repairing') 
                        THEN SUM(METRIC_QUANTITY) ELSE 0
                    END AS mtd

                FROM SEMANTIC_PROD.CONSUMABLES_KPI_VIEW
                WHERE CONSUMABLES in 
                ('Wax_Consumption')

                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1
                """
        QUERY_3 = """
                SELECT 
                CONSUMABLES AS consumables,
                MAX(NORMS_UOM) AS uom,
                    CASE
                        WHEN CONSUMABLES in 
                        ('Glue_Consumption',
                        'Thiourea_Consumption',
                        'Wax_Consumption',
                        'H2SO4_Addition',
                        'HCl_Addition')
                        AND SUM(DEPOSIT) <> 0 THEN SUM(METRIC_QUANTITY) / SUM(DEPOSIT)
                        WHEN CONSUMABLES in 
                        ('Edge_Strip_Consumption', 'Plate_repairing') 
                        THEN SUM(METRIC_QUANTITY) ELSE 0
                    END AS ytd

                FROM SEMANTIC_PROD.CONSUMABLES_KPI_VIEW
                WHERE CONSUMABLES in 
                ('Wax_Consumption')

                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1
                """

    class GlueConsumption:
        """ SPECIFIC CONSUMPTION """
        QUERY_1 = """
                SELECT 
                CONSUMABLES AS consumables,
                MAX(NORMS_UOM) AS uom,
                AVG(NORMS) AS norms,
                    CASE
                        WHEN CONSUMABLES in 
                        ('Glue_Consumption',
                        'Thiourea_Consumption',
                        'Wax_Consumption',
                        'H2SO4_Addition',
                        'HCl_Addition')
                        AND SUM(DEPOSIT) <> 0 THEN SUM(METRIC_QUANTITY) / SUM(DEPOSIT)
                        WHEN CONSUMABLES in 
                        ('Edge_Strip_Consumption', 'Plate_repairing') 
                        THEN SUM(METRIC_QUANTITY) ELSE 0
                    END AS on_date

                FROM SEMANTIC_PROD.CONSUMABLES_KPI_VIEW
                WHERE CONSUMABLES in 
                ('Glue_Consumption')

                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1
                """
        QUERY_2 = """
                SELECT 
                CONSUMABLES AS consumables,
                MAX(NORMS_UOM) AS uom,
                    CASE
                        WHEN CONSUMABLES in 
                        ('Glue_Consumption',
                        'Thiourea_Consumption',
                        'Wax_Consumption',
                        'H2SO4_Addition',
                        'HCl_Addition')
                        AND SUM(DEPOSIT) <> 0 THEN SUM(METRIC_QUANTITY) / SUM(DEPOSIT)
                        WHEN CONSUMABLES in 
                        ('Edge_Strip_Consumption', 'Plate_repairing') 
                        THEN SUM(METRIC_QUANTITY) ELSE 0
                    END AS mtd

                FROM SEMANTIC_PROD.CONSUMABLES_KPI_VIEW
                WHERE CONSUMABLES in 
                ('Glue_Consumption')

                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1
                """
        QUERY_3 = """
                SELECT 
                CONSUMABLES AS consumables,
                MAX(NORMS_UOM) AS uom,
                    CASE
                        WHEN CONSUMABLES in 
                        ('Glue_Consumption',
                        'Thiourea_Consumption',
                        'Wax_Consumption',
                        'H2SO4_Addition',
                        'HCl_Addition')
                        AND SUM(DEPOSIT) <> 0 THEN SUM(METRIC_QUANTITY) / SUM(DEPOSIT)
                        WHEN CONSUMABLES in 
                        ('Edge_Strip_Consumption', 'Plate_repairing') 
                        THEN SUM(METRIC_QUANTITY) ELSE 0
                    END AS ytd

                FROM SEMANTIC_PROD.CONSUMABLES_KPI_VIEW
                WHERE CONSUMABLES in 
                ('Glue_Consumption')

                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1
                """

    class ThioureaConsumption:
        """ SPECIFIC CONSUMPTION """
        QUERY_1 = """
                SELECT 
                CONSUMABLES AS consumables,
                MAX(NORMS_UOM) AS uom,
                AVG(NORMS) AS norms,
                    CASE
                        WHEN CONSUMABLES in 
                        ('Glue_Consumption',
                        'Thiourea_Consumption',
                        'Wax_Consumption',
                        'H2SO4_Addition',
                        'HCl_Addition')
                        AND SUM(DEPOSIT) <> 0 THEN SUM(METRIC_QUANTITY) / SUM(DEPOSIT)
                        WHEN CONSUMABLES in 
                        ('Edge_Strip_Consumption', 'Plate_repairing') 
                        THEN SUM(METRIC_QUANTITY) ELSE 0
                    END AS on_date

                FROM SEMANTIC_PROD.CONSUMABLES_KPI_VIEW
                WHERE CONSUMABLES in 
                ('Thiourea_Consumption')

                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1
                """
        QUERY_2 = """
                SELECT 
                CONSUMABLES AS consumables,
                MAX(NORMS_UOM) AS uom,
                    CASE
                        WHEN CONSUMABLES in 
                        ('Glue_Consumption',
                        'Thiourea_Consumption',
                        'Wax_Consumption',
                        'H2SO4_Addition',
                        'HCl_Addition')
                        AND SUM(DEPOSIT) <> 0 THEN SUM(METRIC_QUANTITY) / SUM(DEPOSIT)
                        WHEN CONSUMABLES in 
                        ('Edge_Strip_Consumption', 'Plate_repairing') 
                        THEN SUM(METRIC_QUANTITY) ELSE 0
                    END AS mtd

                FROM SEMANTIC_PROD.CONSUMABLES_KPI_VIEW
                WHERE CONSUMABLES in 
                ('Thiourea_Consumption')

                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1
                """
        QUERY_3 = """
                SELECT 
                CONSUMABLES AS consumables,
                MAX(NORMS_UOM) AS uom,
                    CASE
                        WHEN CONSUMABLES in 
                        ('Glue_Consumption',
                        'Thiourea_Consumption',
                        'Wax_Consumption',
                        'H2SO4_Addition',
                        'HCl_Addition')
                        AND SUM(DEPOSIT) <> 0 THEN SUM(METRIC_QUANTITY) / SUM(DEPOSIT)
                        WHEN CONSUMABLES in 
                        ('Edge_Strip_Consumption', 'Plate_repairing') 
                        THEN SUM(METRIC_QUANTITY) ELSE 0
                    END AS ytd

                FROM SEMANTIC_PROD.CONSUMABLES_KPI_VIEW
                WHERE CONSUMABLES in 
                ('Thiourea_Consumption')

                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1
                """

    class HClAddition:
        """ SPECIFIC CONSUMPTION """
        QUERY_1 = """
                SELECT 
                CONSUMABLES AS consumables,
                MAX(NORMS_UOM) AS uom,
                AVG(NORMS) AS norms,
                    CASE
                        WHEN CONSUMABLES in 
                        ('Glue_Consumption',
                        'Thiourea_Consumption',
                        'Wax_Consumption',
                        'H2SO4_Addition',
                        'HCl_Addition')
                        AND SUM(DEPOSIT) <> 0 THEN SUM(METRIC_QUANTITY) / SUM(DEPOSIT)
                        WHEN CONSUMABLES in 
                        ('Edge_Strip_Consumption', 'Plate_repairing') 
                        THEN SUM(METRIC_QUANTITY) ELSE 0
                    END AS on_date

                FROM SEMANTIC_PROD.CONSUMABLES_KPI_VIEW
                WHERE CONSUMABLES in 
                ('HCl_Addition')

                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1
                """
        QUERY_2 = """
                SELECT 
                CONSUMABLES AS consumables,
                MAX(NORMS_UOM) AS uom,
                    CASE
                        WHEN CONSUMABLES in 
                        ('Glue_Consumption',
                        'Thiourea_Consumption',
                        'Wax_Consumption',
                        'H2SO4_Addition',
                        'HCl_Addition')
                        AND SUM(DEPOSIT) <> 0 THEN SUM(METRIC_QUANTITY) / SUM(DEPOSIT)
                        WHEN CONSUMABLES in 
                        ('Edge_Strip_Consumption', 'Plate_repairing') 
                        THEN SUM(METRIC_QUANTITY) ELSE 0
                    END AS mtd

                FROM SEMANTIC_PROD.CONSUMABLES_KPI_VIEW
                WHERE CONSUMABLES in 
                ('HCl_Addition')

                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1
                """
        QUERY_3 = """
                SELECT 
                CONSUMABLES AS consumables,
                MAX(NORMS_UOM) AS uom,
                    CASE
                        WHEN CONSUMABLES in 
                        ('Glue_Consumption',
                        'Thiourea_Consumption',
                        'Wax_Consumption',
                        'H2SO4_Addition',
                        'HCl_Addition')
                        AND SUM(DEPOSIT) <> 0 THEN SUM(METRIC_QUANTITY) / SUM(DEPOSIT)
                        WHEN CONSUMABLES in 
                        ('Edge_Strip_Consumption', 'Plate_repairing') 
                        THEN SUM(METRIC_QUANTITY) ELSE 0
                    END AS ytd

                FROM SEMANTIC_PROD.CONSUMABLES_KPI_VIEW
                WHERE CONSUMABLES in 
                ('HCl_Addition')

                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1
                """

    class H2SO4Addition:
        """ SPECIFIC CONSUMPTION """
        QUERY_1 = """
                SELECT 
                CONSUMABLES AS consumables,
                MAX(NORMS_UOM) AS uom,
                AVG(NORMS) AS norms,
                    CASE
                        WHEN CONSUMABLES in 
                        ('Glue_Consumption',
                        'Thiourea_Consumption',
                        'Wax_Consumption',
                        'H2SO4_Addition',
                        'HCl_Addition')
                        AND SUM(DEPOSIT) <> 0 THEN SUM(METRIC_QUANTITY) / SUM(DEPOSIT)
                        WHEN CONSUMABLES in 
                        ('Edge_Strip_Consumption', 'Plate_repairing') 
                        THEN SUM(METRIC_QUANTITY) ELSE 0
                    END AS on_date

                FROM SEMANTIC_PROD.CONSUMABLES_KPI_VIEW
                WHERE CONSUMABLES in 
                ('H2SO4_Addition')

                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1
                """
        QUERY_2 = """
                SELECT 
                CONSUMABLES AS consumables,
                MAX(NORMS_UOM) AS uom,
                    CASE
                        WHEN CONSUMABLES in 
                        ('Glue_Consumption',
                        'Thiourea_Consumption',
                        'Wax_Consumption',
                        'H2SO4_Addition',
                        'HCl_Addition')
                        AND SUM(DEPOSIT) <> 0 THEN SUM(METRIC_QUANTITY) / SUM(DEPOSIT)
                        WHEN CONSUMABLES in 
                        ('Edge_Strip_Consumption', 'Plate_repairing') 
                        THEN SUM(METRIC_QUANTITY) ELSE 0
                    END AS mtd

                FROM SEMANTIC_PROD.CONSUMABLES_KPI_VIEW
                WHERE CONSUMABLES in 
                ('H2SO4_Addition')

                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1
                """
        QUERY_3 = """
                SELECT 
                CONSUMABLES AS consumables,
                MAX(NORMS_UOM) AS uom,
                    CASE
                        WHEN CONSUMABLES in 
                        ('Glue_Consumption',
                        'Thiourea_Consumption',
                        'Wax_Consumption',
                        'H2SO4_Addition',
                        'HCl_Addition')
                        AND SUM(DEPOSIT) <> 0 THEN SUM(METRIC_QUANTITY) / SUM(DEPOSIT)
                        WHEN CONSUMABLES in 
                        ('Edge_Strip_Consumption', 'Plate_repairing') 
                        THEN SUM(METRIC_QUANTITY) ELSE 0
                    END AS ytd

                FROM SEMANTIC_PROD.CONSUMABLES_KPI_VIEW
                WHERE CONSUMABLES in 
                ('H2SO4_Addition')

                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1
                """

    class CurrentEfficiency:
        """ Efficiency """
        QUERY_1 = """
                SELECT 
                    'Current Efficiency' AS efficiencies,
                    '%' AS uom,
                    AVG(NUMO_PLAN) AS norms,
                    (SUM(NUMO_ACTUAL) / NULLIF(SUM(DENO_ACTUAL), 0)) * 100 AS 
                    on_date

                    FROM SEMANTIC_PROD.CE_CD_TE_DETAILED_VIEW

                    WHERE LOWER(TRIM(CATEGORY)) = 'ce'
                    AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                    GROUP BY 1,2
                """
        QUERY_2 = """
                SELECT 
                    'Current Efficiency' AS efficiencies,
                    '%' AS uom,
                    (SUM(NUMO_ACTUAL) / NULLIF(SUM(DENO_ACTUAL), 0)) * 100 AS 
                    mtd

                    FROM SEMANTIC_PROD.CE_CD_TE_DETAILED_VIEW

                    WHERE LOWER(TRIM(CATEGORY)) = 'ce'
                    AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                    GROUP BY 1,2
                """
        QUERY_3 = """
                SELECT 
                    'Current Efficiency' AS efficiencies,
                    '%' AS uom,
                    (SUM(NUMO_ACTUAL) / NULLIF(SUM(DENO_ACTUAL), 0)) * 100 AS 
                    ytd

                    FROM SEMANTIC_PROD.CE_CD_TE_DETAILED_VIEW

                    WHERE LOWER(TRIM(CATEGORY)) = 'ce'
                    AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                    GROUP BY 1,2
                """

    class TimeEfficiency:
        """ Efficiency """
        QUERY_1 = """
                SELECT 'Time Efficiency' AS efficiencies,
                    '%' AS uom,
                    AVG(NUMO_PLAN) AS norms,
                    (SUM(NUMO_ACTUAL) / NULLIF(SUM(DENO_ACTUAL),0)) * 100 
                    AS on_date

                FROM SEMANTIC_PROD.CE_CD_TE_DETAILED_VIEW
                WHERE LOWER(TRIM(CATEGORY)) = 'te'
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1,2
                """
        QUERY_2 = """
                SELECT 'Time Efficiency' AS efficiencies,
                    '%' AS uom,
                    (SUM(NUMO_ACTUAL) / NULLIF(SUM(DENO_ACTUAL),0)) * 100 
                    AS mtd

                FROM SEMANTIC_PROD.CE_CD_TE_DETAILED_VIEW
                WHERE LOWER(TRIM(CATEGORY)) = 'te'
                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1,2
                """
        QUERY_3 = """
                SELECT 'Time Efficiency' AS efficiencies,
                    '%' AS uom,
                    (SUM(NUMO_ACTUAL) / NULLIF(SUM(DENO_ACTUAL),0)) * 100 
                    AS ytd

                FROM SEMANTIC_PROD.CE_CD_TE_DETAILED_VIEW
                WHERE LOWER(TRIM(CATEGORY)) = 'te'
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1,2
                """

    class E40KARectifierEfficiency:
        """ Efficiency """
        QUERY_1 = """
                SELECT 
                '40 KA Rectifier Efficiency' AS efficiencies,
                '%' AS uom,
                AVG(PLAN_METRIC_VALUE) AS norms,
                SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(
                CASE
                WHEN ACTUAL_METRIC_VALUE <> 0 THEN 1
                ELSE NULL END), 0), 1) AS on_date

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) = '40ka_rectifier_efficiency'
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1,2
                """
        QUERY_2 = """
                SELECT 
                '40 KA Rectifier Efficiency' AS efficiencies,
                '%' AS uom,
                SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(
                CASE
                WHEN ACTUAL_METRIC_VALUE <> 0 THEN 1
                ELSE NULL END), 0), 1) AS mtd

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) = '40ka_rectifier_efficiency'
                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1,2
                """
        QUERY_3 = """
                SELECT 
                '40 KA Rectifier Efficiency' AS efficiencies,
                '%' AS uom,
                SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(
                CASE
                WHEN ACTUAL_METRIC_VALUE <> 0 THEN 1
                ELSE NULL END), 0), 1) AS ytd

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) = '40ka_rectifier_efficiency'
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1,2
                """

    class E35KARectifierEfficiency:
        """ Efficiency """
        QUERY_1 = """
                SELECT 
                    '35 KA Rectifier Efficiency' AS efficiencies,
                    '%' AS uom,
                    AVG(PLAN_METRIC_VALUE) AS norms,
                    
                    SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(CASE
                    WHEN ACTUAL_METRIC_VALUE <> 0 THEN 1
                    ELSE NULL END), 0), 1) AS on_date

                    FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW

                    WHERE LOWER(TRIM(KPI)) = '35ka_rectifier_efficiency'

                    AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                    GROUP BY 1,2
                """
        QUERY_2 = """
                SELECT 
                    '35 KA Rectifier Efficiency' AS efficiencies,
                    '%' AS uom,
                    
                    SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(CASE
                    WHEN ACTUAL_METRIC_VALUE <> 0 THEN 1
                    ELSE NULL END), 0), 1) AS mtd

                    FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW

                    WHERE LOWER(TRIM(KPI)) = '35ka_rectifier_efficiency'

                    AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                    GROUP BY 1,2
                    """
        QUERY_3 = """
                SELECT 
                    '35 KA Rectifier Efficiency' AS efficiencies,
                    '%' AS uom,
                    SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(CASE
                    WHEN ACTUAL_METRIC_VALUE <> 0 THEN 1
                    ELSE NULL END), 0), 1) AS ytd

                    FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW

                    WHERE LOWER(TRIM(KPI)) = '35ka_rectifier_efficiency'

                    AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                    GROUP BY 1,2
                """

    class SpentAnodeGenerationRate:
        """ Efficiency """
        QUERY_1 = """
                SELECT 
                'Spent Anode Generation Rate' efficiencies,
                '%' AS uom,
                MAX(NORMS) AS norms,
                MAX(METRIC_VALUE) AS on_date
            
                FROM
                (SELECT KPI,
                CASE
                    WHEN LOWER(TRIM(KPI)) = 'spent_anode_gen_actual' 
                    THEN (SUM(METRIC_NUMERATOR) / NULLIF(SUM(METRIC_DENOMINATOR), 0))
                     * 100
                ELSE NULL
                END AS METRIC_VALUE,
                
                CASE
                    WHEN LOWER(TRIM(KPI)) = 'spent_anode_gen_plan' 
                    THEN AVG(METRIC_NUMERATOR)
                ELSE NULL
                END AS NORMS
            
                FROM SEMANTIC_PROD.REFINERY_SPENT_ANODE_GEN_RATE
            
                WHERE LOWER(TRIM(KPI)) in 
                ('spent_anode_gen_actual', 'spent_anode_gen_plan')
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1)SPENT
                GROUP BY 1,2
                """
        QUERY_2 = """
                    SELECT 
                    'Spent Anode Generation Rate' efficiencies,
                    '%' AS uom,
                    MAX(METRIC_VALUE) AS mtd

                    FROM
                    (SELECT KPI,
                    CASE
                        WHEN LOWER(TRIM(KPI)) = 'spent_anode_gen_actual' 
                        THEN (SUM(METRIC_NUMERATOR) / NULLIF(SUM(METRIC_DENOMINATOR), 0))
                         * 100
                    ELSE NULL
                    END AS METRIC_VALUE,

                    CASE
                        WHEN LOWER(TRIM(KPI)) = 'spent_anode_gen_plan' 
                        THEN AVG(METRIC_NUMERATOR)
                    ELSE NULL
                    END AS NORMS

                    FROM SEMANTIC_PROD.REFINERY_SPENT_ANODE_GEN_RATE

                    WHERE LOWER(TRIM(KPI)) in 
                    ('spent_anode_gen_actual', 'spent_anode_gen_plan')
                    AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                    GROUP BY 1)SPENT
                    GROUP BY 1,2
                    """
        QUERY_3 = """
                SELECT 
                'Spent Anode Generation Rate' efficiencies,
                '%' AS uom,
                MAX(METRIC_VALUE) AS ytd

                FROM
                (SELECT KPI,
                CASE
                    WHEN LOWER(TRIM(KPI)) = 'spent_anode_gen_actual' 
                    THEN (SUM(METRIC_NUMERATOR) / NULLIF(SUM(METRIC_DENOMINATOR), 0))
                     * 100
                ELSE NULL
                END AS METRIC_VALUE,

                CASE
                    WHEN LOWER(TRIM(KPI)) = 'spent_anode_gen_plan' 
                    THEN AVG(METRIC_NUMERATOR)
                ELSE NULL
                END AS NORMS

                FROM SEMANTIC_PROD.REFINERY_SPENT_ANODE_GEN_RATE

                WHERE LOWER(TRIM(KPI)) in 
                ('spent_anode_gen_actual', 'spent_anode_gen_plan')
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1)SPENT
                GROUP BY 1,2
                """

    class Cathode:
        """ FG INVENTORY """
        QUERY_1 = """
                SELECT 
                PRODUCT as fg_inventory,
                SUM(CURRENT_STOCK) AS on_date
                
                FROM SEMANTIC_PROD.INVENTORY_FG_RM_WIP_VIEW
                
                WHERE LOWER(CATEGORY_OF_GOODS) like ('fg%')
                AND LOWER(PRODUCT) in 
                ('cathode')
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1
        """
        QUERY_2 = """
                SELECT 
                PRODUCT as fg_inventory,
                SUM(CURRENT_STOCK) AS mtd

                FROM SEMANTIC_PROD.INVENTORY_FG_RM_WIP_VIEW

                WHERE LOWER(CATEGORY_OF_GOODS) like ('fg%')
                AND LOWER(PRODUCT) in 
                ('cathode')
                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1
                """
        QUERY_3 = """
                SELECT 
                PRODUCT as fg_inventory,
                SUM(CURRENT_STOCK) AS ytd

                FROM SEMANTIC_PROD.INVENTORY_FG_RM_WIP_VIEW

                WHERE LOWER(CATEGORY_OF_GOODS) like ('fg%')
                AND LOWER(PRODUCT) in 
                ('cathode')
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1
                """

    class NiSO4:
        """ FG INVENTORY """
        QUERY_1 = """
                SELECT 
                PRODUCT as fg_inventory,
                SUM(CURRENT_STOCK) AS on_date

                FROM SEMANTIC_PROD.INVENTORY_FG_RM_WIP_VIEW

                WHERE LOWER(CATEGORY_OF_GOODS) like ('fg%')
                AND LOWER(PRODUCT) in 
                ('niso4')
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1
        """
        QUERY_2 = """
                SELECT 
                PRODUCT as fg_inventory,
                SUM(CURRENT_STOCK) AS mtd

                FROM SEMANTIC_PROD.INVENTORY_FG_RM_WIP_VIEW

                WHERE LOWER(CATEGORY_OF_GOODS) like ('fg%')
                AND LOWER(PRODUCT) in 
                ('niso4')
                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1
                """
        QUERY_3 = """
                SELECT 
                PRODUCT as fg_inventory,
                SUM(CURRENT_STOCK) AS ytd

                FROM SEMANTIC_PROD.INVENTORY_FG_RM_WIP_VIEW

                WHERE LOWER(CATEGORY_OF_GOODS) like ('fg%')
                AND LOWER(PRODUCT) in 
                ('niso4')
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1
                """

    class RawSlime:
        """ FG INVENTORY """
        QUERY_1 = """
                SELECT 
                PRODUCT as fg_inventory,
                SUM(CURRENT_STOCK) AS on_date

                FROM SEMANTIC_PROD.INVENTORY_FG_RM_WIP_VIEW

                WHERE LOWER(CATEGORY_OF_GOODS) like ('fg%')
                AND LOWER(PRODUCT) in 
                ('slime')
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1
        """
        QUERY_2 = """
                SELECT 
                PRODUCT as fg_inventory,
                SUM(CURRENT_STOCK) AS mtd

                FROM SEMANTIC_PROD.INVENTORY_FG_RM_WIP_VIEW

                WHERE LOWER(CATEGORY_OF_GOODS) like ('fg%')
                AND LOWER(PRODUCT) in 
                ('slime')
                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1
                """
        QUERY_3 = """
                SELECT 
                PRODUCT as fg_inventory,
                SUM(CURRENT_STOCK) AS ytd

                FROM SEMANTIC_PROD.INVENTORY_FG_RM_WIP_VIEW

                WHERE LOWER(CATEGORY_OF_GOODS) like ('fg%')
                AND LOWER(PRODUCT) in 
                ('slime')
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1
                """

    class CuSo4:
        """ FG INVENTORY """
        QUERY_1 = """
                SELECT 
                PRODUCT as fg_inventory,
                SUM(CURRENT_STOCK) AS on_date

                FROM SEMANTIC_PROD.INVENTORY_FG_RM_WIP_VIEW

                WHERE LOWER(CATEGORY_OF_GOODS) like ('fg%')
                AND LOWER(PRODUCT) in 
                ('cuso4')
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1
        """
        QUERY_2 = """
                SELECT 
                PRODUCT as fg_inventory,
                SUM(CURRENT_STOCK) AS mtd

                FROM SEMANTIC_PROD.INVENTORY_FG_RM_WIP_VIEW

                WHERE LOWER(CATEGORY_OF_GOODS) like ('fg%')
                AND LOWER(PRODUCT) in 
                ('cuso4')
                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1
                """
        QUERY_3 = """
                SELECT 
                PRODUCT as fg_inventory,
                SUM(CURRENT_STOCK) AS ytd

                FROM SEMANTIC_PROD.INVENTORY_FG_RM_WIP_VIEW

                WHERE LOWER(CATEGORY_OF_GOODS) like ('fg%')
                AND LOWER(PRODUCT) in 
                ('cuso4')
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1
                """

    class ElectrolyteComposition:
        """ ELECTROLYTE COMPOSITION """
        QUERY_1 = """
                SELECT 
                ELECTROLYTE_COMPOSITION AS electrolyte_composition,
                MAX(UOM) AS uom,
                MAX(NORMS) AS norms,
                TO_CHAR(TO_DATE('{day_start_date}', 'YYYY-MM-DD'), 'DD-Mon') as date,
                AVG(CIR_1) AS cir_1,
                AVG(CIR_2) AS cir_2


                FROM SEMANTIC_PROD.ELECTROLYTE_COMPOSITION_VIEW ECV
                WHERE DATE = '{day_start_date}'
                GROUP BY 1
                """
