import copy

import pandas as pd
from datetime import datetime
from scripts.constants import ReportType, CommonConstants
from scripts.template.sterlite_report_template import SterliteRefineryTemplate
from scripts.core.logging.application_logging import logger
from scripts.core.exception.app_exceptions import GeneralException
from scripts.core.utilities.postgresql_db_utils import PostgresDBUtility


class CustomReportHandler:
    def __init__(self):
        self.postgres_db_obj = PostgresDBUtility()

    def create_custom_date_filter(self, input_json):
        """
        This method convert start date and end date to a date range.
        :param input_json:
        :return:
        """
        date_range_list = []
        # Fetching Start date
        start_date = datetime.strptime(
            input_json[CommonConstants.PROPERTY][CommonConstants.START_DATE],
            CommonConstants.DATE_TIME_FORMAT
        )
        # Fetching End date
        end_date = datetime.strptime(
            input_json[CommonConstants.PROPERTY][CommonConstants.END_DATE],
            CommonConstants.DATE_TIME_FORMAT
        )

        logger.info(f"Creating list of dates starting from {start_date} to {end_date}")
        # Generating a date range
        date_list = pd.date_range(start_date, end_date, freq=CommonConstants.FREQUENCY)

        # Iterating and creating where clause filters
        for each_dates in date_list.strftime(
                CommonConstants.DATE_TIME_FORMAT).to_list():

            # To get the each_dates - financial year
            financial_year = None
            date_obj = datetime.strptime(each_dates, CommonConstants.DATE_TIME_FORMAT)
            if date_obj.month >= 4:
                financial_year = str(date_obj.year)
            elif date_obj.month < 4:
                financial_year = str(date_obj.year - 1)

            date_range_list.append(
                dict(
                    day_start_date=each_dates,
                    day_end_date=each_dates,
                    month_start_date=each_dates[:-2] + "01",
                    month_end_date=each_dates,
                    year_start_date=financial_year + "-04-01",
                    year_end_date=each_dates,
                )
            )
        return date_range_list

    def get_queries_from_db(self, input_json, date_filter):
        """
        :param input_json:
        :param date_filter:
        :return:
        """
        for each_blocks in input_json:
            # Iterating each blocks for fetching query

            if input_json[each_blocks][CommonConstants.QUERY]:
                for each_kpi in input_json[each_blocks][CommonConstants.QUERY]:
                    temp_data_dict = dict()
                    append_flag = False

                    # Iterating each query for each KPI
                    if input_json[each_blocks][CommonConstants.QUERY][each_kpi]:
                        for each_query in \
                                input_json[each_blocks][CommonConstants.QUERY][
                                    each_kpi]:
                            query = each_query. \
                                format(
                                day_start_date=date_filter[
                                    CommonConstants.DAY_START_DATE],
                                day_end_date=date_filter[CommonConstants.DAY_END_DATE],
                                month_start_date=date_filter[
                                    CommonConstants.MONTH_START_DATE],
                                month_end_date=date_filter[
                                    CommonConstants.MONTH_END_DATE],
                                year_start_date=date_filter[
                                    CommonConstants.YEAR_START_DATE],
                                year_end_date=date_filter[
                                    CommonConstants.YEAR_END_DATE])

                            response = self.postgres_db_obj.fetch_data(query=query)
                            if response:
                                if len(response) <= 1:
                                    temp_data_dict.update(dict(response[0]))
                                    append_flag = True
                                else:
                                    for every_data in response:
                                        input_json[each_blocks][CommonConstants.DATA]. \
                                            append(dict(every_data))

                            if not temp_data_dict and append_flag:
                                # Creating null values if no data
                                for each_columns in input_json[each_blocks][
                                    CommonConstants.DATA_COLUMN]:
                                    temp_data_dict.update({each_columns: None})

                        if append_flag:
                            input_json[each_blocks][CommonConstants.DATA].append(
                                temp_data_dict)
            else:
                temp_data_dict = dict()
                for each_columns in input_json[each_blocks][
                    CommonConstants.DATA_COLUMN]:
                    temp_data_dict.update(
                        {each_columns: None}
                    )
                input_json[each_blocks][CommonConstants.DATA].append(temp_data_dict)
        return input_json

    def write_dataframe_to_excel(self, input_json, sheet_name):
        """
        :param input_json:
        :param sheet_name:
        :return:
        """
        dataframe_list = []
        print(input_json)
        print(sheet_name)
        print(len(input_json))

        if len(input_json) >= 2:
            print("2 block")
            # concatenated_df = pd.concat(
            # [dataframes_to_concat[i], dataframes_to_concat[i + 1]],
            for each_blocks in input_json:
                print(input_json[each_blocks])

        else:
            print("1 block")
        print()
        # for each_blocks in input_json:
        #     print(each_blocks)
        # dataframe = pd.DataFrame(data=input_json[each_blocks]["data"])
        # dataframe.columns = input_json[each_blocks]["columns"]
        # dataframe_list.append(dataframe)

    def custom_report_handler(self, input_json):
        """
        :param input_json:
        :return:
        """
        status = False
        message = "Error generating a message"
        data = CommonConstants.DATA
        try:
            # if str(input_json.job_type).lower() == ReportType.REFINERY_REPORT:
            if str(input_json["job_type"]).lower() == ReportType.REFINERY_REPORT:

                # Getting custom date range using start date and end date
                date_filter = self.create_custom_date_filter(input_json=input_json)

                # with pd.ExcelWriter(path="testing.xlsx", engine="openpyxl") as excel:
                #     pass

                for each_date_range in date_filter:

                    report_template = copy.deepcopy(
                        SterliteRefineryTemplate.REPORT_TEMPLATE
                    )
                    # Iterating over sterlite json file
                    for each_blocks in report_template:
                        # Getting the data from queries
                        each_blocks = self.get_queries_from_db(
                            input_json=each_blocks, date_filter=each_date_range
                        )
                        print("=" * 60)
                        print(each_blocks)
                        self.write_dataframe_to_excel(
                            input_json=each_blocks,
                            sheet_name=each_date_range[CommonConstants.DAY_START_DATE]
                        )
                        break

                    print("@" * 100)
                    print(report_template)
                    break

        except GeneralException as err:
            logger.error(f"Exception in custom_report_handler: {err}")
        return status, message, data
