class SterliteRefineryQuery:
    """
    Refinery report queries
    """

    class CathodeProductionRevised:
        """ CATHODE PRODUCTION REVISED """
        QUERY_1 = """
        SELECT 
        METRIC_VALUE as cathode_production_revised,
        uom

        FROM
        (SELECT DD.DATE_DT AS date,
        CASE
        WHEN LOWER(TRIM(AREA_ICS_HEAD_REFINERY_DATA_SELECT)) = 
        'cathode production plan' THEN 'Cathode Production Revised'
        WHEN LOWER(TRIM(AREA_ICS_HEAD_REFINERY_DATA_SELECT)) = 
        'deposit' THEN 'Deposit Revised'
        ELSE NULL
        END AS KPI,
        'MT' AS UOM,
        CASE
        WHEN LOWER(TRIM(AREA_ICS_HEAD_REFINERY_DATA_SELECT)) = 
        'cathode production plan' THEN 
        COALESCE(AREA_ICS_HEAD_REFINERY_DATA_VALUE::double precision,

        0)
        WHEN LOWER(TRIM(AREA_ICS_HEAD_REFINERY_DATA_SELECT)) = 
        'deposit' THEN COALESCE(AREA_ICS_HEAD_REFINERY_DATA_VALUE::double precision,

        0)
        ELSE NULL
        END AS METRIC_VALUE
        FROM SEMANTIC_PROD.AREA_ICS_HEAD_REFINERY_DATA AIHRD
        LEFT JOIN
        (SELECT DIM_DATE.DATE_DT,
        DIM_DATE.MONTH_OF_YR_NUM AS MNTH,
        DIM_DATE.YR_NAME AS YR
        FROM SEMANTIC_PROD.DIM_DATE) DD ON DATE_PART('month',

        DATE(AIHRD.DATE)) = DD.MNTH
        AND DATE_PART('year',

        DATE(AIHRD.DATE)) = DD.YR
        WHERE LOWER(TRIM(AIHRD.AREA_ICS_HEAD_REFINERY_DATA_SELECT)) 
        in 
         (
        'cathode production plan'
         )
        AND DATE_PART('day',

        DATE(AIHRD.DATE)) = 1 )TB

        WHERE DATE='{day_start_date}'
        """

    class DepositRevised:
        """ DEPOSIT REVISED """
        QUERY_1 = """
                SELECT 
                METRIC_VALUE as deposit_revised

                FROM
                (SELECT DD.DATE_DT AS date,
                CASE
                WHEN LOWER(TRIM(AREA_ICS_HEAD_REFINERY_DATA_SELECT)) = 
                'cathode production plan' THEN 'Cathode Production Revised'
                WHEN LOWER(TRIM(AREA_ICS_HEAD_REFINERY_DATA_SELECT)) = 
                'deposit' THEN 'Deposit Revised'
                ELSE NULL
                END AS KPI,
                'MT' AS UOM,
                CASE
                WHEN LOWER(TRIM(AREA_ICS_HEAD_REFINERY_DATA_SELECT)) = 
                'cathode production plan' THEN 
                COALESCE(AREA_ICS_HEAD_REFINERY_DATA_VALUE::double precision,

                0)
                WHEN LOWER(TRIM(AREA_ICS_HEAD_REFINERY_DATA_SELECT)) = 
                'deposit' THEN COALESCE(AREA_ICS_HEAD_REFINERY_DATA_VALUE::double precision,

                0)
                ELSE NULL
                END AS METRIC_VALUE
                FROM SEMANTIC_PROD.AREA_ICS_HEAD_REFINERY_DATA AIHRD
                LEFT JOIN
                (SELECT DIM_DATE.DATE_DT,
                DIM_DATE.MONTH_OF_YR_NUM AS MNTH,
                DIM_DATE.YR_NAME AS YR
                FROM SEMANTIC_PROD.DIM_DATE) DD ON DATE_PART('month',

                DATE(AIHRD.DATE)) = DD.MNTH
                AND DATE_PART('year',

                DATE(AIHRD.DATE)) = DD.YR
                WHERE LOWER(TRIM(AIHRD.AREA_ICS_HEAD_REFINERY_DATA_SELECT)) 
                in 
                 (
                'deposit'
                 )
                AND DATE_PART('day',

                DATE(AIHRD.DATE)) = 1 )TB

                WHERE DATE='{day_start_date}'
                """

    class AnodeAvailability:
        """ ANODE AVAILABILITY """
        QUERY_1 = """
        SELECT 
        'Cell House Anode Availability' AS ANODE_AVAILABILITY,
        '%' AS UOM,
        ROUND(AVG(ANODE.AA_PLANNED)::NUMERIC, 2) AS NORMS,
        ROUND(((SUM(ANODE.NUMERATOR) / NULLIF(SUM(DENOMINATOR), 0)) * 100)::NUMERIC, 2)
         AS ON_DATE

        FROM
            (SELECT ACTUAL.AA_NUMO AS NUMERATOR,
                    ACTUAL.AA_DENO AS DENOMINATOR,
                    PLAN.AA_PLANNED,
                    COALESCE(ACTUAL.DATE,

                        PLAN.DATE) AS date
                FROM SEMANTIC_PROD.REFINERY_ANODE_AVAILABILITY_ACTUAL_VIEW ACTUAL
                FULL JOIN
                    (SELECT DD_1.DATE_DT AS date,
                            M_PLAN.AA_PLANNED
                        FROM
                            (SELECT DATE(date) AS POSTING_DATE,
                                    ANODE_AVAILABILITY_VALUE::numeric AS AA_PLANNED
                                FROM SEMANTIC_DEV.ANODE_AVAILABILITY
                                WHERE 
                             LOWER(TRIM(ANODE_AVAILABILITY_SELECT)) = 
                             'anode availability'
                                    AND DATE_PART('day',date) = 1
                                GROUP BY 1,
                                    2)M_PLAN
                        LEFT JOIN
                            (SELECT DIM_DATE.DATE_DT,
                                    DIM_DATE.MONTH_OF_YR_NUM AS MNTH,
                                    DIM_DATE.YR_NAME AS YR
                                FROM SEMANTIC_PROD.DIM_DATE) DD_1 ON 
                     DD_1.MNTH = DATE_PART('month', M_PLAN.POSTING_DATE)
                        AND DD_1.YR = DATE_PART('year', M_PLAN.POSTING_DATE))PLAN 
             ON ACTUAL.DATE = PLAN.DATE)ANODE

        WHERE 
        DATE BETWEEN '{day_start_date}' AND '{day_end_date}'

        GROUP BY
        1,2;
        """
        QUERY_2 = """
                SELECT 
                'Cell House Anode Availability' AS ANODE_AVAILABILITY,
                '%' AS UOM,
                ROUND(((SUM(ANODE.NUMERATOR) / NULLIF(SUM(DENOMINATOR), 0)) * 100
                )::NUMERIC, 2) AS MTD

                FROM
                (SELECT ACTUAL.AA_NUMO AS NUMERATOR,
                        ACTUAL.AA_DENO AS DENOMINATOR,
                        PLAN.AA_PLANNED,
                        COALESCE(ACTUAL.DATE,

                            PLAN.DATE) AS date
                    FROM SEMANTIC_PROD.REFINERY_ANODE_AVAILABILITY_ACTUAL_VIEW ACTUAL
                    FULL JOIN
                        (SELECT DD_1.DATE_DT AS date,
                                M_PLAN.AA_PLANNED
                            FROM
                                (SELECT DATE(date) AS POSTING_DATE,
                                        ANODE_AVAILABILITY_VALUE::numeric AS AA_PLANNED
                                    FROM SEMANTIC_DEV.ANODE_AVAILABILITY
                                    WHERE 
                                 LOWER(TRIM(ANODE_AVAILABILITY_SELECT)) = 
                                 'anode availability'
                                        AND DATE_PART('day',date) = 1
                                    GROUP BY 1,
                                        2)M_PLAN
                            LEFT JOIN
                                (SELECT DIM_DATE.DATE_DT,
                                        DIM_DATE.MONTH_OF_YR_NUM AS MNTH,
                                        DIM_DATE.YR_NAME AS YR
                                    FROM SEMANTIC_PROD.DIM_DATE) DD_1 ON 
                         DD_1.MNTH = DATE_PART('month', M_PLAN.POSTING_DATE)
                            AND DD_1.YR = DATE_PART('year', M_PLAN.POSTING_DATE))PLAN 
                     ON ACTUAL.DATE = PLAN.DATE)ANODE

                WHERE 
                DATE BETWEEN '{month_start_date}' AND '{month_end_date}'

                GROUP BY
                1,2;
                """
        QUERY_3 = """
                SELECT 
                'Cell House Anode Availability' AS ANODE_AVAILABILITY,
                '%' AS UOM,
                ROUND(((SUM(ANODE.NUMERATOR) / NULLIF(SUM(DENOMINATOR), 0)) * 
                100)::NUMERIC, 2) AS YTD

                FROM
                (SELECT ACTUAL.AA_NUMO AS NUMERATOR,
                        ACTUAL.AA_DENO AS DENOMINATOR,
                        PLAN.AA_PLANNED,
                        COALESCE(ACTUAL.DATE,

                            PLAN.DATE) AS date
                    FROM SEMANTIC_PROD.REFINERY_ANODE_AVAILABILITY_ACTUAL_VIEW ACTUAL
                    FULL JOIN
                        (SELECT DD_1.DATE_DT AS date,
                                M_PLAN.AA_PLANNED
                            FROM
                                (SELECT DATE(date) AS POSTING_DATE,
                                        ANODE_AVAILABILITY_VALUE::numeric AS AA_PLANNED
                                    FROM SEMANTIC_DEV.ANODE_AVAILABILITY
                                    WHERE 
                                 LOWER(TRIM(ANODE_AVAILABILITY_SELECT)) = 
                                 'anode availability'
                                        AND DATE_PART('day',date) = 1
                                    GROUP BY 1,
                                        2)M_PLAN
                            LEFT JOIN
                                (SELECT DIM_DATE.DATE_DT,
                                        DIM_DATE.MONTH_OF_YR_NUM AS MNTH,
                                        DIM_DATE.YR_NAME AS YR
                                    FROM SEMANTIC_PROD.DIM_DATE) DD_1 ON 
                         DD_1.MNTH = DATE_PART('month', M_PLAN.POSTING_DATE)
                            AND DD_1.YR = DATE_PART('year', M_PLAN.POSTING_DATE))PLAN 
                 ON ACTUAL.DATE = PLAN.DATE)ANODE

                WHERE 
                DATE BETWEEN '{year_start_date}' AND '{year_end_date}'

                GROUP BY
                1,2;
                """

    class DOCellsInOperation:
        """ ANODE AVAILABILITY """
        QUERY_1 = """
        SELECT 
        'DO Cells In Operation' AS ANODE_AVAILABILITY,
        'No.' AS UOM, 
        MAX(CASE 
            WHEN LOWER(TRIM(KPI)) = 'liberator_cells_plan' THEN METRIC_VALUE END) 
            AS NORMS,
        MAX(CASE 
            WHEN LOWER(TRIM(KPI)) = 'liberator_cells_actual' THEN METRIC_VALUE END) 
            AS ON_DATE,
        MAX(CASE 
            WHEN LOWER(TRIM(KPI)) = 'liberator_cells_actual' THEN METRIC_VALUE END) 
            AS MTD,
        MAX(CASE 
            WHEN LOWER(TRIM(KPI)) = 'liberator_cells_actual' THEN METRIC_VALUE END) 
            AS YTD

        FROM 
        SEMANTIC_PROD.BANKS_CELLS_LIBERATORS_VIEW

        GROUP BY 
        1,2
        """

    class TotalCellsInOperation:
        """ ANODE AVAILABILITY """
        QUERY_1 = """
        SELECT 
        'Total Cells In Operation' AS ANODE_AVAILABILITY,
        'No.' AS UOM,
        ROUND(MAX(NORMS)::NUMERIC, 2) AS NORMS,
        ROUND(MAX(METRIC_VALUE)::NUMERIC, 2) AS ON_DATE

        FROM
            (SELECT KPI,
                    CASE
                        WHEN LOWER(TRIM(KPI)) = 'operational_cells_plan' 
                        THEN ROUND(AVG(METRIC_VALUE))
                        ELSE NULL
                    END AS NORMS,
                    CASE
                        WHEN LOWER(TRIM(KPI)) = 'operational_cells_actual' 
                        THEN ROUND(AVG(METRIC_VALUE))
                        ELSE NULL
                    END AS METRIC_VALUE
                FROM SEMANTIC_PROD.REFINERY_OPERATIONAL_CELLS_VIEW
                WHERE LOWER(TRIM(KPI)) in 
                ('operational_cells_actual', 'operational_cells_plan')
                    AND (date BETWEEN '{day_start_date}' AND '{day_end_date}')
                GROUP BY 1)OP_CELLS
        GROUP BY 1,2
        """
        QUERY_2 = """
        SELECT 
        'Total Cells In Operation' AS ANODE_AVAILABILITY,
        'No.' AS UOM,
        ROUND(MAX(METRIC_VALUE)::NUMERIC, 2) AS MTD

        FROM
            (SELECT KPI,
                    CASE
                        WHEN LOWER(TRIM(KPI)) = 'operational_cells_plan' THEN ROUND(AVG(METRIC_VALUE))
                        ELSE NULL
                    END AS NORMS,
                    CASE
                        WHEN LOWER(TRIM(KPI)) = 'operational_cells_actual' THEN ROUND(AVG(METRIC_VALUE))
                        ELSE NULL
                    END AS METRIC_VALUE
                FROM SEMANTIC_PROD.REFINERY_OPERATIONAL_CELLS_VIEW
                WHERE LOWER(TRIM(KPI)) in ('operational_cells_actual', 'operational_cells_plan')
                    AND (date BETWEEN '{month_start_date}' AND '{month_end_date}')
                GROUP BY 1)OP_CELLS
        GROUP BY 1,2
        """
        QUERY_3 = """
                SELECT 
                'Total Cells In Operation' AS ANODE_AVAILABILITY,
                'No.' AS UOM,
                ROUND(MAX(METRIC_VALUE)::NUMERIC, 2) AS YTD

                FROM
                (SELECT KPI,
                        CASE
                            WHEN LOWER(TRIM(KPI)) = 'operational_cells_plan' 
                            THEN ROUND(AVG(METRIC_VALUE))
                            ELSE NULL
                        END AS NORMS,
                        CASE
                            WHEN LOWER(TRIM(KPI)) = 'operational_cells_actual' 
                            THEN ROUND(AVG(METRIC_VALUE))
                            ELSE NULL
                        END AS METRIC_VALUE
                    FROM SEMANTIC_PROD.REFINERY_OPERATIONAL_CELLS_VIEW
                    WHERE LOWER(TRIM(KPI)) in 
                    ('operational_cells_actual', 'operational_cells_plan')
                        AND (date BETWEEN '{year_start_date}' AND '{year_end_date}')
                    GROUP BY 1)OP_CELLS
                GROUP BY 1,2
                """

    class NoOfNearMiss:
        """ SAFETY REPORT """
        QUERY_1 = """
        SELECT 
            CASE
                WHEN LOWER(TRIM(KPI)) = 'first aid' THEN 'No. of First Aid'
                WHEN LOWER(TRIM(KPI)) = 'near miss' THEN 'No. of Near Miss'
            ELSE NULL
            END AS safety_report,

            'No.' AS UOM,
            0 AS NORMS,
            ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) AS ON_DATE
        FROM SEMANTIC_PROD.REFINERY_HSE_VIEW
        WHERE LOWER(TRIM(KPI)) in ('near miss') 
        AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
        GROUP BY 1,2,3
        """
        QUERY_2 = """
        SELECT 
            CASE
                WHEN LOWER(TRIM(KPI)) = 'first aid' THEN 'No. of First Aid'
                WHEN LOWER(TRIM(KPI)) = 'near miss' THEN 'No. of Near Miss'
            ELSE NULL
            END AS safety_report,

            'No.' AS UOM,
            0 AS NORMS,
            ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) AS MTD
        FROM SEMANTIC_PROD.REFINERY_HSE_VIEW
        WHERE LOWER(TRIM(KPI)) in ('near miss') 
        AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
        GROUP BY 1,2,3
        """
        QUERY_3 = """
        SELECT 
            CASE
                WHEN LOWER(TRIM(KPI)) = 'first aid' THEN 'No. of First Aid'
                WHEN LOWER(TRIM(KPI)) = 'near miss' THEN 'No. of Near Miss'
            ELSE NULL
            END AS safety_report,

            'No.' AS UOM,
            0 AS NORMS,
            ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) AS YTD
        FROM SEMANTIC_PROD.REFINERY_HSE_VIEW
        WHERE LOWER(TRIM(KPI)) in ('near miss') 
        AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
        GROUP BY 1,2,3
        """

    class NoOfFirstAid:
        """ SAFETY REPORT """
        QUERY_1 = """
        SELECT 
            CASE
                WHEN LOWER(TRIM(KPI)) = 'first aid' THEN 'No. of First Aid'
                WHEN LOWER(TRIM(KPI)) = 'near miss' THEN 'No. of Near Miss'
            ELSE NULL
            END AS safety_report,

            'No.' AS UOM,
            0 AS NORMS,
            ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) AS ON_DATE 
        FROM SEMANTIC_PROD.REFINERY_HSE_VIEW
        WHERE LOWER(TRIM(KPI)) in ('first aid') 
        AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
        GROUP BY 1,2,3
        """
        QUERY_2 = """
        SELECT 
            CASE
                WHEN LOWER(TRIM(KPI)) = 'first aid' THEN 'No. of First Aid'
                WHEN LOWER(TRIM(KPI)) = 'near miss' THEN 'No. of Near Miss'
            ELSE NULL
            END AS safety_report,

            'No.' AS UOM,
            0 AS NORMS,
            ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) AS MTD
        FROM SEMANTIC_PROD.REFINERY_HSE_VIEW
        WHERE LOWER(TRIM(KPI)) in ('first aid') 
        AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
        GROUP BY 1,2,3
        """
        QUERY_3 = """
        SELECT 
            CASE
                WHEN LOWER(TRIM(KPI)) = 'first aid' THEN 'No. of First Aid'
                WHEN LOWER(TRIM(KPI)) = 'near miss' THEN 'No. of Near Miss'
            ELSE NULL
            END AS safety_report,

            'No.' AS UOM,
            0 AS NORMS,
            ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) AS YTD
        FROM SEMANTIC_PROD.REFINERY_HSE_VIEW
        WHERE LOWER(TRIM(KPI)) in ('first aid') 
        AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
        GROUP BY 1,2,3
        """

    class GridPowerAvailability:
        """ POWER AVAILABILITY """
        QUERY_1 = """
        SELECT 
        'Grid Power Availability' AS power_availability,
        '%' AS uom,
        ROUND(AVG(GRID_PLAN) :: NUMERIC, 2) AS norms,
        ROUND(AVG(GRID_ACTUAL) :: NUMERIC, 2) AS on_date

        FROM
        (SELECT DD_1.DATE_DT AS date,
        PLAN.GRID_PLAN,
        CASE
        WHEN ACTUAL.GRID_ACTUAL IS NULL THEN 100
        ELSE ACTUAL.GRID_ACTUAL
        END AS GRID_ACTUAL
        FROM
        (SELECT DATE(date) AS POSTING_DATE,
        AREA_ICS_HEAD_VALUE::double precision AS GRID_PLAN
        FROM SEMANTIC_PROD.AREA_ICS_HEAD_REFINERY_NORMS
        WHERE LOWER(TRIM(AREA_ICS_HEAD_SELECT)) = 'grid power  availability'
        AND DATE_PART('day',date) = 1
        GROUP BY 1,
        2)PLAN
        LEFT JOIN
        (SELECT DIM_DATE.DATE_DT,
        DIM_DATE.MONTH_OF_YR_NUM AS MNTH,
        DIM_DATE.YR_NAME AS YR
        FROM SEMANTIC_PROD.DIM_DATE) DD_1 ON DD_1.MNTH = DATE_PART('month',

        PLAN.POSTING_DATE)
        AND DD_1.YR = DATE_PART('year',

        PLAN.POSTING_DATE)
        LEFT JOIN
        (SELECT DATE(date) AS POSTING_DATE,
        MAX(CASE
        WHEN LOWER(TRIM(LOSS_OR_GAIN_SHUTDOWN_RECTIFIER)) = 'both' THEN 
        ((24 - COALESCE(LOSS_OR_GAIN_SHUTDOWN_DURATION::double precision,

        0)) / 24) * 100
        ELSE NULL
        END) AS GRID_ACTUAL
        FROM SEMANTIC_PROD.SHUTDOWN_DETAILS
        GROUP BY 1)ACTUAL ON DD_1.DATE_DT = ACTUAL.POSTING_DATE)GRID_DATA

        WHERE date BETWEEN '{day_start_date}' AND '{day_end_date}'
        GROUP BY 1,2
                """
        QUERY_2 = """
                SELECT 
                'Grid Power Availability' AS power_availability,
                '%' AS uom,
                ROUND(AVG(GRID_ACTUAL) :: NUMERIC, 2) AS mtd

                FROM
                (SELECT DD_1.DATE_DT AS date,
                PLAN.GRID_PLAN,
                CASE
                WHEN ACTUAL.GRID_ACTUAL IS NULL THEN 100
                ELSE ACTUAL.GRID_ACTUAL
                END AS GRID_ACTUAL
                FROM
                (SELECT DATE(date) AS POSTING_DATE,
                AREA_ICS_HEAD_VALUE::double precision AS GRID_PLAN
                FROM SEMANTIC_PROD.AREA_ICS_HEAD_REFINERY_NORMS
                WHERE LOWER(TRIM(AREA_ICS_HEAD_SELECT)) = 'grid power  availability'
                AND DATE_PART('day',date) = 1
                GROUP BY 1,
                2)PLAN
                LEFT JOIN
                (SELECT DIM_DATE.DATE_DT,
                DIM_DATE.MONTH_OF_YR_NUM AS MNTH,
                DIM_DATE.YR_NAME AS YR
                FROM SEMANTIC_PROD.DIM_DATE) DD_1 ON DD_1.MNTH = DATE_PART('month',

                PLAN.POSTING_DATE)
                AND DD_1.YR = DATE_PART('year',

                PLAN.POSTING_DATE)
                LEFT JOIN
                (SELECT DATE(date) AS POSTING_DATE,
                MAX(CASE
                WHEN LOWER(TRIM(LOSS_OR_GAIN_SHUTDOWN_RECTIFIER)) = 'both' THEN 
                ((24 - COALESCE(LOSS_OR_GAIN_SHUTDOWN_DURATION::double precision,

                0)) / 24) * 100
                ELSE NULL
                END) AS GRID_ACTUAL
                FROM SEMANTIC_PROD.SHUTDOWN_DETAILS
                GROUP BY 1)ACTUAL ON DD_1.DATE_DT = ACTUAL.POSTING_DATE)GRID_DATA

                WHERE date BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1,2
                """
        QUERY_3 = """
                SELECT 
                'Grid Power Availability' AS power_availability,
                '%' AS uom,
                ROUND(AVG(GRID_ACTUAL) :: NUMERIC, 2) AS ytd

                FROM
                (SELECT DD_1.DATE_DT AS date,
                PLAN.GRID_PLAN,
                CASE
                WHEN ACTUAL.GRID_ACTUAL IS NULL THEN 100
                ELSE ACTUAL.GRID_ACTUAL
                END AS GRID_ACTUAL
                FROM
                (SELECT DATE(date) AS POSTING_DATE,
                AREA_ICS_HEAD_VALUE::double precision AS GRID_PLAN
                FROM SEMANTIC_PROD.AREA_ICS_HEAD_REFINERY_NORMS
                WHERE LOWER(TRIM(AREA_ICS_HEAD_SELECT)) = 'grid power  availability'
                AND DATE_PART('day',date) = 1
                GROUP BY 1,
                2)PLAN
                LEFT JOIN
                (SELECT DIM_DATE.DATE_DT,
                DIM_DATE.MONTH_OF_YR_NUM AS MNTH,
                DIM_DATE.YR_NAME AS YR
                FROM SEMANTIC_PROD.DIM_DATE) DD_1 ON DD_1.MNTH = DATE_PART('month',

                PLAN.POSTING_DATE)
                AND DD_1.YR = DATE_PART('year',

                PLAN.POSTING_DATE)
                LEFT JOIN
                (SELECT DATE(date) AS POSTING_DATE,
                MAX(CASE
                WHEN LOWER(TRIM(LOSS_OR_GAIN_SHUTDOWN_RECTIFIER)) = 'both' THEN 
                ((24 - COALESCE(LOSS_OR_GAIN_SHUTDOWN_DURATION::double precision,

                0)) / 24) * 100
                ELSE NULL
                END) AS GRID_ACTUAL
                FROM SEMANTIC_PROD.SHUTDOWN_DETAILS
                GROUP BY 1)ACTUAL ON DD_1.DATE_DT = ACTUAL.POSTING_DATE)GRID_DATA

                WHERE date BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1,2
                """

    class Circulation1:
        """ POWER AVAILABILITY """
        QUERY_1 = """
        SELECT
        CIRCULATION as power_availability,
        COALESCE(RLB.AREA_ICS_HEAD_UOM, 'Hrs') AS uom,
        ROUND(AVG(AREA_ICS_HEAD_VALUE)::NUMERIC, 2) AS norms,
        ROUND(AVG(OPERATION_HOURS)::NUMERIC, 2) AS on_date

        FROM
        (SELECT CIRCULATION,
        DATE(DATETIME) AS date,
        OPERATION_HOURS
        FROM SEMANTIC_PROD.DCS_DATA DD
        WHERE OPERATION_HOURS IS NOT NULL) DCS
        LEFT JOIN
        (SELECT DATE("date") AS DATETIME,
        AREA_ICS_HEAD_SELECT,
        AREA_ICS_HEAD_VALUE,
        AREA_ICS_HEAD_UOM
        FROM SEMANTIC_PROD.AREA_ICS_HEAD_REFINERY_NORMS
        WHERE LOWER(TRIM(AREA_ICS_HEAD_SELECT)) 
         like ('%rectifier  running%')
        AND AREA_ICS_HEAD_VALUE IS NOT NULL
        AND DATE_PART('day',

        DATE(date)) = 1) RLB ON EXTRACT(MONTH
        FROM date) = EXTRACT(MONTH FROM DATE(RLB.DATETIME))
        AND EXTRACT(YEAR
        FROM date) = EXTRACT(YEAR
        FROM DATE(RLB.DATETIME))
        WHERE CIRCULATION = 'Circulation 1'

        AND date BETWEEN '{day_start_date}' AND '{day_end_date}'
        GROUP BY 1,2
        """
        QUERY_2 = """
                SELECT
                CIRCULATION as power_availability,
                COALESCE(RLB.AREA_ICS_HEAD_UOM, 'Hrs') AS uom,
                ROUND(AVG(OPERATION_HOURS)::NUMERIC, 2) AS mtd

                FROM
                (SELECT CIRCULATION,
                DATE(DATETIME) AS date,
                OPERATION_HOURS
                FROM SEMANTIC_PROD.DCS_DATA DD
                WHERE OPERATION_HOURS IS NOT NULL) DCS
                LEFT JOIN
                (SELECT DATE("date") AS DATETIME,
                AREA_ICS_HEAD_SELECT,
                AREA_ICS_HEAD_VALUE,
                AREA_ICS_HEAD_UOM
                FROM SEMANTIC_PROD.AREA_ICS_HEAD_REFINERY_NORMS
                WHERE LOWER(TRIM(AREA_ICS_HEAD_SELECT)) 
                 like ('%rectifier  running%')
                AND AREA_ICS_HEAD_VALUE IS NOT NULL
                AND DATE_PART('day',

                DATE(date)) = 1) RLB ON EXTRACT(MONTH
                FROM date) = EXTRACT(MONTH FROM DATE(RLB.DATETIME))
                AND EXTRACT(YEAR
                FROM date) = EXTRACT(YEAR
                FROM DATE(RLB.DATETIME))
                WHERE CIRCULATION = 'Circulation 1'

                AND date BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1,2
                """
        QUERY_3 = """
                SELECT
                CIRCULATION as power_availability,
                COALESCE(RLB.AREA_ICS_HEAD_UOM, 'Hrs') AS uom,
                ROUND(AVG(OPERATION_HOURS)::NUMERIC, 2) AS ytd

                FROM
                (SELECT CIRCULATION,
                DATE(DATETIME) AS date,
                OPERATION_HOURS
                FROM SEMANTIC_PROD.DCS_DATA DD
                WHERE OPERATION_HOURS IS NOT NULL) DCS
                LEFT JOIN
                (SELECT DATE("date") AS DATETIME,
                AREA_ICS_HEAD_SELECT,
                AREA_ICS_HEAD_VALUE,
                AREA_ICS_HEAD_UOM
                FROM SEMANTIC_PROD.AREA_ICS_HEAD_REFINERY_NORMS
                WHERE LOWER(TRIM(AREA_ICS_HEAD_SELECT)) 
                 like ('%rectifier  running%')
                AND AREA_ICS_HEAD_VALUE IS NOT NULL
                AND DATE_PART('day',

                DATE(date)) = 1) RLB ON EXTRACT(MONTH
                FROM date) = EXTRACT(MONTH FROM DATE(RLB.DATETIME))
                AND EXTRACT(YEAR
                FROM date) = EXTRACT(YEAR
                FROM DATE(RLB.DATETIME))
                WHERE CIRCULATION = 'Circulation 1'

                AND date BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1,2
                """

    class Circulation2:
        """ POWER AVAILABILITY """
        QUERY_1 = """
                SELECT CIRCULATION AS power_availability,
                COALESCE(RLB.AREA_ICS_HEAD_UOM, 'Hrs') AS uom,
                ROUND(AVG(AREA_ICS_HEAD_VALUE)::NUMERIC, 2) AS norms,
                ROUND(AVG(OPERATION_HOURS)::NUMERIC, 2) AS on_date

                FROM
                (SELECT CIRCULATION,
                DATE(DATETIME) AS date,
                OPERATION_HOURS
                FROM SEMANTIC_PROD.DCS_DATA DD
                WHERE OPERATION_HOURS IS NOT NULL) DCS
                LEFT JOIN
                (SELECT DATE("date") AS DATETIME,
                AREA_ICS_HEAD_SELECT,
                AREA_ICS_HEAD_VALUE,
                AREA_ICS_HEAD_UOM
                FROM SEMANTIC_PROD.AREA_ICS_HEAD_REFINERY_NORMS
                WHERE LOWER(TRIM(AREA_ICS_HEAD_SELECT)) like ('%rectifier  running%')
                AND AREA_ICS_HEAD_VALUE IS NOT NULL
                AND DATE_PART('day',

                DATE(date)) = 1) RLB ON EXTRACT(MONTH
                FROM date) = EXTRACT(MONTH
                FROM DATE(RLB.DATETIME))
                AND EXTRACT(YEAR
                FROM date) = EXTRACT(YEAR
                FROM DATE(RLB.DATETIME))
                WHERE CIRCULATION = 'Circulation 2'

                AND date BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1,2
                """
        QUERY_2 = """
                        SELECT CIRCULATION AS power_availability,
                        COALESCE(RLB.AREA_ICS_HEAD_UOM, 'Hrs') AS uom,
                        ROUND(AVG(OPERATION_HOURS)::NUMERIC, 2) AS mtd

                        FROM
                        (SELECT CIRCULATION,
                        DATE(DATETIME) AS date,
                        OPERATION_HOURS
                        FROM SEMANTIC_PROD.DCS_DATA DD
                        WHERE OPERATION_HOURS IS NOT NULL) DCS
                        LEFT JOIN
                        (SELECT DATE("date") AS DATETIME,
                        AREA_ICS_HEAD_SELECT,
                        AREA_ICS_HEAD_VALUE,
                        AREA_ICS_HEAD_UOM
                        FROM SEMANTIC_PROD.AREA_ICS_HEAD_REFINERY_NORMS
                        WHERE LOWER(TRIM(AREA_ICS_HEAD_SELECT)) like 
                        ('%rectifier  running%')
                        AND AREA_ICS_HEAD_VALUE IS NOT NULL
                        AND DATE_PART('day',

                        DATE(date)) = 1) RLB ON EXTRACT(MONTH
                        FROM date) = EXTRACT(MONTH
                        FROM DATE(RLB.DATETIME))
                        AND EXTRACT(YEAR
                        FROM date) = EXTRACT(YEAR
                        FROM DATE(RLB.DATETIME))
                        WHERE CIRCULATION = 'Circulation 2'

                        AND date BETWEEN '{month_start_date}' AND '{month_end_date}'
                        GROUP BY 1,2
                        """
        QUERY_3 = """
                        SELECT CIRCULATION AS power_availability,
                        COALESCE(RLB.AREA_ICS_HEAD_UOM, 'Hrs') AS uom,
                        ROUND(AVG(OPERATION_HOURS)::NUMERIC, 2) AS ytd

                        FROM
                        (SELECT CIRCULATION,
                        DATE(DATETIME) AS date,
                        OPERATION_HOURS
                        FROM SEMANTIC_PROD.DCS_DATA DD
                        WHERE OPERATION_HOURS IS NOT NULL) DCS
                        LEFT JOIN
                        (SELECT DATE("date") AS DATETIME,
                        AREA_ICS_HEAD_SELECT,
                        AREA_ICS_HEAD_VALUE,
                        AREA_ICS_HEAD_UOM
                        FROM SEMANTIC_PROD.AREA_ICS_HEAD_REFINERY_NORMS
                        WHERE LOWER(TRIM(AREA_ICS_HEAD_SELECT)) like 
                        ('%rectifier  running%')
                        AND AREA_ICS_HEAD_VALUE IS NOT NULL
                        AND DATE_PART('day',

                        DATE(date)) = 1) RLB ON EXTRACT(MONTH
                        FROM date) = EXTRACT(MONTH
                        FROM DATE(RLB.DATETIME))
                        AND EXTRACT(YEAR
                        FROM date) = EXTRACT(YEAR
                        FROM DATE(RLB.DATETIME))
                        WHERE CIRCULATION = 'Circulation 2'

                        AND date BETWEEN '{year_start_date}' AND '{year_end_date}'
                        GROUP BY 1,2
                        """

    class Cir140KARectifierAvgCurrent:
        """ POWER AVAILABILITY """
        QUERY_1 = """
                SELECT 
                'Cir-1 40 KA Rectifier Avg. Current' AS power_availability,
                'KAmp' AS uom,
                ROUND(AVG(PLAN_METRIC_VALUE)::NUMERIC, 2) AS norms,
                ROUND((SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(CASE WHEN 
                ACTUAL_METRIC_VALUE <> 0 THEN 1 ELSE NULL END), 0), 1))::NUMERIC, 2) 
                AS on_date

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) = '40ka_rectifier_current'
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1,2
                """
        QUERY_2 = """
                SELECT 
                'Cir-1 40 KA Rectifier Avg. Current' AS power_availability,
                'KAmp' AS uom,
                ROUND((SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(CASE WHEN 
                ACTUAL_METRIC_VALUE <> 0 THEN 1 ELSE NULL END), 0), 1))::NUMERIC, 2)
                AS mtd

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) = '40ka_rectifier_current'
                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1,2
                """
        QUERY_3 = """
                SELECT 
                'Cir-1 40 KA Rectifier Avg. Current' AS power_availability,
                'KAmp' AS uom,
                ROUND((SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(CASE WHEN 
                ACTUAL_METRIC_VALUE <> 0 THEN 1 ELSE NULL END), 0), 1))::NUMERIC, 2)
                AS ytd

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) = '40ka_rectifier_current'
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1,2
                """

    class Cir235KARectifierAvgCurrent:
        """ POWER AVAILABILITY """
        QUERY_1 = """
                SELECT 
                'Cir-2 35 KA Rectifier Avg. Current' AS power_availability,
                'KAmp' AS uom,
                ROUND(AVG(PLAN_METRIC_VALUE)::NUMERIC, 2) AS norms,
                ROUND((SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(CASE WHEN 
                ACTUAL_METRIC_VALUE <> 0 THEN 1 ELSE NULL END), 0), 1))::NUMERIC, 2)
                AS on_date

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) = '35ka_rectifier_current'
                    AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1,2
                """
        QUERY_2 = """
                SELECT 
                'Cir-2 35 KA Rectifier Avg. Current' AS power_availability,
                'KAmp' AS uom,
                ROUND((SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(CASE WHEN 
                ACTUAL_METRIC_VALUE <> 0 THEN 1 ELSE NULL END), 0), 1))::NUMERIC, 2)
                AS mtd

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) = '35ka_rectifier_current'
                    AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1,2
                """
        QUERY_3 = """
                SELECT 
                'Cir-2 35 KA Rectifier Avg. Current' AS power_availability,
                'KAmp' AS uom,
                ROUND((SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(CASE WHEN 
                ACTUAL_METRIC_VALUE <> 0 THEN 1 ELSE NULL END), 0), 1))::NUMERIC, 2)
                AS ytd

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) = '35ka_rectifier_current'
                    AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1,2
                """

    class TotalAvgCurrent:
        """ POWER AVAILABILITY """
        QUERY_1 = """
                SELECT 
                'Total Avg. Current' AS power_availability,
                'KAmp' AS uom,
                ROUND(AVG(PLAN_METRIC_VALUE)::NUMERIC, 2) AS norms,
                ROUND((SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(CASE WHEN 
                ACTUAL_METRIC_VALUE <> 0 THEN 1 ELSE NULL END), 0), 1))::NUMERIC, 2) 
                AS on_date

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) in 
                ('40ka_rectifier_current', '35ka_rectifier_current')

                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1,2
                """
        QUERY_2 = """
                SELECT 
                'Total Avg. Current' AS power_availability,
                'KAmp' AS uom,
                ROUND((SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(CASE WHEN 
                ACTUAL_METRIC_VALUE <> 0 THEN 1 ELSE NULL END), 0), 1))::NUMERIC, 2)
                AS mtd

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) in 
                ('40ka_rectifier_current', '35ka_rectifier_current')

                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1,2
                """
        QUERY_3 = """
                SELECT 
                'Total Avg. Current' AS power_availability,
                'KAmp' AS uom,
                ROUND((SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(CASE WHEN 
                ACTUAL_METRIC_VALUE <> 0 THEN 1 ELSE NULL END), 0), 1))::NUMERIC, 2)
                AS ytd

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) in 
                ('40ka_rectifier_current', '35ka_rectifier_current')

                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1,2
                """

    class CurrentDensity:
        """ POWER AVAILABILITY """
        QUERY_1 = """
                SELECT 
                'Current Density' AS power_availability,
                'Amp / m2' AS uom,
                ROUND(AVG(NUMO_PLAN)::NUMERIC, 2) AS norms,
                ROUND(AVG(NUMO_ACTUAL)::NUMERIC, 2) AS on_date

                FROM SEMANTIC_PROD.CE_CD_TE_DETAILED_VIEW CCTDV2
                WHERE 
                LOWER(TRIM(CATEGORY)) = 'cd'
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                """
        QUERY_2 = """
                SELECT 
                'Current Density' AS power_availability,
                'Amp / m2' AS uom,
                ROUND(AVG(NUMO_ACTUAL)::NUMERIC, 2) AS mtd

                FROM SEMANTIC_PROD.CE_CD_TE_DETAILED_VIEW CCTDV2
                WHERE 
                LOWER(TRIM(CATEGORY)) = 'cd'
                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                """
        QUERY_3 = """
                SELECT 
                'Current Density' AS power_availability,
                'Amp / m2' AS uom,
                ROUND(AVG(NUMO_ACTUAL)::NUMERIC, 2) AS ytd

                FROM SEMANTIC_PROD.CE_CD_TE_DETAILED_VIEW CCTDV2
                WHERE 
                LOWER(TRIM(CATEGORY)) = 'cd'
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                """

    class AcpCcpcCcp:
        """ RM ANODE RECEIPT DETAILS """
        QUERY_1 = """ 
        SELECT 
        KPI as rm_anode_receipt_details,
        ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) AS on_date

        FROM
        (SELECT 'ACP Anode Receipt (MT)' AS KPI,
                SUM(QUANTITY::double precision) AS METRIC_VALUE,
                DATE(date) AS date
            FROM SEMANTIC_PROD.FACT_SPENT_ANODE
            WHERE MOVEMENT_TYPE = '101'
                AND PLANT = '1200'
                AND STORAGE_LOCATION = '103Q'
                AND MATERIAL_ID = '330000091'
            GROUP BY 1,3
            UNION ALL SELECT 'CCPC Anode Receipt (MT)' AS KPI,
                SUM(QUANTITY::double precision) AS METRIC_VALUE,
                DATE(date) AS date
            FROM SEMANTIC_PROD.FACT_SPENT_ANODE
            WHERE MOVEMENT_TYPE = '101'
                AND PLANT = '1200'
                AND STORAGE_LOCATION = '103C'
                AND MATERIAL_ID = '330000091'
            GROUP BY 1,3
            UNION ALL SELECT 'CCP Anode Receipt (MT)' AS KPI,
                SUM(QUANTITY::double precision) AS METRIC_VALUE,
                DATE(date) AS date
            FROM SEMANTIC_PROD.FACT_SPENT_ANODE
            WHERE MOVEMENT_TYPE = '101'
                AND PLANT = '1200'
                AND STORAGE_LOCATION = '103Q'
                AND MATERIAL_ID = '330000099'
            GROUP BY 1,3)TB
        WHERE DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
        GROUP BY 1
        """
        QUERY_2 = """ 
                SELECT 
                KPI as rm_anode_receipt_details,
                ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) AS mtd

                FROM
                (SELECT 'ACP Anode Receipt (MT)' AS KPI,
                        SUM(QUANTITY::double precision) AS METRIC_VALUE,
                        DATE(date) AS date
                    FROM SEMANTIC_PROD.FACT_SPENT_ANODE
                    WHERE MOVEMENT_TYPE = '101'
                        AND PLANT = '1200'
                        AND STORAGE_LOCATION = '103Q'
                        AND MATERIAL_ID = '330000091'
                    GROUP BY 1,3
                    UNION ALL SELECT 'CCPC Anode Receipt (MT)' AS KPI,
                        SUM(QUANTITY::double precision) AS METRIC_VALUE,
                        DATE(date) AS date
                    FROM SEMANTIC_PROD.FACT_SPENT_ANODE
                    WHERE MOVEMENT_TYPE = '101'
                        AND PLANT = '1200'
                        AND STORAGE_LOCATION = '103C'
                        AND MATERIAL_ID = '330000091'
                    GROUP BY 1,3
                    UNION ALL SELECT 'CCP Anode Receipt (MT)' AS KPI,
                        SUM(QUANTITY::double precision) AS METRIC_VALUE,
                        DATE(date) AS date
                    FROM SEMANTIC_PROD.FACT_SPENT_ANODE
                    WHERE MOVEMENT_TYPE = '101'
                        AND PLANT = '1200'
                        AND STORAGE_LOCATION = '103Q'
                        AND MATERIAL_ID = '330000099'
                    GROUP BY 1,3)TB
                WHERE DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1
                """
        QUERY_3 = """ 
                SELECT 
                KPI as rm_anode_receipt_details,
                ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) AS ytd

                FROM
                (SELECT 'ACP Anode Receipt (MT)' AS KPI,
                        SUM(QUANTITY::double precision) AS METRIC_VALUE,
                        DATE(date) AS date
                    FROM SEMANTIC_PROD.FACT_SPENT_ANODE
                    WHERE MOVEMENT_TYPE = '101'
                        AND PLANT = '1200'
                        AND STORAGE_LOCATION = '103Q'
                        AND MATERIAL_ID = '330000091'
                    GROUP BY 1,3
                    UNION ALL SELECT 'CCPC Anode Receipt (MT)' AS KPI,
                        SUM(QUANTITY::double precision) AS METRIC_VALUE,
                        DATE(date) AS date
                    FROM SEMANTIC_PROD.FACT_SPENT_ANODE
                    WHERE MOVEMENT_TYPE = '101'
                        AND PLANT = '1200'
                        AND STORAGE_LOCATION = '103C'
                        AND MATERIAL_ID = '330000091'
                    GROUP BY 1,3
                    UNION ALL SELECT 'CCP Anode Receipt (MT)' AS KPI,
                        SUM(QUANTITY::double precision) AS METRIC_VALUE,
                        DATE(date) AS date
                    FROM SEMANTIC_PROD.FACT_SPENT_ANODE
                    WHERE MOVEMENT_TYPE = '101'
                        AND PLANT = '1200'
                        AND STORAGE_LOCATION = '103Q'
                        AND MATERIAL_ID = '330000099'
                    GROUP BY 1,3)TB
                WHERE DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1
                """

    class BankCropStripping:
        """ BANK / CROP / STRIPPING TIME """
        QUERY_1 = """
        SELECT 
            CASE
                WHEN "substring"(BTRIM(REFINERY_PRODUCTION_SELECT),
                '\d+$'::text)::numeric >= 1::numeric
                AND "substring"(BTRIM(REFINERY_PRODUCTION_SELECT),
                '\d+$'::text)::numeric <= 10::numeric THEN CONCAT('B',
                "substring"(BTRIM(REFINERY_PRODUCTION_SELECT),
                '\d+$'::text),'C1')
                WHEN "substring"(BTRIM(REFINERY_PRODUCTION_SELECT),
                '\d+$'::text)::numeric >= 11::numeric
                AND "substring"(BTRIM(REFINERY_PRODUCTION_SELECT),
                '\d+$'::text)::numeric <= 22::numeric THEN CONCAT('B',
                SUBSTRING(BTRIM(REFINERY_PRODUCTION_SELECT),
                '\d+$'::text),
                'C2')
            END AS bank_crop,

        ROUND(AVG(REFINARY_PRODUCTION_CE)::NUMERIC, 2) AS ce,
        ROUND(SUM(REFINARY_PRODUCTION_THEORETICAL_WEIGHT)::NUMERIC, 2) AS theor_weight,
        ROUND(SUM(REFINARY_PRODUCTION_ACTUAL_WEIGHT)::NUMERIC, 2) AS actual_weight,
        ROUND(AVG(REFINARY_PRODUCTION_STRIPPING_TIME)::NUMERIC, 2) AS stripping_time

        FROM SEMANTIC_PROD.BANKWISE_REFINERY_PRODUCTION
        WHERE 
        REFINERY_PRODUCTION_SELECT IS NOT NULL AND 
        DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
        GROUP BY 1
        """

    class SpecificConsumption:
        """ SPECIFIC CONSUMPTION """
        QUERY_1 = """
        SELECT 
        CONSUMABLES AS consumables,

        MAX(NORMS_UOM) AS uom,

        ROUND(AVG(NORMS)::NUMERIC, 2) AS norms,

        ROUND((CASE
        WHEN CONSUMABLES in ('Glue_Consumption',
        'Thiourea_Consumption',
        'Wax_Consumption',
        'H2SO4_Addition',
        'HCl_Addition')
        AND SUM(DEPOSIT) <> 0 THEN SUM(METRIC_QUANTITY) / SUM(DEPOSIT)
        WHEN CONSUMABLES in ('Edge_Strip_Consumption',
        'Plate_repairing') THEN SUM(METRIC_QUANTITY)
        ELSE 0
        END)::NUMERIC, 2) on_date

        FROM SEMANTIC_PROD.CONSUMABLES_KPI_VIEW
        WHERE CONSUMABLES in 
        (
        'Glue_Consumption',
        'Thiourea_Consumption',
        'Wax_Consumption',
        'H2SO4_Addition',
        'HCl_Addition',
        'Edge_Strip_Consumption',
        'Plate_repairing'
        )
        AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
        GROUP BY 1
        """
        QUERY_2 = """
                SELECT 
                CONSUMABLES AS consumables,

                ROUND((CASE
                WHEN CONSUMABLES in ('Glue_Consumption',
                'Thiourea_Consumption',
                'Wax_Consumption',
                'H2SO4_Addition',
                'HCl_Addition')
                AND SUM(DEPOSIT) <> 0 THEN SUM(METRIC_QUANTITY) / SUM(DEPOSIT)
                WHEN CONSUMABLES in ('Edge_Strip_Consumption',
                'Plate_repairing') THEN SUM(METRIC_QUANTITY)
                ELSE 0
                END)::NUMERIC, 2) AS mtd

                FROM SEMANTIC_PROD.CONSUMABLES_KPI_VIEW
                WHERE CONSUMABLES in 
                (
                'Glue_Consumption',
                'Thiourea_Consumption',
                'Wax_Consumption',
                'H2SO4_Addition',
                'HCl_Addition',
                'Edge_Strip_Consumption',
                'Plate_repairing'
                )
                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1
                """
        QUERY_3 = """
                SELECT 
                CONSUMABLES AS consumables,

                ROUND((CASE
                WHEN CONSUMABLES in ('Glue_Consumption',
                'Thiourea_Consumption',
                'Wax_Consumption',
                'H2SO4_Addition',
                'HCl_Addition')
                AND SUM(DEPOSIT) <> 0 THEN SUM(METRIC_QUANTITY) / SUM(DEPOSIT)
                WHEN CONSUMABLES in ('Edge_Strip_Consumption',
                'Plate_repairing') THEN SUM(METRIC_QUANTITY)
                ELSE 0
                END)::NUMERIC, 2) AS ytd

                FROM SEMANTIC_PROD.CONSUMABLES_KPI_VIEW
                WHERE CONSUMABLES in 
                (
                'Glue_Consumption',
                'Thiourea_Consumption',
                'Wax_Consumption',
                'H2SO4_Addition',
                'HCl_Addition',
                'Edge_Strip_Consumption',
                'Plate_repairing'
                )
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1
                """

    class CurrentEfficiency:
        """ Efficiency """
        QUERY_1 = """
                SELECT 
                    'Current Efficiency' AS efficiencies,
                    '%' AS uom,
                    AVG(NUMO_PLAN) AS norms,
                    ROUND(((SUM(NUMO_ACTUAL) / NULLIF(SUM(DENO_ACTUAL), 0)) * 
                    100)::NUMERIC, 2) 
                    AS on_date

                    FROM SEMANTIC_PROD.CE_CD_TE_DETAILED_VIEW

                    WHERE LOWER(TRIM(CATEGORY)) = 'ce'
                    AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                    GROUP BY 1,2
                """
        QUERY_2 = """
                SELECT 
                    'Current Efficiency' AS efficiencies,
                    '%' AS uom,
                    ROUND(((SUM(NUMO_ACTUAL) / NULLIF(SUM(DENO_ACTUAL), 0)) * 
                    100)::NUMERIC, 2) AS mtd

                    FROM SEMANTIC_PROD.CE_CD_TE_DETAILED_VIEW

                    WHERE LOWER(TRIM(CATEGORY)) = 'ce'
                    AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                    GROUP BY 1,2
                """
        QUERY_3 = """
                SELECT 
                    'Current Efficiency' AS efficiencies,
                    '%' AS uom,
                    ROUND(((SUM(NUMO_ACTUAL) / NULLIF(SUM(DENO_ACTUAL), 0)) * 
                    100)::NUMERIC, 2) AS ytd

                    FROM SEMANTIC_PROD.CE_CD_TE_DETAILED_VIEW

                    WHERE LOWER(TRIM(CATEGORY)) = 'ce'
                    AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                    GROUP BY 1,2
                """

    class TimeEfficiency:
        """ Efficiency """
        QUERY_1 = """
                SELECT 'Time Efficiency' AS efficiencies,
                    '%' AS uom,
                    AVG(NUMO_PLAN) AS norms,
                    ROUND(((SUM(NUMO_ACTUAL) / NULLIF(SUM(DENO_ACTUAL), 0)) * 
                    100)::NUMERIC, 2) AS on_date

                FROM SEMANTIC_PROD.CE_CD_TE_DETAILED_VIEW
                WHERE LOWER(TRIM(CATEGORY)) = 'te'
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1,2
                """
        QUERY_2 = """
                SELECT 'Time Efficiency' AS efficiencies,
                    '%' AS uom,
                    ROUND(((SUM(NUMO_ACTUAL) / NULLIF(SUM(DENO_ACTUAL), 0)) * 
                    100)::NUMERIC, 2) AS mtd                

                FROM SEMANTIC_PROD.CE_CD_TE_DETAILED_VIEW
                WHERE LOWER(TRIM(CATEGORY)) = 'te'
                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1,2
                """
        QUERY_3 = """
                SELECT 
                'Time Efficiency' AS efficiencies,
                '%' AS uom,
                ROUND(((SUM(NUMO_ACTUAL) / NULLIF(SUM(DENO_ACTUAL), 0)) * 
                100)::NUMERIC, 2)
                AS ytd

                FROM SEMANTIC_PROD.CE_CD_TE_DETAILED_VIEW
                WHERE LOWER(TRIM(CATEGORY)) = 'te'
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1,2
                """

    class E40KARectifierEfficiency:
        """ Efficiency """
        QUERY_1 = """
                SELECT 
                '40 KA Rectifier Efficiency' AS efficiencies,
                '%' AS uom,
                AVG(PLAN_METRIC_VALUE) AS norms,
                SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(
                CASE
                WHEN ACTUAL_METRIC_VALUE <> 0 THEN 1
                ELSE NULL END), 0), 1) AS on_date

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) = '40ka_rectifier_efficiency'
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1,2
                """
        QUERY_2 = """
                SELECT 
                '40 KA Rectifier Efficiency' AS efficiencies,
                '%' AS uom,
                SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(
                CASE
                WHEN ACTUAL_METRIC_VALUE <> 0 THEN 1
                ELSE NULL END), 0), 1) AS mtd

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) = '40ka_rectifier_efficiency'
                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1,2
                """
        QUERY_3 = """
                SELECT 
                '40 KA Rectifier Efficiency' AS efficiencies,
                '%' AS uom,
                SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(
                CASE
                WHEN ACTUAL_METRIC_VALUE <> 0 THEN 1
                ELSE NULL END), 0), 1) AS ytd

                FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW
                WHERE LOWER(TRIM(KPI)) = '40ka_rectifier_efficiency'
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1,2
                """

    class E35KARectifierEfficiency:
        """ Efficiency """
        QUERY_1 = """
                SELECT 
                    '35 KA Rectifier Efficiency' AS efficiencies,
                    '%' AS uom,
                    AVG(PLAN_METRIC_VALUE) AS norms,

                    SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(CASE
                    WHEN ACTUAL_METRIC_VALUE <> 0 THEN 1
                    ELSE NULL END), 0), 1) AS on_date

                    FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW

                    WHERE LOWER(TRIM(KPI)) = '35ka_rectifier_efficiency'

                    AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                    GROUP BY 1,2
                """
        QUERY_2 = """
                SELECT 
                    '35 KA Rectifier Efficiency' AS efficiencies,
                    '%' AS uom,

                    SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(CASE
                    WHEN ACTUAL_METRIC_VALUE <> 0 THEN 1
                    ELSE NULL END), 0), 1) AS mtd

                    FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW

                    WHERE LOWER(TRIM(KPI)) = '35ka_rectifier_efficiency'

                    AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                    GROUP BY 1,2
                    """
        QUERY_3 = """
                SELECT 
                    '35 KA Rectifier Efficiency' AS efficiencies,
                    '%' AS uom,
                    SUM(ACTUAL_METRIC_VALUE) / COALESCE(NULLIF(COUNT(CASE
                    WHEN ACTUAL_METRIC_VALUE <> 0 THEN 1
                    ELSE NULL END), 0), 1) AS ytd

                    FROM SEMANTIC_PROD.RECTIFIER_KPI_VIEW

                    WHERE LOWER(TRIM(KPI)) = '35ka_rectifier_efficiency'

                    AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                    GROUP BY 1,2
                """

    class SpentAnodeGenerationRate:
        """ Efficiency """
        QUERY_1 = """
                SELECT 
                'Spent Anode Generation Rate' efficiencies,
                '%' AS uom,
                MAX(NORMS) AS norms,
                MAX(METRIC_VALUE) AS on_date

                FROM
                (SELECT KPI,
                CASE
                    WHEN LOWER(TRIM(KPI)) = 'spent_anode_gen_actual' 
                    THEN (SUM(METRIC_NUMERATOR) / NULLIF(SUM(METRIC_DENOMINATOR), 0))
                     * 100
                ELSE NULL
                END AS METRIC_VALUE,

                CASE
                    WHEN LOWER(TRIM(KPI)) = 'spent_anode_gen_plan' 
                    THEN AVG(METRIC_NUMERATOR)
                ELSE NULL
                END AS NORMS

                FROM SEMANTIC_PROD.REFINERY_SPENT_ANODE_GEN_RATE

                WHERE LOWER(TRIM(KPI)) in 
                ('spent_anode_gen_actual', 'spent_anode_gen_plan')
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1)SPENT
                GROUP BY 1,2
                """
        QUERY_2 = """
                    SELECT 
                    'Spent Anode Generation Rate' efficiencies,
                    '%' AS uom,
                    MAX(METRIC_VALUE) AS mtd

                    FROM
                    (SELECT KPI,
                    CASE
                        WHEN LOWER(TRIM(KPI)) = 'spent_anode_gen_actual' 
                        THEN (SUM(METRIC_NUMERATOR) / NULLIF(SUM(METRIC_DENOMINATOR), 0))
                         * 100
                    ELSE NULL
                    END AS METRIC_VALUE,

                    CASE
                        WHEN LOWER(TRIM(KPI)) = 'spent_anode_gen_plan' 
                        THEN AVG(METRIC_NUMERATOR)
                    ELSE NULL
                    END AS NORMS

                    FROM SEMANTIC_PROD.REFINERY_SPENT_ANODE_GEN_RATE

                    WHERE LOWER(TRIM(KPI)) in 
                    ('spent_anode_gen_actual', 'spent_anode_gen_plan')
                    AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                    GROUP BY 1)SPENT
                    GROUP BY 1,2
                    """
        QUERY_3 = """
                SELECT 
                'Spent Anode Generation Rate' efficiencies,
                '%' AS uom,
                MAX(METRIC_VALUE) AS ytd

                FROM
                (SELECT KPI,
                CASE
                    WHEN LOWER(TRIM(KPI)) = 'spent_anode_gen_actual' 
                    THEN (SUM(METRIC_NUMERATOR) / NULLIF(SUM(METRIC_DENOMINATOR), 0))
                     * 100
                ELSE NULL
                END AS METRIC_VALUE,

                CASE
                    WHEN LOWER(TRIM(KPI)) = 'spent_anode_gen_plan' 
                    THEN AVG(METRIC_NUMERATOR)
                ELSE NULL
                END AS NORMS

                FROM SEMANTIC_PROD.REFINERY_SPENT_ANODE_GEN_RATE

                WHERE LOWER(TRIM(KPI)) in 
                ('spent_anode_gen_actual', 'spent_anode_gen_plan')
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1)SPENT
                GROUP BY 1,2
                """

    class Cathode:
        """ FG INVENTORY """
        QUERY_1 = """
                SELECT 
                PRODUCT as fg_inventory,
                SUM(CURRENT_STOCK) AS on_date

                FROM SEMANTIC_PROD.INVENTORY_FG_RM_WIP_VIEW

                WHERE LOWER(CATEGORY_OF_GOODS) like ('fg%')
                AND LOWER(PRODUCT) in 
                ('cathode')
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1
        """
        QUERY_2 = """
                SELECT 
                PRODUCT as fg_inventory,
                SUM(CURRENT_STOCK) AS mtd

                FROM SEMANTIC_PROD.INVENTORY_FG_RM_WIP_VIEW

                WHERE LOWER(CATEGORY_OF_GOODS) like ('fg%')
                AND LOWER(PRODUCT) in 
                ('cathode')
                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1
                """
        QUERY_3 = """
                SELECT 
                PRODUCT as fg_inventory,
                SUM(CURRENT_STOCK) AS ytd

                FROM SEMANTIC_PROD.INVENTORY_FG_RM_WIP_VIEW

                WHERE LOWER(CATEGORY_OF_GOODS) like ('fg%')
                AND LOWER(PRODUCT) in 
                ('cathode')
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1
                """

    class FGProdCathode:
        """ FG PRODUCTION """
        QUERY_1 = """
                SELECT 
                KPI as production,
                ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) AS on_date
                
                FROM SEMANTIC_PROD.PRODUCTION_KPI_VIEW
                WHERE LOWER(KPI) in 
                (
                'cathode_production_actual'
                )      
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY
                1;
                """
        QUERY_2 = """
                    SELECT 
            KPI as production,
            ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) AS mtd

            FROM SEMANTIC_PROD.PRODUCTION_KPI_VIEW
            WHERE LOWER(KPI) in 
            (
            'cathode_production_actual'
            )      
            AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
            GROUP BY
            1;
                """
        QUERY_3 = """
                    SELECT 
            KPI as production,
            ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) AS ytd

            FROM SEMANTIC_PROD.PRODUCTION_KPI_VIEW
            WHERE LOWER(KPI) in 
            (
            'cathode_production_actual'
            )      
            AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
            GROUP BY
            1;
                """

    class NiSO4:
        """ FG INVENTORY """
        QUERY_1 = """
                SELECT 
                PRODUCT as fg_inventory,
                SUM(CURRENT_STOCK) AS on_date

                FROM SEMANTIC_PROD.INVENTORY_FG_RM_WIP_VIEW

                WHERE LOWER(CATEGORY_OF_GOODS) like ('fg%')
                AND LOWER(PRODUCT) in 
                ('niso4')
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1
        """
        QUERY_2 = """
                SELECT 
                PRODUCT as fg_inventory,
                SUM(CURRENT_STOCK) AS mtd

                FROM SEMANTIC_PROD.INVENTORY_FG_RM_WIP_VIEW

                WHERE LOWER(CATEGORY_OF_GOODS) like ('fg%')
                AND LOWER(PRODUCT) in 
                ('niso4')
                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1
                """
        QUERY_3 = """
                SELECT 
                PRODUCT as fg_inventory,
                SUM(CURRENT_STOCK) AS ytd

                FROM SEMANTIC_PROD.INVENTORY_FG_RM_WIP_VIEW

                WHERE LOWER(CATEGORY_OF_GOODS) like ('fg%')
                AND LOWER(PRODUCT) in 
                ('niso4')
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1
                """

    class FGProdNiSO4:
        """ FG PRODUCTION """
        QUERY_1 = """
                SELECT 
                KPI as production,
                ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) AS on_date

                FROM SEMANTIC_PROD.PRODUCTION_KPI_VIEW
                WHERE LOWER(KPI) in 
                (
                'niso4_production_actual'
                )      
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY
                1;
                """
        QUERY_2 = """
                            SELECT 
                    KPI as production,
                    ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) AS mtd

                    FROM SEMANTIC_PROD.PRODUCTION_KPI_VIEW
                    WHERE LOWER(KPI) in 
                    (
                    'niso4_production_actual'
                    )      
                    AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                    GROUP BY
                    1;
                        """
        QUERY_3 = """
                            SELECT 
                    KPI as production,
                    ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) AS ytd

                    FROM SEMANTIC_PROD.PRODUCTION_KPI_VIEW
                    WHERE LOWER(KPI) in 
                    (
                    'niso4_production_actual'
                    )      
                    AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                    GROUP BY
                    1;
                        """

    class RawSlime:
        """ FG INVENTORY """
        QUERY_1 = """
                SELECT 
                PRODUCT as fg_inventory,
                SUM(CURRENT_STOCK) AS on_date

                FROM SEMANTIC_PROD.INVENTORY_FG_RM_WIP_VIEW

                WHERE LOWER(CATEGORY_OF_GOODS) like ('fg%')
                AND LOWER(PRODUCT) in 
                ('slime')
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1
        """
        QUERY_2 = """
                SELECT 
                PRODUCT as fg_inventory,
                SUM(CURRENT_STOCK) AS mtd

                FROM SEMANTIC_PROD.INVENTORY_FG_RM_WIP_VIEW

                WHERE LOWER(CATEGORY_OF_GOODS) like ('fg%')
                AND LOWER(PRODUCT) in 
                ('slime')
                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1
                """
        QUERY_3 = """
                SELECT 
                PRODUCT as fg_inventory,
                SUM(CURRENT_STOCK) AS ytd

                FROM SEMANTIC_PROD.INVENTORY_FG_RM_WIP_VIEW

                WHERE LOWER(CATEGORY_OF_GOODS) like ('fg%')
                AND LOWER(PRODUCT) in 
                ('slime')
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1
                """

    class FGProdRawSlime:
        """ FG PRODUCTION """
        QUERY_1 = """
                SELECT 
                KPI as production,
                ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) AS on_date

                FROM SEMANTIC_PROD.PRODUCTION_KPI_VIEW
                WHERE LOWER(KPI) in 
                (
                'slime_production_actual'
                )      
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY
                1;
                """
        QUERY_2 = """
                            SELECT 
                    KPI as production,
                    ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) AS mtd

                    FROM SEMANTIC_PROD.PRODUCTION_KPI_VIEW
                    WHERE LOWER(KPI) in 
                    (
                    'slime_production_actual'
                    )      
                    AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                    GROUP BY
                    1;
                        """
        QUERY_3 = """
                            SELECT 
                    KPI as production,
                    ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) AS ytd

                    FROM SEMANTIC_PROD.PRODUCTION_KPI_VIEW
                    WHERE LOWER(KPI) in 
                    (
                    'slime_production_actual'
                    )      
                    AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                    GROUP BY
                    1;
                        """

    class CuSo4:
        """ FG INVENTORY """
        QUERY_1 = """
                SELECT 
                PRODUCT as fg_inventory,
                SUM(CURRENT_STOCK) AS on_date

                FROM SEMANTIC_PROD.INVENTORY_FG_RM_WIP_VIEW

                WHERE LOWER(CATEGORY_OF_GOODS) like ('fg%')
                AND LOWER(PRODUCT) in 
                ('cuso4')
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1
        """
        QUERY_2 = """
                SELECT 
                PRODUCT as fg_inventory,
                SUM(CURRENT_STOCK) AS mtd

                FROM SEMANTIC_PROD.INVENTORY_FG_RM_WIP_VIEW

                WHERE LOWER(CATEGORY_OF_GOODS) like ('fg%')
                AND LOWER(PRODUCT) in 
                ('cuso4')
                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1
                """
        QUERY_3 = """
                SELECT 
                PRODUCT as fg_inventory,
                SUM(CURRENT_STOCK) AS ytd

                FROM SEMANTIC_PROD.INVENTORY_FG_RM_WIP_VIEW

                WHERE LOWER(CATEGORY_OF_GOODS) like ('fg%')
                AND LOWER(PRODUCT) in 
                ('cuso4')
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1
                """

    class FGProdCuSo4:
        """ FG PRODUCTION """
        QUERY_1 = """
            SELECT 
            KPI as production,
            ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) AS on_date
    
            FROM SEMANTIC_PROD.PRODUCTION_KPI_VIEW
            WHERE LOWER(KPI) in 
            (
            'cuso4_production_actual'
            )      
            AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
            GROUP BY
            1;
            """
        QUERY_2 = """
                    SELECT 
            KPI as production,
            ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) AS mtd

            FROM SEMANTIC_PROD.PRODUCTION_KPI_VIEW
            WHERE LOWER(KPI) in 
            (
            'cuso4_production_actual'
            )      
            AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
            GROUP BY
            1;
                """
        QUERY_3 = """
                        SELECT 
                KPI as production,
                ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) AS ytd

                FROM SEMANTIC_PROD.PRODUCTION_KPI_VIEW
                WHERE LOWER(KPI) in 
                (
                'cuso4_production_actual'
                )      
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY
                1;
                    """

    class ElectrolyteComposition:
        """ ELECTROLYTE COMPOSITION """
        QUERY_1 = """
                SELECT 
                ELECTROLYTE_COMPOSITION AS electrolyte_composition,
                MAX(UOM) AS uom,
                MAX(NORMS) AS norms,
                TO_CHAR(TO_DATE('{day_start_date}', 'YYYY-MM-DD'), 'DD-Mon') as date,
                AVG(CIR_1) AS cir_1,
                AVG(CIR_2) AS cir_2


                FROM SEMANTIC_PROD.ELECTROLYTE_COMPOSITION_VIEW ECV
                WHERE DATE = '{day_start_date}'
                GROUP BY 1
                """

    class CathodeDeposit:
        """ PRODUCTION """
        QUERY_1 = """
                SELECT 
                    'Cathode Production' AS production,
                    uom,
                    MAX(NORMS) AS norms,
                    ROUND(MAX(METRIC_VALUE):: NUMERIC, 2) AS on_date

                FROM
                (SELECT 'Cathode Deposit' AS KPI,
                'MT' AS UOM, date, 
                CASE
                WHEN LOWER(KPI) = 'deposit_plan' THEN SUM(METRIC_VALUE)
                END AS NORMS,
                CASE
                WHEN LOWER(KPI) = 'deposit_actual' THEN SUM(METRIC_VALUE)
                END AS METRIC_VALUE
                FROM SEMANTIC_PROD.FINAL_DEPOSIT_KPI_VIEW
                GROUP BY 1,2,3,KPI) FOO
                WHERE 
                DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1,2;
                """
        QUERY_2 = """
                SELECT 
                    'Cathode Production' AS production,
                    uom,
                    MAX(NORMS) AS norms,
                    ROUND(MAX(METRIC_VALUE):: NUMERIC, 2) AS mtd

                FROM
                (SELECT 'Cathode Deposit' AS KPI,
                'MT' AS UOM, date, 
                CASE
                WHEN LOWER(KPI) = 'deposit_plan' THEN SUM(METRIC_VALUE)
                END AS NORMS,
                CASE
                WHEN LOWER(KPI) = 'deposit_actual' THEN SUM(METRIC_VALUE)
                END AS METRIC_VALUE
                FROM SEMANTIC_PROD.FINAL_DEPOSIT_KPI_VIEW
                GROUP BY 1,2,3,KPI) FOO
                WHERE 
                DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1,2;
                """
        QUERY_3 = """
                SELECT 
                    'Cathode Production' AS production,
                    uom,
                    MAX(NORMS) AS norms,
                    ROUND(MAX(METRIC_VALUE):: NUMERIC, 2) AS ytd

                FROM
                (SELECT 'Cathode Deposit' AS KPI,
                'MT' AS UOM, date, 
                CASE
                WHEN LOWER(KPI) = 'deposit_plan' THEN SUM(METRIC_VALUE)
                END AS NORMS,
                CASE
                WHEN LOWER(KPI) = 'deposit_actual' THEN SUM(METRIC_VALUE)
                END AS METRIC_VALUE
                FROM SEMANTIC_PROD.FINAL_DEPOSIT_KPI_VIEW
                GROUP BY 1,2,3,KPI) FOO
                WHERE 
                DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1,2;
                """

    class CathodeProductionSAP:
        """ PRODUCTION """
        QUERY_1 = """
                SELECT 
                'Cathode Production SAP' AS production,
                uom,
                MAX(NORMS) AS norms,
                MAX(METRIC_VALUE) AS on_date
                
                FROM
                (SELECT KPI,
                'MT' AS UOM, date, CASE
                WHEN LOWER(KPI) = 'cathode_production_plan' THEN SUM(METRIC_VALUE)
                END AS NORMS,
                CASE
                WHEN LOWER(KPI) = 'cathode_production_actual' THEN SUM(METRIC_VALUE)
                END AS METRIC_VALUE
                FROM SEMANTIC_PROD.PRODUCTION_KPI_VIEW
                WHERE LOWER(KPI) like ('cathode_production%')
                GROUP BY 1,2,
                3,
                KPI) FOO
                WHERE DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1,2;
                """
        QUERY_2 = """
                SELECT 
                'Cathode Production SAP' AS production,
                uom,
                MAX(METRIC_VALUE) AS mtd

                FROM
                (SELECT KPI,
                'MT' AS UOM, date, CASE
                WHEN LOWER(KPI) = 'cathode_production_plan' THEN SUM(METRIC_VALUE)
                END AS NORMS,
                CASE
                WHEN LOWER(KPI) = 'cathode_production_actual' THEN SUM(METRIC_VALUE)
                END AS METRIC_VALUE
                FROM SEMANTIC_PROD.PRODUCTION_KPI_VIEW
                WHERE LOWER(KPI) like ('cathode_production%')
                GROUP BY 1,2,
                3,
                KPI) FOO
                WHERE DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1,2;
                """
        QUERY_3 = """
                SELECT 
                'Cathode Production SAP' AS production,
                uom,
                MAX(METRIC_VALUE) AS ytd

                FROM
                (SELECT KPI,
                'MT' AS UOM, date, CASE
                WHEN LOWER(KPI) = 'cathode_production_plan' THEN SUM(METRIC_VALUE)
                END AS NORMS,
                CASE
                WHEN LOWER(KPI) = 'cathode_production_actual' THEN SUM(METRIC_VALUE)
                END AS METRIC_VALUE
                FROM SEMANTIC_PROD.PRODUCTION_KPI_VIEW
                WHERE LOWER(KPI) like ('cathode_production%')
                GROUP BY 1,2,
                3,
                KPI) FOO
                WHERE DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1,2;
                """

    class DepositCellDay:
        """ PRODUCTION """
        QUERY_1 = """
                SELECT 
        'Deposit / Cell / Day' AS production,
        'MT' AS uom,
        ROUND((SUM(DEP.DEPOSIT_PLAN) / (AVG(CELLS.CELLS_PLAN) * COUNT(1)))::
        NUMERIC, 2) AS norms,
        ROUND((SUM(DEP.DEPOSIT_ACTUAL) / (AVG(CELLS.CELLS_ACTUAL) * COUNT(1)))::
        NUMERIC, 2) AS on_date

        FROM
        (SELECT date, COALESCE(MAX(CASE
        WHEN LOWER(TRIM(KPI)) = 'deposit_actual' THEN METRIC_VALUE
        END),

        0) AS DEPOSIT_ACTUAL,
        COALESCE(MAX(CASE
        WHEN LOWER(TRIM(KPI)) = 'deposit_plan' THEN METRIC_VALUE
        END),
        0) AS DEPOSIT_PLAN
        FROM SEMANTIC_PROD.FINAL_DEPOSIT_KPI_VIEW
        WHERE LOWER(TRIM(KPI)) in ('deposit_actual',
        'deposit_plan')
        GROUP BY 1)DEP
        LEFT JOIN
        (SELECT date AS POSTING_DATE,
        COALESCE(MAX(CASE
        WHEN LOWER(TRIM(KPI)) = 'operational_cells_actual' 
        THEN METRIC_VALUE
        END),
        0) AS CELLS_ACTUAL,
        COALESCE(MAX(CASE
        WHEN LOWER(TRIM(KPI)) = 'operational_cells_plan' THEN METRIC_VALUE
        END),
        0) AS CELLS_PLAN
        FROM SEMANTIC_PROD.REFINERY_OPERATIONAL_CELLS_VIEW
        WHERE LOWER(TRIM(KPI)) in ('operational_cells_actual',
        'operational_cells_plan')
        GROUP BY 1)CELLS ON DEP.DATE = CELLS.POSTING_DATE
        AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
        GROUP BY 1,2;
        """
        QUERY_2 = """
            SELECT 
        'Deposit / Cell / Day' AS production,
        'MT' AS uom,
        ROUND((SUM(DEP.DEPOSIT_ACTUAL) / (AVG(CELLS.CELLS_ACTUAL) * COUNT(1)))::
        NUMERIC, 2) AS mtd

            FROM
            (SELECT date, COALESCE(MAX(CASE
            WHEN LOWER(TRIM(KPI)) = 'deposit_actual' THEN METRIC_VALUE
            END),

            0) AS DEPOSIT_ACTUAL,
            COALESCE(MAX(CASE
            WHEN LOWER(TRIM(KPI)) = 'deposit_plan' THEN METRIC_VALUE
            END),
            0) AS DEPOSIT_PLAN
            FROM SEMANTIC_PROD.FINAL_DEPOSIT_KPI_VIEW
            WHERE LOWER(TRIM(KPI)) in ('deposit_actual',
            'deposit_plan')
            GROUP BY 1)DEP
            LEFT JOIN
            (SELECT date AS POSTING_DATE,
            COALESCE(MAX(CASE
            WHEN LOWER(TRIM(KPI)) = 'operational_cells_actual' 
            THEN METRIC_VALUE
            END),
            0) AS CELLS_ACTUAL,
            COALESCE(MAX(CASE
            WHEN LOWER(TRIM(KPI)) = 'operational_cells_plan' THEN METRIC_VALUE
            END),
            0) AS CELLS_PLAN
            FROM SEMANTIC_PROD.REFINERY_OPERATIONAL_CELLS_VIEW
            WHERE LOWER(TRIM(KPI)) in ('operational_cells_actual',
            'operational_cells_plan')
            GROUP BY 1)CELLS ON DEP.DATE = CELLS.POSTING_DATE
            AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
            GROUP BY 1,2;
            """
        QUERY_3 = """
            SELECT 
            'Deposit / Cell / Day' AS production,
            'MT' AS uom,
        ROUND((SUM(DEP.DEPOSIT_ACTUAL) / (AVG(CELLS.CELLS_ACTUAL) * COUNT(1)))::
            NUMERIC, 2) AS ytd

            FROM
            (SELECT date, COALESCE(MAX(CASE
            WHEN LOWER(TRIM(KPI)) = 'deposit_actual' THEN METRIC_VALUE
            END),

            0) AS DEPOSIT_ACTUAL,
            COALESCE(MAX(CASE
            WHEN LOWER(TRIM(KPI)) = 'deposit_plan' THEN METRIC_VALUE
            END),
            0) AS DEPOSIT_PLAN
            FROM SEMANTIC_PROD.FINAL_DEPOSIT_KPI_VIEW
            WHERE LOWER(TRIM(KPI)) in ('deposit_actual',
            'deposit_plan')
            GROUP BY 1)DEP
            LEFT JOIN
            (SELECT date AS POSTING_DATE,
            COALESCE(MAX(CASE
            WHEN LOWER(TRIM(KPI)) = 'operational_cells_actual' 
            THEN METRIC_VALUE
            END),
            0) AS CELLS_ACTUAL,
            COALESCE(MAX(CASE
            WHEN LOWER(TRIM(KPI)) = 'operational_cells_plan' THEN METRIC_VALUE
            END),
            0) AS CELLS_PLAN
            FROM SEMANTIC_PROD.REFINERY_OPERATIONAL_CELLS_VIEW
            WHERE LOWER(TRIM(KPI)) in ('operational_cells_actual',
            'operational_cells_plan')
            GROUP BY 1)CELLS ON DEP.DATE = CELLS.POSTING_DATE
            AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
            GROUP BY 1,2;
            """

    class PowerAvailabilityCir1:
        """ POWER AVAILABILITY """
        QUERY_1 = """
                SELECT 
                'Power Availability to Cir-1' AS power_availability,
                '%' AS uom,
                ROUND(AVG(AREA_ICS_HEAD_VALUE)::NUMERIC, 2) AS norms,
                ROUND(AVG(RHRSPCT)::NUMERIC, 2) AS on_date

                FROM
                (SELECT CIRCULATION,
                DATE(DATETIME) AS date,
                (OPERATION_HOURS / 24) * 100 AS RHRSPCT
                FROM SEMANTIC_PROD.DCS_DATA DD
                WHERE OPERATION_HOURS IS NOT NULL) DCS
                LEFT JOIN
                (SELECT DATE(date) AS DATETIME,
                AREA_ICS_HEAD_SELECT,
                AREA_ICS_HEAD_VALUE,
                AREA_ICS_HEAD_UOM
                FROM SEMANTIC_PROD.AREA_ICS_HEAD_REFINERY_NORMS
                WHERE LOWER(TRIM(AREA_ICS_HEAD_SELECT)) 
                LIKE ('%Power  Availability%')
                AND AREA_ICS_HEAD_VALUE IS NOT NULL
                AND DATE_PART('day',

                DATE(date)) = 1) RLB ON EXTRACT(MONTH
                FROM date) = EXTRACT(MONTH
                FROM DATE(RLB.DATETIME))
                AND EXTRACT(YEAR
                FROM date) = EXTRACT(YEAR
                FROM DATE(RLB.DATETIME))
                WHERE CIRCULATION = 'Circulation 1'
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1,2;
                """
        QUERY_2 = """
                SELECT 
                'Power Availability to Cir-1' AS power_availability,
                '%' AS uom,
                ROUND(AVG(RHRSPCT)::NUMERIC, 2) AS mtd

                FROM
                (SELECT CIRCULATION,
                DATE(DATETIME) AS date,
                (OPERATION_HOURS / 24) * 100 AS RHRSPCT
                FROM SEMANTIC_PROD.DCS_DATA DD
                WHERE OPERATION_HOURS IS NOT NULL) DCS
                LEFT JOIN
                (SELECT DATE(date) AS DATETIME,
                AREA_ICS_HEAD_SELECT,
                AREA_ICS_HEAD_VALUE,
                AREA_ICS_HEAD_UOM
                FROM SEMANTIC_PROD.AREA_ICS_HEAD_REFINERY_NORMS
                WHERE LOWER(TRIM(AREA_ICS_HEAD_SELECT)) 
                LIKE ('%Power  Availability%')
                AND AREA_ICS_HEAD_VALUE IS NOT NULL
                AND DATE_PART('day',

                DATE(date)) = 1) RLB ON EXTRACT(MONTH
                FROM date) = EXTRACT(MONTH
                FROM DATE(RLB.DATETIME))
                AND EXTRACT(YEAR
                FROM date) = EXTRACT(YEAR
                FROM DATE(RLB.DATETIME))
                WHERE CIRCULATION = 'Circulation 1'
                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1,2;
                """
        QUERY_3 = """
                SELECT 
                'Power Availability to Cir-1' AS power_availability,
                '%' AS uom,
                ROUND(AVG(RHRSPCT)::NUMERIC, 2) AS ytd

                FROM
                (SELECT CIRCULATION,
                DATE(DATETIME) AS date,
                (OPERATION_HOURS / 24) * 100 AS RHRSPCT
                FROM SEMANTIC_PROD.DCS_DATA DD
                WHERE OPERATION_HOURS IS NOT NULL) DCS
                LEFT JOIN
                (SELECT DATE(date) AS DATETIME,
                AREA_ICS_HEAD_SELECT,
                AREA_ICS_HEAD_VALUE,
                AREA_ICS_HEAD_UOM
                FROM SEMANTIC_PROD.AREA_ICS_HEAD_REFINERY_NORMS
                WHERE LOWER(TRIM(AREA_ICS_HEAD_SELECT)) 
                LIKE ('%Power  Availability%')
                AND AREA_ICS_HEAD_VALUE IS NOT NULL
                AND DATE_PART('day',

                DATE(date)) = 1) RLB ON EXTRACT(MONTH
                FROM date) = EXTRACT(MONTH
                FROM DATE(RLB.DATETIME))
                AND EXTRACT(YEAR
                FROM date) = EXTRACT(YEAR
                FROM DATE(RLB.DATETIME))
                WHERE CIRCULATION = 'Circulation 1'
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1,2;
                """

    class PowerAvailabilityCir2:
        """ POWER AVAILABILITY """
        QUERY_1 = """
        SELECT 
        'Power Availability to Cir-2' AS power_availability,
        '%' AS uom,
        ROUND(AVG(AREA_ICS_HEAD_VALUE)::NUMERIC, 2) AS norms,
        ROUND(AVG(RHRSPCT)::NUMERIC, 2) AS on_date
        
        FROM
        (SELECT CIRCULATION,
        DATE(DATETIME) AS date,
        (OPERATION_HOURS / 24) * 100 AS RHRSPCT
        FROM SEMANTIC_PROD.DCS_DATA DD
        WHERE OPERATION_HOURS IS NOT NULL) DCS
        LEFT JOIN
        (SELECT DATE(date) AS DATETIME,
        AREA_ICS_HEAD_SELECT,
        AREA_ICS_HEAD_VALUE,
        AREA_ICS_HEAD_UOM
        FROM SEMANTIC_PROD.AREA_ICS_HEAD_REFINERY_NORMS
        WHERE LOWER(TRIM(AREA_ICS_HEAD_SELECT)) like ('%Power  Availability%')
        AND AREA_ICS_HEAD_VALUE IS NOT NULL
        AND DATE_PART('day',
        
        DATE(date)) = 1) RLB ON EXTRACT(MONTH
        FROM date) = EXTRACT(MONTH
        FROM DATE(RLB.DATETIME))
        AND EXTRACT(YEAR
        FROM date) = EXTRACT(YEAR
        FROM DATE(RLB.DATETIME))
        WHERE CIRCULATION = 'Circulation 2'
        AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
        GROUP BY 1,2;
        """
        QUERY_2 = """
                SELECT 
                'Power Availability to Cir-2' AS power_availability,
                '%' AS uom,
                ROUND(AVG(RHRSPCT)::NUMERIC, 2) AS mtd

                FROM
                (SELECT CIRCULATION,
                DATE(DATETIME) AS date,
                (OPERATION_HOURS / 24) * 100 AS RHRSPCT
                FROM SEMANTIC_PROD.DCS_DATA DD
                WHERE OPERATION_HOURS IS NOT NULL) DCS
                LEFT JOIN
                (SELECT DATE(date) AS DATETIME,
                AREA_ICS_HEAD_SELECT,
                AREA_ICS_HEAD_VALUE,
                AREA_ICS_HEAD_UOM
                FROM SEMANTIC_PROD.AREA_ICS_HEAD_REFINERY_NORMS
                WHERE LOWER(TRIM(AREA_ICS_HEAD_SELECT)) like ('%Power  Availability%')
                AND AREA_ICS_HEAD_VALUE IS NOT NULL
                AND DATE_PART('day',

                DATE(date)) = 1) RLB ON EXTRACT(MONTH
                FROM date) = EXTRACT(MONTH
                FROM DATE(RLB.DATETIME))
                AND EXTRACT(YEAR
                FROM date) = EXTRACT(YEAR
                FROM DATE(RLB.DATETIME))
                WHERE CIRCULATION = 'Circulation 2'
                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1,2;
                """
        QUERY_3 = """
                SELECT 
                'Power Availability to Cir-2' AS power_availability,
                '%' AS uom,
                ROUND(AVG(RHRSPCT)::NUMERIC, 2) AS ytd

                FROM
                (SELECT CIRCULATION,
                DATE(DATETIME) AS date,
                (OPERATION_HOURS / 24) * 100 AS RHRSPCT
                FROM SEMANTIC_PROD.DCS_DATA DD
                WHERE OPERATION_HOURS IS NOT NULL) DCS
                LEFT JOIN
                (SELECT DATE(date) AS DATETIME,
                AREA_ICS_HEAD_SELECT,
                AREA_ICS_HEAD_VALUE,
                AREA_ICS_HEAD_UOM
                FROM SEMANTIC_PROD.AREA_ICS_HEAD_REFINERY_NORMS
                WHERE LOWER(TRIM(AREA_ICS_HEAD_SELECT)) like ('%Power  Availability%')
                AND AREA_ICS_HEAD_VALUE IS NOT NULL
                AND DATE_PART('day',

                DATE(date)) = 1) RLB ON EXTRACT(MONTH
                FROM date) = EXTRACT(MONTH
                FROM DATE(RLB.DATETIME))
                AND EXTRACT(YEAR
                FROM date) = EXTRACT(YEAR
                FROM DATE(RLB.DATETIME))
                WHERE CIRCULATION = 'Circulation 2'
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1,2;
                """

    class PowerAvailabilityCellHouse:
        """ POWER AVAILABILITY """
        QUERY_1 = """
        SELECT 
        'Power Availability to Cell House' AS power_availability,
        '%' AS uom,
        ROUND(AVG(AREA_ICS_HEAD_VALUE)::NUMERIC, 2) AS norms,
        ROUND(AVG(CIRPCTG)::NUMERIC, 2) AS on_date

        FROM
        (SELECT CIRCULATION,
        DATE(DATETIME) AS date,
        (AVG(OPERATION_HOURS) / 24) * 100 AS CIRPCTG
        FROM SEMANTIC_PROD.DCS_DATA DD
        WHERE OPERATION_HOURS IS NOT NULL
        GROUP BY 1,2) DCS
        LEFT JOIN
        (SELECT DATE(date) AS DATETIME,
        AREA_ICS_HEAD_SELECT,
        AREA_ICS_HEAD_VALUE,
        AREA_ICS_HEAD_UOM
        FROM SEMANTIC_PROD.AREA_ICS_HEAD_REFINERY_NORMS
        WHERE LOWER(TRIM(AREA_ICS_HEAD_SELECT)) like ('%power  availability%')
        AND AREA_ICS_HEAD_VALUE IS NOT NULL
        AND DATE_PART('day',

        DATE(date)) = 1) RLB ON EXTRACT(MONTH
        FROM date) = EXTRACT(MONTH
        FROM DATE(RLB.DATETIME))
        AND EXTRACT(YEAR
        FROM date) = EXTRACT(YEAR
        FROM DATE(RLB.DATETIME))
        AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
        GROUP BY 1,2;
                """
        QUERY_2 = """
                SELECT 
                'Power Availability to Cell House' AS power_availability,
                '%' AS uom,
                ROUND(AVG(CIRPCTG)::NUMERIC, 2) AS mtd

                FROM
                (SELECT CIRCULATION,
                DATE(DATETIME) AS date,
                (AVG(OPERATION_HOURS) / 24) * 100 AS CIRPCTG
                FROM SEMANTIC_PROD.DCS_DATA DD
                WHERE OPERATION_HOURS IS NOT NULL
                GROUP BY 1,2) DCS
                LEFT JOIN
                (SELECT DATE(date) AS DATETIME,
                AREA_ICS_HEAD_SELECT,
                AREA_ICS_HEAD_VALUE,
                AREA_ICS_HEAD_UOM
                FROM SEMANTIC_PROD.AREA_ICS_HEAD_REFINERY_NORMS
                WHERE LOWER(TRIM(AREA_ICS_HEAD_SELECT)) like ('%power  availability%')
                AND AREA_ICS_HEAD_VALUE IS NOT NULL
                AND DATE_PART('day',

                DATE(date)) = 1) RLB ON EXTRACT(MONTH
                FROM date) = EXTRACT(MONTH
                FROM DATE(RLB.DATETIME))
                AND EXTRACT(YEAR
                FROM date) = EXTRACT(YEAR
                FROM DATE(RLB.DATETIME))
                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1,2;
                        """
        QUERY_3 = """
                SELECT 
                'Power Availability to Cell House' AS power_availability,
                '%' AS uom,
                ROUND(AVG(CIRPCTG)::NUMERIC, 2) AS ytd

                FROM
                (SELECT CIRCULATION,
                DATE(DATETIME) AS date,
                (AVG(OPERATION_HOURS) / 24) * 100 AS CIRPCTG
                FROM SEMANTIC_PROD.DCS_DATA DD
                WHERE OPERATION_HOURS IS NOT NULL
                GROUP BY 1,2) DCS
                LEFT JOIN
                (SELECT DATE(date) AS DATETIME,
                AREA_ICS_HEAD_SELECT,
                AREA_ICS_HEAD_VALUE,
                AREA_ICS_HEAD_UOM
                FROM SEMANTIC_PROD.AREA_ICS_HEAD_REFINERY_NORMS
                WHERE LOWER(TRIM(AREA_ICS_HEAD_SELECT)) like ('%power  availability%')
                AND AREA_ICS_HEAD_VALUE IS NOT NULL
                AND DATE_PART('day',

                DATE(date)) = 1) RLB ON EXTRACT(MONTH
                FROM date) = EXTRACT(MONTH
                FROM DATE(RLB.DATETIME))
                AND EXTRACT(YEAR
                FROM date) = EXTRACT(YEAR
                FROM DATE(RLB.DATETIME))
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1,2;
                """

    class Cir1Cir2:
        """ CIRCULATION """
        QUERY_1 = """
                SELECT CASE
                WHEN "substring"(BTRIM(REFINERY_PRODUCTION_SELECT),
                '\d+$'::text)::numeric >= 1::numeric
                AND "substring"(BTRIM(REFINERY_PRODUCTION_SELECT),
                '\d+$'::text)::numeric <= 10::numeric THEN 'cir_1'::text
                WHEN "substring"(BTRIM(REFINERY_PRODUCTION_SELECT),
                '\d+$'::text)::numeric >= 11::numeric
                AND "substring"(BTRIM(REFINERY_PRODUCTION_SELECT),
                '\d+$'::text)::numeric <= 22::numeric THEN 'cir_2'::text
                END AS circulation,

                ROUND(AVG(REFINARY_PRODUCTION_CE)::NUMERIC, 2) AS ce,
                ROUND(SUM(REFINARY_PRODUCTION_THEORETICAL_WEIGHT)::NUMERIC, 3) 
                AS theor_weight,
                ROUND(SUM(REFINARY_PRODUCTION_ACTUAL_WEIGHT)::NUMERIC, 3) 
                AS actual_weight

                FROM SEMANTIC_PROD.BANKWISE_REFINERY_PRODUCTION
                WHERE REFINERY_PRODUCTION_SELECT IS NOT NULL
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1;
                """

    class TotalCirculation:
        """ CIRCULATION """
        QUERY_1 = """
                SELECT 
                'Total' AS circulation,
                ROUND(AVG(REFINARY_PRODUCTION_CE)::NUMERIC, 2) AS ce,
                ROUND(SUM(REFINARY_PRODUCTION_THEORETICAL_WEIGHT)::NUMERIC, 3) 
                AS theor_weight,
                ROUND(SUM(REFINARY_PRODUCTION_ACTUAL_WEIGHT)::NUMERIC, 3) 
                AS actual_weight

                FROM SEMANTIC_PROD.BANKWISE_REFINERY_PRODUCTION
                WHERE REFINERY_PRODUCTION_SELECT IS NOT NULL
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1;
                """

    class CropCir:
        """ CROP Cir 1, 2.. """
        QUERY_1 = """
                SELECT 
                CONCAT('Cir-', SUBSTRING(TRIM(DCS.CIR)
                FROM '\d+$'), ' Crop-', SUBSTRING(TRIM(DCS.CROP_NO::text)
                FROM '\d+$')) AS crop,

                COUNT(1) AS banks,
                SUM(CELLS.CELL_COUNT) AS total_cells,
                AVG(DCS.AVG_CELL_VOLTAGE) AS cell_voltage,
                SUM(NO_OF_SHORTS) AS t_shorts

                FROM
                (SELECT DATE(DATETIME) AS date,
                TRIM(CIRCULATION) AS CIR,
                MAX(CROP_NO) AS CROP_NO,
                TRIM(BANK) AS BANK,
                MAX(AVERAGE_CELL_VOLTAGE::double precision) AS AVG_CELL_VOLTAGE,
                MAX(NO_OF_SHORTS::double precision) AS NO_OF_SHORTS
                FROM SEMANTIC_PROD.DCS_DATA DD
                WHERE LOWER(TRIM(BANK)) like 'bank%'
                AND LOWER(TRIM(CIRCULATION)) in ('circulation 1',
                'circulation 2')
                GROUP BY 1,2,
                4)DCS
                LEFT JOIN
                (SELECT DATE(date) AS date,
                TRIM(BANK) AS BANK,
                CELL_COUNT::double precision
                FROM SEMANTIC_PROD.NO_OF_BANK_CELLS NOBC
                GROUP BY 1,2,
                3)CELLS ON DCS.DATE = CELLS.DATE
                AND TRIM(DCS.BANK) = TRIM(CELLS.BANK)
                WHERE DCS.DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1;
                """

    class StrippingTime:
        """ STRIPPING TIME | CSM Plate Rejection """
        QUERY_1 = """
                SELECT 
                'Stripping Time/Changeover (Till Date)' AS stripping_time,
                'hr' AS uom,
                ROUND(AVG(CASE WHEN LOWER(TRIM(CROP)) = '1st crop' 
                THEN REFINARY_PRODUCTION_STRIPPING_TIME::double precision 
                END)::NUMERIC, 2) AS "1st_crop",
                ROUND(AVG(CASE WHEN LOWER(TRIM(CROP)) = '2nd crop' 
                THEN REFINARY_PRODUCTION_STRIPPING_TIME::double precision 
                END)::NUMERIC, 2) AS "2nd_crop",
                ROUND(AVG(CASE WHEN LOWER(TRIM(CROP)) = '3rd crop' 
                THEN REFINARY_PRODUCTION_STRIPPING_TIME::double precision 
                END)::NUMERIC, 2) AS "3rd_crop"

                FROM SEMANTIC_PROD.BANKWISE_REFINERY_PRODUCTION
                WHERE LOWER(TRIM(CROP)) in ('1st crop', '2nd crop', '3rd crop')
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1,2;
                """

    class FilterAvailability:
        """ FILTER AVAILABILITY """
        QUERY_1 = """
        SELECT 
        'Filter Availability' AS filter_availability,
        '%' AS uom,
        ROUND(MAX(NORMS)::NUMERIC, 2) AS norms,
        ROUND(MAX(METRIC_VALUE)::NUMERIC, 2) AS on_date

        FROM
        (SELECT KPI,
        CASE
        WHEN LOWER(TRIM(KPI)) = 'filter_availability_plan' THEN AVG(METRIC_VALUE)
        ELSE NULL
        END AS NORMS,
        CASE
        WHEN LOWER(TRIM(KPI)) = 'filter_availability_actual' THEN AVG(METRIC_VALUE)
        ELSE NULL
        END AS METRIC_VALUE

        FROM SEMANTIC_PROD.REFINERY_FILTER_AVAILABILITY_VIEW
        WHERE LOWER(TRIM(KPI)) in ('filter_availability_actual',
        'filter_availability_plan')
        AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
        GROUP BY 1)TB
        GROUP BY 1,2
        """
        QUERY_2 = """
                SELECT 
                'Filter Availability' AS filter_availability,
                '%' AS uom,
                ROUND(MAX(METRIC_VALUE)::NUMERIC, 2) AS mtd

                FROM
                (SELECT KPI,
                CASE
                WHEN LOWER(TRIM(KPI)) = 'filter_availability_plan' THEN AVG(METRIC_VALUE)
                ELSE NULL
                END AS NORMS,
                CASE
                WHEN LOWER(TRIM(KPI)) = 'filter_availability_actual' THEN AVG(METRIC_VALUE)
                ELSE NULL
                END AS METRIC_VALUE

                FROM SEMANTIC_PROD.REFINERY_FILTER_AVAILABILITY_VIEW
                WHERE LOWER(TRIM(KPI)) in ('filter_availability_actual',
                'filter_availability_plan')
                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1)TB
                GROUP BY 1,2
                """
        QUERY_3 = """
                        SELECT 
                'Filter Availability' AS filter_availability,
                '%' AS uom,
                ROUND(MAX(METRIC_VALUE)::NUMERIC, 2) AS ytd

                FROM
                (SELECT KPI,
                CASE
                WHEN LOWER(TRIM(KPI)) = 'filter_availability_plan' THEN AVG(METRIC_VALUE)
                ELSE NULL
                END AS NORMS,
                CASE
                WHEN LOWER(TRIM(KPI)) = 'filter_availability_actual' THEN AVG(METRIC_VALUE)
                ELSE NULL
                END AS METRIC_VALUE

                FROM SEMANTIC_PROD.REFINERY_FILTER_AVAILABILITY_VIEW
                WHERE LOWER(TRIM(KPI)) in ('filter_availability_actual',
                'filter_availability_plan')
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1)TB
                GROUP BY 1,2
                """

    class FilteredVolume:
        """ FILTERED VOLUME """
        QUERY_1 = """
        SELECT 
            ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) 
            AS filter_availability
            
            FROM SEMANTIC_PROD.REFINERY_FILTER_VOLUME_VIEW RFVV
            
        WHERE LOWER(TRIM(KPI)) = 'filter_volume'
        AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
        """

    class TotalVolumeRefinery:
        """ TOTAL VOLUME REFINERY """
        QUERY_1 = """
           SELECT 
               ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) AS total_volume_refinery

               FROM SEMANTIC_PROD.REFINERY_FILTER_VOLUME_VIEW RFVV
           WHERE LOWER(TRIM(KPI)) = 'total_refinery_volume'
           AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
           """

    class CsmPlateRejection:
        """ CSM Plate Rejection """
        QUERY_1 = """
                SELECT 
                KPI as csm_plate_rejection,
                '%' AS uom,
                ROUND(((SUM(METRICS_NUMERATOR) / 
                NULLIF(SUM(METRICS_DENOMINATOR), 0)) * 100)
                ::NUMERIC, 2) AS METRIC_VALUE

                FROM SEMANTIC_PROD.CSM_PLATE_REJECTION_VIEW CPRV
                WHERE LOWER(KPI) = 'csm_plate_rejection'
                AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
                GROUP BY 1;
                """

    class SpecificEnergyConsumption:
        """ SPECIFIC ENERGY CONSUMPTION """
        QUERY_1 = """
        SELECT CASE
        WHEN TRIM(KPI) = 'Steam_Consumption_For_Machines' THEN 
        'Steam Consumption For Machines'
        WHEN TRIM(KPI) = 'Steam_Consumption_For_Cell_House' THEN 
        'Steam Consumption For Cell House'
        WHEN TRIM(KPI) = 'Steam_Consumption_Total' THEN 'Steam Consumption Total'
        WHEN TRIM(KPI) = 'Steam_CS_Plant' THEN 'Steam Consumption CS'
        WHEN TRIM(KPI) = 'Steam_NS_Plant' THEN 'Steam Consumption NS'
        WHEN TRIM(KPI) = 'Steam_MEE_Plant' THEN 'Steam Consumption MEE'
        WHEN TRIM(KPI) = 'Ancillary_Power_Consumption' THEN 
        'Ancillary Power Consumption'
        WHEN TRIM(KPI) = 'Purification_Power_Consumption' THEN 
        'Purification Power Consumption'
        WHEN TRIM(KPI) = 'Rectifier_Power_Consumption' THEN 
        'Rectifier Power Consumption'
        WHEN TRIM(KPI) = 'Power_Consumption_MEE' THEN 'Power Consumption MEE'
        WHEN TRIM(KPI) = 'Power_Consumption_CS_NS' THEN 'Power Consumption NS & CS'
        ELSE NULL
        END AS utilities_consumptions,
        
        CASE
        WHEN TRIM(KPI) in ('Steam_Consumption_For_Machines',
        'Steam_Consumption_For_Cell_House',
        'Steam_CS_Plant',
        'Steam_NS_Plant',
        'Steam_Consumption_Total') THEN 'Kg/MT'
        WHEN TRIM(KPI) in ('Ancillary_Power_Consumption',
        'Rectifier_Power_Consumption',
        'Power_Consumption_CS_NS') THEN 'KWhr/MT'
        WHEN TRIM(KPI) in ('Power_Consumption_MEE',
        'Purification_Power_Consumption') THEN 'KWhr/m3'
        WHEN TRIM(KPI) in ('Steam_MEE_Plant') THEN 'MT/m3'
        ELSE NULL
        END AS uom,
        
        ROUND(PLANNED_VALUE::NUMERIC, 2) AS norms,
        ROUND(ACTUAL_VALUE::NUMERIC, 2) AS on_date
        
        FROM
        (SELECT KPI,
        CASE
        WHEN TRIM(KPI) in ('Steam_Consumption_For_Machines',
        'Steam_Consumption_For_Cell_House',
        'Ancillary_Power_Consumption',
        'Rectifier_Power_Consumption',
        'Steam_Consumption_Total')
        AND SUM(DEPOSIT) <> 0 THEN SUM(ACTUAL_NUMERATOR) / SUM(DEPOSIT)
        WHEN TRIM(KPI) in ('Purification_Power_Consumption')
        AND SUM(PURIFICATION_VOL) <> 0 THEN SUM(ACTUAL_NUMERATOR) 
        / SUM(PURIFICATION_VOL)
        WHEN TRIM(KPI) in ('Steam_CS_Plant')
        AND SUM(CUSO4_PRODUCTION) <> 0 THEN SUM(ACTUAL_NUMERATOR) 
        / SUM(CUSO4_PRODUCTION)
        WHEN TRIM(KPI) in ('Steam_NS_Plant')
        AND SUM(NISO4_PRODUCTION) <> 0 THEN SUM(ACTUAL_NUMERATOR) 
        / SUM(NISO4_PRODUCTION)
        WHEN TRIM(KPI) in ('Power_Consumption_MEE',
        'Steam_MEE_Plant')
        AND SUM(BLEEDING_VOL_MEE) <> 0 THEN SUM(ACTUAL_NUMERATOR) 
        / SUM(BLEEDING_VOL_MEE)
        WHEN TRIM(KPI) in ('Power_Consumption_CS_NS')
        AND SUM(CUSO4_PRODUCTION + NISO4_PRODUCTION) <> 0 THEN 
        SUM(ACTUAL_NUMERATOR) / SUM(CUSO4_PRODUCTION + NISO4_PRODUCTION)
        ELSE 0
        END AS ACTUAL_VALUE,
        CASE
        WHEN TRIM(KPI) in ('Steam_CS_Plant')
        AND SUM(CUSO4_PLAN) <> 0 THEN SUM(PLANNED_VALUE) / SUM(CUSO4_PLAN)
        WHEN TRIM(KPI) in ('Steam_NS_Plant')
        AND SUM(NISO4_PLAN) <> 0 THEN SUM(PLANNED_VALUE) / SUM(NISO4_PLAN)
        WHEN TRIM(KPI) in ('Power_Consumption_MEE',
        'Steam_MEE_Plant')
        AND SUM(BLEEDING_VOL_PLAN) <> 0 THEN SUM(PLANNED_VALUE) / 
        SUM(BLEEDING_VOL_PLAN)
        WHEN TRIM(KPI) in ('Power_Consumption_CS_NS')
        AND SUM(CUSO4_PLAN + NISO4_PLAN) <> 0 THEN SUM(PLANNED_VALUE) / 
        SUM(CUSO4_PLAN + NISO4_PLAN)
        ELSE AVG(PLANNED_VALUE)
        END AS PLANNED_VALUE
        FROM SEMANTIC_PROD.REFINERY_STEAM_CONSUMPTION_KPI_VIEW RSCKV
        WHERE TRIM(KPI) in 
        (
        'Steam_Consumption_For_Machines',
        'Steam_Consumption_For_Cell_House',
        'Steam_Consumption_Total',
        'Steam_CS_Plant',
        'Steam_NS_Plant',
        'Steam_MEE_Plant',
        'Ancillary_Power_Consumption',
        'Purification_Power_Consumption',
        'Rectifier_Power_Consumption',
        'Power_Consumption_MEE',
        'Power_Consumption_CS_NS'
        )
        AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
        GROUP BY 1)TB        
        """
        QUERY_2 = """
                SELECT CASE
                WHEN TRIM(KPI) = 'Steam_Consumption_For_Machines' THEN 
                'Steam Consumption For Machines'
                WHEN TRIM(KPI) = 'Steam_Consumption_For_Cell_House' THEN 
                'Steam Consumption For Cell House'
                WHEN TRIM(KPI) = 'Steam_Consumption_Total' THEN 'Steam Consumption Total'
                WHEN TRIM(KPI) = 'Steam_CS_Plant' THEN 'Steam Consumption CS'
                WHEN TRIM(KPI) = 'Steam_NS_Plant' THEN 'Steam Consumption NS'
                WHEN TRIM(KPI) = 'Steam_MEE_Plant' THEN 'Steam Consumption MEE'
                WHEN TRIM(KPI) = 'Ancillary_Power_Consumption' THEN 
                'Ancillary Power Consumption'
                WHEN TRIM(KPI) = 'Purification_Power_Consumption' THEN 
                'Purification Power Consumption'
                WHEN TRIM(KPI) = 'Rectifier_Power_Consumption' THEN 
                'Rectifier Power Consumption'
                WHEN TRIM(KPI) = 'Power_Consumption_MEE' THEN 'Power Consumption MEE'
                WHEN TRIM(KPI) = 'Power_Consumption_CS_NS' THEN 'Power Consumption NS & CS'
                ELSE NULL
                END AS utilities_consumptions,

                ROUND(ACTUAL_VALUE::NUMERIC, 2) AS mtd

                FROM
                (SELECT KPI,
                CASE
                WHEN TRIM(KPI) in ('Steam_Consumption_For_Machines',
                'Steam_Consumption_For_Cell_House',
                'Ancillary_Power_Consumption',
                'Rectifier_Power_Consumption',
                'Steam_Consumption_Total')
                AND SUM(DEPOSIT) <> 0 THEN SUM(ACTUAL_NUMERATOR) / SUM(DEPOSIT)
                WHEN TRIM(KPI) in ('Purification_Power_Consumption')
                AND SUM(PURIFICATION_VOL) <> 0 THEN SUM(ACTUAL_NUMERATOR) 
                / SUM(PURIFICATION_VOL)
                WHEN TRIM(KPI) in ('Steam_CS_Plant')
                AND SUM(CUSO4_PRODUCTION) <> 0 THEN SUM(ACTUAL_NUMERATOR) 
                / SUM(CUSO4_PRODUCTION)
                WHEN TRIM(KPI) in ('Steam_NS_Plant')
                AND SUM(NISO4_PRODUCTION) <> 0 THEN SUM(ACTUAL_NUMERATOR) 
                / SUM(NISO4_PRODUCTION)
                WHEN TRIM(KPI) in ('Power_Consumption_MEE',
                'Steam_MEE_Plant')
                AND SUM(BLEEDING_VOL_MEE) <> 0 THEN SUM(ACTUAL_NUMERATOR) 
                / SUM(BLEEDING_VOL_MEE)
                WHEN TRIM(KPI) in ('Power_Consumption_CS_NS')
                AND SUM(CUSO4_PRODUCTION + NISO4_PRODUCTION) <> 0 THEN 
                SUM(ACTUAL_NUMERATOR) / SUM(CUSO4_PRODUCTION + NISO4_PRODUCTION)
                ELSE 0
                END AS ACTUAL_VALUE,
                CASE
                WHEN TRIM(KPI) in ('Steam_CS_Plant')
                AND SUM(CUSO4_PLAN) <> 0 THEN SUM(PLANNED_VALUE) / SUM(CUSO4_PLAN)
                WHEN TRIM(KPI) in ('Steam_NS_Plant')
                AND SUM(NISO4_PLAN) <> 0 THEN SUM(PLANNED_VALUE) / SUM(NISO4_PLAN)
                WHEN TRIM(KPI) in ('Power_Consumption_MEE',
                'Steam_MEE_Plant')
                AND SUM(BLEEDING_VOL_PLAN) <> 0 THEN SUM(PLANNED_VALUE) / 
                SUM(BLEEDING_VOL_PLAN)
                WHEN TRIM(KPI) in ('Power_Consumption_CS_NS')
                AND SUM(CUSO4_PLAN + NISO4_PLAN) <> 0 THEN SUM(PLANNED_VALUE) / 
                SUM(CUSO4_PLAN + NISO4_PLAN)
                ELSE AVG(PLANNED_VALUE)
                END AS PLANNED_VALUE
                FROM SEMANTIC_PROD.REFINERY_STEAM_CONSUMPTION_KPI_VIEW RSCKV
                WHERE TRIM(KPI) in 
                (
                'Steam_Consumption_For_Machines',
                'Steam_Consumption_For_Cell_House',
                'Steam_Consumption_Total',
                'Steam_CS_Plant',
                'Steam_NS_Plant',
                'Steam_MEE_Plant',
                'Ancillary_Power_Consumption',
                'Purification_Power_Consumption',
                'Rectifier_Power_Consumption',
                'Power_Consumption_MEE',
                'Power_Consumption_CS_NS'
                )
                AND DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1)TB        
                """
        QUERY_3 = """
                SELECT CASE
                WHEN TRIM(KPI) = 'Steam_Consumption_For_Machines' THEN 
                'Steam Consumption For Machines'
                WHEN TRIM(KPI) = 'Steam_Consumption_For_Cell_House' THEN 
                'Steam Consumption For Cell House'
                WHEN TRIM(KPI) = 'Steam_Consumption_Total' THEN 
                'Steam Consumption Total'
                WHEN TRIM(KPI) = 'Steam_CS_Plant' THEN 'Steam Consumption CS'
                WHEN TRIM(KPI) = 'Steam_NS_Plant' THEN 'Steam Consumption NS'
                WHEN TRIM(KPI) = 'Steam_MEE_Plant' THEN 'Steam Consumption MEE'
                WHEN TRIM(KPI) = 'Ancillary_Power_Consumption' THEN 
                'Ancillary Power Consumption'
                WHEN TRIM(KPI) = 'Purification_Power_Consumption' THEN 
                'Purification Power Consumption'
                WHEN TRIM(KPI) = 'Rectifier_Power_Consumption' THEN 
                'Rectifier Power Consumption'
                WHEN TRIM(KPI) = 'Power_Consumption_MEE' THEN 'Power Consumption MEE'
                WHEN TRIM(KPI) = 'Power_Consumption_CS_NS' THEN 
                'Power Consumption NS & CS'
                ELSE NULL
                END AS utilities_consumptions,

                ROUND(ACTUAL_VALUE::NUMERIC, 2) AS ytd

                FROM
                (SELECT KPI,
                CASE
                WHEN TRIM(KPI) in ('Steam_Consumption_For_Machines',
                'Steam_Consumption_For_Cell_House',
                'Ancillary_Power_Consumption',
                'Rectifier_Power_Consumption',
                'Steam_Consumption_Total')
                AND SUM(DEPOSIT) <> 0 THEN SUM(ACTUAL_NUMERATOR) / SUM(DEPOSIT)
                WHEN TRIM(KPI) in ('Purification_Power_Consumption')
                AND SUM(PURIFICATION_VOL) <> 0 THEN SUM(ACTUAL_NUMERATOR) 
                / SUM(PURIFICATION_VOL)
                WHEN TRIM(KPI) in ('Steam_CS_Plant')
                AND SUM(CUSO4_PRODUCTION) <> 0 THEN SUM(ACTUAL_NUMERATOR) 
                / SUM(CUSO4_PRODUCTION)
                WHEN TRIM(KPI) in ('Steam_NS_Plant')
                AND SUM(NISO4_PRODUCTION) <> 0 THEN SUM(ACTUAL_NUMERATOR) 
                / SUM(NISO4_PRODUCTION)
                WHEN TRIM(KPI) in ('Power_Consumption_MEE',
                'Steam_MEE_Plant')
                AND SUM(BLEEDING_VOL_MEE) <> 0 THEN SUM(ACTUAL_NUMERATOR) 
                / SUM(BLEEDING_VOL_MEE)
                WHEN TRIM(KPI) in ('Power_Consumption_CS_NS')
                AND SUM(CUSO4_PRODUCTION + NISO4_PRODUCTION) <> 0 THEN 
                SUM(ACTUAL_NUMERATOR) / SUM(CUSO4_PRODUCTION + NISO4_PRODUCTION)
                ELSE 0
                END AS ACTUAL_VALUE,
                CASE
                WHEN TRIM(KPI) in ('Steam_CS_Plant')
                AND SUM(CUSO4_PLAN) <> 0 THEN SUM(PLANNED_VALUE) / SUM(CUSO4_PLAN)
                WHEN TRIM(KPI) in ('Steam_NS_Plant')
                AND SUM(NISO4_PLAN) <> 0 THEN SUM(PLANNED_VALUE) / SUM(NISO4_PLAN)
                WHEN TRIM(KPI) in ('Power_Consumption_MEE',
                'Steam_MEE_Plant')
                AND SUM(BLEEDING_VOL_PLAN) <> 0 THEN SUM(PLANNED_VALUE) / 
                SUM(BLEEDING_VOL_PLAN)
                WHEN TRIM(KPI) in ('Power_Consumption_CS_NS')
                AND SUM(CUSO4_PLAN + NISO4_PLAN) <> 0 THEN SUM(PLANNED_VALUE) / 
                SUM(CUSO4_PLAN + NISO4_PLAN)
                ELSE AVG(PLANNED_VALUE)
                END AS PLANNED_VALUE
                FROM SEMANTIC_PROD.REFINERY_STEAM_CONSUMPTION_KPI_VIEW RSCKV
                WHERE TRIM(KPI) in 
                (
                'Steam_Consumption_For_Machines',
                'Steam_Consumption_For_Cell_House',
                'Steam_Consumption_Total',
                'Steam_CS_Plant',
                'Steam_NS_Plant',
                'Steam_MEE_Plant',
                'Ancillary_Power_Consumption',
                'Purification_Power_Consumption',
                'Rectifier_Power_Consumption',
                'Power_Consumption_MEE',
                'Power_Consumption_CS_NS'
                )
                AND DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1)TB        
                """

    class SuspendedSolidsCir1:
        """ SUSPENDED SOLIDS """
        QUERY_1 = """
            SELECT
                CASE
                WHEN TRIM(CIRCULATION::text) = '1' THEN PARAMETERS_NAME
                ELSE NULL
                END AS "cir_1",
                
                MAX(CASE
                WHEN TRIM(CIRCULATION::text) = '1' THEN 
                PARAMETERS_VALUES::double precision
                END) AS cir_1_values
                
                FROM SEMANTIC_PROD.FACT_CUSTOM_PARAMETERS FCP
            WHERE TRIM(CIRCULATION::text) = '1'
            AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
            GROUP BY 1
            """

    class SuspendedSolidsCir2:
        """ SUSPENDED SOLIDS """
        QUERY_1 = """
            SELECT CASE
                WHEN TRIM(CIRCULATION::text) = '2' THEN PARAMETERS_NAME
                ELSE NULL
                END AS "cir_2",
                MAX(CASE
                WHEN TRIM(CIRCULATION::text) = '2' THEN 
                PARAMETERS_VALUES::double precision
                END) AS cir_2_values
                
                FROM SEMANTIC_PROD.FACT_CUSTOM_PARAMETERS FCP
            WHERE TRIM(CIRCULATION::text) = '2'
            AND DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
            GROUP BY 1
            """

    class PmCompliance:
        """ PM COMPLIANCE """
        QUERY_1 = """
        SELECT 
        CATEGORY as pm_compliance,
        ROUND(((SUM(NUMERATOR) / NULLIF(SUM(DENOMINATOR), 0)) * 100)::
        NUMERIC, 2) AS on_date
        
        FROM
        (SELECT date, CASE
        WHEN TRIM(CATEGORY) = 'rfny' THEN 'o01'
        ELSE CATEGORY
        END AS CATEGORY,
        SUM(PM_COMPLIANCE_CREATED) AS DENOMINATOR,
        SUM(PM_COMPLIANCE_COMPLETED) AS NUMERATOR
        FROM
        (SELECT DATE(BASIC_START_DATE) AS date,
        LOWER(TRIM(AUTHORIZE_GROUP)) AS CATEGORY,
        COALESCE(CASE
        WHEN LOWER(TRIM(COMP_COMPLETED)) = 'x'
        OR LOWER(TRIM(COMP_CLOSED)) = 'x' THEN COUNT(ORDER_ID)::double precision
        ELSE NULL
        END,
        
        0) AS PM_COMPLIANCE_COMPLETED,
        COALESCE(CASE
        WHEN LOWER(TRIM(COMP_COMPLETED)) <> 'x'
        OR LOWER(TRIM(COMP_CLOSED)) <> 'x' THEN COUNT(ORDER_ID)::double precision
        ELSE NULL
        END,
        
        0) AS PM_COMPLIANCE_CREATED
        FROM SEMANTIC_PROD.FACT_PM_COMPLIANCE
        WHERE LOWER(TRIM(AUTHORIZE_GROUP)) in 
        ('m01',
        'e01',
        'rfny')
        AND PLANNING_PANT::text = '1200'::text
        GROUP BY 1,
        2,
        COMP_COMPLETED,
        COMP_CLOSED) TB
        GROUP BY 1,2)COMP
        WHERE DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
        GROUP BY 1
        """
        QUERY_2 = """
                SELECT 
                CATEGORY as pm_compliance,
                ROUND(((SUM(NUMERATOR) / NULLIF(SUM(DENOMINATOR), 0)) * 100)::
                NUMERIC, 2) AS mtd

                FROM
                (SELECT date, CASE
                WHEN TRIM(CATEGORY) = 'rfny' THEN 'o01'
                ELSE CATEGORY
                END AS CATEGORY,
                SUM(PM_COMPLIANCE_CREATED) AS DENOMINATOR,
                SUM(PM_COMPLIANCE_COMPLETED) AS NUMERATOR
                FROM
                (SELECT DATE(BASIC_START_DATE) AS date,
                LOWER(TRIM(AUTHORIZE_GROUP)) AS CATEGORY,
                COALESCE(CASE
                WHEN LOWER(TRIM(COMP_COMPLETED)) = 'x'
                OR LOWER(TRIM(COMP_CLOSED)) = 'x' THEN COUNT(ORDER_ID)::
                double precision
                ELSE NULL
                END,

                0) AS PM_COMPLIANCE_COMPLETED,
                COALESCE(CASE
                WHEN LOWER(TRIM(COMP_COMPLETED)) <> 'x'
                OR LOWER(TRIM(COMP_CLOSED)) <> 'x' THEN COUNT(ORDER_ID)::
                double precision
                ELSE NULL
                END,

                0) AS PM_COMPLIANCE_CREATED
                FROM SEMANTIC_PROD.FACT_PM_COMPLIANCE
                WHERE LOWER(TRIM(AUTHORIZE_GROUP)) in 
                ('m01',
                'e01',
                'rfny')
                AND PLANNING_PANT::text = '1200'::text
                GROUP BY 1,
                2,
                COMP_COMPLETED,
                COMP_CLOSED) TB
                GROUP BY 1,2)COMP
                WHERE DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1
                """
        QUERY_3 = """
                SELECT 
                CATEGORY as pm_compliance,
                ROUND(((SUM(NUMERATOR) / NULLIF(SUM(DENOMINATOR), 0)) * 100)::
                NUMERIC, 2) AS ytd

                FROM
                (SELECT date, CASE
                WHEN TRIM(CATEGORY) = 'rfny' THEN 'o01'
                ELSE CATEGORY
                END AS CATEGORY,
                SUM(PM_COMPLIANCE_CREATED) AS DENOMINATOR,
                SUM(PM_COMPLIANCE_COMPLETED) AS NUMERATOR
                FROM
                (SELECT DATE(BASIC_START_DATE) AS date,
                LOWER(TRIM(AUTHORIZE_GROUP)) AS CATEGORY,
                COALESCE(CASE
                WHEN LOWER(TRIM(COMP_COMPLETED)) = 'x'
                OR LOWER(TRIM(COMP_CLOSED)) = 'x' THEN COUNT(ORDER_ID)::
                double precision
                ELSE NULL
                END,

                0) AS PM_COMPLIANCE_COMPLETED,
                COALESCE(CASE
                WHEN LOWER(TRIM(COMP_COMPLETED)) <> 'x'
                OR LOWER(TRIM(COMP_CLOSED)) <> 'x' THEN COUNT(ORDER_ID)::
                double precision
                ELSE NULL
                END,

                0) AS PM_COMPLIANCE_CREATED
                FROM SEMANTIC_PROD.FACT_PM_COMPLIANCE
                WHERE LOWER(TRIM(AUTHORIZE_GROUP)) in 
                ('m01',
                'e01',
                'rfny')
                AND PLANNING_PANT::text = '1200'::text
                GROUP BY 1,
                2,
                COMP_COMPLETED,
                COMP_CLOSED) TB
                GROUP BY 1,2)COMP
                WHERE DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1
                """

    class DepositLossGainDetails:
        """ DEPOSIT LOSS (-) / GAIN (+) DETAILS """
        QUERY_1 = """
        SELECT KPI AS category,
        ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) AS on_date
            
            FROM
            (SELECT 'Shut Down Losses' AS KPI,
            COALESCE(SHUTDOWN_LOSSES::double precision,
            0) AS METRIC_VALUE, date
            FROM SEMANTIC_PROD.FINAL_DEPOSIT_LOSS_GAIN_VIEW
            UNION ALL SELECT 'Anode Availability' AS KPI,
            COALESCE(ANODE_AVAILABILITY::double precision,
            0) AS METRIC_VALUE, date
            FROM SEMANTIC_PROD.FINAL_DEPOSIT_LOSS_GAIN_VIEW
            UNION ALL SELECT 'Power Availability' AS KPI,
            COALESCE(POWER_AVAILABILITY::double precision,
            0) AS METRIC_VALUE, date
            FROM SEMANTIC_PROD.FINAL_DEPOSIT_LOSS_GAIN_VIEW
            UNION ALL SELECT 'Current Density' AS KPI,
            COALESCE(CURRENT_DENSITY::double precision,
            0) AS METRIC_VALUE, date
            FROM SEMANTIC_PROD.FINAL_DEPOSIT_LOSS_GAIN_VIEW
            UNION ALL SELECT 'Time Efficiency' AS KPI,
            COALESCE(TIME_EFFICIENCY::double precision,
            0) AS METRIC_VALUE, date
            FROM SEMANTIC_PROD.FINAL_DEPOSIT_LOSS_GAIN_VIEW
            UNION ALL SELECT 'Current Efficiency' AS KPI,
            COALESCE(CURRENT_EFFICIENCY::double precision,
            0) AS METRIC_VALUE, date
            FROM SEMANTIC_PROD.FINAL_DEPOSIT_LOSS_GAIN_VIEW
            UNION ALL SELECT 'Total Loss / Gain' AS KPI,
            COALESCE(SHUTDOWN_LOSSES::double precision,
            0) + COALESCE(ANODE_AVAILABILITY::double precision,
            0) + COALESCE(CURRENT_EFFICIENCY::double precision,
            0) + COALESCE(TIME_EFFICIENCY::double precision,
            0) + COALESCE(CURRENT_DENSITY::double precision,
            0) + COALESCE(POWER_AVAILABILITY::double precision,
            0) AS METRIC_VALUE, date
            FROM SEMANTIC_PROD.FINAL_DEPOSIT_LOSS_GAIN_VIEW) TB
            
            WHERE DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
            GROUP BY 1
        """
        QUERY_2 = """
            SELECT KPI AS category,
                ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) AS mtd

                FROM
                (SELECT 'Shut Down Losses' AS KPI,
                COALESCE(SHUTDOWN_LOSSES::double precision,
                0) AS METRIC_VALUE, date
                FROM SEMANTIC_PROD.FINAL_DEPOSIT_LOSS_GAIN_VIEW
                UNION ALL SELECT 'Anode Availability' AS KPI,
                COALESCE(ANODE_AVAILABILITY::double precision,
                0) AS METRIC_VALUE, date
                FROM SEMANTIC_PROD.FINAL_DEPOSIT_LOSS_GAIN_VIEW
                UNION ALL SELECT 'Power Availability' AS KPI,
                COALESCE(POWER_AVAILABILITY::double precision,
                0) AS METRIC_VALUE, date
                FROM SEMANTIC_PROD.FINAL_DEPOSIT_LOSS_GAIN_VIEW
                UNION ALL SELECT 'Current Density' AS KPI,
                COALESCE(CURRENT_DENSITY::double precision,
                0) AS METRIC_VALUE, date
                FROM SEMANTIC_PROD.FINAL_DEPOSIT_LOSS_GAIN_VIEW
                UNION ALL SELECT 'Time Efficiency' AS KPI,
                COALESCE(TIME_EFFICIENCY::double precision,
                0) AS METRIC_VALUE, date
                FROM SEMANTIC_PROD.FINAL_DEPOSIT_LOSS_GAIN_VIEW
                UNION ALL SELECT 'Current Efficiency' AS KPI,
                COALESCE(CURRENT_EFFICIENCY::double precision,
                0) AS METRIC_VALUE, date
                FROM SEMANTIC_PROD.FINAL_DEPOSIT_LOSS_GAIN_VIEW
                UNION ALL SELECT 'Total Loss / Gain' AS KPI,
                COALESCE(SHUTDOWN_LOSSES::double precision,
                0) + COALESCE(ANODE_AVAILABILITY::double precision,
                0) + COALESCE(CURRENT_EFFICIENCY::double precision,
                0) + COALESCE(TIME_EFFICIENCY::double precision,
                0) + COALESCE(CURRENT_DENSITY::double precision,
                0) + COALESCE(POWER_AVAILABILITY::double precision,
                0) AS METRIC_VALUE, date
                FROM SEMANTIC_PROD.FINAL_DEPOSIT_LOSS_GAIN_VIEW) TB

                WHERE DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1
                """
        QUERY_3 = """
                SELECT KPI AS category,
                ROUND(SUM(METRIC_VALUE)::NUMERIC, 2) AS ytd

                FROM
                (SELECT 'Shut Down Losses' AS KPI,
                COALESCE(SHUTDOWN_LOSSES::double precision,
                0) AS METRIC_VALUE, date
                FROM SEMANTIC_PROD.FINAL_DEPOSIT_LOSS_GAIN_VIEW
                UNION ALL SELECT 'Anode Availability' AS KPI,
                COALESCE(ANODE_AVAILABILITY::double precision,
                0) AS METRIC_VALUE, date
                FROM SEMANTIC_PROD.FINAL_DEPOSIT_LOSS_GAIN_VIEW
                UNION ALL SELECT 'Power Availability' AS KPI,
                COALESCE(POWER_AVAILABILITY::double precision,
                0) AS METRIC_VALUE, date
                FROM SEMANTIC_PROD.FINAL_DEPOSIT_LOSS_GAIN_VIEW
                UNION ALL SELECT 'Current Density' AS KPI,
                COALESCE(CURRENT_DENSITY::double precision,
                0) AS METRIC_VALUE, date
                FROM SEMANTIC_PROD.FINAL_DEPOSIT_LOSS_GAIN_VIEW
                UNION ALL SELECT 'Time Efficiency' AS KPI,
                COALESCE(TIME_EFFICIENCY::double precision,
                0) AS METRIC_VALUE, date
                FROM SEMANTIC_PROD.FINAL_DEPOSIT_LOSS_GAIN_VIEW
                UNION ALL SELECT 'Current Efficiency' AS KPI,
                COALESCE(CURRENT_EFFICIENCY::double precision,
                0) AS METRIC_VALUE, date
                FROM SEMANTIC_PROD.FINAL_DEPOSIT_LOSS_GAIN_VIEW
                UNION ALL SELECT 'Total Loss / Gain' AS KPI,
                COALESCE(SHUTDOWN_LOSSES::double precision,
                0) + COALESCE(ANODE_AVAILABILITY::double precision,
                0) + COALESCE(CURRENT_EFFICIENCY::double precision,
                0) + COALESCE(TIME_EFFICIENCY::double precision,
                0) + COALESCE(CURRENT_DENSITY::double precision,
                0) + COALESCE(POWER_AVAILABILITY::double precision,
                0) AS METRIC_VALUE, date
                FROM SEMANTIC_PROD.FINAL_DEPOSIT_LOSS_GAIN_VIEW) TB

                WHERE DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1
            """

    class BleedingSection:
        """ BLEEDING SECTION """
        QUERY_1 = """
        SELECT 
        KPI as bleeding_section,
        MAX(UOM) as uom,

        CASE
        WHEN TRIM(KPI) in ('Purification Rectifier Avg. Current',
        'Purification Rectifier Running Hours') THEN MAX(TARGET)
        ELSE SUM(TARGET)
        END AS on_date_target,

        CASE
        WHEN TRIM(KPI) in ('Purification Rectifier Avg. Current',
        'Purification Rectifier Running Hours') THEN AVG(ACTUAL)
        ELSE SUM(ACTUAL)
        END AS on_date_actual

        FROM
        (SELECT DATE(DATETIME) AS date,
        'Purification Rectifier Avg. Current' AS KPI,
        'KAmp' AS UOM,
        0::double precision AS TARGET,
        MAX(CURRENT_AVG::double precision) AS ACTUAL
        FROM SEMANTIC_PROD.DCS_DATA
        WHERE LOWER(TRIM(BANK)) = 'purification cell'
        GROUP BY 1,2,
        3,4
        UNION ALL SELECT DATE(DATETIME) AS date,
        'Purification Rectifier Running Hours' AS KPI,
        'KAmp' AS UOM,
        0::double precision AS TARGET,
        MAX(RUNNING_HOURS::double precision) AS ACTUAL
        FROM SEMANTIC_PROD.DCS_DATA
        WHERE LOWER(TRIM(BANK)) = 'purification cell'
        GROUP BY 1,2,
        3,4
        UNION ALL SELECT COALESCE(ACT.POSTING_DATE,

        PL.DATE) AS date,
        'Volume Treated In Purification Cells ' AS KPI,
        COALESCE(ACT.UOM,

        PL.UOM) AS UOM,
        PL.PLAN_VAL AS TARGET,
        COALESCE(ACT.ACTUAL,
        0) AS ACTUAL
        FROM
        (SELECT DATE(REFINERY_DAILY_PURIFICATION.DATE) AS POSTING_DATE,
        REFINERY_DAILY_PURIFICATION.UNITS AS UOM,
        COALESCE(REFINERY_DAILY_PURIFICATION.PURIFICATION_SECTION_ACTUAL::numeric,

        0::numeric) AS ACTUAL
        FROM SEMANTIC_PROD.REFINERY_DAILY_PURIFICATION
        WHERE LOWER(BTRIM(REFINERY_DAILY_PURIFICATION.
        PURIFICATION_SECTION_SELECT::text)) = 
         'volume treated in do cells'::text
        AND DATE(REFINERY_DAILY_PURIFICATION.DATE) > '2023-07-31'::date
        GROUP BY 1,
        2,
        3)ACT
        FULL JOIN
        (SELECT DD.DATE_DT AS date,
        TRIM(UNITS) AS UOM,
        COALESCE(PURIFICATION_SECTION_PLAN::double precision,

        0) AS PLAN_VAL
        FROM SEMANTIC_PROD.PRODUCTION_PURIFICATION_SECTION PPS
        LEFT JOIN
        (SELECT DIM_DATE.DATE_DT,
        DIM_DATE.MONTH_OF_YR_NUM AS MNTH,
        DIM_DATE.YR_NAME AS YR
        FROM SEMANTIC_PROD.DIM_DATE) DD ON DATE_PART('month',

        DATE(PPS.DATE)) = DD.MNTH
        AND DATE_PART('year',

        DATE(PPS.DATE)) = DD.YR
        WHERE LOWER(TRIM(PPS.PURIFICATION_SECTION_SELECT)) = 
         'volume treated in do cells'
        AND DATE_PART('day',

        DATE(PPS.DATE)) = 1 )PL ON ACT.POSTING_DATE = PL.DATE
        GROUP BY 1,2,
        3,4,
        5
        UNION ALL SELECT DATE(SLIME_NSP_CSNS_AND_MEE.DATE) AS date,
        'Bleeding volume in MEE'::text AS KPI,
        SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_SELECT1 AS UOM,
        COALESCE(CSNS_MEE_PLAN::double precision,
        0) AS TARGET,
        COALESCE(SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_ACTUAL::numeric,

        0::numeric) AS ACTUAL
        FROM SEMANTIC_PROD.SLIME_NSP_CSNS_AND_MEE
        WHERE LOWER(BTRIM(SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_SELECT::text))
         = 'bleeding volume in mee plant'::text
        GROUP BY 1,2,
        3,4,
        5
        UNION ALL SELECT DATE(SLIME_NSP_CSNS_AND_MEE.DATE) AS date,
        'Evaporation in MEE Plant'::text AS KPI,
        SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_SELECT1 AS UOM,
        COALESCE(CSNS_MEE_PLAN::double precision,
        0) AS TARGET,
        COALESCE(SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_ACTUAL::numeric,

        0::numeric) AS ACTUAL
        FROM SEMANTIC_PROD.SLIME_NSP_CSNS_AND_MEE
        WHERE LOWER(BTRIM(SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_SELECT::text)) 
         = 'evaporated volume in mee plant'::text
        GROUP BY 1,2,
        3,4,
        5
        UNION ALL SELECT DATE(SLIME_NSP_CSNS_AND_MEE.DATE) AS date,
        'Bleeding Volume CS'::text AS KPI,
        SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_SELECT1 AS UOM,
        COALESCE(CSNS_MEE_PLAN::double precision,
        0) AS TARGET,
        COALESCE(SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_ACTUAL::numeric,

        0::numeric) AS ACTUAL
        FROM SEMANTIC_PROD.SLIME_NSP_CSNS_AND_MEE
        WHERE LOWER(BTRIM(SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_SELECT::text)) 
         = 'bleeding volume in cs plant'::text
        GROUP BY 1,2,
        3,4,
        5
        UNION ALL SELECT DATE(SLIME_NSP_CSNS_AND_MEE.DATE) AS date,
        'Bleeding Volume NS'::text AS KPI,
        SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_SELECT1 AS UOM,
        COALESCE(CSNS_MEE_PLAN::double precision,
        0) AS TARGET,
        COALESCE(SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_ACTUAL::numeric,

        0::numeric) AS ACTUAL
        FROM SEMANTIC_PROD.SLIME_NSP_CSNS_AND_MEE
        WHERE LOWER(BTRIM(SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_SELECT::text)) 
         = 'bleeding volume in ns plant'::text
        GROUP BY 1,2,
        3,4,
        5)BLEED

        WHERE DATE BETWEEN '{day_start_date}' AND '{day_end_date}'
        GROUP BY 1
        """
        QUERY_2 = """
                SELECT 
                KPI as bleeding_section,

                CASE
                WHEN TRIM(KPI) in ('Purification Rectifier Avg. Current',
                'Purification Rectifier Running Hours') THEN MAX(TARGET)
                ELSE SUM(TARGET)
                END AS mtd_target,

                CASE
                WHEN TRIM(KPI) in ('Purification Rectifier Avg. Current',
                'Purification Rectifier Running Hours') THEN AVG(ACTUAL)
                ELSE SUM(ACTUAL)
                END AS mtd_actual

                FROM
                (SELECT DATE(DATETIME) AS date,
                'Purification Rectifier Avg. Current' AS KPI,
                'KAmp' AS UOM,
                0::double precision AS TARGET,
                MAX(CURRENT_AVG::double precision) AS ACTUAL
                FROM SEMANTIC_PROD.DCS_DATA
                WHERE LOWER(TRIM(BANK)) = 'purification cell'
                GROUP BY 1,2,
                3,4
                UNION ALL SELECT DATE(DATETIME) AS date,
                'Purification Rectifier Running Hours' AS KPI,
                'KAmp' AS UOM,
                0::double precision AS TARGET,
                MAX(RUNNING_HOURS::double precision) AS ACTUAL
                FROM SEMANTIC_PROD.DCS_DATA
                WHERE LOWER(TRIM(BANK)) = 'purification cell'
                GROUP BY 1,2,
                3,4
                UNION ALL SELECT COALESCE(ACT.POSTING_DATE,

                PL.DATE) AS date,
                'Volume Treated In Purification Cells ' AS KPI,
                COALESCE(ACT.UOM,

                PL.UOM) AS UOM,
                PL.PLAN_VAL AS TARGET,
                COALESCE(ACT.ACTUAL,
                0) AS ACTUAL
                FROM
                (SELECT DATE(REFINERY_DAILY_PURIFICATION.DATE) AS POSTING_DATE,
                REFINERY_DAILY_PURIFICATION.UNITS AS UOM,
                COALESCE(REFINERY_DAILY_PURIFICATION.PURIFICATION_SECTION_ACTUAL::numeric,

                0::numeric) AS ACTUAL
                FROM SEMANTIC_PROD.REFINERY_DAILY_PURIFICATION
                WHERE LOWER(BTRIM(REFINERY_DAILY_PURIFICATION.
                PURIFICATION_SECTION_SELECT::text)) = 
                 'volume treated in do cells'::text
                AND DATE(REFINERY_DAILY_PURIFICATION.DATE) > '2023-07-31'::date
                GROUP BY 1,
                2,
                3)ACT
                FULL JOIN
                (SELECT DD.DATE_DT AS date,
                TRIM(UNITS) AS UOM,
                COALESCE(PURIFICATION_SECTION_PLAN::double precision,

                0) AS PLAN_VAL
                FROM SEMANTIC_PROD.PRODUCTION_PURIFICATION_SECTION PPS
                LEFT JOIN
                (SELECT DIM_DATE.DATE_DT,
                DIM_DATE.MONTH_OF_YR_NUM AS MNTH,
                DIM_DATE.YR_NAME AS YR
                FROM SEMANTIC_PROD.DIM_DATE) DD ON DATE_PART('month',

                DATE(PPS.DATE)) = DD.MNTH
                AND DATE_PART('year',

                DATE(PPS.DATE)) = DD.YR
                WHERE LOWER(TRIM(PPS.PURIFICATION_SECTION_SELECT)) = 
                 'volume treated in do cells'
                AND DATE_PART('day',

                DATE(PPS.DATE)) = 1 )PL ON ACT.POSTING_DATE = PL.DATE
                GROUP BY 1,2,
                3,4,
                5
                UNION ALL SELECT DATE(SLIME_NSP_CSNS_AND_MEE.DATE) AS date,
                'Bleeding volume in MEE'::text AS KPI,
                SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_SELECT1 AS UOM,
                COALESCE(CSNS_MEE_PLAN::double precision,
                0) AS TARGET,
                COALESCE(SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_ACTUAL::numeric,

                0::numeric) AS ACTUAL
                FROM SEMANTIC_PROD.SLIME_NSP_CSNS_AND_MEE
                WHERE LOWER(BTRIM(SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_SELECT::text))
                 = 'bleeding volume in mee plant'::text
                GROUP BY 1,2,
                3,4,
                5
                UNION ALL SELECT DATE(SLIME_NSP_CSNS_AND_MEE.DATE) AS date,
                'Evaporation in MEE Plant'::text AS KPI,
                SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_SELECT1 AS UOM,
                COALESCE(CSNS_MEE_PLAN::double precision,
                0) AS TARGET,
                COALESCE(SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_ACTUAL::numeric,

                0::numeric) AS ACTUAL
                FROM SEMANTIC_PROD.SLIME_NSP_CSNS_AND_MEE
                WHERE LOWER(BTRIM(SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_SELECT::text)) 
                 = 'evaporated volume in mee plant'::text
                GROUP BY 1,2,
                3,4,
                5
                UNION ALL SELECT DATE(SLIME_NSP_CSNS_AND_MEE.DATE) AS date,
                'Bleeding Volume CS'::text AS KPI,
                SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_SELECT1 AS UOM,
                COALESCE(CSNS_MEE_PLAN::double precision,
                0) AS TARGET,
                COALESCE(SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_ACTUAL::numeric,

                0::numeric) AS ACTUAL
                FROM SEMANTIC_PROD.SLIME_NSP_CSNS_AND_MEE
                WHERE LOWER(BTRIM(SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_SELECT::text)) 
                 = 'bleeding volume in cs plant'::text
                GROUP BY 1,2,
                3,4,
                5
                UNION ALL SELECT DATE(SLIME_NSP_CSNS_AND_MEE.DATE) AS date,
                'Bleeding Volume NS'::text AS KPI,
                SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_SELECT1 AS UOM,
                COALESCE(CSNS_MEE_PLAN::double precision,
                0) AS TARGET,
                COALESCE(SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_ACTUAL::numeric,

                0::numeric) AS ACTUAL
                FROM SEMANTIC_PROD.SLIME_NSP_CSNS_AND_MEE
                WHERE LOWER(BTRIM(SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_SELECT::text)) 
                 = 'bleeding volume in ns plant'::text
                GROUP BY 1,2,
                3,4,
                5)BLEED

                WHERE DATE BETWEEN '{month_start_date}' AND '{month_end_date}'
                GROUP BY 1
                """
        QUERY_3 = """
                SELECT 
                KPI as bleeding_section,

                CASE
                WHEN TRIM(KPI) in ('Purification Rectifier Avg. Current',
                'Purification Rectifier Running Hours') THEN MAX(TARGET)
                ELSE SUM(TARGET)
                END AS ytd_target,

                CASE
                WHEN TRIM(KPI) in ('Purification Rectifier Avg. Current',
                'Purification Rectifier Running Hours') THEN AVG(ACTUAL)
                ELSE SUM(ACTUAL)
                END AS ytd_actual

                FROM
                (SELECT DATE(DATETIME) AS date,
                'Purification Rectifier Avg. Current' AS KPI,
                'KAmp' AS UOM,
                0::double precision AS TARGET,
                MAX(CURRENT_AVG::double precision) AS ACTUAL
                FROM SEMANTIC_PROD.DCS_DATA
                WHERE LOWER(TRIM(BANK)) = 'purification cell'
                GROUP BY 1,2,
                3,4
                UNION ALL SELECT DATE(DATETIME) AS date,
                'Purification Rectifier Running Hours' AS KPI,
                'KAmp' AS UOM,
                0::double precision AS TARGET,
                MAX(RUNNING_HOURS::double precision) AS ACTUAL
                FROM SEMANTIC_PROD.DCS_DATA
                WHERE LOWER(TRIM(BANK)) = 'purification cell'
                GROUP BY 1,2,
                3,4
                UNION ALL SELECT COALESCE(ACT.POSTING_DATE,

                PL.DATE) AS date,
                'Volume Treated In Purification Cells ' AS KPI,
                COALESCE(ACT.UOM,

                PL.UOM) AS UOM,
                PL.PLAN_VAL AS TARGET,
                COALESCE(ACT.ACTUAL,
                0) AS ACTUAL
                FROM
                (SELECT DATE(REFINERY_DAILY_PURIFICATION.DATE) AS POSTING_DATE,
                REFINERY_DAILY_PURIFICATION.UNITS AS UOM,
                COALESCE(REFINERY_DAILY_PURIFICATION.PURIFICATION_SECTION_ACTUAL::numeric,

                0::numeric) AS ACTUAL
                FROM SEMANTIC_PROD.REFINERY_DAILY_PURIFICATION
                WHERE LOWER(BTRIM(REFINERY_DAILY_PURIFICATION.
                PURIFICATION_SECTION_SELECT::text)) = 
                 'volume treated in do cells'::text
                AND DATE(REFINERY_DAILY_PURIFICATION.DATE) > '2023-07-31'::date
                GROUP BY 1,
                2,
                3)ACT
                FULL JOIN
                (SELECT DD.DATE_DT AS date,
                TRIM(UNITS) AS UOM,
                COALESCE(PURIFICATION_SECTION_PLAN::double precision,

                0) AS PLAN_VAL
                FROM SEMANTIC_PROD.PRODUCTION_PURIFICATION_SECTION PPS
                LEFT JOIN
                (SELECT DIM_DATE.DATE_DT,
                DIM_DATE.MONTH_OF_YR_NUM AS MNTH,
                DIM_DATE.YR_NAME AS YR
                FROM SEMANTIC_PROD.DIM_DATE) DD ON DATE_PART('month',

                DATE(PPS.DATE)) = DD.MNTH
                AND DATE_PART('year',

                DATE(PPS.DATE)) = DD.YR
                WHERE LOWER(TRIM(PPS.PURIFICATION_SECTION_SELECT)) = 
                 'volume treated in do cells'
                AND DATE_PART('day',

                DATE(PPS.DATE)) = 1 )PL ON ACT.POSTING_DATE = PL.DATE
                GROUP BY 1,2,
                3,4,
                5
                UNION ALL SELECT DATE(SLIME_NSP_CSNS_AND_MEE.DATE) AS date,
                'Bleeding volume in MEE'::text AS KPI,
                SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_SELECT1 AS UOM,
                COALESCE(CSNS_MEE_PLAN::double precision,
                0) AS TARGET,
                COALESCE(SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_ACTUAL::numeric,

                0::numeric) AS ACTUAL
                FROM SEMANTIC_PROD.SLIME_NSP_CSNS_AND_MEE
                WHERE LOWER(BTRIM(SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_SELECT::text))
                 = 'bleeding volume in mee plant'::text
                GROUP BY 1,2,
                3,4,
                5
                UNION ALL SELECT DATE(SLIME_NSP_CSNS_AND_MEE.DATE) AS date,
                'Evaporation in MEE Plant'::text AS KPI,
                SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_SELECT1 AS UOM,
                COALESCE(CSNS_MEE_PLAN::double precision,
                0) AS TARGET,
                COALESCE(SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_ACTUAL::numeric,

                0::numeric) AS ACTUAL
                FROM SEMANTIC_PROD.SLIME_NSP_CSNS_AND_MEE
                WHERE LOWER(BTRIM(SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_SELECT::text)) 
                 = 'evaporated volume in mee plant'::text
                GROUP BY 1,2,
                3,4,
                5
                UNION ALL SELECT DATE(SLIME_NSP_CSNS_AND_MEE.DATE) AS date,
                'Bleeding Volume CS'::text AS KPI,
                SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_SELECT1 AS UOM,
                COALESCE(CSNS_MEE_PLAN::double precision,
                0) AS TARGET,
                COALESCE(SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_ACTUAL::numeric,

                0::numeric) AS ACTUAL
                FROM SEMANTIC_PROD.SLIME_NSP_CSNS_AND_MEE
                WHERE LOWER(BTRIM(SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_SELECT::text)) 
                 = 'bleeding volume in cs plant'::text
                GROUP BY 1,2,
                3,4,
                5
                UNION ALL SELECT DATE(SLIME_NSP_CSNS_AND_MEE.DATE) AS date,
                'Bleeding Volume NS'::text AS KPI,
                SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_SELECT1 AS UOM,
                COALESCE(CSNS_MEE_PLAN::double precision,
                0) AS TARGET,
                COALESCE(SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_ACTUAL::numeric,

                0::numeric) AS ACTUAL
                FROM SEMANTIC_PROD.SLIME_NSP_CSNS_AND_MEE
                WHERE LOWER(BTRIM(SLIME_NSP_CSNS_AND_MEE.CSNS_MEE_SELECT::text)) 
                 = 'bleeding volume in ns plant'::text
                GROUP BY 1,2,
                3,4,
                5)BLEED

                WHERE DATE BETWEEN '{year_start_date}' AND '{year_end_date}'
                GROUP BY 1
                """

    class Department:
        """ DEPARTMENT(M4) """
        QUERY_1 = """
        SELECT 
        TYPE_OF_BREAKDOWN AS department,
        EQUIPMENT_DESCRIPTION AS equipment_details,
        FUNCTIONAL_LOCATION_DESCRIPTION AS equipment_location,
        ROUND(BREAKDOWN_DURATION_HOURS::NUMERIC, 2) AS duration,
        ROUND(PRODUCTION_LOSS::NUMERIC, 2) AS production,
        CAUSE_OF_BREAKDOWN AS cause

        FROM
        (SELECT BD_HR.PLANNER_GROUP AS TYPE_OF_BREAKDOWN,
        BD_HR.DATE,
        BD_HR.EQUIPMENT,
        BD_HR.FUNC_LOCATION,
        BD_HR.CAUSE_OF_BREAKDOWN,
        ED.EQUIPMENT_DESCRIPTION,
        FL.FUNCTIONAL_LOCATION_DESCRIPTION,
        SUM(BD_HR.BREAKDOWN_DURATION_HOURS) AS BREAKDOWN_DURATION_HOURS,
        SUM(BD_HR.PRODUCTION_LOSS) AS PRODUCTION_LOSS
        FROM
        (SELECT CASE
        WHEN LOWER(BTRIM(FBPL.PLANNER_GROUP::text)) = 'o01'::text THEN 
        'Process'::CHARACTER varying
        WHEN LOWER(BTRIM(FBPL.PLANNER_GROUP::text)) = 'm01'::text THEN 
        'Mechanical'::CHARACTER varying
        WHEN LOWER(BTRIM(FBPL.PLANNER_GROUP::text)) = 'e01'::text THEN 
        'Electrical'::CHARACTER varying
        WHEN LOWER(BTRIM(FBPL.PLANNER_GROUP::text)) = 'log'::text THEN 
        'Logistics'::CHARACTER varying
        ELSE FBPL.PLANNER_GROUP
        END AS PLANNER_GROUP,
        FBPL.NOTIFICATION,
        TRIM(EQUIPMENT) AS EQUIPMENT,
        TRIM(FUNCTIONAL_LOCATION) AS FUNC_LOCATION,
        TRIM(FBPL.CAUSE_OF_BREAKDOWN) AS CAUSE_OF_BREAKDOWN,
        SUM(COALESCE(FBPL.BREAKDOWN_DURATION_HOURS,

        0::numeric)) AS BREAKDOWN_DURATION_HOURS,
        COALESCE(FBPL.PRODUCTION_LOSS::numeric,

        0::numeric) AS PRODUCTION_LOSS,
        FBPL.MALFUNCTIONAL_START AS date
        FROM SEMANTIC_PROD.FACT_BREAKDOWN_PRODUCTION_LOSS FBPL
        WHERE (LOWER(BTRIM(FBPL.PLANNER_GROUP::text)) = ANY (ARRAY['o01'::text,
        'm01'::text,
        'e01'::text,
        'log'::text]))
        AND LOWER(BTRIM(FBPL.FUNCTIONAL_LOCATION::text)) !~~ '1200-ref-acpp%'::text
        AND LOWER(BTRIM(FBPL.FUNCTIONAL_LOCATION::text)) ~~ '1200-ref%'::text
        AND BTRIM(FBPL.PRODUCTION_LOSS::text) <> ''::text
        GROUP BY 1,2,3,4,5,7,8) BD_HR
        LEFT JOIN
        (SELECT TRIM(EQUIPMENT) AS EQUIPMENT,
        TRIM(EQUIPMENT_DESCRIPTION) AS EQUIPMENT_DESCRIPTION
        FROM SEMANTIC_PROD.DIM_EQUIPMENT_DETAILS
        GROUP BY 1,
        2)ED ON BD_HR.EQUIPMENT = ED.EQUIPMENT
        LEFT JOIN
        (SELECT TRIM(FUNCTIONAL_LOCATION) AS FUNCTIONAL_LOCATION,
        TRIM(FUNCTIONAL_LOCATION_DESCRIPTION) AS FUNCTIONAL_LOCATION_DESCRIPTION
        FROM SEMANTIC_PROD.DIM_FUNCTIONAL_LOC_DETAILS)FL ON BD_HR.FUNC_LOCATION = 
        FL.FUNCTIONAL_LOCATION
        GROUP BY 1,2,3,4,5,6,7)TB

        WHERE 
        DATE = '{day_start_date}'
        """
