from scripts.constants import PostgresConstant
from scripts.core.db.postgres.custom_report_query import SterliteRefineryQuery, SterliteCCPCQuery


class CCPCReportTemplate:
    CCPC_REPORT_TEMPLATE = [
        {
            "BLANK0": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            }
        },
        {
            "PARTICULARS": {
                "columns": [
                    "PARTICULARS",
                    "UNIT",
                    "ON DATE",
                    "MTD",
                ],
                "query": {
                    "BLISTER": [
                        SterliteCCPCQuery.BLISTER.QUERY_1,
                        SterliteCCPCQuery.BLISTER.QUERY_2,
                    ],
                    "KCMANODE": [
                        SterliteCCPCQuery.KCMANODE.QUERY_1,
                        SterliteCCPCQuery.KCMANODE.QUERY_2,
                    ],
                    "DINGOT": [
                        SterliteCCPCQuery.DINGOT.QUERY_1,
                        SterliteCCPCQuery.DINGOT.QUERY_2,
                    ],
                    "IMPORTEDSPENTANODE": [
                        SterliteCCPCQuery.IMPORTEDSPENTANODE.QUERY_1,
                        SterliteCCPCQuery.IMPORTEDSPENTANODE.QUERY_2,
                    ],
                    "CURODRM": [
                        SterliteCCPCQuery.CURODRM.QUERY_1,
                        SterliteCCPCQuery.CURODRM.QUERY_2,
                    ],
                    "MASTERALLOY": [
                        SterliteCCPCQuery.MASTERALLOY.QUERY_1,
                        SterliteCCPCQuery.MASTERALLOY.QUERY_2,
                    ],
                    "CUSHAVINGS": [
                        SterliteCCPCQuery.CUSHAVINGS.QUERY_1,
                        SterliteCCPCQuery.CUSHAVINGS.QUERY_2,
                    ],
                    "SAPPRODUCTIONBOOKING": [
                        SterliteCCPCQuery.SAPPRODUCTIONBOOKING.QUERY_1,
                        SterliteCCPCQuery.SAPPRODUCTIONBOOKING.QUERY_2,
                    ],
                    "D.OCATHODE(RFNY)": [
                        SterliteCCPCQuery.DOCATHODE.QUERY_1,
                        SterliteCCPCQuery.DOCATHODE.QUERY_2,
                    ],
                    "REFINERYSPENTANODE": [
                        SterliteCCPCQuery.REFINERYSPENTANODE.QUERY_1,
                        SterliteCCPCQuery.REFINERYSPENTANODE.QUERY_2,
                    ],
                    "REFINERYREJECTEDANODE": [
                        SterliteCCPCQuery.REFINERYREJECTEDANODE.QUERY_1,
                        SterliteCCPCQuery.REFINERYREJECTEDANODE.QUERY_2,
                    ],
                    "REJECTEDCOILS": [
                        SterliteCCPCQuery.REJECTEDCOILS.QUERY_1,
                        SterliteCCPCQuery.REJECTEDCOILS.QUERY_2,
                    ],
                    "GGRADE": [
                        SterliteCCPCQuery.GGRADE.QUERY_1,
                        SterliteCCPCQuery.GGRADE.QUERY_2,
                    ],
                    "ACPREJANODE": [
                        SterliteCCPCQuery.ACPREJANODE.QUERY_1,
                        SterliteCCPCQuery.ACPREJANODE.QUERY_2,
                    ],
                    "BERRY": [
                        SterliteCCPCQuery.BERRY.QUERY_1,
                        SterliteCCPCQuery.BERRY.QUERY_2,
                    ],
                    "RFNYCUTCOIL": [
                        SterliteCCPCQuery.RFNYCUTCOIL.QUERY_1,
                        SterliteCCPCQuery.RFNYCUTCOIL.QUERY_2,
                    ],
                    "CCPCREJANODE": [
                        SterliteCCPCQuery.CCPCREJANODE.QUERY_1,
                        SterliteCCPCQuery.CCPCREJANODE.QUERY_2,
                    ],
                    "ANODEREJECTION": [
                        SterliteCCPCQuery.ANODEREJECTION.QUERY_1,
                        SterliteCCPCQuery.ANODEREJECTION.QUERY_2,
                    ],
                },
                "data": [],
                "data_column": ["particulars", "unit", "on_date", "mtd",
                                ],
            },
            "BLANK0": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "TOTAL BREAKDOWN DETAILS": {
                "columns": ["TOTAL BREAKDOWN DETAILS(MINS)", "DURATION(MINS)"],
                "query": {
                    "TOTAL BREAKDOWN DETAILS(MINS)": [
                        SterliteCCPCQuery.TotalBreakdownDetails.QUERY_1,
                        SterliteCCPCQuery.TotalBreakdownDetails.QUERY_2
                    ]
                },
                "data": [],
                "data_column": ["kpi", "breakdown_duration_hours"],
            },
            "BLANK1": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "METAL TEMP": {
                "columns": ["TEMP", "ON DATE"],
                "query": {
                    "MetalTemp": [
                        SterliteCCPCQuery.MetalTemp.QUERY_1,
                    ]
                },
                "data": [],
                "data_column": ["temp", "on_date"],
            },
            "BLANK2": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "FURNACE SHELL TEMP": {
                "columns": ["POSITION", "SHIFT", "AVG-TEMP"],
                "query": {
                },
                "data": [],
                "data_column": ["position", "shift", "avg-temp"],
                "addition": {
                    "merge_header": "Furnace Shell Temp       	DCS - Data to be fetched shiftwise",
                }

            },

        },
        {
            "SHIFT-A": {
                "columns": [
                    "DCS - DATA TO BE FETCHED SHIFTWISE",
                    "",
                    "6AM",
                    "7AM",
                    "8AM",
                    "1PM"
                ],
                "query": {
                },
                "data": [],
                "data_column": [
                    "dcs_data_to_be_fetched_shiftwise",
                    "",
                    "6am",
                    "7am",
                    "8am",
                    "1pm"
                ],
                "addition": {
                    "merge_header": "SHIFT-A",
                }
            }
        },
        {
            "SHIFT-B": {
                "columns": [
                    "DCS - DATA TO BE FETCHED SHIFTWISE",
                    "",
                    "6AM",
                    "7AM",
                    "8AM",
                    "1PM"
                ],
                "query": {
                },
                "data": [],
                "data_column": [
                    "dcs - data to be fetched shiftwise",
                    "",
                    "6am",
                    "7am",
                    "8am",
                    "1pm"
                ],
                "addition": {
                    "merge_header": "SHIFT-B",
                }
            }
        },
        {
            "SHIFT-C": {
                "columns": [
                    "DCS - DATA TO BE FETCHED SHIFTWISE",
                    "",
                    "6AM",
                    "7AM",
                    "8AM",
                    "1PM"
                ],
                "query": {
                },
                "data": [],
                "data_column": [
                    "dcs - data to be fetched shiftwise",
                    "",
                    "6am",
                    "7am",
                    "8am",
                    "1pm"
                ],
                "addition": {
                    "merge_header": "SHIFT-C",
                }
            }
        },
        {
            "TBC": {
                "columns": ["SHIFT", "TIME", "TANK OUTLET PRESSURE", "VAP. OUTLET PRESSURE", "LINE. OUTLET PRESSURE",
                            "LINE. TEM "],
                "query": {
                    "Tbc": [
                        SterliteCCPCQuery.Tbc.QUERY_1,
                        SterliteCCPCQuery.Tbc.QUERY_2,
                        SterliteCCPCQuery.Tbc.QUERY_3,
                    ]
                },
                "data": [],
                "data_column": ["shift", "time", "tank outlet pressure", "vap. outlet pressure",
                                "line. outlet pressure", "line. tem "],
            },
        },
        {
            "PROCESS PARAMETERS": {
                "columns": ["PARAMATER", "AVG VALUE"],
                "query": {
                    "ProcessParameter": [SterliteCCPCQuery.ProcessParameter.QUERY_1]
                },
                "data": [],
                "data_column": ["parameter", "avg_value"]
            },
        },
        {
            "CHARGING DETAILS": {
                "columns": ["CHARGING DETAILS", "A SHIFT", "B SHIFT", "C SHIFT", "TOTAL"],
                "query": {
                    "ChargingDetails": [
                        SterliteCCPCQuery.ChargingDetails.QUERY_1,
                        SterliteCCPCQuery.ChargingDetails.QUERY_2,
                    ]

                },
                "data": [],
                "data_column": ["charging_details", "shift_a", "shift_b", "shift_c", "total"],
            },
            "BLANK": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "MONTHWISE PRODUCTION DETAILS (MT)": {
                "columns": ["NOS", "TARGET", "PRODUCTION"],
                "query": {},
                "data": [],
                "data_column": ["nos", "target", "production"],
                "addition": {
                    "merge_header": "Monthwise Production details (MT)"
                }
            },
        },
        {
            "PRODUCTION DETAILS-NO. OF ANODES": {
                "columns": [
                    "PRODUCTION DETAILS-NO. OF ANODES",
                    "A SHIFT",
                    "B SHIFT",
                    "C SHIFT",
                    "TOTAL",
                    "A-SHIFT PRDN",
                    "B-SHIFT PRDN",
                    "C-SHIFT PRDN",
                    "OD PRODN (MT) ="
                ],
                "query": {

                },
                "data": [],
                "data_column": [
                    "production details-no. of anodes",
                    "a_shift",
                    "b_shift",
                    "c_shift",
                    "total",
                    "a_shift_prdn",
                    "b_shift_prdn",
                    "c_shift_prdn",
                    "od_prodn"
                ],
            },
            "BLANK": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },

        },
        {
            "CONSUMPTION ITEMS": {
                "columns": [
                    "CONSUMPTION ITEMS",
                    "UNIT",
                    "ON DATE",
                    "MTD",
                ],
                "query": {
                    "BariumSulphate": [
                        SterliteCCPCQuery.BariumSulphate.QUERY_1,
                        SterliteCCPCQuery.BariumSulphate.QUERY_2,
                    ],
                    "SodiumSulphate": [
                        SterliteCCPCQuery.SodiumSulphate.QUERY_1,
                        SterliteCCPCQuery.SodiumSulphate.QUERY_2,
                    ],
                    "Power": [
                        SterliteCCPCQuery.Power.QUERY_1,
                        SterliteCCPCQuery.Power.QUERY_2,
                    ]
                },
                "data": [],
                "data_column": [
                    "consumption_items",
                    "unit",
                    "on_date",
                    "mtd",
                ],
            }
        },
        {
            "ACTIVITY-TIME": {
                "columns": [
                    "ACTIVITY-TIME",
                    "SHIFT",
                    "START TIME",
                    "END TIME",
                    "TOTAL TIME (MINUTES)",
                    "REASON FOR STOPAGE"
                ],
                "query": {
                },
                "data": [],
                "data_column": [
                    "activity_time",
                    "shift",
                    "start_time",
                    "end_time",
                    "total_time",
                    "reason_for_stopage"
                ],
            }
        },
        {
            "PERSONS ON DUTY": {
                "columns": [
                    "PERSONS ON DUTY",
                    "A SHIFT",
                    "B SHIFT",
                    "C SHIFT"
                ],
                "query": {
                    "PersonOnDuty": [
                        SterliteCCPCQuery.PersonOnDuty.QUERY_1
                    ]

                },
                "data": [],
                "data_column": [
                    "persons_on_duty",
                    "a_shift",
                    "b_shift",
                    "c_shift"
                ]
            },
            "BLANK": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "SHIFT": {
                "columns": ["SHIFT", "LPG CONSUMPTION", "SPECIFIC PER SHIFT"],
                "query": {},
                "data": [],
                "data_column": ["shift", "lpg consumption", "specific per shift"],
                "addition": {
                    "merge_header": "SPECIFIC CONSUMPTION",
                    "primary": "consumables"
                }
            },
        },
        {
            "A SHIFT": {
                "columns": [
                    "A SHIFT"
                ],
                "query": {
                },
                "data": [],
                "data_column": ["a_shift"
                                ]
            },
            "BLANK": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "SET ANODE WEIGHT -270": {
                "columns": ["SET ANODE WEIGHT -270", "WEIGH BRIDGE", "metric", "kpi", "shift"],
                "query": {
                    "SetAnideWeight": [
                        SterliteCCPCQuery.SetAnodeWeight.QUERY_1
                    ]
                },
                "data": [],
                "data_column": ["kpi", "shift", "set_anode_weight", "weight_bridge", "metric"],
            },
        },
        {
            "SHIFT ACTIVITY TRACKER DESCRIPTION": {
                "columns": [
                    "S.NO",
                    "SHIFT ACTIVITY TRACKER DESCRIPTION"
                ],
                "query": {
                    "StrippingTime": [
                        SterliteRefineryQuery.StrippingTime.QUERY_1
                    ]
                },
                "data": [],
                "data_column": [
                    "s.no",
                    "shift_activity_tracker_description"
                ]
            }
        },
        {
            "B SHIFT": {
                "columns": [
                    "B SHIFT"
                ],
                "query": {
                },
                "data": [],
                "data_column": ["b_shift"
                                ]
            },
            "BLANK": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "SET ANODE WEIGHT -270": {
                "columns": ["SET ANODE WEIGHT -270", "WEIGH BRIDGE", "metric", "kpi", "shift"],
                "query": {
                    "SetAnideWeight": [
                        SterliteCCPCQuery.SetAnodeWeight.QUERY_1
                    ]
                },
                "data": [],
                "data_column": ["kpi", "shift", "set_anode_weight", "weight_bridge", "metric"],
            },
        },
        {
            "SHIFT ACTIVITY TRACKER DESCRIPTION": {
                "columns": [
                    "S.NO",
                    "SHIFT ACTIVITY TRACKER DESCRIPTION"
                ],
                "query": {
                    "StrippingTime": [
                        SterliteRefineryQuery.StrippingTime.QUERY_1
                    ]
                },
                "data": [],
                "data_column": [
                    "s.no",
                    "shift_activity_tracker_description"
                ]
            }
        },
        {
            "C SHIFT": {
                "columns": [
                    "C SHIFT"
                ],
                "query": {
                },
                "data": [],
                "data_column": ["c_shift"
                                ]
            },
            "BLANK": {
                "columns": [
                    None
                ],
                "data": [],
                "query": {},
                "data_column": [
                    None
                ]
            },
            "SET ANODE WEIGHT -270": {
                "columns": ["SET ANODE WEIGHT -270", "WEIGH BRIDGE", "metric", "kpi", "shift"],
                "query": {
                    "SetAnideWeight": [
                        SterliteCCPCQuery.SetAnodeWeight.QUERY_1
                    ]
                },
                "data": [],
                "data_column": ["kpi", "shift", "set_anode_weight", "weight_bridge", "metric"],

            },
        },
        {
            "SHIFT ACTIVITY TRACKER DESCRIPTION": {
                "columns": [
                    "S.NO",
                    "SHIFT ACTIVITY TRACKER DESCRIPTION"
                ],
                "query": {
                    "StrippingTime": [
                        SterliteRefineryQuery.StrippingTime.QUERY_1
                    ]
                },
                "data": [],
                "data_column": [
                    "s.no",
                    "shift_activity_tracker_description"
                ]
            }
        },
    ]
    WORKSHEET_HEADER_FORMAT = {
        "bold": True,
        "align": "center",
        "valign": "center",
        "fg_color": "#e6e7eb",
        "font_color": "#1b314f",
        "border": 1,
        'font_size': '20',
    }
    COLUMN_HEADER_FORMAT = {
        "bold": True,
        "align": "center",
        "valign": "center",
        "fg_color": "#e6e7eb",
        "font_color": "#021b5e",
        "border": 1,
    }
    BLANK_COLUMN_HEADER_FORMAT = {
        "bold": True,
        "align": "center",
        "valign": "center",
    }
