from pymongo import MongoClient
import pandas as pd

# PERIODIC sheet---step_id,old_property_name,new_property_name,step_type
#  NON-PERIODIC sheet-----logbook_id,project_id,step_id,old_property_name,new_property_name,step_type

# give input file,sheet name,input details  here

input_file_name = 'sterlite.xlsx'
sheet_name = 'PERIODIC'
CONNECTION_STRING = "mongodb://ilens:ilens4321@192.168.0.220:2717/"

# --------------------------------main code -------------------------------------------

client = MongoClient(CONNECTION_STRING)
ilens_assistant = client["project_384__ilens_assistant"]
ilens_configuration = client["project_384__ilens_configuration"]

task_instances = ilens_assistant['task_instances']
task_instance_data = ilens_assistant['task_instance_data']
periodic_data = ilens_configuration['periodic_data']


def replace_keys(data, replacements):
    if not isinstance(data, dict):
        return data
    new_data = {}
    for key, value in data.items():
        if key in replacements:
            new_data[replacements[key]] = replace_keys(value, replacements)
        else:
            new_data[key] = replace_keys(value, replacements)
    return new_data


file_path = input_file_name
json_values = pd.read_excel(file_path, sheet_name=sheet_name)

json_values.columns = json_values.columns.str.strip()

for index, row in json_values.iterrows():
    step_id = row['step_id']
    input_project_id = row.get('project_id', None)
    input_dict = {row['old_property_name']: row['new_property_name']}
    step_type = row['step_type']
    logbook_id = row.get('logbook_id', None)

    print(f"Processing row for step_id: {step_id}, step_type: {step_type}")

    if step_type == "PERIODIC":
        query = {"step_id": step_id}
        periodic_step_data = list(ilens_assistant.periodic_data.find(query))
        updated_y = []
        if periodic_step_data:
            for each in periodic_step_data:
                if 'manual_data' in each:
                    each['manual_data'] = replace_keys(each['manual_data'], input_dict)
                updated_y.append(each)
        for item in updated_y:
            update_query = {"step_id": item['step_id'], "_id": item["_id"]}
            ilens_assistant.periodic_data.update_one(update_query, {"$set": item})

        print(f"Executed the script for step_id: {step_id}, step_type: {step_type}")

    elif step_type == 'NON-PERIODIC':

        query = {"logbook_id": logbook_id, "project_id": input_project_id}
        data = []
        if logbook_data := list(ilens_assistant.task_instances.find(query)):
            data.extend(each['task_id'] for each in logbook_data)
        task_details = list(ilens_assistant.task_instance_data.find(
            {"step_id": step_id, "project_id": input_project_id, "task_id": {"$in": data}}))
        updated_y = []
        if task_details:
            for item in task_details:
                if 'step_data' in item and 'data' in item['step_data']:
                    item['step_data'] = replace_keys(item['step_data'], input_dict)
                updated_y.append(item)
        for item in updated_y:
            if item['task_id'] in data:
                update_query = {"task_id": item['task_id'], "step_id": step_id,
                                "project_id": input_project_id}
                ilens_assistant.task_instance_data.update_one(update_query, {"$set": item})

        print(f"Executed the script for step_id: {step_id}, step_type: {step_type}")
