import json
from pymongo import MongoClient

input_json_file_name = 'input_json.json'
input_project_id = "project_099"
input_logbook_id = "logbook_131"
input_step_id = 'step_182'
step_type = "NON-PERIODIC"  # NON-PERIODIC,PERIODIC

CONNECTION_STRING = "mongodb://ilens:ilens4321@192.168.0.220:2717/"
client = MongoClient(CONNECTION_STRING)

# add correct database names below
ilens_assistant = client["ilens_assistant"]
ilens_configuration = client["ilens_configuration"]

task_instances = ilens_assistant['task_instances']
task_instance_data = ilens_assistant['task_instance_data']
periodic_data = ilens_configuration['periodic_data']

with open(input_json_file_name) as user_file:
    input_json = user_file.read()
    input_dict = json.loads(input_json)


def replace_keys(data, replacements):
    if not isinstance(data, dict):
        return data
    new_data = {}
    for key, value in data.items():
        if key in replacements:
            new_data[replacements[key]] = replace_keys(value, replacements)
        else:
            new_data[key] = replace_keys(value, replacements)
    return new_data


if step_type == 'NON-PERIODIC':

    query = {"logbook_id": input_logbook_id, "project_id": input_project_id}
    data = []
    if logbook_data := list(ilens_assistant.task_instances.find(query)):
        data.extend(each['task_id'] for each in logbook_data)
    task_details = list(ilens_assistant.task_instance_data.find(
        {"step_id": input_step_id, "project_id": input_project_id, "task_id": {"$in": data}}))
    updated_y = []
    if task_details:
        for item in task_details:
            if 'step_data' in item and 'data' in item['step_data']:
                item['step_data'] = replace_keys(item['step_data'], input_dict)
            updated_y.append(item)
        for item in updated_y:
            if item['task_id'] in data:
                update_query = {"task_id": item['task_id'], "step_id": input_step_id, "project_id": input_project_id}
                ilens_assistant.task_instance_data.update_one(update_query, {"$set": item})

elif step_type == "PERIODIC":

    query = {"step_id": input_step_id}
    periodic_step_data = list(ilens_assistant.periodic_data.find(query))
    updated_y = []
    if periodic_step_data:
        for each in periodic_step_data:
            if 'manual_data' in each:
                each['manual_data'] = replace_keys(each['manual_data'], input_dict)
            updated_y.append(each)
        for item in updated_y:
            update_query = {"step_id": item['step_id'], "_id": item["_id"]}
            ilens_assistant.periodic_data.update_one(update_query, {"$set": item})
