from fastapi import FastAPI
from fastapi.openapi.utils import get_openapi
from scripts.handler.handling import Calculator
from scripts.handler.input import Schema1
from starlette.responses import HTMLResponse

tags_metadata = [
    {
        "name": "apis",
        "description": "Displays a message like hello and world for get protocols and posts helloworld for post apis.",
    },
    {
        "name": "calculator",
        "description": "Used to perform operations like to addition,substraction,multiplication and division.",
        "externalDocs": {
            "description": "Items external docs",
            "url": "https://fastapi.tiangolo.com/",
        },
    },
    {
        "name": "introduction",
        "description": "Displays a message like hello and world for get protocols and posts helloworld for post apis.",
    },
]

app = FastAPI(openapi_tags=tags_metadata)
lable_lang_mapping = {"Plain JS": "JavaScript", "NodeJS": "JavaScript"}


@app.get("/hello", tags=["apis"])
async def gethello():
    return [{"message": "hello"}]


@app.get("/world", tags=["apis"])
async def getworld():
    return [{"message": "world"}]


@app.post("/helloworld", tags=["apis"])
async def posthelloworld():
    return {"message": "helloworld"}


@app.post("/calculate", tags=["calculator"])
async def operationtoperform(request_data: Schema1):
    ans = Calculator.calculation(request_data)
    return ans



def custom_openapi():
    if app.openapi_schema:
        return app.openapi_schema
    openapi_schema = get_openapi(
        title="Calculator",
        version="2.5.0",
        description="\t This is a very custom OpenAPI schema for CALCULATOR which is used to perform operations like addition, substraction, multiplication and division. \n \n  **Redoc** is an open-source tool that generates API documentation from OpenAPI specifications.\n It's one of the most powerful free docs tools in the industry, producing clean, customizable documentation with an attractive three-panel design. With support for Markdown, it allows you to write and style descriptions with ease.",
        routes=app.routes,
    )
    openapi_schema["paths"]["/hello"]["get"]["x-codeSamples"] = [{
        'lang': 'JavaScript',
        'source': 'console.log("hello");',
        'label': 'Plain JS'
    },
        {
            'lang': 'JavaScript',
            'source': 'console.log("hello node");',
            'label': 'NodeJS'
        }
    ]

    openapi_schema["paths"]["/world"]["get"]["x-codeSamples"] = [{
        'lang': 'JavaScript',
        'source': 'console.log("world");',
        'label': 'Plain JS'
    },
        {
            'lang': 'JavaScript',
            'source': 'console.log("world node");',
            'label': 'NodeJS'
        }
    ]

    openapi_schema["paths"]["/calculate"]["post"]["x-codeSamples"] = [{
        'lang': 'JavaScript',
        'source': 'console.log("calculation");',
        'label': 'Plain JS'
    },
        {
            'lang': 'JavaScript',
            'source': 'console.log("calculation node");',
            'label': 'NodeJS'
        }
    ]

    openapi_schema["info"]["x-logo"] = {"url": "https://www.ilmexhibitions.com/cemindia/exhibitor/logos/KL%20Logo.png"}

    app.openapi_schema = openapi_schema

    return app.openapi_schema


app.openapi = custom_openapi
