from fastapi import FastAPI
from fastapi.openapi.utils import get_openapi
from scripts.handler.handling import Calculator
from scripts.handler.input import Schema1
import os

app = FastAPI()
lable_lang_mapping = {"Plain JS": "JavaScript", "NodeJS": "JavaScript"}

ans=0
@app.get("/hello")
async def gethello():
    return [{"message": "hello"}]


@app.get("/world")
async def getworld():
    return [{"message": "world"}]

@app.post("/helloworld")
async def posthelloworld():
    return {"message": "helloworld"}

@app.post("/calculate")
async def operationtoperform(request_data:Schema1):
    ans= Calculator.calculation(request_data)
    return ans
def custom_openapi():
    if app.openapi_schema:
        return app.openapi_schema
    openapi_schema = get_openapi(
        title="Calculator",
        version="2.5.0",
        description="This is a very custom OpenAPI schema for CALCULATOR",
        routes=app.routes,
    )
    openapi_schema["paths"]["/hello"]["get"]["x-codeSamples"] = [{
        'lang': 'JavaScript',
        'source': 'console.log("hello");',
        'label': 'Plain JS'
    },
        {
            'lang': 'JavaScript',
            'source': 'console.log("hello node");',
            'label': 'NodeJS'
        }
    ]

    openapi_schema["paths"]["/world"]["get"]["x-codeSamples"] = [{
        'lang': 'JavaScript',
        'source': 'console.log("world");',
        'label': 'Plain JS'
    },
        {
            'lang': 'JavaScript',
            'source': 'console.log("world node");',
            'label': 'NodeJS'
        }
    ]

    openapi_schema["paths"]["/calculate"]["post"]["x-codeSamples"] = [{
        'lang': 'JavaScript',
        'source': 'console.log("calculation");',
        'label': 'Plain JS'
    },
        {
            'lang': 'JavaScript',
            'source': 'console.log("calculation node");',
            'label': 'NodeJS'
        }
    ]


    openapi_schema["info"]["x-logo"] = {
        "url": "data:image/png;base64,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"
    }

    app.openapi_schema = openapi_schema

    return app.openapi_schema


app.openapi = custom_openapi