import os
import subprocess
from loguru import logger


class ModelOptimization:
    def __init__(self, num_class, image_size=416):
        self.num_class = num_class
        self.image_size = image_size

    def change_configurations(self):
        logger.info(f"Provided number of classes and image size are :  {self.num_class} and {self.image_size}")
        try:

            with open('yolov5/yololayer.h', 'r') as file:
                # read a list of lines into data
                data = file.readlines()

            data[19] = f"    static constexpr int CLASS_NUM = {self.num_class};\n"
            data[20] = f"    static constexpr int INPUT_H = {self.image_size};\n"
            data[21] = f"    static constexpr int INPUT_H = {self.image_size};\n"

            # and write everything back
            with open('yolov5/yololayer.h', 'w') as file:
                file.writelines(data)
            logger.info("Successfully changed configurations")
        except Exception as e:
            logger.info(f"Failed to change configurations :  {e}")

    def optimize_model(self, ):
        try:

            current_directory = os.getcwd()
            logger.info(f"Current directory is :  {current_directory}")
            build_path = os.path.join(current_directory, "yolov5", "build")
            os.mkdir(build_path)
            logger.info(f"Created build folder")
            os.chdir('yolov5/build')
            logger.info("Running CMake command")
            subprocess.run(['cmake', '..'])
            logger.info("Running Make command")
            subprocess.run(['make'])
            logger.info("Optimizing model")
            subprocess.run(["sudo", "./yolov5", "-s", "jk_v5_cam_47.wts", "jk_v5_cam_47.engine", "c", "0.33", "0.50"])

        except Exception as e:
            logger.info(f"Failed to optimized model :  {e}")


# obj = ModelOptimization(num_class=2, image_size=244)
# obj.change_configurations()

