# Python program to save a
# video using OpenCV


import cv2
import os

# Create an object to read
# from camera
video = cv2.VideoCapture(os.environ['RTSP_URL'])

# We need to check if camera
# is opened previously or not
if (video.isOpened() == False):
    print("Error reading video file")

# We need to set resolutions.
# so, convert them from float to integer.
frame_width = int(video.get(3))
frame_height = int(video.get(4))

size = (frame_width, frame_height)

# Below VideoWriter object will create
# a frame of above defined The output
# is stored in 'filename.avi' file.
file_name = os.path.join(os.getcwd() , os.environ["FILE_NAME"] + ".avi")
result = cv2.VideoWriter(file_name,
                         cv2.VideoWriter_fourcc(*'MJPG'),
                         10, size)

while (True):
    ret, frame = video.read()

    if ret == True:

        # Write the frame into the
        # file 'filename.avi'
        print(type(result))
        result.write(frame)

        # Display the frame
        # saved in the file
        # cv2.imshow('Frame', frame)

        # Press S on keyboard
        # to stop the process
        if cv2.waitKey(1) & 0xFF == ord('s'):
            break

    # Break the loop
    else:
        break

# When everything done, release
# the video capture and video
# write objects
video.release()
# result.release()

# Closes all the frames
cv2.destroyAllWindows()

print("The video was successfully saved")