from typing import Union

from fastapi import FastAPI
from pydantic import BaseModel
import os
import cv2
import time
import subprocess
import threading

class Item(BaseModel):
    rtsp: str
    name: str
    # description: Union[str, None] = None
    # price: float
    # tax: Union[float, None] = None

def background(f):
    '''
    a threading decorator
    use @background above the function you want to run in the background
    '''
    def backgrnd_func(*a, **kw):
        threading.Thread(target=f, args=a, kwargs=kw).start()
    return backgrnd_func


@background
def video_rec(item):

    # size = (640, 480)
    working_dir = "videos"
    file_name = item["name"] + ".mp4"
    file_name = os.path.join(working_dir, file_name)
    print(file_name)
    # Below VideoWriter object will create
    # a frame of above defined The output
    # is stored in 'filename.avi' file.
    video = cv2.VideoCapture(item["rtsp"])

    # We need to check if camera
    # is opened previously or not
    if (video.isOpened() == False):
        print("Error reading video file")

    # We need to set resolutions.
    # so, convert them from float to integer.
    frame_width = int(video.get(3))
    frame_height = int(video.get(4))

    size = (frame_width, frame_height)
    result = cv2.VideoWriter(file_name,
                             cv2.VideoWriter_fourcc(*'avc1'),
                             10, size)
    # cap = cv2.VideoCapture(item["rtsp"])
    t1 = time.time()
    ret = True
    while ret:
        ret, frame = video.read()
        if (ret == True):

            result.write(frame)
            t2 = time.time()
            time_taken = t2 - t1
            if (time_taken > 10):
                print("released")
                result.release()
                ret = False
        # if(ret == False):
        #     break

    video.release()

app = FastAPI()


@app.post("/items/")
async def create_item(item: Item):
# def video_write(self, frame, unique_id):
#     frame_width = int(frame.shape[1])
#     frame_height = int(frame.shape[0])
    item = item.dict()
    video_rec(item)





if __name__ == "__main__":
    from uvicorn import run

    run(app, host="0.0.0.0", port=2328)