from zipfile import ZipFile
import os
import shutil


class ExtractDataset:
    """
    Extracts the dataset.
    """
    def __init__(self):
        self.dest_path = None
        self.dataset_path = None

    def extract_ds(self, dataset_path, dest_path):
        self.dataset_path = dataset_path
        self.dest_path = dest_path
        with ZipFile(self.dataset_path, 'r') as zObject:
            zObject.extractall(path=dest_path)

    def move_files(self, dataset_path, dest_path):
        self.dataset_path = dataset_path
        self.dest_path = dest_path

        dataset_outer_path = os.listdir(self.dataset_path)
        classes = os.listdir(os.path.join(self.dataset_path, dataset_outer_path[0]))
        for cls in classes:
            shutil.move(os.path.join(self.dataset_path, dataset_outer_path[0], cls), os.path.join(self.dest_path, cls))

            # for name in files:
            #     shutil.move(os.path.join(root, name), os.path.join(self.dest_path, name))
