import os
from loguru import logger
import datetime
import traceback
from azure.storage.blob import BlobServiceClient
from scripts.constants.app_configuration import BLOB_CONTAINER_NAME, BLOB_ACCOUNT_NAME, BLOB_ACCOUNT_KEY


class Blob_Uploader:
    def __init__(self, project, site, line, camera, local_path):
        self.project = project
        self.site = site
        self.line = line
        self.camera = camera
        self.blob_service_client = BlobServiceClient(f"https://{BLOB_ACCOUNT_NAME}.blob.core.windows.net",
                                                     credential=BLOB_ACCOUNT_KEY)
        # self.local_path = "./hyp"
        self.local_path = local_path
        self.container = BLOB_CONTAINER_NAME

    def upload(self):
        try:
            for i in os.listdir(self.local_path):
                upload_file_path = os.path.join(self.local_path, i)
                blob_client = self.blob_service_client.get_blob_client(container=self.container,
                                                                       blob=f'{self.project}/{self.site}/{self.line}/'
                                                                            f'{self.camera}/'
                                                                            f'{datetime.datetime.now().day}_'
                                                                            f'{datetime.datetime.now().month}_'
                                                                            f'{datetime.datetime.now().year}'
                                                                            f'/images/{i}')
                with open(file=upload_file_path, mode="rb") as data:
                    blob_client.upload_blob(data)
            logger.info(
                f'Uploaded to Azure Storage with blob path:{self.project}/{self.site}/{self.line}/{self.camera}/'
                f'{datetime.datetime.now().day}_{datetime.datetime.now().month}_{datetime.datetime.now().year}'
                f'/images')

            return True
        except Exception as e:
            traceback.print_exc()
            logger.error(f"Failed to Push Files to blob Storage! : {str(e)}")
            return False
