import os
import os.path
import sys
from configparser import ConfigParser, BasicInterpolation

import yaml

master_configuration_file = r"./conf/master_config.yml"


class EnvInterpolation(BasicInterpolation):
    """
    Interpolation which expands environment variables in values.
    """

    def before_get(self, parser, section, option, value, defaults):
        value = super().before_get(parser, section, option, value, defaults)

        if not os.path.expandvars(value).startswith("$"):
            return os.path.expandvars(value)
        else:
            return


try:
    config = ConfigParser(interpolation=EnvInterpolation())
    config.read("conf/application.conf")
except Exception as e:
    print(f"Error while loading the config: {e}")
    print("Failed to Load Configuration. Exiting!!!")
    sys.exit()


class Logging:
    level = config.get("LOGGING", "level", fallback="INFO")
    level = level or "INFO"
    tb_flag = config.getboolean("LOGGING", "traceback", fallback=True)
    tb_flag = tb_flag if tb_flag is not None else True


BLOB_ACCOUNT_NAME = config["BLOB_STORAGE"]["account_name"]
BLOB_ACCOUNT_KEY = config["BLOB_STORAGE"]["account_key"]
BLOB_CONTAINER_NAME = config["BLOB_STORAGE"]["container_name"]


class MlFlow:
    mlflow_tracking_uri = config['MLFLOW']['mlflow_tracking_uri']
    # mlflow_tracking_username = config['MLFLOW']['mlflow_tracking_username']
    # mlflow_tracking_password = config['MLFLOW']['mlflow_tracking_password']
    azure_storage_connection_string = config['MLFLOW']['azure_storage_connection_string']
    azure_storage_access_key = config['MLFLOW']['azure_storage_access_key']
    user = config['MLFLOW']['user']
    experiment_name = config['MLFLOW']['experiment_name']
    run_name = config['MLFLOW']['run_name']
    model_name = config['MLFLOW']['model_name']
    check_param = config['MLFLOW']['check_param']
    model_check_param = config['MLFLOW']['model_check_param']


class StatusMessage:
    tr_data_uploaded = 'Data Downloaded Successfully'
    tr_data_upload_started = 'Data Upload Started'
    tr_started = 'Started'
    tr_data_download_started = 'Data Download Started'
    tr_data_downloaded = 'Data Downloaded Successfully'
    tr_augmentation_completed = 'Augmentation Completed'
    tr_init_training = 'Initiating Training'
    tr_in_progress = 'Training In-Progress'
    tr_completed = 'Training Completed'
    tr_failed = 'Training Failed'


class Mongo:
    mongo_uri = config['MONGO']['mongo_uri']
    mongo_db = config['MONGO']['mongo_db']


class job:
    job_id = config['JOB']['job_id']
    job_collection = config['JOB']['collection']


class ReqTimeZone:
    required_tz = "Asia/Kolkata"
