import os
from loguru import logger
import datetime
import traceback
from azure.storage.blob import BlobServiceClient
from scripts.constants.app_configuration import BLOB_CONN_STR, BLOB_CONTAINER_NAME


class Blob_Downloader:
    def __init__(self, project, site, blob_path, raw_ds_path):
        self.project = project
        self.site = site
        self.blob_path = blob_path
        # self.line = line
        # self.camera = camera
        self.blob_service_client = BlobServiceClient.from_connection_string(BLOB_CONN_STR)
        self.raw_ds_path = raw_ds_path
        self.container = BLOB_CONTAINER_NAME

    def download(self):
        try:
            # for i in os.listdir(self.local_path):
            download_file_path = os.path.join(self.raw_ds_path, "dataset.zip")
            blob_client = self.blob_service_client.get_blob_client(container=self.container,
                                                                   blob=self.blob_path)
            with open(download_file_path, "wb") as download_file:
                blob_client.download_blob().readinto(download_file)
            # logger.info(
            #     f'Uploaded to Azure Storage with blob path:{self.project}/{self.site}/{self.line}/{self.camera}/'
            #     f'{datetime.datetime.now().day}_{datetime.datetime.now().month}_{datetime.datetime.now().year}'
            #     f'/images')

            return True
        except Exception as e:
            traceback.print_exc()
            logger.error(f"Failed to Push Files to blob Storage! : {str(e)}")
            return False
