import os
import os.path
import sys
from configparser import ConfigParser, BasicInterpolation

import yaml

master_configuration_file = r"./conf/master_config.yml"


class EnvInterpolation(BasicInterpolation):
    """
    Interpolation which expands environment variables in values.
    """

    def before_get(self, parser, section, option, value, defaults):
        value = super().before_get(parser, section, option, value, defaults)

        if not os.path.expandvars(value).startswith("$"):
            return os.path.expandvars(value)
        else:
            return


try:
    config = ConfigParser(interpolation=EnvInterpolation())
    config.read("conf/application.conf")
except Exception as e:
    print(f"Error while loading the config: {e}")
    print("Failed to Load Configuration. Exiting!!!")
    sys.exit()


class Logging:
    level = config.get("LOGGING", "level", fallback="INFO")
    level = level or "INFO"
    tb_flag = config.getboolean("LOGGING", "traceback", fallback=True)
    tb_flag = tb_flag if tb_flag is not None else True


BLOB_CONN_STR = config["BLOB_STORAGE"]["conn_str"]
BLOB_CONTAINER_NAME = config["BLOB_STORAGE"]["container_name"]
