import os.path

if __name__ == "__main__":
    from dotenv import load_dotenv

    load_dotenv(dotenv_path='config.env')

import yaml
import traceback
import warnings
from loguru import logger
from scripts.constants.app_configuration import master_configuration_file
from scripts.utils.blob_downloader import Blob_Downloader
from scripts.utils.data_augmentation import AugmentationManager
from scripts.utils.dataset_extraction import ExtractDataset


warnings.filterwarnings("ignore")


def main():
    with open(master_configuration_file, 'r') as _cf:
        master_conf = yaml.full_load(_cf)
    root_data_path = master_conf["master_config"]["data_path"]
    raw_dataset_path = os.path.join(root_data_path, "raw_dataset")
    extracted_dataset_path = os.path.join(root_data_path, "exatracted_dataset")
    unaugmented_dataset_path = os.path.join(root_data_path, "unaugmented_dataset")
    augmented_dataset_path = os.path.join(root_data_path, "augmented_dataset")
    # annotation_directory = os.path.join("data", "dataset")
    # post_process_directory = os.path.join(root_data_path, "post")
    if(not os.path.exists(root_data_path)):
        os.mkdir(root_data_path)
    if (not os.path.exists(raw_dataset_path)):
        os.mkdir(raw_dataset_path)
    if (not os.path.exists(extracted_dataset_path)):
        os.mkdir(extracted_dataset_path)
    if (not os.path.exists(unaugmented_dataset_path)):
        os.mkdir(unaugmented_dataset_path)
    if (not os.path.exists(augmented_dataset_path)):
        os.mkdir(augmented_dataset_path)



    augmentation_functions = {}
    logger.info("Starting Vision Data Accusation Pipeline")

    # logger.info(f"Master Configuration Read, Found {len(master_conf['master_config']['rtsp_url'])} Steams with check "
    #             f"batch size of {master_conf['master_config']['check_batch_size']}")
    blob_list = master_conf['master_config']['blob_path']
    # print(blob_list)
    # for url in blob_list:
    logger.info(f'Starting accusation of Stream {blob_list}')

    blob_util = Blob_Downloader(master_conf['master_config']['project'],
                                master_conf['master_config']['site'],
                                master_conf['master_config']['blob_path'],
                                raw_dataset_path)
    blob_download_status = blob_util.download()
    if blob_download_status:
        logger.info("Data Downloaded Successfully!")
    else:
        logger.warning("Failed To Download Data")

    extract = ExtractDataset()
    extract.extract_ds(os.path.join(raw_dataset_path, "dataset.zip"), extracted_dataset_path)

    extract.move_files(extracted_dataset_path, unaugmented_dataset_path)
    try:

        sub_dir = os.walk("data")
        print(sub_dir)

        annotation_directory = sub_dir[0]
        post_process_directory = sub_dir[0]
    except:
        annotation_directory = "data"
        post_process_directory = "data"

    augmentation_list = master_conf['master_config']['augmentation_types']
    # print(augmentation_list)
    for augmentation in augmentation_list:
        augmentation_value = master_conf['master_config']['augmentation_types'][augmentation]["value"]
        augmentation_functions[augmentation]=[{"property":augmentation, "value": augmentation_value}]
    print(augmentation_functions)
    augmentation_manager = AugmentationManager(augmentation_functions)
    augmentation_manager.process(annotation_directory = unaugmented_dataset_path, post_process_directory = augmented_dataset_path)




if __name__ == '__main__':
    logger.info("Attempting to Start Vision Data Accusation Pipeline!")
    try:
        main()
    except Exception as e:
        traceback.print_exc()
        logger.error(f"Failed to Start Vision Data Accusation Pipeline! : {str(e)}")
