from ultralytics import YOLO
from PIL import Image
import cv2
import os
from PIL import Image

from paddleocr import PaddleOCR, draw_ocr

os.environ["KMP_DUPLICATE_LIB_OK"] = "TRUE"
#Load yolo model

model = YOLO(r"C:\Users\riya.srivastava\PycharmProjects\paddleocr\yolo8n_object_detection.pt")
pth = r"C:\Users\riya.srivastava\PycharmProjects\paddleocr\meter.jpg"

#load paddleocr model
folder_path = r"D:\sikhin_ssd_datasets\all_images_txt_files\all_images\paddleocr_datasets_600_1900 - Copy\crop_img"

# Paddleocr supports Chinese, English, French, German, Korean and Japanese.
# You can set the parameter `lang` as `ch`, `en`, `french`, `german`, `korean`, `japan`
# to switch the language model in order.
ocr = PaddleOCR(lang='en',
                use_angle_cls=True,
                use_gpu=False,
                det_db_thresh=0.2,
                rec_thresh=0.2,
                det_db_box_thresh=0.2,
                use_space_char=True,
                rec_char_info_thresh=0.2,
                max_text_length=45,
                det_db_unclip_ratio=2.0,
                use_dynamic_shape=False,
                det_visualize=False,
                drop_score=0.2,
                det_db_score_mode="fast",
                det_db_polynms_overlap_thresh=0.1,
                debug=False,
                det_rotate_crop=False,
                det_max_crop_size=1280,
                det_polygon=False,
                det_split_mode=True,
                rec_model_dir=r'C:\Users\riya.srivastava\Downloads\trained_model_output\content\PaddleOCR\output\inference\en_PP-OCRv3_rec',
                rec_image_shape="3, 32, 320",
                rec_char_type="en",
                rec_batch_num=12,
                det_model_dir=None,
                det_limit_side_len=960,
                rec_image_dir=None,
                rec_batch_num1=18,
                rec_char_dict_path=r"C:\Users\riya.srivastava\PycharmProjects\paddleocr\PaddleOCR\ppocr\utils\en_dict_ssd.txt",
                drop_score1=0.4,
                use_dilation=True,
                use_polygon_score=True,
                rec_algorithm='SVTR_LCNet',
                det_algorithm='DB'
                )  # need to run only once to download and load model into memory


#read image
image = cv2.imread(pth)
results = model.predict(image)

result = results[0]

# print(result)
bbox_tensor = result.boxes.xyxy
cls_tensor = result.boxes.cls
conf_tensor = result.boxes.conf

for bbox, cls, conf in zip(bbox_tensor, cls_tensor, conf_tensor):
    # print(bbox)
    # print(cls)
    # print(conf)
    x1, y1, x2, y2 = int(bbox[0]), int(bbox[1]), int(bbox[2]), int(bbox[3])
    class_index = int(cls)
    if conf>0.7:

        confidence = float(conf)
        print(confidence)
        y=y1
        h = abs(y2 - y1)
        w = abs(x2 - x1)
        x=x1
        crop_img = image[y:y + h, x:x + w]

        gray = cv2.cvtColor(crop_img, cv2.COLOR_BGR2GRAY)
        blurred = cv2.GaussianBlur(gray, (7, 7), 0)

        # apply simple thresholding with a hardcoded threshold value
        (T, threshInv) = cv2.threshold(blurred, 230, 255,
                                       cv2.THRESH_BINARY_INV)
        cv2.imshow("Simple Thresholding", threshInv)
        cv2.waitKey(0)

        # apply Otsu's automatic thresholding
        (T, threshInv) = cv2.threshold(blurred, 0, 255,
                                       cv2.THRESH_BINARY_INV | cv2.THRESH_OTSU)
        cv2.imshow("Otsu Thresholding", threshInv)
        # cv2.imwrite("Otsu.png", threshInv)
        cv2.waitKey(0)

        result = ocr.ocr(threshInv, cls=True, rec=True, det=False)

        # Print the OCR result
        for idx in range(len(result)):
            res = result[idx]
            for line in res:
                print(line)

        # Draw and save the OCR result
        result = result[0]  # Assuming you only want to draw the first result
        # boxes = [line[0] for line in result]
        boxes = []
        # txts = [line[1][0] for line in result]
        txts = [line[0] for line in result]
        print(txts)
