import cv2
import os
import numpy as np
import uuid


def rotation(image, angle=10):
    rows, cols, _ = image.shape
    M = cv2.getRotationMatrix2D((cols / 2, rows / 2), angle, 0.5)
    img_rotation = cv2.warpAffine(image, M, (cols, rows))
    return img_rotation


def shearing(image):
    rows, cols, _ = image.shape
    M = np.float32([[1, 0.5, 0], [0, 1, 0], [0, 0, 1]])
    img_shearing = cv2.warpPerspective(image, M, (int(cols * 1.5), int(rows * 1.5)))
    return img_shearing


def noise(mean=0, stddev=180):
    # img.noise("laplacian", attenuate=1.0)
    # mean = 0
    # stddev = 180
    noise = np.zeros(img.shape, np.uint8)
    cv2.randn(noise, mean, stddev)

    # Add noise to image
    img_noisy = cv2.add(img, noise)
    return img_noisy


input_path = r"D:\Kalypso-robotics\seven_segment\All_cropimg_texts_v3_v5\all_dilated_images"
output_path = r"D:\Kalypso-robotics\seven_segment\All_cropimg_texts_v3_v5\dilated_augmented"

if not os.path.exists(output_path):
    os.makedirs(output_path)

img_list = os.listdir(input_path)
with open(r"D:\Kalypso-robotics\seven_segment\All_cropimg_texts_v3_v5\All_txt_files_v3_v5\merged_texts.txt", "r") as f:
    lines = f.readlines()

for line in lines:
    # print(line)
    abc = line.split("\t")
    # print(abc)
    text = abc[1]
    image_name = abc[0]

    print(image_name)
    # print(text[:-1])
    x = image_name.split("crop_img/")
    # print(x)
    image_name = x[1]
    print(image_name)

    # txt_path = r"D:\sikhin_ssd_datasets\dataset_ssd_dilated_images - Copy\augmented_rec_gt.txt"
    # if not os.path.exists(txt_path):
    #     os.makedirs(txt_path)

    #

    # for image_name in img_list:
    image_path = os.path.join(input_path, image_name)

    # Load the image
    img = cv2.imread(image_path)

    if img is not None:
        # Perform rotation on the image
        rotated_img = rotation(img, angle=10)
        cv2.imshow("image_rotation", rotated_img)
        new_img_name_rotation = str(uuid.uuid4()) + "_" + str(text[:-1]) + "_rotation_.jpg"
        label_text_rotation = "crop_img/" + new_img_name_rotation + "\t" + text
        # Save the rotated image to the output directory
        output_image_path = os.path.join(output_path, new_img_name_rotation)

        cv2.imwrite(output_image_path, rotated_img)
        print(f"Rotated and saved: {output_image_path}")
    else:
        print(f"Failed to load image: {image_path}")

    if img is not None:
        sheared_img = shearing(img)
        cv2.imshow("image_shearing", sheared_img)
        new_img_name_shearing = str(uuid.uuid4()) + "_" + str(text[:-1]) + "_shearing_.jpg"
        cv2.waitKey(1)
        output_image_path = os.path.join(output_path, new_img_name_shearing)
        label_text_shearing = "crop_img/" + new_img_name_shearing + "\t" + text
        cv2.imwrite(output_image_path, sheared_img)
        print(f"Rotated and saved: {output_image_path}")
    else:
        print(f"Failed to load image: {image_path}")

    if img is not None:
        noisy_img = noise(mean=0, stddev=180)
        cv2.imshow("image_noise", noisy_img)
        new_img_name_noisy = str(uuid.uuid4()) + "_" + str(text[:-1]) + "_noisy_.jpg"
        cv2.waitKey(1)
        output_image_path = os.path.join(output_path, new_img_name_noisy)
        label_text_noisy = "crop_img/" + new_img_name_noisy + "\t" + text
        cv2.imwrite(output_image_path, noisy_img)
        print(f"Rotated and saved: {output_image_path}")
    else:
        print(f"Failed to load image: {image_path}")

    with open("merged_augmented_rec_gt.txt", "a") as q:
        q.write(label_text_rotation)
        q.write(label_text_shearing)
        q.write(label_text_noisy)

        # q.write("")
    q.close()
