from paddleocr import PaddleOCR, draw_ocr
import numpy as np
from PIL import Image
import cv2
import os

# path='/home/shikhin/PycharmProjects/kalypso_robotic_project/paddle_ocr_seven_segment_display/random_ssd_images_50'
path = r"D:\Kalypso-robotics\seven_segment\All_cropimg_texts_v3_v5\All_crop_images_merged - Copy"
img_list = os.listdir(path)

for img in img_list:
    img_join = os.path.join(path, img)
    # print(img_join)
    image = cv2.imread(img_join)
    # cv2.imshow("Image", image)
    # # convert the image to grayscale and blur it slightly
    gray = cv2.cvtColor(image, cv2.COLOR_BGR2GRAY)
    blurred = cv2.GaussianBlur(gray, (7, 7), 0)

    # apply simple thresholding with a hardcoded threshold value
    # (T, threshInv) = cv2.threshold(blurred, 230, 255,
    #                                cv2.THRESH_BINARY_INV)
    # cv2.imshow("Simple Thresholding", threshInv)
    # cv2.waitKey(0)

    # apply Otsu's automatic thresholding
    (T, threshInv) = cv2.threshold(blurred, 0, 255,
                                   cv2.THRESH_BINARY_INV | cv2.THRESH_OTSU)
    cv2.imshow("Otsu Thresholding", threshInv)

    # # define the kernel
    # kernel = np.ones((5, 5), np.uint8)
    #
    # # invert the image
    # invert = cv2.bitwise_not(threshInv)
    #
    # # erode the image
    # erosion = cv2.erode(invert, kernel,
    #                     iterations=1)
    # define the kernel
    kernel = np.ones((3, 3), np.uint8)

    # invert the image
    invert = cv2.bitwise_not(threshInv)

    # dilate the image
    dilation = cv2.dilate(invert, kernel, iterations=1)
    # print the output
    # plt.imshow(erosion, cmap='gray')

    # define the kernel
    kernel = np.ones((3, 3), np.uint8)

    # opening the image
    closing = cv2.morphologyEx(dilation, cv2.MORPH_CLOSE, kernel, iterations=1)

    cv2.imshow("closed", closing)
    dest_path = r"D:\Kalypso-robotics\seven_segment\All_cropimg_texts_v3_v5\all_dilated_images"
    image_join = os.path.join(dest_path, img)
    print(image_join)
    cv2.imwrite(image_join, closing)
    cv2.waitKey(1)
    # Paddleocr supports Chinese, English, French, German, Korean and Japanese.
    # You can set the parameter `lang` as `ch`, `en`, `french`, `german`, `korean`, `japan`
    # to switch the language model in order.
    # ocr = PaddleOCR(use_angle_cls=True, lang='en')  # need to run only once to download and load model into memory
    # img_path = img_join
    # # img_path = '/home/shikhin/PycharmProjects/kalypso_robotic_project/paddle_ocr_seven_segment_display/abc.png'
    # result = ocr.ocr(closing, cls=True)
    # for idx in range(len(result)):
    #     res = result[idx]
    #     for line in res:
    #         print(line)
    #
    # # draw result
    #
    # result = result[0]
    # image = Image.open(img_path).convert('RGB')
    # boxes = [line[0] for line in result]
    # txts = [line[1][0] for line in result]
    # scores = [line[1][1] for line in result]
    # im_show = draw_ocr(image, boxes, txts, scores,
    #                    font_path=r'C:\Users\riya.srivastava\PycharmProjects\paddleocr\PaddleOCR\doc\fonts\simfang.ttf')
    # im_show = Image.fromarray(im_show)
    # im_show.save('result.jpg')
    #
    # # Reading an image in default mode
    #
    # # img_path = '/home/shikhin/PycharmProjects/kalypso_robotic_project/paddle_ocr_seven_segment_display/abc.png'
    # # image = cv2.imread(img_path)
    # # window_name = 'Image'
    #
    # open_cv_image = np.array(im_show)
    # # Convert RGB to BGR
    # open_cv_image = open_cv_image[:, :, ::-1].copy()
    # cv2.imshow('Image', open_cv_image)
    #
    # cv2.waitKey(1)

# closing all open windows
cv2.destroyAllWindows()
