import os

os.environ["KMP_DUPLICATE_LIB_OK"] = "TRUE"
from PIL import Image

from paddleocr import PaddleOCR, draw_ocr

folder_path = r"C:\Users\vinod.baste\Downloads\crops (1)\content\runs\detect\exp\crops\text"

# Paddleocr supports Chinese, English, French, German, Korean and Japanese.
# You can set the parameter `lang` as `ch`, `en`, `french`, `german`, `korean`, `japan`
# to switch the language model in order.
ocr = PaddleOCR(lang='en',
                use_angle_cls=True,
                use_gpu=False,
                det_db_thresh=0.2,
                rec_thresh=0.2,
                det_db_box_thresh=0.2,
                use_space_char=True,
                rec_char_info_thresh=0.2,
                max_text_length=45,
                rec_char_dict_path=r'C:\Users\vinod.baste\Desktop\TextDetectionOCR\en_dict.txt',
                det_db_unclip_ratio=2.0,
                use_dynamic_shape=False,
                det_visualize=False,
                drop_score=0.2,
                det_db_score_mode="fast",
                det_db_polynms_overlap_thresh=0.1,
                debug=False,
                det_rotate_crop=False,
                det_max_crop_size=1280,
                det_polygon=False,
                det_split_mode=True,
                rec_model_dir=r'C:\Users\vinod.baste\Desktop\TextDetectionOCR\en_PP-OCRv3_rec',
                rec_image_shape="3, 32, 320",
                rec_char_type="en",
                rec_batch_num=12,
                # det_model_dir=r"C:\Users\vinod.baste\Downloads\trained_model_output_det\content\PaddleOCR\output"
                #               r"\det_db_inference",
                det_limit_side_len=960,
                rec_image_dir=None,
                rec_batch_num1=18,
                rec_char_dict_path1=None,
                drop_score1=0.4,
                use_dilation=True,
                use_polygon_score=True,
                rec_algorithm='SVTR_LCNet',
                det_algorithm='DB'
                )  # need to run only once to download and load model into memory

# Iterate over each file in the folder
for filename in os.listdir(folder_path):
    # Check if the file is an image (you can add more file extensions if needed)
    if filename.lower().endswith(".jpg") or filename.endswith(".png") or filename.endswith(".bmp"):
        # Read the image
        image_path = os.path.join(folder_path, filename)
        img = Image.open(image_path).convert('RGB')

        # Perform OCR on the image
        result = ocr.ocr(image_path, cls=True, rec=True, det=False)

        # Print the OCR result
        for idx in range(len(result)):
            res = result[idx]
            for line in res:
                print(line)

        # Draw and save the OCR result
        result = result[0]  # Assuming you only want to draw the first result
        # boxes = [line[0] for line in result]
        boxes = []
        # txts = [line[1][0] for line in result]
        txts = [line[0] for line in result]
        # scores = [line[1][1] for line in result]
        scores = [line[1] for line in result]
        im_show = draw_ocr(img, boxes, txts=txts, scores=scores, font_path='RobotoLight.ttf')
        im_show = Image.fromarray(im_show)
        new_folder = r"C:\Users\vinod.baste\Desktop\New folder (3)\crop_out - Copy"
        save_path = os.path.join(new_folder, "result_" + filename)
        im_show.save(save_path)