# import the necessary packages
from threading import Thread
import sys
import cv2
import time
import os
import shutil
import imutils

# import the Queue class from Python 3
if sys.version_info >= (3, 0):
    from queue import Queue

# otherwise, import the Queue class for Python 2.7
else:
    from Queue import Queue


def frame_transform(frame):
    frame = imutils.resize(frame, width=416, height=416)
    return frame

class FilePathVideoStream:
    def __init__(self, path, transform=None, queue_size=256):
        # initialize the file video stream along with the boolean
        # used to indicate if the thread should be stopped or not
        self.path=path
        self.stream=cv2.imread(path)
        # while True:
        #     self.stream = cv2.VideoCapture(path)
        #     if not self.stream.isOpened():
        #         time.sleep(0.01)
        #         continue
        #     break
        self.stopped = False
        self.transform = transform

        # initialize the queue used to store frames read from
        # the video file
        # self.Q = Queue(maxsize=queue_size)
        # intialize thread
        self.thread = Thread(target=self.update, args=())
        self.thread.daemon = True

    def start(self):
        # start a thread to read frames from the file video stream
        self.thread.start()
        return self

    def update(self):
        # keep looping infinitely
        while True:
            # if the thread indicator variable is set, stop the
            # thread
            if self.stopped:
                break

            # otherwise, ensure the queue has room in it


            frame=self.stream
            grabbed=True

            if  grabbed:
                self.stopped = True

            if self.transform:
                frame = self.transform(frame)
                return frame


                # add the frame to the queue

            else:
                time.sleep(0.1)  # Rest for 10ms, we have a full queue

        # self.stream.release()

    def read(self):
        # return next frame in the queue
        return self.Q.get()

    # Insufficient to have consumer use while(more()) which does
    # not take into account if the producer has reached end of
    # file stream.
    def running(self):
        # custom addition to this func
        cond = self.more() or not self.stopped
        if not cond:
            self.move_file()
        return cond

    def more(self):
        # return True if there are still frames in the queue. If stream is not stopped, try to wait a moment
        tries = 0
        while self.Q.qsize() == 0 and not self.stopped and tries < 5:
            time.sleep(0.1)
            tries += 1

        return self.Q.qsize() > 0

    def stop(self):
        # indicate that the thread should be stopped
        self.stopped = True
        # wait until stream resources are released (producer thread might be still grabbing frame)
        self.thread.join()
        
    def move_file(self):
        src_path = self.path
        dest_path = "archive"
        root_path = os.path.dirname(os.path.abspath(__file__))
        src = os.path.join(root_path, src_path)
        if not os.path.exists(dest_path):
            os.mkdir(dest_path)
        shutil.move(src, dest_path)
