import time

from edge_engine.common.logsetup import logger
from edge_engine.common.config import DEVICE_ID
from uuid import uuid4
import traceback
import cv2

class FrameProcessor:
    def __init__(self, stream, model):
        self.model = model
        self.stream = stream
        logger.info("Setting up frame processor !!")
        self.count = 0
        self.skip_frame_every = 1  # 1 does not skip any frame (n-1 frames get skipped)


    def run_model(self):
        while self.stream.stream.isOpened():
            try:
                logger.debug("Getting frame mask_model")
                frame = self.stream.read()
                logger.debug("Running mask_model")
                self.count += 1
                # print("count.......",self.count)
                if frame is not None and self.count % self.skip_frame_every == 0:
                    fid = uuid4()
                    data = {
                        "frame": frame,
                        "frameId": "{}".format(fid),
                        "deviceId": "{}".format(DEVICE_ID),
                    }

                    self.model.predict(data)
                time.sleep(0.01)
            except Exception as e:
                logger.error(e)
                logger.error(traceback.format_exc())


class FrameProcessorv2:
    def __init__(self, stream, model):
        self.model = model
        self.stream = stream
        self.count = 0
        self.skip_frame_every = 3  # 1 does not skip any frame (n-1 frames get skipped)

    def run_model(self):
        try:
            frame = self.stream
            # print("steam",type(frame))
            self.count += 1
            if frame is not None:
                fid = uuid4()
                data = {
                    "frame": frame,
                    "frameId": "{}".format(fid),
                    "deviceId": "{}".format(DEVICE_ID),
                }

                self.model.predict(data)

        except Exception as e:
            logger.error(e)
            logger.error(traceback.format_exc())



