import yaml
import traceback
import warnings
from loguru import logger
from scripts.constants.app_configuration import master_configuration_file
from scripts.db.mongo_connect import MongoLogger
from scripts.password_verification import PasswordVerification
from security.password_encryption import Base64Encryption

warnings.filterwarnings("ignore")


def main():
    logger.info("Starting Login Page")
    with open(master_configuration_file, 'r') as _cf:
        master_conf = yaml.full_load(_cf)

    logger.info("Connecting to mongoDB")
    # try:
        
    mongo_cred = master_conf['master_config']['mongo_cred']
    db_name = master_conf['master_config']['db']
    coll = master_conf['master_config']['collection']
    mongo_logger = MongoLogger()
    collection = mongo_logger.mongo_connect(mongo_cred, db_name, coll)
    user_name = input("Enter your username")
    password = input("Enter your password")
    base64_encrypt = Base64Encryption()
    password_encrypt = base64_encrypt.encrypt(password)
    verify = PasswordVerification()
    status = verify.verify(collection, user_name, password_encrypt)
    print(status)

if __name__ == '__main__':
    logger.info("Attempting to Start Loading Login Page")
    try:
        main()
    except Exception as e:
        traceback.print_exc()
        logger.error(f"Failed to Load Login Page{str(e)}")
